/*
 * Decompiled with CFR 0.152.
 */
package abl.runtime;

import abl.runtime.AblRuntimeError;
import abl.runtime.BehavingEntity;
import abl.runtime.Behavior;
import abl.runtime.ExecutableStep;
import abl.runtime.GoalStep;
import abl.runtime.Step;
import abl.runtime.__StepDesc;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public abstract class MultiStepBehavior
extends Behavior {
    protected HashSet<Step> children = new HashSet();
    private int numberNeededForSuccess = -1;
    private int numberOfCompletedSteps = 0;
    private GoalStep lastPursuedGoal = null;

    public MultiStepBehavior(GoalStep arg_parent, Method arg_contextCondition, Method arg_contextConditionSensorFactory, boolean arg_isAtomic, String arg_signature, short arg_specificity, int arg_behaviorID, Object[] arg_behaviorVariableFrame, __StepDesc[] arg_stepDescs, int arg_numberNeededForSuccess) {
        super(arg_parent, arg_contextCondition, arg_contextConditionSensorFactory, null, null, arg_isAtomic, arg_signature, arg_specificity, arg_behaviorID, arg_behaviorVariableFrame, arg_stepDescs);
        if (arg_numberNeededForSuccess == -1) {
            if (this.getBehaviorType() != 3) {
                this.numberNeededForSuccess = 0;
                Step[] tempSteps = this.getAllSteps();
                int i = 0;
                while (i < tempSteps.length) {
                    if (!tempSteps[i].getEffectOnlyOrTeamEffectOnly()) {
                        ++this.numberNeededForSuccess;
                    }
                    ++i;
                }
            }
        } else {
            this.numberNeededForSuccess = arg_numberNeededForSuccess;
        }
    }

    public MultiStepBehavior(GoalStep arg_parent, Method arg_contextCondition, Method arg_contextConditionSensorFactory, Method arg_successCondition, Method arg_successConditionSensorFactory, boolean arg_isAtomic, String arg_signature, short arg_specificity, int arg_behaviorID, Object[] arg_behaviorVariableFrame, __StepDesc[] arg_stepDescs, int arg_numberNeededForSuccess) {
        super(arg_parent, arg_contextCondition, arg_contextConditionSensorFactory, arg_successCondition, arg_successConditionSensorFactory, arg_isAtomic, arg_signature, arg_specificity, arg_behaviorID, arg_behaviorVariableFrame, arg_stepDescs);
        if (arg_numberNeededForSuccess == -1) {
            if (this.getBehaviorType() != 3) {
                this.numberNeededForSuccess = 0;
                Step[] tempSteps = this.getAllSteps();
                int i = 0;
                while (i < tempSteps.length) {
                    if (!tempSteps[i].getEffectOnlyOrTeamEffectOnly()) {
                        ++this.numberNeededForSuccess;
                    }
                    ++i;
                }
            }
        } else {
            this.numberNeededForSuccess = arg_numberNeededForSuccess;
        }
    }

    public MultiStepBehavior(GoalStep arg_parent, Method arg_contextCondition, Method arg_contextConditionSensorFactory, Method arg_successCondition, Method arg_successConditionSensorFactory, boolean arg_isAtomic, String arg_signature, short arg_specificity, int arg_behaviorID, Object[] arg_behaviorVariableFrame, __StepDesc[] arg_stepDescs, int arg_numberNeededForSuccess, BehavingEntity[] arg_teamMembers) {
        super(arg_parent, arg_contextCondition, arg_contextConditionSensorFactory, arg_successCondition, arg_successConditionSensorFactory, arg_isAtomic, arg_signature, arg_specificity, arg_behaviorID, arg_behaviorVariableFrame, arg_stepDescs, arg_teamMembers);
        if (arg_numberNeededForSuccess == -1) {
            if (this.getBehaviorType() != 3) {
                this.numberNeededForSuccess = 0;
                Step[] tempSteps = this.getAllSteps();
                int i = 0;
                while (i < tempSteps.length) {
                    if (!tempSteps[i].getEffectOnlyOrTeamEffectOnly()) {
                        ++this.numberNeededForSuccess;
                    }
                    ++i;
                }
            }
        } else {
            this.numberNeededForSuccess = arg_numberNeededForSuccess;
        }
    }

    public MultiStepBehavior(GoalStep arg_parent, Method arg_contextCondition, Method arg_contextConditionSensorFactory, boolean arg_isAtomic, String arg_signature, short arg_specificity, int arg_behaviorID, Object[] arg_behaviorVariableFrame, __StepDesc[] arg_stepDescs, int arg_numberNeededForSuccess, BehavingEntity[] arg_teamMembers) {
        super(arg_parent, arg_contextCondition, arg_contextConditionSensorFactory, null, null, arg_isAtomic, arg_signature, arg_specificity, arg_behaviorID, arg_behaviorVariableFrame, arg_stepDescs, arg_teamMembers);
        if (arg_numberNeededForSuccess == -1) {
            Step[] tempSteps = this.getAllSteps();
            this.numberNeededForSuccess = 0;
            int i = 0;
            while (i < tempSteps.length) {
                if (!tempSteps[i].getEffectOnlyOrTeamEffectOnly()) {
                    ++this.numberNeededForSuccess;
                }
                ++i;
            }
        } else {
            this.numberNeededForSuccess = arg_numberNeededForSuccess;
        }
    }

    int getNumberNeededForSuccess() {
        return this.numberNeededForSuccess;
    }

    final int getNumberOfCompletedSteps() {
        return this.numberOfCompletedSteps;
    }

    final GoalStep getLastPursuedGoal() {
        return this.lastPursuedGoal;
    }

    final int getNumberOfSteps() {
        return this.stepDescs.length;
    }

    final Step[] getChildren() {
        return this.children.toArray(new Step[this.children.size()]);
    }

    final void pursueGoal(GoalStep g) {
        this.lastPursuedGoal = g;
    }

    final void clearLastPursuedGoal() {
        this.lastPursuedGoal = null;
    }

    @Override
    protected void removeChildren() {
        Step[] s = this.children.toArray(new Step[this.children.size()]);
        int i = 0;
        while (i < s.length) {
            this.removeChild(s[i], false);
            ++i;
        }
    }

    void addChild(Step s) {
        if (this.parent != null && this.parent.isSuspended()) {
            List suspenders = this.parent.getStepsSuspendingMe();
            int metaSuspenderCount = this.parent.getMetaSuspenderCount();
            assert (suspenders.size() != 0 || metaSuspenderCount > 0);
            if (suspenders.size() != 0) {
                Iterator iter = suspenders.iterator();
                while (iter.hasNext()) {
                    s.suspend((ExecutableStep)iter.next());
                }
            }
            if (metaSuspenderCount > 0) {
                int i = 0;
                while (i < metaSuspenderCount) {
                    s.metaSuspend();
                    ++i;
                }
            }
        }
        this.children.add(s);
        if (!s.getEffectOnlyOrTeamEffectOnly()) {
            ++this.numberNeededForSuccess;
        }
        BehavingEntity.getBehavingEntity().addStep(s);
        this.changes.firePropertyChange("child", null, s);
    }

    @Override
    void addChildren() {
        Step[] newChildren = this.getAllSteps();
        int i = 0;
        while (i < newChildren.length) {
            this.children.add(newChildren[i]);
            BehavingEntity.getBehavingEntity().addStep(newChildren[i]);
            this.changes.firePropertyChange("child", null, newChildren[i]);
            ++i;
        }
    }

    @Override
    protected void removeChild(Step child, boolean isCallerChild) {
        assert (this.children.contains(child)) : "child == " + child + " current children == " + this.children;
        super.removeChild(child, isCallerChild);
        this.children.remove(child);
        this.lastPursuedGoal = null;
        if (this.numberNeededForSuccess != -1 && !child.getEffectOnlyOrTeamEffectOnly()) {
            ++this.numberOfCompletedSteps;
        }
    }

    protected Step[] getAllSteps() {
        Step[] steps = new Step[this.stepDescs.length];
        int i = 0;
        while (i < steps.length) {
            try {
                Object[] factoryArgs = new Object[]{new Integer(this.stepDescs[i].stepID), this, this.getBehaviorVariableFrame()};
                steps[i] = (Step)this.stepDescs[i].factory.invoke(null, factoryArgs);
            }
            catch (Exception e) {
                throw new AblRuntimeError("Error invoking step factory", e);
            }
            ++i;
        }
        return steps;
    }

    boolean isSuccessful() {
        assert (this.numberNeededForSuccess != -1);
        return this.numberOfCompletedSteps >= this.numberNeededForSuccess;
    }

    @Override
    boolean currentLineOfExpansion(GoalStep currentGoal) {
        if (this.parent != null) {
            if (currentGoal == null || this.lastPursuedGoal == null || currentGoal == this.lastPursuedGoal) {
                return this.parent.currentLineOfExpansion(currentGoal);
            }
            return false;
        }
        return currentGoal == null || this.lastPursuedGoal == null || currentGoal == this.lastPursuedGoal;
    }

    @Override
    final void suspend(ExecutableStep step) {
        for (Step child : this.children) {
            child.suspend(step);
        }
    }

    @Override
    final void metaSuspend() {
        for (Step child : this.children) {
            child.metaSuspend();
        }
    }

    @Override
    final void unsuspend(ExecutableStep step) {
        for (Step child : this.children) {
            child.unsuspend(step);
        }
    }

    @Override
    final void metaUnsuspend() {
        for (Step child : this.children) {
            child.metaUnsuspend();
        }
    }

    @Override
    final void jointUnsuspend() {
        Iterator<Step> iter = this.children.iterator();
        while (iter.hasNext()) {
            iter.next().jointUnsuspend();
        }
    }

    @Override
    final void suspendSkipJointGoals(ExecutableStep step) {
        for (Step s : this.children) {
            if (s.getStepType() == 1 && ((GoalStep)s).isJointGoal()) continue;
            if (s.getStepType() == 1) {
                ((GoalStep)s).suspendSkipJointGoals(step);
                continue;
            }
            s.suspend(step);
        }
    }

    @Override
    final void metaSuspendSkipJointGoals() {
        for (Step s : this.children) {
            if (s.getStepType() == 1 && ((GoalStep)s).isJointGoal()) continue;
            if (s.getStepType() == 1) {
                ((GoalStep)s).metaSuspendSkipJointGoals();
                continue;
            }
            s.metaSuspend();
        }
    }

    final List freezeSubtreeAndNegotiateRemoval() {
        if (this.hasTeamEffectOnlySteps()) {
            return this.freezeNonTeamEffectOnlySubtreeAndNegotiateRemoval();
        }
        BehavingEntity.getBehavingEntity().removeBehavior(this);
        Iterator<Step> iter = this.children.iterator();
        Vector<Step> v = new Vector<Step>();
        while (iter.hasNext()) {
            v.addAll(this.freezeChild(iter.next()));
        }
        return v;
    }

    @Override
    protected final List freezeNonTeamEffectOnlySubtreeAndNegotiateRemoval() {
        BehavingEntity.getBehavingEntity().removeBehavior(this);
        Iterator<Step> iter = this.children.iterator();
        Vector<Step> v = new Vector<Step>();
        while (iter.hasNext()) {
            Step s = iter.next();
            if (s.getTeamEffectOnly()) continue;
            v.addAll(this.freezeChild(s));
        }
        return v;
    }

    @Override
    protected final boolean hasTeamEffectOnlySteps() {
        Iterator<Step> iter = this.children.iterator();
        while (iter.hasNext()) {
            if (!iter.next().getTeamEffectOnly()) continue;
            return true;
        }
        return false;
    }

    @Override
    final List negotiateSuspensionOfSubtree() {
        Iterator<Step> iter = this.children.iterator();
        Vector v = new Vector();
        while (iter.hasNext()) {
            v.addAll(this.negotiateSuspensionOfChild(iter.next()));
        }
        return v;
    }

    @Override
    final List negotiateSuspensionOfSubtree(ExecutableStep s) {
        Iterator<Step> iter = this.children.iterator();
        Vector v = new Vector();
        while (iter.hasNext()) {
            v.addAll(this.negotiateSuspensionOfChild(iter.next(), s));
        }
        return v;
    }
}

