/*
 * Decompiled with CFR 0.152.
 */
package abl.runtime;

import abl.runtime.AblNamedPropertySupport;
import abl.runtime.AblRuntimeError;
import abl.runtime.BehavingEntity;
import abl.runtime.Behavior;
import abl.runtime.RuntimeError;
import abl.runtime.SequentialBehavior;
import abl.runtime.SequentialBehaviorWME;
import abl.runtime.Step;
import abl.runtime.__StepDesc;
import java.lang.reflect.Method;

public class ModifyStep
extends Step {
    public static final short MOVESTEP = 0;
    public static final short DELETESTEP = 1;
    public static final short ADDSTEP = 2;
    private short mModifyType = (short)-1;
    private int mTargetStepID = -4;
    private int mFromIndex = -1;
    private int mToIndex = -1;
    private Method mArgFactory = null;

    public ModifyStep(int stepID, Behavior arg_parent, boolean arg_persistent, boolean arg_persistentWhenSucceeds, boolean arg_persistentWhenFails, boolean arg_ignoreFailure, boolean arg_effectOnly, boolean arg_teamEffectOnly, short arg_priority, short arg_priorityModifier, boolean arg_post, String arg_postMemory, Method arg_execute, Method arg_successTest, Method arg_successTestSensorFactory, AblNamedPropertySupport arg_propertyTable, short modifyType, int subStepID, int fromIndex, int toIndex, Method arg_factory) {
        super(stepID, arg_parent, arg_persistent, arg_persistentWhenSucceeds, arg_persistentWhenFails, arg_ignoreFailure, arg_effectOnly, arg_teamEffectOnly, arg_priority, arg_priorityModifier, arg_post, arg_postMemory, arg_execute, arg_successTest, arg_successTestSensorFactory, arg_propertyTable, (short)7);
        this.mModifyType = modifyType;
        this.mTargetStepID = subStepID;
        this.mFromIndex = fromIndex;
        this.mToIndex = toIndex;
        this.mArgFactory = arg_factory;
    }

    @Override
    void resetStep() {
        throw new RuntimeError("Attempt to reset a modify step.");
    }

    private void modifyBehavior(SequentialBehaviorWME targetBehaviorWME) {
        this.succeedStep();
        if (targetBehaviorWME == null) {
            throw new RuntimeError("Attempt to modify a non-existent Sequential Behavior.");
        }
        Behavior targetBehavior = targetBehaviorWME.getBehavior();
        switch (this.mModifyType) {
            default: {
                throw new RuntimeError("Invalid modifyType in ModifyStep");
            }
            case 0: {
                ((SequentialBehavior)targetBehavior).moveStep(this.mFromIndex, this.mToIndex);
                break;
            }
            case 1: {
                ((SequentialBehavior)targetBehavior).moveStep(this.mFromIndex, -1);
                break;
            }
            case 2: {
                __StepDesc newStep = new __StepDesc(this.mTargetStepID, this.mArgFactory);
                ((SequentialBehavior)targetBehavior).insertStep(newStep, this.mToIndex);
            }
        }
    }

    private final SequentialBehaviorWME bindArgs() {
        SequentialBehaviorWME targetBehavior = null;
        if (this.execute != null) {
            Object[] objectArray = new Object[3];
            objectArray[0] = new Integer(this.stepID);
            objectArray[2] = BehavingEntity.getBehavingEntity();
            Object[] exeArgs = objectArray;
            try {
                Object[] tempArgs = (Object[])this.execute.invoke(null, exeArgs);
                targetBehavior = (SequentialBehaviorWME)tempArgs[0];
            }
            catch (Exception e) {
                throw new AblRuntimeError("Error invoking execute", e);
            }
        }
        return targetBehavior;
    }

    @Override
    void execute() {
        SequentialBehaviorWME target = this.bindArgs();
        this.modifyBehavior(target);
    }
}

