/*
 * Decompiled with CFR 0.152.
 */
package abl.runtime;

import abl.runtime.AblNamedPropertySupport;
import abl.runtime.BehavingEntity;
import abl.runtime.Behavior;
import abl.runtime.ExecutableStep;
import abl.runtime.GoalStep;
import abl.runtime.JointGoalNegotiationThread;
import abl.runtime.JointGoalNegotiator;
import abl.runtime.Step;
import debug.Trace;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class JointGoalStep
extends GoalStep {
    JointGoalNegotiator negotiator = null;
    private boolean isNegotiating = false;
    protected boolean teamNeededForSuccess;

    public JointGoalStep(int stepID, Behavior arg_parent, boolean arg_persistent, boolean arg_persistentWhenSucceeds, boolean arg_persistentWhenFails, boolean arg_ignoreFailure, boolean arg_effectOnly, boolean arg_teamEffectOnly, short arg_priority, short arg_priorityModifier, boolean arg_post, String arg_postMemory, Method arg_execute, Method arg_successTest, Method arg_successTestSensorFactory, AblNamedPropertySupport arg_propertyTable, String arg_signature, String[] arg_stepsIConflictWith, boolean arg_teamNeededForSuccess) {
        super(stepID, arg_parent, arg_persistent, arg_persistentWhenSucceeds, arg_persistentWhenFails, arg_ignoreFailure, arg_effectOnly, arg_teamEffectOnly, arg_priority, arg_priorityModifier, arg_post, arg_postMemory, arg_execute, arg_successTest, arg_successTestSensorFactory, arg_propertyTable, arg_signature, arg_stepsIConflictWith);
        this.teamNeededForSuccess = arg_teamNeededForSuccess;
    }

    public JointGoalStep(int stepID, Behavior arg_parent, boolean arg_persistent, boolean arg_persistentWhenSucceeds, boolean arg_persistentWhenFails, boolean arg_ignoreFailure, boolean arg_effectOnly, boolean arg_teamEffectOnly, short arg_priority, short arg_priorityModifier, boolean arg_post, String arg_postMemory, Method arg_execute, Method arg_successTest, Method arg_successTestSensorFactory, AblNamedPropertySupport arg_propertyTable, String arg_signature, String[] arg_stepsIConflictWith, short arg_goalType, boolean arg_teamNeededForSuccess) {
        super(stepID, arg_parent, arg_persistent, arg_persistentWhenSucceeds, arg_persistentWhenFails, arg_ignoreFailure, arg_effectOnly, arg_teamEffectOnly, arg_priority, arg_priorityModifier, arg_post, arg_postMemory, arg_execute, arg_successTest, arg_successTestSensorFactory, arg_propertyTable, arg_signature, arg_stepsIConflictWith, arg_goalType);
        this.teamNeededForSuccess = arg_teamNeededForSuccess;
    }

    protected JointGoalNegotiator getNewJointGoalNegotiator(Hashtable commitSet) {
        return new JointGoalNegotiator(commitSet);
    }

    protected JointGoalNegotiator getNewJointGoalNegotiator(Set teamMembers) {
        return new JointGoalNegotiator(teamMembers, this);
    }

    protected JointGoalNegotiator getNewJointGoalNegotiator(Hashtable commitSet, int state) {
        return new JointGoalNegotiator(commitSet, state);
    }

    protected JointGoalNegotiator getNewJointGoalNegotiator(Set teamMembers, boolean newEntryNegotiation) {
        return new JointGoalNegotiator(teamMembers, newEntryNegotiation, this);
    }

    @Override
    boolean isJointGoal() {
        return true;
    }

    Set getTeamMembers() {
        if (this.negotiator == null) {
            return null;
        }
        return this.negotiator.getTeamMembers();
    }

    synchronized boolean getIsNegotiating() {
        return this.isNegotiating;
    }

    synchronized void setIsNegotiating(boolean b) {
        this.isNegotiating = b;
    }

    boolean getTeamNeededForSuccess() {
        return this.teamNeededForSuccess;
    }

    void resetNegotiator(Hashtable commitSet, int state) {
        this.negotiator = this.getNewJointGoalNegotiator(commitSet, state);
    }

    @Override
    void chooseBehavior(final Object[] args) {
        final Behavior beh = BehavingEntity.getBehavingEntity().chooseJointBehavior(args, this.failedBehaviors, this);
        final JointGoalNegotiationThread negotiateEntryThread = new JointGoalNegotiationThread(this.negotiator, this + " negotiateEntryThread"){

            @Override
            public void run() {
                JointGoalStep.this.negotiator = JointGoalStep.this.getNewJointGoalNegotiator(beh.getTeamMembers(), true);
                Hashtable commitSet = BehavingEntity.getBehavingEntity().negotiateEntry(JointGoalStep.this, args);
                if (commitSet != null) {
                    JointGoalStep.this.addChild(beh);
                    JointGoalStep.this.executeBookkeeping();
                } else {
                    JointGoalStep.this.addFailedBehavior(beh);
                    JointGoalStep.this.negotiator = null;
                }
                JointGoalStep.this.setIsNegotiating(false);
            }
        };
        JointGoalNegotiationThread negotiateFailureOfOtherGoalsThread = new JointGoalNegotiationThread(this.negotiator, this + " negotiateFailureOfOtherGoalsThread"){

            @Override
            public void run() {
                if (JointGoalStep.this.negotiator != null) {
                    JointGoalStep.this.negotiator.negotiateFailure();
                    JointGoalStep.this.removeChild(true);
                    BehavingEntity.getBehavingEntity().registerNegotiationThread(negotiateEntryThread);
                }
            }
        };
        assert (!this.getIsNegotiating());
        if (beh != null) {
            if (this.negotiator == null) {
                this.setIsNegotiating(true);
                BehavingEntity.getBehavingEntity().registerNegotiationThread(negotiateEntryThread);
            } else if (!this.negotiator.getTeamMembers().equals(beh.getTeamMembers())) {
                this.setIsNegotiating(true);
                BehavingEntity.getBehavingEntity().registerNegotiationThread(negotiateFailureOfOtherGoalsThread);
            } else {
                this.addChild(beh);
                this.executeBookkeeping();
            }
        } else {
            this.failStep();
        }
    }

    static void blockOnSubtreeNegotiation(List jointGoals) {
        assert (Thread.currentThread() != BehavingEntity.getBehavingEntity().getDecisionCycleThread());
        for (JointGoalStep js : jointGoals) {
            if (js.negotiator == null || js.negotiator.getState() == 7 || js.negotiator.getState() == 9 || js.negotiator.getState() == 16 || js.negotiator.getState() == 11) continue;
            ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
        }
    }

    @Override
    void succeedStep() {
        if (this.negotiator == null) {
            super.succeedStep();
        } else if (this.negotiator.getState() == 7) {
            super.succeedStep();
        } else {
            final List jointGoals = this.freezeSubtreeAndNegotiateRemovalEntry();
            JointGoalNegotiationThread negotiateSuccessThread = new JointGoalNegotiationThread(this.negotiator, this + " negotiateSuccessThread"){

                @Override
                public void run() {
                    JointGoalStep.this.setIsNegotiating(true);
                    JointGoalStep.blockOnSubtreeNegotiation(jointGoals);
                    if (JointGoalStep.this.negotiator != null) {
                        if (JointGoalStep.this.negotiator.getState() == 6) {
                            JointGoalStep.this.negotiator.negotiateSuccess();
                        } else if (JointGoalStep.this.negotiator.negotiateSuccess()) {
                            JointGoalStep.this.succeedStepSuper();
                            JointGoalStep.this.setIsNegotiating(false);
                        }
                    }
                }
            };
            BehavingEntity.getBehavingEntity().registerNegotiationThread(negotiateSuccessThread);
        }
    }

    @Override
    void failStep() {
        Trace.ablTrace("(JointGoalStep)" + this.getSignature() + "failStep()");
        if (this.negotiator == null) {
            super.failStep();
        } else if (this.negotiator.getState() == 9) {
            super.failStep();
        } else {
            final List jointGoals = this.freezeSubtreeAndNegotiateRemovalEntry();
            JointGoalNegotiationThread negotiateFailureThread = new JointGoalNegotiationThread(this.negotiator, this + " negotiateFailureThread"){

                @Override
                public void run() {
                    JointGoalStep.this.setIsNegotiating(true);
                    JointGoalStep.blockOnSubtreeNegotiation(jointGoals);
                    if (JointGoalStep.this.negotiator != null && JointGoalStep.this.negotiator.negotiateFailure()) {
                        JointGoalStep.this.failStepSuper();
                        JointGoalStep.this.setIsNegotiating(false);
                    }
                }
            };
            BehavingEntity.getBehavingEntity().registerNegotiationThread(negotiateFailureThread);
        }
    }

    private void negotiateSuspend(final ExecutableStep step) {
        final List jointGoals = this.negotiateSuspensionOfSubtreeEntry(step);
        JointGoalNegotiationThread negotiateSuspensionThread = new JointGoalNegotiationThread(this.negotiator, this + " negotiateSuspensionThread"){

            @Override
            public void run() {
                JointGoalStep.this.setIsNegotiating(true);
                JointGoalStep.blockOnSubtreeNegotiation(jointGoals);
                if (JointGoalStep.this.negotiator != null && JointGoalStep.this.negotiator.negotiateSuspend()) {
                    if (step != null) {
                        JointGoalStep.this.suspendSuper(step, false);
                    } else {
                        JointGoalStep.this.metaSuspendSuper(false);
                    }
                    JointGoalStep.this.negotiator.setState(12);
                    JointGoalStep.this.setIsNegotiating(false);
                }
            }
        };
        BehavingEntity.getBehavingEntity().registerNegotiationThread(negotiateSuspensionThread);
    }

    @Override
    void suspend(ExecutableStep step) {
        if (this.negotiator == null) {
            super.suspend(step);
        } else {
            this.negotiateSuspend(step);
        }
    }

    @Override
    void metaSuspend() {
        if (this.negotiator == null) {
            super.metaSuspend();
        } else {
            this.negotiateSuspend(null);
        }
    }

    private void negotiateUnsuspend(final ExecutableStep step) {
        JointGoalNegotiationThread negotiateUnsuspensionThread = new JointGoalNegotiationThread(this.negotiator, this + " negotiateUnsuspensionThread"){

            @Override
            public void run() {
                JointGoalStep.this.setIsNegotiating(true);
                if (JointGoalStep.this.negotiator != null && JointGoalStep.this.negotiator.negotiateUnsuspend()) {
                    if (step != null) {
                        JointGoalStep.this.unsuspendSuper(step);
                    } else {
                        JointGoalStep.this.metaUnsuspendSuper();
                    }
                    JointGoalStep.this.setIsNegotiating(false);
                    if (JointGoalStep.this.isSuspended()) {
                        JointGoalStep.this.negotiator.setState(12);
                    } else {
                        JointGoalStep.this.negotiator.setState(4);
                    }
                }
            }
        };
        BehavingEntity.getBehavingEntity().registerNegotiationThread(negotiateUnsuspensionThread);
    }

    private void unsuspendSuper(ExecutableStep step) {
        super.unsuspend(step);
    }

    private void metaUnsuspendSuper() {
        super.metaUnsuspend();
    }

    private void jointUnsuspendSuper() {
        super.jointUnsuspend();
    }

    private void suspendSuper(ExecutableStep step, boolean recurse) {
        super.suspend(step, recurse);
    }

    private void metaSuspendSuper(boolean recurse) {
        super.metaSuspend(recurse);
    }

    private void jointSuspendSuper() {
        super.jointSuspend();
    }

    private void failStepSuper() {
        super.failStep();
    }

    private void succeedStepSuper() {
        super.succeedStep();
    }

    @Override
    void unsuspend(ExecutableStep step) {
        if (this.negotiator != null) {
            this.negotiateUnsuspend(step);
        } else {
            super.unsuspend(step);
        }
    }

    @Override
    void metaUnsuspend() {
        if (this.negotiator != null) {
            this.negotiateUnsuspend(null);
        } else {
            super.metaUnsuspend();
        }
    }

    void jointUnsuspendEntry() {
        super.jointUnsuspend();
    }

    @Override
    void jointUnsuspend() {
        JointGoalNegotiationThread jointUnsuspendThread = new JointGoalNegotiationThread(this.negotiator, this + " jointUnsuspendThread"){

            @Override
            public void run() {
                JointGoalStep.this.setIsNegotiating(true);
                if (JointGoalStep.this.negotiator != null && JointGoalStep.this.negotiator.negotiateUnsuspend()) {
                    JointGoalStep.this.jointUnsuspendSuper();
                    JointGoalStep.this.setIsNegotiating(false);
                    if (JointGoalStep.this.isSuspended()) {
                        JointGoalStep.this.negotiator.setState(12);
                    } else {
                        JointGoalStep.this.negotiator.setState(4);
                    }
                }
            }
        };
        if (this.negotiator != null) {
            BehavingEntity.getBehavingEntity().registerNegotiationThread(jointUnsuspendThread);
        } else {
            super.jointUnsuspend();
        }
    }

    @Override
    void resetStep() {
        super.resetStep();
    }

    void cleanupParentIfRoot() {
        if (this.parent.isRootBehavior()) {
            this.parent.removeChild(this, true);
        }
    }

    List freezeSubtreeAndNegotiateRemovalEntry() {
        return super.freezeSubtreeAndNegotiateRemoval();
    }

    List freezeSubtreeAndNegotiateRemoval() {
        JointGoalNegotiationThread negotiateRemovalThread = new JointGoalNegotiationThread(this.negotiator, this + " negotiateRemovalThread"){

            @Override
            public void run() {
                JointGoalStep.this.setIsNegotiating(true);
                if (JointGoalStep.this.negotiator != null && JointGoalStep.this.negotiator.negotiateRemoval()) {
                    JointGoalStep.this.removeGoal();
                    JointGoalStep.this.setIsNegotiating(false);
                }
            }
        };
        assert (this.child == null || this.negotiator != null) : "step = " + this + " negotiator = " + this.negotiator + ", child = " + this.child;
        if (this.negotiator != null) {
            BehavingEntity.getBehavingEntity().registerNegotiationThread(negotiateRemovalThread);
            Vector<Step> v = new Vector<Step>(super.freezeSubtreeAndNegotiateRemoval());
            v.add(this);
            return v;
        }
        return new Vector(0);
    }

    List negotiateSuspensionOfSubtreeEntry() {
        if (this.child != null) {
            return this.child.negotiateSuspensionOfSubtree();
        }
        return new Vector(0);
    }

    @Override
    List negotiateSuspensionOfSubtree() {
        JointGoalNegotiationThread negotiateSuspendThread = new JointGoalNegotiationThread(this.negotiator, this + " negotiateSuspendThread"){

            @Override
            public void run() {
                JointGoalStep.this.setIsNegotiating(true);
                if (JointGoalStep.this.negotiator != null) {
                    if (JointGoalStep.this.negotiator.negotiateSuspend()) {
                        JointGoalStep.this.jointSuspendSuper();
                    }
                    JointGoalStep.this.setIsNegotiating(false);
                }
            }
        };
        BehavingEntity.getBehavingEntity().registerNegotiationThread(negotiateSuspendThread);
        Vector<JointGoalStep> v = new Vector<JointGoalStep>(this.negotiateSuspensionOfSubtreeEntry());
        v.add(this);
        return v;
    }

    List negotiateSuspensionOfSubtreeEntry(ExecutableStep step) {
        if (this.child != null) {
            return this.child.negotiateSuspensionOfSubtree(step);
        }
        return new Vector(0);
    }

    @Override
    List negotiateSuspensionOfSubtree(final ExecutableStep step) {
        JointGoalNegotiationThread negotiateSuspendThread = new JointGoalNegotiationThread(this.negotiator, this + " negotiateSuspendThread"){

            @Override
            public void run() {
                JointGoalStep.this.setIsNegotiating(true);
                if (JointGoalStep.this.negotiator != null && JointGoalStep.this.negotiator.negotiateSuspend()) {
                    if (step != null) {
                        JointGoalStep.this.suspendSuper(step, false);
                    } else {
                        JointGoalStep.this.metaSuspendSuper(false);
                    }
                    JointGoalStep.this.setIsNegotiating(false);
                }
            }
        };
        BehavingEntity.getBehavingEntity().registerNegotiationThread(negotiateSuspendThread);
        Vector<JointGoalStep> v = new Vector<JointGoalStep>(this.negotiateSuspensionOfSubtreeEntry(step));
        v.add(this);
        return v;
    }
}

