/*
 * Decompiled with CFR 0.152.
 */
package abl.runtime;

import abl.compiler.AblDebuggerConstants;
import abl.runtime.BehavingEntity;
import abl.runtime.DebuggableJointGoalStep;
import abl.runtime.JointGoalNegotiationThread;
import abl.runtime.JointGoalNegotiator;
import abl.runtime.JointGoalStep;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class JointGoalNegotiatorDebug
extends JointGoalNegotiator
implements AblDebuggerConstants {
    private final byte debugLevel;
    private final List negotiationEvents = new ArrayList(20);

    JointGoalNegotiatorDebug(Set teamMembers, boolean isNewEntryNegotiation, JointGoalStep g, byte arg_debugLevel) {
        super(teamMembers, isNewEntryNegotiation, g);
        this.debugLevel = arg_debugLevel;
    }

    JointGoalNegotiatorDebug(Hashtable commitSet, byte arg_debugLevel) {
        super(commitSet);
        this.debugLevel = arg_debugLevel;
    }

    JointGoalNegotiatorDebug(Hashtable commitSet, int currentState, byte arg_debugLevel) {
        super(commitSet, currentState);
        this.debugLevel = arg_debugLevel;
    }

    JointGoalNegotiatorDebug(Set teamMembers, JointGoalStep g, byte arg_debugLevel) {
        super(teamMembers, g);
        this.debugLevel = arg_debugLevel;
    }

    @Override
    protected synchronized void setState(int state) {
        JointGoalNegotiationThread t2 = (JointGoalNegotiationThread)Thread.currentThread();
        this.negotiationEvents.add(new JointGoalNegotiationEvent(t2.descriptorString, null, state));
        super.setState(state);
    }

    @Override
    protected final void initiateNegotiationAction(JointGoalStep g, int negotiation) {
        JointGoalNegotiationInfo info = new JointGoalNegotiationInfo(g, null, negotiation);
        if (this.debugLevel == 2) {
            ((DebuggableJointGoalStep)((Object)this.negotiatingGoal)).traceAblNegotiationEvent(20, info);
        }
        this.negotiationEvents.add(new JointGoalNegotiationEvent("INITIATE_NEGOTIATION", info, this.getState()));
    }

    @Override
    protected final void completeNegotiationAction(JointGoalStep g, int negotiation) {
        JointGoalNegotiationInfo info = new JointGoalNegotiationInfo(g, null, negotiation);
        if (this.debugLevel == 2) {
            ((DebuggableJointGoalStep)((Object)this.negotiatingGoal)).traceAblNegotiationEvent(21, info);
        }
        this.negotiationEvents.add(new JointGoalNegotiationEvent("COMPLETE_NEGOTIATION", info, this.getState()));
    }

    @Override
    protected final void initiateIntentionAction(BehavingEntity sender, JointGoalStep receivingGoal, int intention) {
        JointGoalNegotiationInfo info = new JointGoalNegotiationInfo(receivingGoal, sender, intention);
        if (this.debugLevel == 2) {
            ((DebuggableJointGoalStep)((Object)this.negotiatingGoal)).traceAblNegotiationEvent(22, info);
        }
        this.negotiationEvents.add(new JointGoalNegotiationEvent("INITIATE_INTENTION", info, this.getState()));
    }

    @Override
    protected final void commitToIntentionAction(JointGoalStep g, int intention) {
        JointGoalNegotiationInfo info = new JointGoalNegotiationInfo(g, null, intention);
        if (this.debugLevel == 2) {
            ((DebuggableJointGoalStep)((Object)this.negotiatingGoal)).traceAblNegotiationEvent(23, info);
        }
        this.negotiationEvents.add(new JointGoalNegotiationEvent("COMMIT_TO_INTENTION", info, this.getState()));
    }

    @Override
    protected final void processIntentionAction(BehavingEntity sender, JointGoalStep receivingGoal, int intention) {
        JointGoalNegotiationInfo info = new JointGoalNegotiationInfo(receivingGoal, sender, intention);
        if (this.debugLevel == 2) {
            ((DebuggableJointGoalStep)((Object)this.negotiatingGoal)).traceAblNegotiationEvent(24, info);
        }
        this.negotiationEvents.add(new JointGoalNegotiationEvent("PROCESS_INTENTION", info, this.getState()));
    }

    @Override
    void printNegotiationHistory(PrintStream s) {
        Iterator iter = this.negotiationEvents.iterator();
        s.println("Negotiation history:  for " + this.negotiatingGoal + ":");
        s.println("   Current state: " + JointGoalNegotiatorDebug.formatState(this.getState()));
        while (iter.hasNext()) {
            JointGoalNegotiationEvent evt = (JointGoalNegotiationEvent)iter.next();
            s.println("   " + evt);
        }
    }

    @Override
    final void printNegotiationHistory() {
        this.printNegotiationHistory(System.err);
    }

    class JointGoalNegotiationEvent {
        String negotiation;
        JointGoalNegotiationInfo info;
        int currentState;

        JointGoalNegotiationEvent(String negotiation, JointGoalNegotiationInfo info, int currentState) {
            this.negotiation = negotiation;
            this.info = info;
            this.currentState = currentState;
        }

        public String toString() {
            if (this.info != null) {
                String entity = this.info.behavingEntity != null ? this.info.behavingEntity.getBehavingEntityShortName() : "self";
                return String.valueOf(this.negotiation) + " from: " + entity + ", intention: " + JointGoalNegotiatorDebug.formatIntention(this.info.intention) + ", state: " + JointGoalNegotiatorDebug.formatState(this.currentState);
            }
            return "state changed by " + this.negotiation + " to: " + JointGoalNegotiatorDebug.formatState(this.currentState);
        }
    }

    class JointGoalNegotiationInfo {
        final JointGoalStep g;
        final BehavingEntity behavingEntity;
        final int intention;

        JointGoalNegotiationInfo(JointGoalStep g, BehavingEntity behavingEntity, int intention) {
            this.g = g;
            this.behavingEntity = behavingEntity;
            this.intention = intention;
        }
    }
}

