/*
 * Decompiled with CFR 0.152.
 */
package abl.runtime;

import abl.runtime.BehavingEntity;
import abl.runtime.JointGoalNegotiationThread;
import abl.runtime.JointGoalStep;
import abl.runtime.MessageReceivedAfterCommitError;
import abl.runtime.UnexpectedStateError;
import debug.Trace;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class JointGoalNegotiator {
    protected int currentState;
    protected final BehavingEntity receiver = BehavingEntity.getBehavingEntity();
    protected JointGoalStep negotiatingGoal;
    static final int INVALID = -3;
    static final int FIRST_STATE = -1;
    static final int START = -1;
    static final int INTENTION_TO_ENTER = 0;
    static final int INTENTION_TO_REFUSE_ENTRY = 1;
    static final int COMMIT_TO_ENTER = 2;
    static final int COMMIT_TO_REFUSE_ENTRY = 3;
    static final int RUNNING = 4;
    static final int INTENTION_TO_SUCCEED = 5;
    static final int WAIT_FOR_SUCCESS = 6;
    static final int COMMIT_TO_SUCCEED = 7;
    static final int INTENTION_TO_FAIL = 8;
    static final int COMMIT_TO_FAIL = 9;
    static final int INTENTION_TO_SUSPEND = 10;
    static final int COMMIT_TO_SUSPEND = 11;
    static final int SUSPENDED = 12;
    static final int INTENTION_TO_UNSUSPEND = 13;
    static final int COMMIT_TO_UNSUSPEND = 14;
    static final int INTENTION_TO_REMOVE = 15;
    static final int COMMIT_TO_REMOVE = 16;
    static final int LAST_STATE = 16;
    static final int FIRST_ENTRY_INTENTION = 17;
    static final int ENTER = 17;
    static final int REFUSE_ENTRY = 18;
    static final int LAST_ENTRY_INTENTION = 18;
    static final int FIRST_EXIT_INTENTION = 19;
    static final int SUCCEED = 19;
    static final int FAIL = 20;
    static final int REMOVE = 21;
    static final int SUSPEND = 22;
    static final int UNSUSPEND = 23;
    static final int LAST_EXIT_INTENTION = 23;
    protected Hashtable runningCommitSet = new Hashtable();
    protected Set negotiatingCommitSet = new HashSet();
    protected final Set teamMembers;
    private static long uniqueEntryNegotiationID = 0L;
    protected JointGoalStep escroedGoalStep = null;

    private boolean teamMembersAreBehavingEntities(Set teamMembers) {
        Iterator iter = teamMembers.iterator();
        while (iter.hasNext()) {
            try {
                BehavingEntity entity = (BehavingEntity)iter.next();
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return true;
    }

    JointGoalNegotiator(Set teamMembers, JointGoalStep negotiatingGoal) {
        assert (this.teamMembersAreBehavingEntities(teamMembers));
        this.teamMembers = new HashSet(teamMembers);
        this.currentState = -1;
        this.negotiatingGoal = negotiatingGoal;
    }

    JointGoalNegotiator(Set teamMembers, boolean isNewEntryNegotiation, JointGoalStep negotiatingGoal) {
        assert (this.teamMembersAreBehavingEntities(teamMembers));
        this.teamMembers = new HashSet(teamMembers);
        this.currentState = -1;
        if (isNewEntryNegotiation) {
            ++uniqueEntryNegotiationID;
        }
        this.negotiatingGoal = negotiatingGoal;
    }

    JointGoalNegotiator(Hashtable commitSet) {
        this.teamMembers = new HashSet(commitSet.keySet());
        assert (this.teamMembersAreBehavingEntities(this.teamMembers));
        this.runningCommitSet = new Hashtable(commitSet);
        this.currentState = -1;
        this.negotiatingGoal = (JointGoalStep)this.runningCommitSet.get(this.receiver);
        assert (this.negotiatingGoal != null);
    }

    JointGoalNegotiator(Hashtable commitSet, int currentState) {
        this.teamMembers = new HashSet(commitSet.keySet());
        assert (this.teamMembersAreBehavingEntities(this.teamMembers));
        this.runningCommitSet = new Hashtable(commitSet);
        assert (JointGoalNegotiator.isLegalState(currentState)) : Integer.toString(currentState);
        this.currentState = currentState;
        this.negotiatingGoal = (JointGoalStep)this.runningCommitSet.get(this.receiver);
        assert (this.negotiatingGoal != null);
    }

    public static String formatIntention(int intention) {
        assert (intention >= 17 && intention <= 23);
        switch (intention) {
            case 17: {
                return "ENTER";
            }
            case 18: {
                return "REFUSE_ENTRY";
            }
            case 19: {
                return "SUCCEED";
            }
            case 20: {
                return "FAIL";
            }
            case 21: {
                return "REMOVE";
            }
            case 22: {
                return "SUSPEND";
            }
            case 23: {
                return "UNSUSPEND";
            }
        }
        return "NOT_INTENTION";
    }

    public static String formatState(int state) {
        assert (state >= -1 && state <= 16);
        switch (state) {
            case -1: {
                return "START";
            }
            case 0: {
                return "INTENTION_TO_ENTER";
            }
            case 1: {
                return "INTENTION_TO_REFUSE_ENTRY";
            }
            case 2: {
                return "COMMIT_TO_ENTER";
            }
            case 3: {
                return "COMMIT_TO_REFUSE_ENTRY";
            }
            case 4: {
                return "RUNNING";
            }
            case 5: {
                return "INTENTION_TO_SUCCEED";
            }
            case 6: {
                return "WAIT_FOR_SUCCESS";
            }
            case 7: {
                return "COMMIT_TO_SUCCEED";
            }
            case 8: {
                return "INTENTION_TO_FAIL";
            }
            case 9: {
                return "COMMIT_TO_FAIL";
            }
            case 10: {
                return "INTENTION_TO_SUSPEND";
            }
            case 11: {
                return "COMMIT_TO_SUSPEND";
            }
            case 12: {
                return "SUSPENDED";
            }
            case 13: {
                return "INTENTION_TO_UNSUSPEND";
            }
            case 14: {
                return "COMMIT_TO_UNSUSPEND";
            }
            case 15: {
                return "INTENTION_TO_REMOVE";
            }
            case 16: {
                return "COMMIT_TO_REMOVE";
            }
        }
        return "INVALID";
    }

    Long getUniqueEntryNegotiationID() {
        return new Long(uniqueEntryNegotiationID);
    }

    synchronized int getState() {
        return this.currentState;
    }

    protected synchronized void setState(int state) {
        assert (state >= -1 && state <= 16);
        this.currentState = state;
        if (state == 2 || state == 3 || state == 7 || state == 9 || state == 11 || state == 14 || state == 16) {
            BehavingEntity.getBehavingEntity().jointGoalNegotiatorCommitted();
        }
    }

    Set getTeamMembers() {
        return new HashSet(this.teamMembers);
    }

    void setCommitSet(Hashtable commitSet) {
        this.runningCommitSet = new Hashtable(commitSet);
        this.negotiatingGoal = (JointGoalStep)this.runningCommitSet.get(this.receiver);
        assert (this.negotiatingGoal != null);
    }

    Hashtable getCommitSet() {
        return new Hashtable(this.runningCommitSet);
    }

    static boolean isLegalState(int state) {
        return state >= -1 && state <= 16;
    }

    protected void initiateNegotiationAction(JointGoalStep g, int negotiation) {
    }

    protected void completeNegotiationAction(JointGoalStep g, int negotiation) {
    }

    protected void initiateIntentionAction(BehavingEntity sender, JointGoalStep negotiatingGoal, int intention) {
    }

    protected void commitToIntentionAction(JointGoalStep g, int intention) {
    }

    protected void processIntentionAction(BehavingEntity sender, JointGoalStep negotiatingGoal, int intention) {
    }

    void printNegotiationHistory() {
    }

    void printNegotiationHistory(PrintStream p) {
    }

    private int convertCommitStateToIntention(int commitState) {
        switch (commitState) {
            case 2: {
                return 17;
            }
            case 3: {
                return 18;
            }
            case 7: {
                return 19;
            }
            case 9: {
                return 20;
            }
            case 11: 
            case 12: {
                return 22;
            }
            case 4: 
            case 14: {
                return 23;
            }
            case 16: {
                return 21;
            }
        }
        return 24;
    }

    public Hashtable negotiateEntry(Object[] args, JointGoalStep initiatingGoal) {
        Trace.ablTrace("Negotiating entry for " + initiatingGoal + ", teamNeededForSuccess = " + initiatingGoal.getTeamNeededForSuccess());
        if (this.getState() != -1) {
            throw new UnexpectedStateError(this.getState());
        }
        this.setState(0);
        Long uniqueID = new Long(uniqueEntryNegotiationID);
        this.escroedGoalStep = initiatingGoal;
        this.initiateNegotiationAction(initiatingGoal, 17);
        this.runningCommitSet.put(BehavingEntity.getBehavingEntity(), initiatingGoal);
        this.broadcastIntentionToEnter(uniqueID, args, initiatingGoal.getTeamNeededForSuccess(), initiatingGoal);
        while (this.getState() != 2 && this.getState() != 3) {
            ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
        }
        Trace.ablTrace("Entry negotiated");
        if (this.getState() == 2) {
            this.completeNegotiationAction(initiatingGoal, 17);
        } else {
            this.completeNegotiationAction(initiatingGoal, 18);
        }
        if (this.getState() == 2) {
            this.setState(4);
            return this.getCommitSet();
        }
        if (this.getState() == 3) {
            return null;
        }
        throw new UnexpectedStateError(this.getState());
    }

    /*
     * Unable to fully structure code
     */
    public void processIntentionToEnter(Long uniqueEntryNegotiationID, BehavingEntity sender, Object[] args, boolean teamNeededForSuccess, Set teamMembers, JointGoalStep sendingGoal, JointGoalStep escroedGoalStep) {
        block13: {
            block12: {
                myBehavingEntity = BehavingEntity.getBehavingEntity();
                Trace.ablTrace("Process intention to enter in " + myBehavingEntity + " for goal " + sendingGoal);
                this.processIntentionAction(sender, sendingGoal, 17);
                if (this.getState() != -1) break block12;
                newBeh = BehavingEntity.getBehavingEntity().chooseJointBehavior(args, new HashSet<E>(), escroedGoalStep, teamMembers);
                if (newBeh == null) ** GOTO lbl37
                this.setState(0);
                this.initiateIntentionAction(sender, escroedGoalStep, 17);
                this.runningCommitSet.put(sender, sendingGoal);
                this.runningCommitSet.put(myBehavingEntity, escroedGoalStep);
                this.broadcastIntentionToEnter(uniqueEntryNegotiationID, args, escroedGoalStep.getTeamNeededForSuccess(), escroedGoalStep);
                if (!this.runningCommitSet.keySet().equals(teamMembers)) ** GOTO lbl24
                this.setState(2);
                this.commitToIntentionAction(escroedGoalStep, 17);
                myBehavingEntity.terminateEntryNegotiation(uniqueEntryNegotiationID);
                escroedGoalStep.resetNegotiator(this.runningCommitSet, 4);
                myBehavingEntity.getRootCollectionBehavior().addChild(escroedGoalStep);
                escroedGoalStep.addChild(newBeh);
                escroedGoalStep.executeBookkeeping();
                break block13;
lbl-1000:
                // 1 sources

                {
                    ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
lbl24:
                    // 2 sources

                    ** while (this.getState() != 2 && this.getState() != 3)
                }
lbl25:
                // 1 sources

                this.commitToIntentionAction(escroedGoalStep, this.convertCommitStateToIntention(this.getState()));
                myBehavingEntity.terminateEntryNegotiation(uniqueEntryNegotiationID);
                if (this.getState() == 2) {
                    escroedGoalStep.resetNegotiator(this.runningCommitSet, 4);
                    myBehavingEntity.getRootCollectionBehavior().addChild(escroedGoalStep);
                    escroedGoalStep.addChild(newBeh);
                    escroedGoalStep.executeBookkeeping();
                } else if (this.getState() == 3) {
                    escroedGoalStep = null;
                } else {
                    throw new UnexpectedStateError(this.getState());
lbl37:
                    // 1 sources

                    this.setState(1);
                    this.initiateIntentionAction(null, escroedGoalStep, 18);
                    this.runningCommitSet.put(myBehavingEntity, new Integer(0));
                    this.broadcastIntentionToRefuseEntry(uniqueEntryNegotiationID);
                    while (this.getState() != 3) {
                        ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
                    }
                    this.commitToIntentionAction(escroedGoalStep, 18);
                    myBehavingEntity.terminateEntryNegotiation(uniqueEntryNegotiationID);
                    escroedGoalStep = null;
                }
                break block13;
            }
            if (this.getState() == 0) {
                if (this.runningCommitSet.get(sender) == null) {
                    this.runningCommitSet.put(sender, sendingGoal);
                }
                if (this.runningCommitSet.keySet().equals(teamMembers)) {
                    this.setState(2);
                }
            } else if (this.getState() == 1) {
                this.runningCommitSet.remove(sender);
                this.broadcastIntentionToRefuseEntry(uniqueEntryNegotiationID);
            } else {
                throw new UnexpectedStateError(this.getState());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void processIntentionToRefuseEntry(Long uniqueEntryNegotiationID, BehavingEntity sender) {
        block7: {
            block8: {
                block6: {
                    this.processIntentionAction(sender, this.escroedGoalStep, 18);
                    receiver = BehavingEntity.getBehavingEntity();
                    if (this.getState() != -1) break block6;
                    this.initiateIntentionAction(sender, null, 18);
                    this.setState(1);
                    this.runningCommitSet.put(receiver, new Integer(0));
                    this.runningCommitSet.put(sender, new Integer(0));
                    this.broadcastIntentionToRefuseEntry(uniqueEntryNegotiationID);
                    if (!this.runningCommitSet.keySet().equals(this.teamMembers)) ** GOTO lbl17
                    this.setState(3);
                    this.commitToIntentionAction(this.escroedGoalStep, 18);
                    BehavingEntity.getBehavingEntity().terminateEntryNegotiation(uniqueEntryNegotiationID);
                    break block7;
lbl-1000:
                    // 1 sources

                    {
                        ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
lbl17:
                        // 2 sources

                        ** while (this.getState() != 3)
                    }
lbl18:
                    // 1 sources

                    this.commitToIntentionAction(this.escroedGoalStep, 18);
                    BehavingEntity.getBehavingEntity().terminateEntryNegotiation(uniqueEntryNegotiationID);
                    break block7;
                }
                if (this.getState() != 0) break block8;
                this.setState(1);
                this.initiateIntentionAction(null, this.escroedGoalStep, 18);
                this.runningCommitSet = new Hashtable<K, V>();
                this.runningCommitSet.put(receiver, new Integer(0));
                this.runningCommitSet.put(sender, new Integer(0));
                this.broadcastIntentionToRefuseEntry(uniqueEntryNegotiationID);
                if (!this.runningCommitSet.keySet().equals(this.teamMembers)) ** GOTO lbl37
                this.setState(3);
                this.commitToIntentionAction(null, 18);
                BehavingEntity.getBehavingEntity().terminateEntryNegotiation(uniqueEntryNegotiationID);
                break block7;
lbl-1000:
                // 1 sources

                {
                    ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
lbl37:
                    // 2 sources

                    ** while (this.getState() != 3)
                }
lbl38:
                // 1 sources

                this.commitToIntentionAction(this.escroedGoalStep, 18);
                BehavingEntity.getBehavingEntity().terminateEntryNegotiation(uniqueEntryNegotiationID);
                break block7;
            }
            if (this.getState() == 1) {
                if (this.runningCommitSet.get(sender) == null) {
                    this.runningCommitSet.put(sender, new Integer(0));
                }
                if (this.runningCommitSet.keySet().equals(this.teamMembers)) {
                    this.setState(3);
                }
            } else {
                throw new UnexpectedStateError(this.getState());
            }
        }
    }

    private boolean initiateSuccessNegotiation() {
        BehavingEntity thisEntity = BehavingEntity.getBehavingEntity();
        JointGoalStep negotiatingGoal = (JointGoalStep)this.runningCommitSet.get(thisEntity);
        this.initiateNegotiationAction(negotiatingGoal, 19);
        this.setState(5);
        this.negotiatingCommitSet.clear();
        this.negotiatingCommitSet.add(thisEntity);
        this.broadcastIntentionToExit(19);
        while (this.getState() != 7 && this.getState() != 9 && this.getState() != 16) {
            ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
        }
        this.completeNegotiationAction(negotiatingGoal, this.convertCommitStateToIntention(this.getState()));
        return this.getState() == 7;
    }

    public boolean negotiateSuccess() {
        JointGoalStep negotiatingGoal = (JointGoalStep)this.runningCommitSet.get(BehavingEntity.getBehavingEntity());
        Trace.ablTrace("Initiating success in state " + this.getState());
        switch (this.getState()) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                while (this.getState() != 4 && this.getState() != 3 && this.getState() != 7 && this.getState() != 9 && this.getState() != 16) {
                    ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
                }
                if (this.getState() == 4) {
                    negotiatingGoal.removeChild(true);
                    return this.initiateSuccessNegotiation();
                }
                if (this.getState() == 3) {
                    return false;
                }
                throw new UnexpectedStateError(this.getState(), negotiatingGoal);
            }
            case 7: 
            case 9: 
            case 16: {
                return false;
            }
            case 3: 
            case 5: 
            case 8: 
            case 15: {
                return false;
            }
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return this.initiateSuccessNegotiation();
            }
            case 6: {
                this.initiateNegotiationAction(negotiatingGoal, 19);
                this.setState(5);
                while (this.getState() != 7 && this.getState() != 9 && this.getState() != 16) {
                    ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
                }
                this.completeNegotiationAction(negotiatingGoal, this.convertCommitStateToIntention(this.getState()));
                return this.getState() == 7;
            }
        }
        throw new UnexpectedStateError(this.getState(), negotiatingGoal);
    }

    /*
     * Unable to fully structure code
     */
    private void initiateIntentionToSucceed(BehavingEntity sender) {
        block4: {
            receiver = BehavingEntity.getBehavingEntity();
            negotiatingGoal = (JointGoalStep)this.runningCommitSet.get(receiver);
            Trace.ablTrace("Initiating intention to succeed on " + receiver);
            Trace.ablTrace("Goal to succeed " + negotiatingGoal + ", teamNeededForSuccess = " + negotiatingGoal.getTeamNeededForSuccess());
            this.setState(5);
            this.initiateIntentionAction(sender, negotiatingGoal, 19);
            this.negotiatingCommitSet.clear();
            this.negotiatingCommitSet.add(sender);
            this.negotiatingCommitSet.add(receiver);
            if (negotiatingGoal.getTeamNeededForSuccess()) {
                Trace.ablTrace("waiting for success in " + negotiatingGoal);
                this.setState(6);
                while (this.getState() != 5 && this.getState() != 7 && this.getState() != 9 && this.getState() != 16) {
                    ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
                }
                Trace.ablTrace("goal succeeded: " + negotiatingGoal);
            }
            if (this.getState() != 5) break block4;
            JointGoalStep.blockOnSubtreeNegotiation(negotiatingGoal.freezeSubtreeAndNegotiateRemovalEntry());
            this.broadcastIntentionToExit(19);
            if (!this.negotiatingCommitSet.equals(this.teamMembers)) ** GOTO lbl28
            this.setState(7);
            this.commitToIntentionAction(negotiatingGoal, 19);
            negotiatingGoal.succeedStep();
            break block4;
lbl-1000:
            // 1 sources

            {
                ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
lbl28:
                // 2 sources

                ** while (this.getState() != 7 && this.getState() != 9 && this.getState() != 16)
            }
lbl29:
            // 1 sources

            this.commitToIntentionAction(negotiatingGoal, this.convertCommitStateToIntention(this.getState()));
            if (this.getState() == 7) {
                negotiatingGoal.succeedStep();
            }
        }
    }

    public void processIntentionToSucceed(BehavingEntity sender) {
        BehavingEntity receiver = BehavingEntity.getBehavingEntity();
        JointGoalStep negotiatingGoal = (JointGoalStep)this.runningCommitSet.get(receiver);
        this.processIntentionAction(sender, negotiatingGoal, 19);
        block0 : switch (this.getState()) {
            case -1: 
            case 1: 
            case 3: {
                throw new UnexpectedStateError(this.getState(), negotiatingGoal);
            }
            case 0: 
            case 2: {
                while (this.getState() != 4 && this.getState() != 3 && this.getState() != 7 && this.getState() != 9 && this.getState() != 16) {
                    ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
                }
                switch (this.getState()) {
                    case 4: {
                        this.initiateIntentionToSucceed(sender);
                        break block0;
                    }
                    case 7: 
                    case 9: 
                    case 16: {
                        break block0;
                    }
                    case 3: {
                        throw new UnexpectedStateError(this.getState(), negotiatingGoal);
                    }
                }
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                this.initiateIntentionToSucceed(sender);
                break;
            }
            case 15: {
                return;
            }
            case 5: 
            case 6: {
                this.negotiatingCommitSet.add(sender);
                if (!this.negotiatingCommitSet.equals(this.teamMembers)) break;
                this.setState(7);
                break;
            }
            case 7: 
            case 9: 
            case 16: {
                throw new MessageReceivedAfterCommitError(19, this.getState(), negotiatingGoal);
            }
            case 8: {
                this.negotiatingCommitSet.remove(sender);
                break;
            }
            default: {
                throw new UnexpectedStateError(this.getState(), negotiatingGoal);
            }
        }
    }

    private void initiateFailureNegotiation() {
        BehavingEntity thisEntity = BehavingEntity.getBehavingEntity();
        JointGoalStep negotiatingGoal = (JointGoalStep)this.runningCommitSet.get(thisEntity);
        this.initiateNegotiationAction(negotiatingGoal, 20);
        this.setState(8);
        this.negotiatingCommitSet.clear();
        this.negotiatingCommitSet.add(BehavingEntity.getBehavingEntity());
        this.broadcastIntentionToExit(20);
        while (this.getState() != 9) {
            ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
        }
        this.completeNegotiationAction(negotiatingGoal, this.convertCommitStateToIntention(this.getState()));
    }

    public boolean negotiateFailure() {
        Trace.ablTrace("Negotiating failure");
        switch (this.getState()) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                while (this.getState() != 4 && this.getState() != 3 && this.getState() != 7 && this.getState() != 9 && this.getState() != 16) {
                    ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
                }
                if (this.getState() == 4) {
                    this.negotiatingGoal.removeChild(true);
                    this.initiateFailureNegotiation();
                    return true;
                }
                if (this.getState() == 3) {
                    return false;
                }
                throw new UnexpectedStateError(this.getState(), this.negotiatingGoal);
            }
            case 7: 
            case 9: 
            case 16: {
                return false;
            }
            case 3: 
            case 8: 
            case 15: {
                return false;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                this.initiateFailureNegotiation();
                return true;
            }
        }
        throw new UnexpectedStateError(this.getState(), this.negotiatingGoal);
    }

    /*
     * Unable to fully structure code
     */
    private void initiateIntentionToFail(BehavingEntity sender) {
        block1: {
            receiver = BehavingEntity.getBehavingEntity();
            negotiatingGoal = (JointGoalStep)this.runningCommitSet.get(receiver);
            this.setState(8);
            this.initiateIntentionAction(sender, negotiatingGoal, 20);
            this.negotiatingCommitSet.clear();
            this.negotiatingCommitSet.add(sender);
            this.negotiatingCommitSet.add(receiver);
            JointGoalStep.blockOnSubtreeNegotiation(negotiatingGoal.freezeSubtreeAndNegotiateRemovalEntry());
            this.broadcastIntentionToExit(20);
            if (!this.negotiatingCommitSet.equals(this.teamMembers)) ** GOTO lbl18
            this.setState(9);
            this.commitToIntentionAction(negotiatingGoal, 20);
            ((JointGoalStep)this.runningCommitSet.get(receiver)).failStep();
            break block1;
lbl-1000:
            // 1 sources

            {
                ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
lbl18:
                // 2 sources

                ** while (this.getState() != 9)
            }
lbl19:
            // 1 sources

            this.commitToIntentionAction(negotiatingGoal, 20);
            ((JointGoalStep)this.runningCommitSet.get(receiver)).failStep();
        }
    }

    public void processIntentionToFail(BehavingEntity sender) {
        BehavingEntity receiver = BehavingEntity.getBehavingEntity();
        JointGoalStep negotiatingGoal = (JointGoalStep)this.runningCommitSet.get(receiver);
        this.processIntentionAction(sender, negotiatingGoal, 20);
        switch (this.getState()) {
            case -1: 
            case 1: 
            case 3: {
                throw new UnexpectedStateError(this.getState(), negotiatingGoal);
            }
            case 0: 
            case 2: {
                while (this.getState() != 4 && this.getState() != 3 && this.getState() != 7 && this.getState() != 9 && this.getState() != 16) {
                    ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
                }
                if (this.getState() == 4) {
                    this.initiateIntentionToFail(sender);
                    break;
                }
                throw new UnexpectedStateError(this.getState(), negotiatingGoal);
            }
            case 7: 
            case 9: 
            case 16: {
                throw new MessageReceivedAfterCommitError(20, this.getState(), negotiatingGoal);
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                this.initiateIntentionToFail(sender);
                break;
            }
            case 15: {
                break;
            }
            case 8: {
                this.negotiatingCommitSet.add(sender);
                if (!this.negotiatingCommitSet.equals(this.teamMembers)) break;
                this.setState(9);
                break;
            }
            default: {
                throw new UnexpectedStateError(this.getState(), negotiatingGoal);
            }
        }
    }

    private boolean initiateSuspendNegotiation() {
        BehavingEntity thisEntity = BehavingEntity.getBehavingEntity();
        JointGoalStep negotiatingGoal = (JointGoalStep)this.runningCommitSet.get(thisEntity);
        this.initiateNegotiationAction(negotiatingGoal, 22);
        this.setState(10);
        this.negotiatingCommitSet.clear();
        this.negotiatingCommitSet.add(thisEntity);
        this.broadcastIntentionToExit(22);
        while (this.getState() != 16 && this.getState() != 9 && this.getState() != 7 && this.getState() != 11) {
            ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
        }
        this.completeNegotiationAction(negotiatingGoal, this.convertCommitStateToIntention(this.getState()));
        return this.getState() == 11;
    }

    public boolean negotiateSuspend() {
        JointGoalStep negotiatingGoal = (JointGoalStep)this.runningCommitSet.get(BehavingEntity.getBehavingEntity());
        Trace.ablTrace("Initiating suspend in state " + this.getState());
        switch (this.getState()) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                while (this.getState() != 4 && this.getState() != 3 && this.getState() != 7 && this.getState() != 9 && this.getState() != 16) {
                    ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
                }
                if (this.getState() == 4) {
                    return this.initiateSuspendNegotiation();
                }
                if (this.getState() == 3) {
                    return false;
                }
                throw new UnexpectedStateError(this.getState(), negotiatingGoal);
            }
            case 7: 
            case 9: 
            case 16: {
                return false;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 15: {
                return false;
            }
            case 4: 
            case 6: {
                return this.initiateSuspendNegotiation();
            }
            case 11: 
            case 13: 
            case 14: {
                while (this.getState() != 7 && this.getState() != 9 && this.getState() != 16 && this.getState() != 4 && this.getState() != 12) {
                    ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
                }
                if (this.getState() == 4 || this.getState() == 12) {
                    return this.initiateSuspendNegotiation();
                }
                return false;
            }
        }
        throw new UnexpectedStateError(this.getState(), negotiatingGoal);
    }

    /*
     * Unable to fully structure code
     */
    private void initiateIntentionToSuspend(BehavingEntity sender) {
        block2: {
            receiver = BehavingEntity.getBehavingEntity();
            negotiatingGoal = (JointGoalStep)this.runningCommitSet.get(receiver);
            this.initiateIntentionAction(sender, negotiatingGoal, 22);
            this.setState(10);
            this.negotiatingCommitSet.clear();
            this.negotiatingCommitSet.add(sender);
            this.negotiatingCommitSet.add(receiver);
            JointGoalStep.blockOnSubtreeNegotiation(negotiatingGoal.negotiateSuspensionOfSubtreeEntry());
            this.broadcastIntentionToExit(22);
            if (!this.negotiatingCommitSet.equals(this.teamMembers)) ** GOTO lbl18
            this.commitToIntentionAction(negotiatingGoal, 22);
            this.setState(12);
            negotiatingGoal.jointSuspend();
            break block2;
lbl-1000:
            // 1 sources

            {
                ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
lbl18:
                // 2 sources

                ** while (this.getState() != 7 && this.getState() != 9 && this.getState() != 16 && this.getState() != 11)
            }
lbl19:
            // 1 sources

            this.commitToIntentionAction(negotiatingGoal, this.convertCommitStateToIntention(this.getState()));
            if (this.getState() == 11) {
                negotiatingGoal.jointSuspend();
                this.setState(12);
            }
        }
    }

    public void processIntentionToSuspend(BehavingEntity sender) {
        BehavingEntity receiver = BehavingEntity.getBehavingEntity();
        JointGoalStep negotiatingGoal = (JointGoalStep)this.runningCommitSet.get(receiver);
        this.processIntentionAction(sender, negotiatingGoal, 22);
        switch (this.getState()) {
            case -1: 
            case 1: 
            case 3: {
                throw new UnexpectedStateError(this.getState(), negotiatingGoal);
            }
            case 0: 
            case 2: {
                while (this.getState() != 4 && this.getState() != 3 && this.getState() != 7 && this.getState() != 9 && this.getState() != 16) {
                    ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
                }
                if (this.getState() == 4) {
                    this.initiateIntentionToSuspend(sender);
                    break;
                }
                throw new UnexpectedStateError(this.getState(), negotiatingGoal);
            }
            case 7: 
            case 9: 
            case 16: {
                throw new MessageReceivedAfterCommitError(20, this.getState(), negotiatingGoal);
            }
            case 4: 
            case 6: 
            case 12: {
                this.initiateIntentionToSuspend(sender);
                break;
            }
            case 13: {
                HashSet oldNegotiatingCommitSet = new HashSet(this.negotiatingCommitSet);
                this.initiateIntentionToSuspend(sender);
                while (this.getState() != 4 && this.getState() != 7 && this.getState() != 9 && this.getState() != 16 && this.getState() != 12) {
                    ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
                }
                if (this.getState() != 4 && this.getState() != 12) break;
                this.setState(13);
                this.negotiatingCommitSet = oldNegotiatingCommitSet;
                break;
            }
            case 11: 
            case 14: {
                while (this.getState() != 4 && this.getState() != 7 && this.getState() != 9 && this.getState() != 16 && this.getState() != 12) {
                    ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
                }
                if (this.getState() != 4 && this.getState() != 12) break;
                this.initiateIntentionToSuspend(sender);
                break;
            }
            case 5: 
            case 8: 
            case 15: {
                this.negotiatingCommitSet.remove(sender);
                break;
            }
            case 10: {
                this.negotiatingCommitSet.add(sender);
                if (!this.negotiatingCommitSet.equals(this.teamMembers)) break;
                this.setState(11);
                break;
            }
            default: {
                throw new UnexpectedStateError(this.getState(), negotiatingGoal);
            }
        }
    }

    private boolean initiateUnsuspendNegotiation() {
        BehavingEntity thisEntity = BehavingEntity.getBehavingEntity();
        JointGoalStep negotiatingGoal = (JointGoalStep)this.runningCommitSet.get(thisEntity);
        this.initiateNegotiationAction(negotiatingGoal, 23);
        this.setState(13);
        this.negotiatingCommitSet.clear();
        this.negotiatingCommitSet.add(thisEntity);
        this.broadcastIntentionToExit(23);
        while (this.getState() != 16 && this.getState() != 9 && this.getState() != 7 && this.getState() != 14) {
            ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
        }
        this.completeNegotiationAction(negotiatingGoal, this.convertCommitStateToIntention(this.getState()));
        return this.getState() == 14;
    }

    public boolean negotiateUnsuspend() {
        Trace.ablTrace("Initiating unsuspend in state " + this.getState());
        switch (this.getState()) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                while (this.getState() != 4 && this.getState() != 3 && this.getState() != 7 && this.getState() != 9 && this.getState() != 16) {
                    ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
                }
                if (this.getState() == 4) {
                    return this.initiateUnsuspendNegotiation();
                }
                if (this.getState() == 3) {
                    return false;
                }
                throw new UnexpectedStateError(this.getState(), this.negotiatingGoal);
            }
            case 7: 
            case 9: 
            case 16: {
                return false;
            }
            case 11: 
            case 14: {
                while (this.getState() != 16 && this.getState() != 9 && this.getState() != 7 && this.getState() != 12 && this.getState() != 4) {
                    ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
                }
                if (this.getState() == 12 || this.getState() == 4) {
                    return this.initiateUnsuspendNegotiation();
                }
                return false;
            }
            case 10: 
            case 13: {
                while (this.getState() != 16 && this.getState() != 9 && this.getState() != 7 && this.getState() != 12 && this.getState() != 4) {
                    ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
                }
                if (this.getState() == 12) {
                    return this.initiateUnsuspendNegotiation();
                }
                return false;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 15: {
                return false;
            }
            case 12: {
                return this.initiateUnsuspendNegotiation();
            }
        }
        throw new UnexpectedStateError(this.getState(), this.negotiatingGoal);
    }

    /*
     * Unable to fully structure code
     */
    private void initiateIntentionToUnsuspend(BehavingEntity sender) {
        block6: {
            receiver = BehavingEntity.getBehavingEntity();
            negotiatingGoal = (JointGoalStep)this.runningCommitSet.get(receiver);
            this.initiateIntentionAction(sender, negotiatingGoal, 23);
            this.setState(13);
            this.negotiatingCommitSet.clear();
            this.negotiatingCommitSet.add(sender);
            this.negotiatingCommitSet.add(receiver);
            this.broadcastIntentionToExit(23);
            if (!this.negotiatingCommitSet.equals(this.teamMembers)) ** GOTO lbl20
            this.commitToIntentionAction(negotiatingGoal, 23);
            negotiatingGoal.jointUnsuspendEntry();
            if (negotiatingGoal.isSuspended()) {
                this.setState(12);
            } else {
                this.setState(4);
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
lbl20:
                // 2 sources

                ** while (this.getState() != 7 && this.getState() != 9 && this.getState() != 16 && this.getState() != 14)
            }
lbl21:
            // 1 sources

            this.commitToIntentionAction(negotiatingGoal, this.convertCommitStateToIntention(this.getState()));
            if (this.getState() == 14) {
                negotiatingGoal.jointUnsuspendEntry();
                if (negotiatingGoal.isSuspended()) {
                    this.setState(12);
                } else {
                    this.setState(4);
                }
            }
        }
    }

    public void processIntentionToUnsuspend(BehavingEntity sender) {
        BehavingEntity receiver = BehavingEntity.getBehavingEntity();
        JointGoalStep negotiatingGoal = (JointGoalStep)this.runningCommitSet.get(receiver);
        this.processIntentionAction(sender, negotiatingGoal, 23);
        switch (this.getState()) {
            case -1: 
            case 1: 
            case 3: {
                throw new UnexpectedStateError(this.getState(), negotiatingGoal);
            }
            case 0: 
            case 2: {
                while (this.getState() != 4 && this.getState() != 3 && this.getState() != 7 && this.getState() != 9 && this.getState() != 16) {
                    ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
                }
                if (this.getState() == 4) {
                    this.initiateIntentionToUnsuspend(sender);
                    break;
                }
                throw new UnexpectedStateError(this.getState(), negotiatingGoal);
            }
            case 7: 
            case 9: 
            case 16: {
                throw new MessageReceivedAfterCommitError(20, this.getState(), negotiatingGoal);
            }
            case 12: {
                this.initiateIntentionToUnsuspend(sender);
                break;
            }
            case 4: {
                throw new UnexpectedStateError(this.getState(), negotiatingGoal);
            }
            case 10: 
            case 11: 
            case 14: {
                while (this.getState() != 4 && this.getState() != 7 && this.getState() != 9 && this.getState() != 16 && this.getState() != 12) {
                    ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
                }
                if (this.getState() != 4 && this.getState() != 12) break;
                this.initiateIntentionToUnsuspend(sender);
                break;
            }
            case 5: 
            case 8: 
            case 15: {
                break;
            }
            case 13: {
                this.negotiatingCommitSet.add(sender);
                if (!this.negotiatingCommitSet.equals(this.teamMembers)) break;
                this.setState(14);
                break;
            }
            default: {
                throw new UnexpectedStateError(this.getState(), negotiatingGoal);
            }
        }
    }

    private boolean initiateRemovalNegotiation() {
        BehavingEntity thisEntity = BehavingEntity.getBehavingEntity();
        JointGoalStep negotiatingGoal = (JointGoalStep)this.runningCommitSet.get(thisEntity);
        this.initiateNegotiationAction(negotiatingGoal, 21);
        this.setState(15);
        this.negotiatingCommitSet.clear();
        this.negotiatingCommitSet.add(thisEntity);
        this.broadcastIntentionToExit(21);
        while (this.getState() != 16 && this.getState() != 9 && this.getState() != 7) {
            ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
        }
        this.completeNegotiationAction(negotiatingGoal, this.convertCommitStateToIntention(this.getState()));
        return this.getState() == 16;
    }

    public boolean negotiateRemoval() {
        Trace.ablTrace("Negotiating removal");
        switch (this.getState()) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                while (this.getState() != 4 && this.getState() != 3 && this.getState() != 7 && this.getState() != 9 && this.getState() != 16) {
                    ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
                }
                if (this.getState() == 4) {
                    this.negotiatingGoal.removeChild(true);
                    return this.initiateRemovalNegotiation();
                }
                if (this.getState() == 3) {
                    return false;
                }
                throw new UnexpectedStateError(this.getState(), this.negotiatingGoal);
            }
            case 7: 
            case 9: 
            case 16: {
                return false;
            }
            case 3: 
            case 8: 
            case 15: {
                return false;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return this.initiateRemovalNegotiation();
            }
        }
        throw new UnexpectedStateError(this.getState(), this.negotiatingGoal);
    }

    private void removeGoal(JointGoalStep g) {
        g.removeGoal();
        g.cleanupParentIfRoot();
    }

    /*
     * Unable to fully structure code
     */
    private void initiateIntentionToRemove(BehavingEntity sender) {
        block2: {
            receiver = BehavingEntity.getBehavingEntity();
            negotiatingGoal = (JointGoalStep)this.runningCommitSet.get(receiver);
            this.initiateIntentionAction(sender, negotiatingGoal, 21);
            this.setState(15);
            this.negotiatingCommitSet.clear();
            this.negotiatingCommitSet.add(sender);
            this.negotiatingCommitSet.add(receiver);
            JointGoalStep.blockOnSubtreeNegotiation(negotiatingGoal.freezeSubtreeAndNegotiateRemovalEntry());
            this.broadcastIntentionToExit(21);
            if (!this.negotiatingCommitSet.equals(this.teamMembers)) ** GOTO lbl18
            this.commitToIntentionAction(negotiatingGoal, 21);
            this.setState(16);
            this.removeGoal((JointGoalStep)this.runningCommitSet.get(receiver));
            break block2;
lbl-1000:
            // 1 sources

            {
                ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
lbl18:
                // 2 sources

                ** while (this.getState() != 7 && this.getState() != 9 && this.getState() != 16)
            }
lbl19:
            // 1 sources

            this.commitToIntentionAction(negotiatingGoal, this.convertCommitStateToIntention(this.getState()));
            if (this.getState() == 16) {
                this.removeGoal((JointGoalStep)this.runningCommitSet.get(receiver));
            }
        }
    }

    public void processIntentionToRemove(BehavingEntity sender) {
        BehavingEntity receiver = BehavingEntity.getBehavingEntity();
        JointGoalStep negotiatingGoal = (JointGoalStep)this.runningCommitSet.get(receiver);
        this.processIntentionAction(sender, negotiatingGoal, 21);
        switch (this.getState()) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                while (this.getState() != 4 && this.getState() != 3 && this.getState() != 7 && this.getState() != 9 && this.getState() != 16) {
                    ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
                }
                if (this.getState() == 4) {
                    this.initiateIntentionToRemove(sender);
                    break;
                }
                if (this.getState() == 3) {
                    return;
                }
                throw new UnexpectedStateError(this.getState(), negotiatingGoal);
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                this.initiateIntentionToRemove(sender);
                break;
            }
            case 15: {
                this.negotiatingCommitSet.add(sender);
                if (!this.negotiatingCommitSet.equals(this.teamMembers)) break;
                this.setState(16);
                break;
            }
            case 8: {
                this.negotiatingCommitSet.remove(sender);
                break;
            }
            case 7: 
            case 9: 
            case 16: {
                throw new MessageReceivedAfterCommitError(19, this.getState(), negotiatingGoal);
            }
            default: {
                throw new UnexpectedStateError(this.getState(), negotiatingGoal);
            }
        }
    }

    private void broadcastIntentionToEnter(Long uniqueEntryNegotiationID, Object[] args, boolean teamNeededForSuccess, JointGoalStep g) {
        BehavingEntity sender = BehavingEntity.getBehavingEntity();
        HashSet broadcastSet = new HashSet(this.teamMembers);
        broadcastSet.remove(sender);
        for (BehavingEntity destination : broadcastSet) {
            destination.queueIntentionToEnter(uniqueEntryNegotiationID, sender, args, teamNeededForSuccess, this.teamMembers, g);
        }
    }

    private void broadcastIntentionToRefuseEntry(Long uniqueEntryNegotiationID) {
        BehavingEntity sender = BehavingEntity.getBehavingEntity();
        HashSet broadcastSet = new HashSet(this.teamMembers);
        broadcastSet.remove(sender);
        for (BehavingEntity destination : broadcastSet) {
            destination.queueIntentionToRefuseEntry(uniqueEntryNegotiationID, sender, this.teamMembers);
        }
    }

    private void broadcastIntentionToExit(int intention) {
        BehavingEntity sender = BehavingEntity.getBehavingEntity();
        HashSet broadcastSet = new HashSet(this.teamMembers);
        broadcastSet.remove(sender);
        for (BehavingEntity destination : broadcastSet) {
            JointGoalStep goal = (JointGoalStep)this.runningCommitSet.get(destination);
            destination.queueIntentionToExit(sender, goal, intention);
        }
    }
}

