/*
 * Decompiled with CFR 0.152.
 */
package abl.runtime;

import abl.runtime.AblRuntimeError;
import abl.runtime.BehavingEntity;
import abl.runtime.JointGoalNegotiator;
import abl.runtime.JointGoalStep;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

abstract class JointGoalNegotiationThread
extends Thread {
    private boolean isWaiting = true;
    private boolean isStarted = false;
    private final JointGoalNegotiator negotiator;
    final String descriptorString;
    private final String stackTrace;
    private final int originalPriority;
    private final JointGoalStep negotiatingStep;

    JointGoalNegotiationThread(JointGoalNegotiator negotiator, String desc) {
        this.descriptorString = desc;
        this.negotiator = negotiator;
        this.negotiatingStep = null;
        ByteArrayOutputStream charBufferStream = new ByteArrayOutputStream();
        new Throwable().printStackTrace(new PrintStream(charBufferStream));
        this.stackTrace = charBufferStream.toString();
        this.originalPriority = Thread.currentThread().getPriority();
    }

    JointGoalNegotiationThread(JointGoalStep s, String desc) {
        this.descriptorString = desc;
        this.negotiatingStep = s;
        this.negotiator = null;
        ByteArrayOutputStream charBufferStream = new ByteArrayOutputStream();
        new Throwable().printStackTrace(new PrintStream(charBufferStream));
        this.stackTrace = charBufferStream.toString();
        this.originalPriority = Thread.currentThread().getPriority();
    }

    public synchronized boolean getIsWaiting() {
        return this.isWaiting;
    }

    private synchronized void setIsWaiting(boolean b) {
        this.isWaiting = b;
    }

    public synchronized boolean getIsStarted() {
        return this.isStarted;
    }

    private synchronized void setIsStarted(boolean b) {
        this.isStarted = b;
    }

    @Override
    public void start() {
        assert (Thread.currentThread() == BehavingEntity.getBehavingEntity().getDecisionCycleThread());
        this.setIsStarted(true);
        this.setIsWaiting(false);
        Thread.currentThread().setPriority(10);
        super.start();
        this.waitForNegotiation();
    }

    synchronized void waitForDecisionCycle() {
        assert (!this.isWaiting);
        this.isWaiting = true;
        Thread.currentThread().setPriority(10);
        this.notify();
        try {
            this.wait();
            JointGoalNegotiationThread.yield();
            Thread.currentThread().setPriority(this.originalPriority);
        }
        catch (InterruptedException e) {
            System.out.println(this);
            throw new AblRuntimeError(e);
        }
    }

    synchronized void continueNegotiation() {
        assert (this != Thread.currentThread());
        if (this.isWaiting) {
            Thread.currentThread().setPriority(10);
            this.notify();
            this.isWaiting = false;
            try {
                this.wait();
                JointGoalNegotiationThread.yield();
                Thread.currentThread().setPriority(this.originalPriority);
            }
            catch (InterruptedException e) {
                System.out.println(this);
                throw new AblRuntimeError(e);
            }
        }
    }

    private synchronized void waitForNegotiation() {
        assert (this != Thread.currentThread());
        try {
            this.wait();
            JointGoalNegotiationThread.yield();
            Thread.currentThread().setPriority(this.originalPriority);
        }
        catch (InterruptedException e) {
            System.out.println(this);
            throw new AblRuntimeError(e);
        }
    }

    @Override
    public String toString() {
        ByteArrayOutputStream bStream = new ByteArrayOutputStream();
        PrintStream pStream = new PrintStream(bStream);
        pStream.println("JointGoalNegotiationThread: " + this.descriptorString);
        pStream.println("Thread is alive: " + this.isAlive());
        pStream.println("Current execution state:");
        if (this.negotiator != null) {
            this.negotiator.printNegotiationHistory(pStream);
        } else if (this.negotiatingStep != null && this.negotiatingStep.negotiator != null) {
            this.negotiatingStep.negotiator.printNegotiationHistory(pStream);
        } else {
            pStream.println("No negotiation history");
        }
        pStream.println("Stacktrace indicates negotiation initiator - NOT AN ERROR");
        pStream.println(this.stackTrace);
        return bStream.toString();
    }

    String shortToString() {
        return "JointGoalNegotiationThread: " + this.descriptorString;
    }
}

