/*
 * Decompiled with CFR 0.152.
 */
package abl.runtime;

import abl.runtime.AblRuntimeError;
import abl.runtime.BehavingEntity;
import abl.runtime.Behavior;
import abl.runtime.BehaviorWME;
import abl.runtime.CollectionBehavior;
import abl.runtime.CollectionBehaviorWME;
import abl.runtime.ExecutableStepWME;
import abl.runtime.GoalStep;
import abl.runtime.ParallelBehavior;
import abl.runtime.ParallelBehaviorWME;
import abl.runtime.SequentialBehavior;
import abl.runtime.SequentialBehaviorWME;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class GoalStepWME
extends ExecutableStepWME {
    protected BehaviorWME child = null;
    protected GoalChildChangeListener listener = new GoalChildChangeListener(this);

    public GoalStepWME(GoalStep goalStep, BehaviorWME parent) {
        super(goalStep, parent);
        goalStep.addChildChangeListener(this.listener);
    }

    @Override
    void delete() {
        ((GoalStep)this.s).removeChildChangeListener(this.listener);
        super.delete();
    }

    public synchronized String getSignature() {
        return ((GoalStep)this.s).getSignature();
    }

    public synchronized BehaviorWME getChild() {
        return this.child;
    }

    public synchronized boolean getIsExpanded() {
        return ((GoalStep)this.s).isExpanded();
    }

    private synchronized void setChild(BehaviorWME b) {
        this.child = b;
    }

    private class GoalChildChangeListener
    implements PropertyChangeListener {
        GoalStepWME goalStepWME;

        GoalChildChangeListener(GoalStepWME g) {
            this.goalStepWME = g;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            assert (!(evt.getOldValue() != null && evt.getNewValue() != null || evt.getOldValue() == null && evt.getNewValue() == null));
            if (evt.getOldValue() == null) {
                assert (this.goalStepWME.child == null);
                Behavior newBehavior = (Behavior)evt.getNewValue();
                BehaviorWME newBehaviorWME = null;
                switch (newBehavior.getBehaviorType()) {
                    case 3: {
                        throw new AblRuntimeError("Reflection on adaptive behaviors not implemented yet.");
                    }
                    case 0: {
                        newBehaviorWME = new SequentialBehaviorWME((SequentialBehavior)newBehavior, this.goalStepWME);
                        break;
                    }
                    case 1: {
                        newBehaviorWME = new ParallelBehaviorWME((ParallelBehavior)newBehavior, this.goalStepWME);
                        break;
                    }
                    case 2: {
                        newBehaviorWME = new CollectionBehaviorWME((CollectionBehavior)newBehavior, this.goalStepWME);
                    }
                }
                this.goalStepWME.setChild(newBehaviorWME);
                BehavingEntity.getBehavingEntity().addWME(newBehaviorWME);
            } else {
                assert (this.goalStepWME.child != null);
                BehavingEntity.getBehavingEntity().deleteWME(this.goalStepWME.child);
                GoalStepWME.this.child.delete();
                this.goalStepWME.setChild(null);
            }
        }
    }
}

