/*
 * Decompiled with CFR 0.152.
 */
package abl.runtime;

import abl.runtime.AblNamedPropertySupport;
import abl.runtime.AblRuntimeError;
import abl.runtime.BehavingEntity;
import abl.runtime.Behavior;
import abl.runtime.ExecutableStep;
import abl.runtime.JointGoalNegotiationThread;
import abl.runtime.JointGoalStep;
import abl.runtime.MultiStepBehavior;
import abl.runtime.MultiStepBehaviorWME;
import abl.runtime.Step;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;

public class GoalStep
extends ExecutableStep {
    protected Behavior child = null;
    public static final short SUBGOAL = 0;
    public static final short SPAWNGOAL_DEFAULT = 1;
    public static final short SPAWNGOAL_AT_NODE = 2;
    private String signature;
    private short goalExecutionType = 0;
    protected HashSet failedBehaviors = new HashSet();
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private boolean succeeding = false;
    private NegotiateSubtreeRemovalThread currentNegotiationThread = null;
    private Object[] args;
    private MultiStepBehaviorWME rerootParent = null;
    private boolean rerooted = false;

    public GoalStep(int stepID, Behavior arg_parent, boolean arg_persistent, boolean arg_persistentWhenSucceeds, boolean arg_persistentWhenFails, boolean arg_ignoreFailure, boolean arg_effectOnly, boolean arg_teamEffectOnly, short arg_priority, short arg_priorityModifier, boolean arg_post, String arg_postMemory, Method arg_execute, Method arg_successTest, Method arg_successTestSensorFactory, AblNamedPropertySupport arg_propertyTable, String arg_signature, String[] arg_stepsIConflictWith) {
        super(stepID, arg_parent, arg_persistent, arg_persistentWhenSucceeds, arg_persistentWhenFails, arg_ignoreFailure, arg_effectOnly, arg_teamEffectOnly, arg_priority, arg_priorityModifier, arg_post, arg_postMemory, arg_execute, arg_successTest, arg_successTestSensorFactory, arg_propertyTable, (short)1, arg_stepsIConflictWith);
        this.signature = arg_signature;
        this.name = this.signature.substring(0, this.signature.indexOf("("));
    }

    public GoalStep(int stepID, Behavior arg_parent, boolean arg_persistent, boolean arg_persistentWhenSucceeds, boolean arg_persistentWhenFails, boolean arg_ignoreFailure, boolean arg_effectOnly, boolean arg_teamEffectOnly, short arg_priority, short arg_priorityModifier, boolean arg_post, String arg_postMemory, Method arg_execute, Method arg_successTest, Method arg_successTestSensorFactory, AblNamedPropertySupport arg_propertyTable, String arg_signature, String[] arg_stepsIConflictWith, short arg_goalExecutionType) {
        super(stepID, arg_parent, arg_persistent, arg_persistentWhenSucceeds, arg_persistentWhenFails, arg_ignoreFailure, arg_effectOnly, arg_teamEffectOnly, arg_priority, arg_priorityModifier, arg_post, arg_postMemory, arg_execute, arg_successTest, arg_successTestSensorFactory, arg_propertyTable, (short)1, arg_stepsIConflictWith);
        this.signature = arg_signature;
        this.name = this.signature.substring(0, this.signature.indexOf("("));
        this.goalExecutionType = arg_goalExecutionType;
    }

    String getSignature() {
        return this.signature;
    }

    short getGoalExecutionType() {
        return this.goalExecutionType;
    }

    boolean getRerooted() {
        return this.rerooted;
    }

    boolean isJointGoal() {
        return false;
    }

    protected void addFailedBehavior(Behavior beh) {
        this.failedBehaviors.add(new Integer(beh.getID()));
    }

    private static String formatAction(int action) {
        switch (action) {
            case 1: {
                return "SUCCEED";
            }
            case 2: {
                return "FAIL";
            }
            case 3: {
                return "RESET";
            }
        }
        return "INVALID_ACTION";
    }

    private void succeedStepSuper() {
        super.succeedStep();
    }

    private void failStepSuper() {
        super.failStep();
    }

    @Override
    void succeedStep() {
        this.succeeding = true;
        if (!this.isJointGoal()) {
            List<Step> jointGoals = this.freezeSubtreeAndNegotiateRemoval();
            if (!jointGoals.isEmpty()) {
                if (this.currentNegotiationThread == null || this.currentNegotiationThread.getActionOnCommit() != 1) {
                    NegotiateSubtreeRemovalThread negotiateSuccessThread = new NegotiateSubtreeRemovalThread(jointGoals, 1);
                    if (this.currentNegotiationThread != null) {
                        BehavingEntity.getBehavingEntity().unregisterNegotiationThread(this.currentNegotiationThread);
                    }
                    BehavingEntity.getBehavingEntity().registerNegotiationThread(negotiateSuccessThread);
                    this.currentNegotiationThread = negotiateSuccessThread;
                }
            } else {
                super.succeedStep();
            }
        } else {
            if (this.child != null) {
                this.child.removeChildren();
            }
            super.succeedStep();
        }
    }

    @Override
    void failStep() {
        if (!this.isJointGoal()) {
            List<Step> jointGoals = this.freezeSubtreeAndNegotiateRemoval();
            if (!jointGoals.isEmpty()) {
                if (this.currentNegotiationThread == null || this.currentNegotiationThread.getActionOnCommit() != 2) {
                    NegotiateSubtreeRemovalThread negotiateFailureThread = new NegotiateSubtreeRemovalThread(jointGoals, 2);
                    if (this.currentNegotiationThread != null) {
                        BehavingEntity.getBehavingEntity().unregisterNegotiationThread(this.currentNegotiationThread);
                    }
                    BehavingEntity.getBehavingEntity().registerNegotiationThread(negotiateFailureThread);
                    this.currentNegotiationThread = negotiateFailureThread;
                }
            } else {
                super.failStep();
            }
        } else {
            super.failStep();
        }
    }

    @Override
    void resetStep() {
        if (!this.isJointGoal()) {
            List<Step> jointGoals = this.freezeSubtreeAndNegotiateRemoval();
            if (!jointGoals.isEmpty()) {
                if (this.currentNegotiationThread == null || this.currentNegotiationThread.getActionOnCommit() != 3) {
                    NegotiateSubtreeRemovalThread negotiateResetThread = new NegotiateSubtreeRemovalThread(jointGoals, 3);
                    if (this.currentNegotiationThread != null) {
                        BehavingEntity.getBehavingEntity().unregisterNegotiationThread(this.currentNegotiationThread);
                    }
                    BehavingEntity.getBehavingEntity().registerNegotiationThread(negotiateResetThread);
                    this.currentNegotiationThread = negotiateResetThread;
                }
            } else {
                this.resetStepBody();
            }
        } else {
            this.resetStepBody();
        }
    }

    private void resetStepBody() {
        this.removeChild(true);
        this.failedBehaviors.clear();
        BehavingEntity.getBehavingEntity().resetStep(this);
    }

    void addChild(Behavior node) {
        if (node == null) {
            throw new AblRuntimeError("Null ABTNode passed to addChild().");
        }
        if (this.child != null) {
            throw new AblRuntimeError("addChild() called on a GoalStep with non-null child.");
        }
        this.child = node;
        BehavingEntity.getBehavingEntity().addBehavior(this.child);
        this.changes.firePropertyChange("child", null, node);
        this.child.addChildren();
    }

    void removeGoal() {
        this.removeChild(true);
    }

    void removeChild(boolean isRecursive) {
        if (this.child != null) {
            if (isRecursive) {
                this.child.removeBehavior();
            }
            this.changes.firePropertyChange("child", this.child, null);
            this.child = null;
        }
    }

    @Override
    boolean isExecuting() {
        return this.isExpanded() && !this.isSuspended();
    }

    boolean isExpanded() {
        return this.child != null;
    }

    @Override
    protected final void executeBookkeeping() {
        short parentBehaviorType = this.parent.getBehaviorType();
        if (parentBehaviorType == 1 || parentBehaviorType == 2) {
            ((MultiStepBehavior)this.parent).pursueGoal(this);
        }
        super.executeBookkeeping();
    }

    private void rerootGoal(MultiStepBehaviorWME newParent) {
        this.succeedStep();
        if (newParent == null) {
            this.parent = BehavingEntity.getBehavingEntity().getRootCollectionBehavior();
        } else {
            Behavior tempParent = newParent.getBehavior();
            if (tempParent == null) {
                System.err.println("WARNING: unexected NULL behavior when attempting to reroot goal " + this + " at behavior " + newParent + ". Failing the step");
                this.failStep();
                return;
            }
            this.parent = tempParent;
        }
        ((MultiStepBehavior)this.parent).addChild(this);
    }

    void chooseBehavior(Object[] args) {
        Behavior beh = BehavingEntity.getBehavingEntity().chooseIndividualBehavior(args, this.failedBehaviors, this);
        if (beh != null) {
            assert (!beh.isJointBehavior());
            this.addChild(beh);
            this.executeBookkeeping();
        } else {
            this.failStep();
        }
    }

    @Override
    boolean currentLineOfExpansion(GoalStep currentGoal) {
        return this.parent.currentLineOfExpansion(this);
    }

    @Override
    void suspend(ExecutableStep step) {
        this.suspend(step, true);
    }

    void suspend(ExecutableStep step, boolean isRecursive) {
        if (!this.isSuspended()) {
            BehavingEntity.getBehavingEntity().suspendStep(this);
        }
        super.suspend(step);
        if (isRecursive && this.child != null) {
            this.child.suspend(step);
        }
    }

    void suspendSkipJointGoals(ExecutableStep step) {
        if (!this.isSuspended()) {
            BehavingEntity.getBehavingEntity().suspendStep(this);
        }
        super.suspend(step);
        if (this.child != null) {
            this.child.suspendSkipJointGoals(step);
        }
    }

    @Override
    void metaSuspend() {
        this.metaSuspend(true);
    }

    void metaSuspend(boolean isRecursive) {
        if (!this.isSuspended()) {
            BehavingEntity.getBehavingEntity().suspendStep(this);
        }
        super.metaSuspend();
        if (isRecursive && this.child != null) {
            this.child.metaSuspend();
        }
    }

    void metaSuspendSkipJointGoals() {
        if (!this.isSuspended()) {
            BehavingEntity.getBehavingEntity().suspendStep(this);
        }
        super.metaSuspend();
        if (this.child != null) {
            this.child.metaSuspendSkipJointGoals();
        }
    }

    @Override
    void jointSuspend() {
        if (!this.isSuspended()) {
            BehavingEntity.getBehavingEntity().suspendStep(this);
        }
        super.jointSuspend();
    }

    @Override
    void unsuspend(ExecutableStep step) {
        super.unsuspend(step);
        if (!this.isSuspended()) {
            BehavingEntity.getBehavingEntity().unsuspendStep(this);
        }
    }

    @Override
    void metaUnsuspend() {
        super.metaUnsuspend();
        if (!this.isSuspended()) {
            BehavingEntity.getBehavingEntity().unsuspendStep(this);
        }
        if (this.child != null) {
            this.child.metaUnsuspend();
        }
    }

    @Override
    void jointUnsuspend() {
        super.jointUnsuspend();
        if (!this.isSuspended()) {
            BehavingEntity.getBehavingEntity().unsuspendStep(this);
        }
        if (this.child != null) {
            this.child.jointUnsuspend();
        }
    }

    void addChildChangeListener(PropertyChangeListener l) {
        this.changes.addPropertyChangeListener("child", l);
    }

    void removeChildChangeListener(PropertyChangeListener l) {
        this.changes.removePropertyChangeListener("child", l);
    }

    List<Step> freezeSubtreeAndNegotiateRemoval() {
        BehavingEntity.getBehavingEntity().removeSuccessTest(this);
        if (this.child != null) {
            return this.child.freezeSubtreeAndNegotiateRemoval();
        }
        return new Vector<Step>(0);
    }

    List negotiateSuspensionOfSubtree() {
        this.jointSuspend();
        if (this.child != null) {
            return this.child.negotiateSuspensionOfSubtree();
        }
        return new Vector(0);
    }

    List negotiateSuspensionOfSubtree(ExecutableStep step) {
        if (step != null) {
            this.suspend(step, false);
        } else {
            this.metaSuspend(false);
        }
        if (this.child != null) {
            return this.child.negotiateSuspensionOfSubtree(step);
        }
        return new Vector(0);
    }

    @Override
    void processStepRemoval() {
        if (this.succeeding) {
            if (this.goalExecutionType == 0 || this.rerooted) {
                super.processStepRemoval();
            } else {
                this.rerooted = true;
                this.succeeding = false;
            }
        } else {
            super.processStepRemoval();
        }
    }

    private final void bindArgs() {
        if (this.execute != null) {
            Object[] exeArgs = new Object[]{new Integer(this.stepID), this.parent.getBehaviorVariableFrame(), BehavingEntity.getBehavingEntity()};
            try {
                Object[] tempArgs = (Object[])this.execute.invoke(null, exeArgs);
                if (this.goalExecutionType != 2) {
                    this.args = tempArgs;
                }
                int len = tempArgs.length - 1;
                this.args = new Object[len];
                int i = 0;
                while (i < len) {
                    this.args[i] = tempArgs[i + 1];
                    ++i;
                }
                this.rerootParent = (MultiStepBehaviorWME)tempArgs[0];
            }
            catch (Exception e) {
                throw new AblRuntimeError("Error invoking execute", e);
            }
        } else {
            this.args = null;
        }
    }

    @Override
    void execute() {
        this.checkForConflictsOnExecution();
        if (!this.isSuspended()) {
            if (this.goalExecutionType != 0) {
                if (!this.rerooted) {
                    this.bindArgs();
                    this.rerootGoal(this.rerootParent);
                } else {
                    this.chooseBehavior(this.args);
                }
            } else {
                this.bindArgs();
                this.chooseBehavior(this.args);
            }
        }
    }

    private class NegotiateSubtreeRemovalThread
    extends JointGoalNegotiationThread {
        static final int INVALID_ACTION = 0;
        static final int SUCCEED = 1;
        static final int FAIL = 2;
        static final int RESET = 3;
        private List jointGoals;
        private int actionOnCommit;

        NegotiateSubtreeRemovalThread(List jointGoals, int actionOnCommit) {
            super((JointGoalStep)null, GoalStep.this + " NegotiateSubtreeRemovalThread(" + GoalStep.formatAction(actionOnCommit) + ")");
            this.jointGoals = new Vector(0);
            this.actionOnCommit = 0;
            assert (actionOnCommit > 0 && actionOnCommit <= 3);
            this.jointGoals = jointGoals;
            this.actionOnCommit = actionOnCommit;
        }

        int getActionOnCommit() {
            return this.actionOnCommit;
        }

        @Override
        public void run() {
            for (JointGoalStep js : this.jointGoals) {
                if (js.negotiator == null || js.negotiator.getState() == 7 || js.negotiator.getState() == 9 || js.negotiator.getState() == 16) continue;
                ((JointGoalNegotiationThread)Thread.currentThread()).waitForDecisionCycle();
            }
            switch (this.actionOnCommit) {
                case 1: {
                    GoalStep.this.succeedStepSuper();
                    break;
                }
                case 2: {
                    GoalStep.this.failStepSuper();
                    break;
                }
                case 3: {
                    GoalStep.this.resetStepBody();
                    break;
                }
                default: {
                    throw new AblRuntimeError("Unexpected action type " + this.actionOnCommit);
                }
            }
        }
    }
}

