/*
 * Decompiled with CFR 0.152.
 */
package abl.runtime;

import abl.runtime.AblNamedPropertySupport;
import abl.runtime.BehavingEntity;
import abl.runtime.Behavior;
import abl.runtime.Step;
import java.lang.reflect.Method;

public abstract class ExecutableStep
extends Step {
    protected String[] stepsIConflictWith = null;
    protected String name;

    public ExecutableStep(int stepID, Behavior arg_parent, boolean arg_persistent, boolean arg_persistentWhenSucceeds, boolean arg_persistentWhenFails, boolean arg_ignoreFailure, boolean arg_effectOnly, boolean arg_teamEffectOnly, short arg_priority, short arg_priorityModifier, boolean arg_post, String arg_postMemory, Method arg_execute, Method arg_successTest, Method arg_successTestSensorFactory, AblNamedPropertySupport arg_propertyTable, short arg_stepType, String[] arg_stepsIConflictWith) {
        super(stepID, arg_parent, arg_persistent, arg_persistentWhenSucceeds, arg_persistentWhenFails, arg_ignoreFailure, arg_effectOnly, arg_teamEffectOnly, arg_priority, arg_priorityModifier, arg_post, arg_postMemory, arg_execute, arg_successTest, arg_successTestSensorFactory, arg_propertyTable, arg_stepType);
        this.stepsIConflictWith = arg_stepsIConflictWith;
    }

    protected void checkForConflictsOnExecution() {
        if (this.stepsIConflictWith != null) {
            BehavingEntity.getBehavingEntity().findConflictsWithCurrentlyExecutingSteps(this, 1);
        }
    }

    protected void initConflictSteps(String[] steps) {
        this.stepsIConflictWith = steps;
    }

    abstract boolean isExecuting();

    String[] getConflicts() {
        if (this.stepsIConflictWith != null) {
            return (String[])this.stepsIConflictWith.clone();
        }
        return new String[0];
    }

    private void unsuspendStepsIHaveSuspended() {
        Step[] stepsIHaveSuspendedArray = this.stepsIHaveSuspended.toArray(new Step[this.stepsIHaveSuspended.size()]);
        int i = 0;
        while (i < stepsIHaveSuspendedArray.length) {
            stepsIHaveSuspendedArray[i].unsuspend(this);
            ++i;
        }
    }

    void processStepRemoval() {
        this.unsuspendStepsIHaveSuspended();
        this.updateStepsSuspendingMe();
    }

    String getName() {
        return this.name;
    }

    @Override
    void suspend(ExecutableStep step) {
        if (this.isExecuting()) {
            this.unsuspendStepsIHaveSuspended();
        }
        super.suspend(step);
    }

    @Override
    void metaSuspend() {
        if (this.isExecuting()) {
            this.unsuspendStepsIHaveSuspended();
        }
        super.metaSuspend();
    }

    @Override
    void jointSuspend() {
        if (this.isExecuting()) {
            this.unsuspendStepsIHaveSuspended();
        }
        super.jointSuspend();
    }

    void suspenderFor(Step step) {
        this.stepsIHaveSuspended.add(step);
    }

    void unsuspenderFor(Step step) {
        this.stepsIHaveSuspended.remove(step);
    }
}

