/*
 * Decompiled with CFR 0.152.
 */
package abl.runtime;

import abl.runtime.AblEvent;
import abl.runtime.AblEventSupport;
import abl.runtime.AblListener;
import abl.runtime.AblRuntimeError;
import abl.runtime.BehavingEntity;
import abl.runtime.GoalStep;
import abl.runtime.JointGoalNegotiatorDebug;
import abl.runtime.JointGoalStep;
import abl.runtime.Step;
import abl.runtime.__BehaviorDesc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import wm.WorkingMemoryDebugger;

public class Debugger {
    private static final String DECISION_CYCLE_TEXT = "Decisions per second";
    private static final String CONDITION_TIME_TEXT = "Continuous condition time/100 cycles";
    private static final int minimumViewWidth = 200;
    private static final int preferredViewWidth = 500;
    private static final int minimumViewHeight = 100;
    private static final int preferredViewHeight = 200;
    private static final int minimumTopPaneWidth = 400;
    private static final int preferredTopPaneWidth = 1000;
    private static final int minimumTopPaneHeight = 200;
    private static final int preferredTopPaneHeight = 400;
    private static final int minimumMainSplitPaneWidth = 200;
    private static final int preferredMainSplitPaneWidth = 500;
    private static final int minimumMainSplitPaneHeight = 300;
    private static final int preferredMainSplitPaneHeight = 600;
    private static final int minimumButtonPaneWidth = 200;
    private static final int preferredButtonPaneWidth = 500;
    private static final int buttonPaneHeight = 90;
    private BehavingEntity entity;
    private WorkingMemoryDebugger wmPanel;
    private JTree ABTTree;
    protected JTextArea traceArea;
    protected JScrollBar traceViewScroller;
    protected JScrollPane traceView;
    private boolean bBreakDecisionCycle = true;
    private JLabel decisionsPerSecondLabel;
    private JLabel accumulatedConditionTimeLabel;
    private JCheckBox ABTUpdateTreeButton;
    private int decisionCycleCounterForDecisionsPerMillisecond = 0;
    private int decisionCycleCounterForConditionTime = 0;
    private long accumulatedContinuousConditionTime = 0L;
    private long startTime = System.currentTimeMillis();
    protected JCheckBox traceToScreenChkBox;
    protected JCheckBox traceToBufferChkBox;
    protected final TraceListener traceListener = new TraceListener();
    protected List traceBuffer = new LinkedList();
    protected Set tracedBehaviors = new HashSet();
    private JFrame debugFrame;
    private JButton breakBtn;
    private JButton stepBtn;
    private JButton continueBtn;
    private final AblEventSupport listenerSupport = new AblEventSupport();
    private static final HashSet debuggedBehaviors = new HashSet();

    public Debugger(BehavingEntity entity) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception e) {
            throw new AblRuntimeError("Error setting the look and feel in the debugger");
        }
        this.wmPanel = entity.getWMDebugger();
        this.ABTTree = new JTree(null);
        this.ABTTree.setRootVisible(true);
        this.ABTTree.setCellRenderer(new ABTCellRenderer());
        JPanel ABTTreeViewPanel = new JPanel();
        this.ABTUpdateTreeButton = new JCheckBox("Continuously update ABT");
        JScrollPane ABTTreeView = new JScrollPane(this.ABTTree);
        ABTTreeView.getViewport().setScrollMode(2);
        ABTTreeViewPanel.setLayout(new BoxLayout(ABTTreeViewPanel, 1));
        ABTTreeViewPanel.add(this.ABTUpdateTreeButton);
        ABTTreeViewPanel.add(ABTTreeView);
        ABTTreeViewPanel.setBorder(BorderFactory.createTitledBorder("Active Behavior Tree"));
        this.breakBtn = new JButton("Break");
        this.stepBtn = new JButton("Step");
        this.continueBtn = new JButton("Continue");
        this.breakBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Debugger.this.bBreakDecisionCycle = true;
                Debugger.this.debugFrame.getRootPane().setDefaultButton(Debugger.this.continueBtn);
            }
        });
        this.stepBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Debugger.this.releaseDecisionThread();
            }
        });
        this.continueBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Debugger.this.wmPanel.clearWMView();
                Debugger.this.clearABTTreeModel();
                Debugger.this.bBreakDecisionCycle = false;
                Debugger.this.releaseDecisionThread();
                Debugger.this.debugFrame.getRootPane().setDefaultButton(Debugger.this.breakBtn);
            }
        });
        JSplitPane topPane = new JSplitPane(0, true, this.wmPanel, ABTTreeViewPanel);
        topPane.setOneTouchExpandable(true);
        this.wmPanel.setMinimumSize(new Dimension(200, 100));
        ABTTreeViewPanel.setMinimumSize(new Dimension(200, 100));
        this.wmPanel.setPreferredSize(new Dimension(500, 200));
        ABTTreeViewPanel.setPreferredSize(new Dimension(500, 200));
        this.traceArea = new JTextArea();
        this.traceArea.setEditable(false);
        this.traceView = new JScrollPane(this.traceArea);
        this.traceViewScroller = this.traceView.getVerticalScrollBar();
        this.traceView.getViewport().setScrollMode(2);
        this.traceArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Debugger.this.traceArea.selectAll();
                Debugger.this.traceArea.copy();
            }
        });
        JButton selectTraceBtn = new JButton("Select Trace");
        this.traceToScreenChkBox = new JCheckBox("Trace to screen");
        this.traceToBufferChkBox = new JCheckBox("Trace to buffer");
        JButton clearScreenBtn = new JButton("Clear Screen");
        JButton clearBufferBtn = new JButton("Clear Buffer");
        JButton replayBufferBtn = new JButton("Replay Buffer");
        selectTraceBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new SelectTraceDialog().setVisible(true);
            }
        });
        clearScreenBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Debugger.this.traceArea.setText("");
            }
        });
        clearBufferBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Debugger.this.traceBuffer.clear();
            }
        });
        replayBufferBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Debugger.this.traceArea.setText("");
                for (AblEvent event : Debugger.this.traceBuffer) {
                    if (event.getSourceType() == 1) {
                        __BehaviorDesc desc = (__BehaviorDesc)event.getSource();
                        if (!Debugger.this.tracedBehaviors.contains(desc.signature)) continue;
                        Debugger.this.traceArea.append(Debugger.this.traceListener.formatBehaviorTrace(event));
                        continue;
                    }
                    if (event.getSourceType() == 3) {
                        JointGoalNegotiatorDebug.JointGoalNegotiationInfo info = (JointGoalNegotiatorDebug.JointGoalNegotiationInfo)event.getObject();
                        if (info.g == null) continue;
                        if (Debugger.this.tracedBehaviors.contains(info.g.getParent().getSignature())) {
                            Debugger.this.traceArea.append(Debugger.this.traceListener.formatBehaviorTrace(event));
                            continue;
                        }
                        Debugger.this.traceArea.append(Debugger.this.traceListener.formatBehaviorTrace(event));
                        continue;
                    }
                    Step s = (Step)event.getSource();
                    if (!Debugger.this.tracedBehaviors.contains(s.getParent().getSignature())) continue;
                    Debugger.this.traceArea.append(Debugger.this.traceListener.formatBehaviorTrace(event));
                }
            }
        });
        JPanel traceViewPanel = new JPanel();
        traceViewPanel.setLayout(new BoxLayout(traceViewPanel, 1));
        JPanel buttonPanelMain = new JPanel();
        buttonPanelMain.setLayout(new BoxLayout(buttonPanelMain, 1));
        buttonPanelMain.setMaximumSize(new Dimension(400, 120));
        buttonPanelMain.setAlignmentX(0.5f);
        JPanel buttonPanel1 = new JPanel();
        buttonPanel1.setLayout(new BoxLayout(buttonPanel1, 0));
        buttonPanel1.setAlignmentX(0.0f);
        JPanel buttonPanel2 = new JPanel();
        buttonPanel2.setLayout(new BoxLayout(buttonPanel2, 0));
        buttonPanel2.setAlignmentX(0.0f);
        traceViewPanel.add(buttonPanelMain);
        buttonPanelMain.add(buttonPanel1);
        buttonPanelMain.add(buttonPanel2);
        buttonPanel1.add(selectTraceBtn);
        buttonPanel1.add(Box.createHorizontalStrut(10));
        buttonPanel1.add(this.traceToScreenChkBox);
        buttonPanel1.add(Box.createHorizontalStrut(10));
        buttonPanel1.add(this.traceToBufferChkBox);
        buttonPanel2.add(clearScreenBtn);
        buttonPanel2.add(Box.createHorizontalStrut(10));
        buttonPanel2.add(clearBufferBtn);
        buttonPanel2.add(Box.createHorizontalStrut(10));
        buttonPanel2.add(replayBufferBtn);
        traceViewPanel.add(Box.createVerticalStrut(10));
        traceViewPanel.add(this.traceView);
        traceViewPanel.setBorder(BorderFactory.createTitledBorder("Behavior Trace"));
        JSplitPane mainSplitPane = new JSplitPane(0, true, topPane, traceViewPanel);
        mainSplitPane.setOneTouchExpandable(true);
        topPane.setMinimumSize(new Dimension(400, 200));
        topPane.setPreferredSize(new Dimension(1000, 400));
        mainSplitPane.setMinimumSize(new Dimension(200, 300));
        mainSplitPane.setPreferredSize(new Dimension(500, 600));
        mainSplitPane.setAlignmentX(1.0f);
        this.decisionsPerSecondLabel = new JLabel(DECISION_CYCLE_TEXT);
        this.accumulatedConditionTimeLabel = new JLabel(CONDITION_TIME_TEXT);
        JPanel buttonPane = new JPanel();
        Box labels = new Box(1);
        Box buttons = new Box(0);
        buttonPane.add(labels);
        buttonPane.add(Box.createRigidArea(new Dimension(50, 0)));
        buttonPane.add(buttons);
        labels.add(this.decisionsPerSecondLabel);
        labels.add(this.accumulatedConditionTimeLabel);
        buttons.add(this.breakBtn);
        buttons.add(Box.createRigidArea(new Dimension(10, 0)));
        buttons.add(this.stepBtn);
        buttons.add(Box.createRigidArea(new Dimension(10, 0)));
        buttons.add(this.continueBtn);
        buttonPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        buttonPane.setAlignmentX(1.0f);
        buttonPane.setMinimumSize(new Dimension(200, 90));
        buttonPane.setPreferredSize(new Dimension(500, 90));
        this.entity = entity;
        String longEntityName = entity.getClass().getName();
        String shortEntityName = longEntityName.substring(longEntityName.lastIndexOf(46) + 1);
        this.debugFrame = new JFrame(String.valueOf(shortEntityName) + " Debugger");
        this.debugFrame.getContentPane().setLayout(new BoxLayout(this.debugFrame.getContentPane(), 1));
        this.debugFrame.getContentPane().add(mainSplitPane);
        this.debugFrame.getContentPane().add(buttonPane);
        this.debugFrame.getRootPane().setDefaultButton(this.continueBtn);
        this.debugFrame.pack();
        this.debugFrame.setVisible(true);
        this.listenerSupport.addAblListener(this.traceListener);
    }

    public boolean getBreakDecisionCycle() {
        return this.bBreakDecisionCycle;
    }

    protected void setTreeModel(JTree tree, DefaultTreeModel treeModel) {
        tree.setModel(treeModel);
        LinkedList paths = this.getAllLeafPaths((TreeNode)treeModel.getRoot(), treeModel);
        ListIterator pathIter = paths.listIterator();
        while (pathIter.hasNext()) {
            tree.makeVisible((TreePath)pathIter.next());
        }
    }

    public void setABTTreeModel(DefaultTreeModel treeModel) {
        this.setTreeModel(this.ABTTree, treeModel);
    }

    protected void clearABTTreeModel() {
        this.ABTTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("ABT not available")));
    }

    public boolean updateABT() {
        return this.ABTUpdateTreeButton.isSelected();
    }

    protected LinkedList getAllLeafPaths(TreeNode node, DefaultTreeModel model) {
        LinkedList<TreePath> pathList = new LinkedList<TreePath>();
        int childCount = node.getChildCount();
        if (childCount == 0) {
            pathList.add(new TreePath(model.getPathToRoot(node)));
            return pathList;
        }
        int i = 0;
        while (i < childCount) {
            pathList.addAll(this.getAllLeafPaths(node.getChildAt(i), model));
            ++i;
        }
        return pathList;
    }

    public synchronized void debug(long continuousConditionTime) {
        assert (continuousConditionTime >= 0L);
        if (this.bBreakDecisionCycle) {
            System.out.println(String.valueOf(BehavingEntity.getBehavingEntity().getBehavingEntityShortName()) + ": hit breakpoint");
            this.decisionCycleCounterForDecisionsPerMillisecond = 0;
            this.wmPanel.update();
            this.setABTTreeModel(this.entity.getABTTreeModel());
            BehavingEntity.getBehavingEntity().printNegotiationThreads();
            BehavingEntity.getBehavingEntity().printLeafSteps();
            BehavingEntity.getBehavingEntity().printAtomicSteps();
            try {
                this.wait();
            }
            catch (Exception e) {
                throw new AblRuntimeError("Unexpected interruption in Debugger.debug()");
            }
        } else {
            long currentTime;
            if (this.updateABT()) {
                this.setABTTreeModel(this.entity.getABTTreeModel());
            }
            if ((currentTime = System.currentTimeMillis()) - this.startTime >= 1000L) {
                float decisionsPerMillisecond = (float)this.decisionCycleCounterForDecisionsPerMillisecond / (float)(currentTime - this.startTime);
                this.decisionsPerSecondLabel.setText("Decisions per second " + Math.round(decisionsPerMillisecond * 1000.0f));
                this.decisionCycleCounterForDecisionsPerMillisecond = 0;
                this.startTime = System.currentTimeMillis();
            } else {
                ++this.decisionCycleCounterForDecisionsPerMillisecond;
            }
            this.accumulatedContinuousConditionTime += continuousConditionTime;
            if (this.decisionCycleCounterForConditionTime == 100) {
                this.accumulatedConditionTimeLabel.setText("Continuous condition time/100 cycles " + this.accumulatedContinuousConditionTime);
                this.decisionCycleCounterForConditionTime = 0;
                this.accumulatedContinuousConditionTime = 0L;
            } else {
                ++this.decisionCycleCounterForConditionTime;
            }
        }
    }

    public synchronized void breakSenseCycle() {
    }

    public synchronized void setTraceToBuffer(boolean b) {
        this.traceToBufferChkBox.setSelected(b);
    }

    public synchronized void setTraceToScreen(boolean b) {
        this.traceToScreenChkBox.setSelected(b);
    }

    public synchronized void releaseDecisionThread() {
        this.notify();
    }

    public void breakNextDecisionCycle() {
        this.bBreakDecisionCycle = true;
    }

    public void addABLListener(AblListener behaviorListener) {
        this.listenerSupport.addAblListener(behaviorListener);
    }

    public void removeABLListener(AblListener behaviorListener) {
        this.listenerSupport.removeAblListener(behaviorListener);
    }

    void traceAblExecutionEvent(int type, Step source, Object obj, int nestLevel, int behaviorID) {
        if (debuggedBehaviors.contains(new Integer(behaviorID))) {
            this.listenerSupport.fireAblEvent(type, source, obj, nestLevel);
        }
    }

    void traceAblExecutionEvent(int type, __BehaviorDesc source, Object obj, int nestLevel, int behaviorID) {
        if (debuggedBehaviors.contains(new Integer(behaviorID))) {
            this.listenerSupport.fireAblEvent(type, source, obj, nestLevel);
        }
    }

    void traceBehavior(int behaviorID) {
        debuggedBehaviors.add(new Integer(behaviorID));
    }

    void untraceBehavior(int behaviorID) {
        debuggedBehaviors.remove(new Integer(behaviorID));
    }

    protected class ABTCellRenderer
    extends DefaultTreeCellRenderer {
        protected ABTCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            try {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                Step step = (Step)node.getUserObject();
                if (step.isSuspended()) {
                    this.setForeground(Color.red);
                } else if (step.getStepType() == 1 && ((GoalStep)step).isJointGoal() && ((JointGoalStep)step).getIsNegotiating()) {
                    this.setForeground(Color.blue);
                } else {
                    this.setForeground(Color.black);
                }
                return this;
            }
            catch (ClassCastException e) {
                this.setForeground(Color.black);
                return this;
            }
            catch (NullPointerException e) {
                this.setForeground(Color.black);
                return this;
            }
        }
    }

    class SelectTraceDialog
    extends JDialog {
        private final JPanel contentPane;
        private final JPanel checkBoxes;
        private final JScrollPane checkBoxesView;
        private final JPanel buttonContainer;
        private final JButton okBtn;
        private final JButton cancelBtn;
        private final JButton selectAllBtn;
        private final JButton clearAllBtn;
        final SelectTraceDialog me = this;

        SelectTraceDialog() {
            this.setTitle("Select behaviors to trace");
            this.contentPane = new JPanel();
            this.setContentPane(this.contentPane);
            this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
            this.checkBoxes = new ScrollableJPanel();
            this.checkBoxes.setLayout(new BoxLayout(this.checkBoxes, 1));
            this.checkBoxesView = new JScrollPane(this.checkBoxes);
            this.checkBoxesView.getViewport().setScrollMode(2);
            this.buttonContainer = new JPanel();
            this.buttonContainer.setLayout(new BoxLayout(this.buttonContainer, 0));
            this.buttonContainer.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.selectAllBtn = new JButton("Select All");
            this.clearAllBtn = new JButton("Clear All");
            this.okBtn = new JButton("OK");
            this.cancelBtn = new JButton("Cancel");
            this.okBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Component[] comp = SelectTraceDialog.this.checkBoxes.getComponents();
                    int i = 0;
                    while (i < comp.length) {
                        JCheckBox cbox = (JCheckBox)comp[i];
                        if (cbox.isSelected()) {
                            if (!((SelectTraceDialog)SelectTraceDialog.this).Debugger.this.tracedBehaviors.contains(cbox.getText())) {
                                Debugger.this.entity.traceBehaviorSignature(cbox.getText());
                                ((SelectTraceDialog)SelectTraceDialog.this).Debugger.this.tracedBehaviors.add(cbox.getText());
                            }
                        } else if (((SelectTraceDialog)SelectTraceDialog.this).Debugger.this.tracedBehaviors.contains(cbox.getText())) {
                            Debugger.this.entity.untraceBehaviorSignature(cbox.getText());
                            ((SelectTraceDialog)SelectTraceDialog.this).Debugger.this.tracedBehaviors.remove(cbox.getText());
                        }
                        ++i;
                    }
                    SelectTraceDialog.this.me.dispose();
                }
            });
            this.cancelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectTraceDialog.this.me.dispose();
                }
            });
            this.selectAllBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Component[] comp = SelectTraceDialog.this.checkBoxes.getComponents();
                    int i = 0;
                    while (i < comp.length) {
                        ((JCheckBox)comp[i]).setSelected(true);
                        ++i;
                    }
                }
            });
            this.clearAllBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Component[] comp = SelectTraceDialog.this.checkBoxes.getComponents();
                    int i = 0;
                    while (i < comp.length) {
                        ((JCheckBox)comp[i]).setSelected(false);
                        ++i;
                    }
                }
            });
            this.getContentPane().add(this.checkBoxesView);
            this.getContentPane().add(this.buttonContainer);
            this.buttonContainer.add(this.selectAllBtn);
            this.buttonContainer.add(this.clearAllBtn);
            this.buttonContainer.add(Box.createHorizontalStrut(30));
            this.buttonContainer.add(this.okBtn);
            this.buttonContainer.add(this.cancelBtn);
            Dimension buttonContainerSize = this.buttonContainer.getMaximumSize();
            this.buttonContainer.setMaximumSize(new Dimension(buttonContainerSize.width, 30));
            this.buttonContainer.setMinimumSize(new Dimension(200, 30));
            Set behSet = Debugger.this.entity.getRegisteredBehaviors();
            String[] behs = behSet.toArray(new String[behSet.size()]);
            Arrays.sort(behs, new StringIgnoreCaseComparator());
            int i = 0;
            while (i < behs.length) {
                boolean select = Debugger.this.tracedBehaviors.contains(behs[i]);
                JCheckBox behaviorCheckBox = new JCheckBox(behs[i], select);
                this.checkBoxes.add(behaviorCheckBox);
                ++i;
            }
            JCheckBox tempBox = new JCheckBox();
            int currentPreferredHeight = tempBox.getPreferredSize().height * behs.length;
            Dimension screenSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds().getSize();
            if (currentPreferredHeight > screenSize.height - 60) {
                this.checkBoxesView.setPreferredSize(new Dimension(this.checkBoxes.getPreferredSize().width, screenSize.height - 100));
            }
            this.setModal(true);
            this.pack();
        }

        class ScrollableJPanel
        extends JPanel
        implements Scrollable {
            ScrollableJPanel() {
            }

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return this.getPreferredSize();
            }

            @Override
            public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
                return new JCheckBox((String)"Sample").getPreferredSize().height;
            }

            @Override
            public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
                JCheckBox sample = new JCheckBox("Sample");
                if (orientation == 1) {
                    return visibleRect.height - sample.getPreferredSize().height;
                }
                return visibleRect.width - sample.getPreferredSize().height;
            }

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return false;
            }

            @Override
            public boolean getScrollableTracksViewportHeight() {
                return false;
            }
        }
    }

    class StringIgnoreCaseComparator
    implements Comparator {
        StringIgnoreCaseComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((String)o1).compareToIgnoreCase((String)o2);
        }
    }

    class TraceListener
    implements AblListener {
        static final String lineSep = "\n";
        final Hashtable timeTable = new Hashtable();

        TraceListener() {
        }

        private String getNegotiationActionString(JointGoalNegotiatorDebug.JointGoalNegotiationInfo i) {
            switch (i.intention) {
                case 17: {
                    return "entry";
                }
                case 18: {
                    return "refuse entry";
                }
                case 19: {
                    return "succeed";
                }
                case 20: {
                    return "fail";
                }
                case 21: {
                    return "remove";
                }
                case 22: {
                    return "suspend";
                }
                case 23: {
                    return "unsuspend";
                }
            }
            return "unrecognized action";
        }

        public AblEvent computeElapsedTime(AblEvent e) {
            Object source = e.getSource();
            Long time = (Long)this.timeTable.get(source);
            int eventType = e.getType();
            switch (e.getType()) {
                case 5: 
                case 7: 
                case 9: {
                    this.timeTable.put(source, new Long(System.currentTimeMillis()));
                    break;
                }
                case 3: 
                case 6: 
                case 8: 
                case 10: {
                    if (time == null) break;
                    e.setElapsedTime(System.currentTimeMillis() - time);
                    this.timeTable.remove(source);
                    break;
                }
                case 2: {
                    this.timeTable.put(source, new Long(System.currentTimeMillis()));
                    Object o = e.getObject();
                    if (o != null) {
                        time = (Long)this.timeTable.get(o);
                    }
                    if (time == null) break;
                    e.setElapsedTime(System.currentTimeMillis() - time);
                }
            }
            return e;
        }

        public String formatBehaviorTrace(AblEvent e) {
            String actionMessage;
            Object o = e.getObject();
            Object source = e.getSource();
            long time = e.getElapsedTime();
            switch (e.getType()) {
                case 1: {
                    actionMessage = "precondition tested: " + o;
                    break;
                }
                case 2: {
                    actionMessage = "behavior chosen";
                    break;
                }
                case 3: {
                    if (((Boolean)o).booleanValue()) {
                        actionMessage = "behavior succeeded";
                        break;
                    }
                    actionMessage = "behavior failed";
                    break;
                }
                case 4: {
                    actionMessage = "context condition failed";
                    break;
                }
                case 5: {
                    actionMessage = "execution";
                    break;
                }
                case 6: {
                    if (((Boolean)o).booleanValue()) {
                        actionMessage = "succeeded";
                        break;
                    }
                    actionMessage = "act failed";
                    break;
                }
                case 7: {
                    actionMessage = "execution";
                    break;
                }
                case 8: {
                    if (((Boolean)o).booleanValue()) {
                        actionMessage = "succeeded";
                        break;
                    }
                    actionMessage = "failed";
                    break;
                }
                case 9: {
                    actionMessage = "execution";
                    break;
                }
                case 10: {
                    actionMessage = "succeeded";
                    break;
                }
                case 11: {
                    actionMessage = "succeeded";
                    break;
                }
                case 12: {
                    actionMessage = "execution";
                    break;
                }
                case 13: {
                    actionMessage = "failed";
                    break;
                }
                case 14: {
                    actionMessage = "execution";
                    break;
                }
                case 15: {
                    actionMessage = "succeeded";
                    break;
                }
                case 18: {
                    actionMessage = "success test succeeded";
                    break;
                }
                case 19: {
                    actionMessage = "re-rooting subgoal at ABT root";
                    break;
                }
                case 20: {
                    actionMessage = "initiating " + this.getNegotiationActionString((JointGoalNegotiatorDebug.JointGoalNegotiationInfo)o) + " negotiation";
                    break;
                }
                case 21: {
                    actionMessage = "completing " + this.getNegotiationActionString((JointGoalNegotiatorDebug.JointGoalNegotiationInfo)o) + " negotiation";
                    break;
                }
                case 22: {
                    actionMessage = "initiating " + this.getNegotiationActionString((JointGoalNegotiatorDebug.JointGoalNegotiationInfo)o) + " intention";
                    break;
                }
                case 23: {
                    actionMessage = "committing to " + this.getNegotiationActionString((JointGoalNegotiatorDebug.JointGoalNegotiationInfo)o) + " intention";
                    break;
                }
                case 24: {
                    actionMessage = "process " + this.getNegotiationActionString((JointGoalNegotiatorDebug.JointGoalNegotiationInfo)o) + " intention";
                    break;
                }
                default: {
                    actionMessage = "unrecognized action " + e.getType();
                }
            }
            int nestLevel = e.getNestLevel();
            StringBuffer blankBuffer = new StringBuffer(2 * nestLevel);
            int i = 0;
            while (i < nestLevel) {
                blankBuffer.append("  ");
                ++i;
            }
            String sourceMessage = "";
            switch (e.getSourceType()) {
                case 1: {
                    if (e.getType() == 1 || e.getType() == 2) {
                        sourceMessage = ((__BehaviorDesc)source).uniqueName;
                        break;
                    }
                    sourceMessage = ((__BehaviorDesc)source).signature;
                    break;
                }
                case 3: {
                    JointGoalNegotiatorDebug.JointGoalNegotiationInfo i2 = (JointGoalNegotiatorDebug.JointGoalNegotiationInfo)o;
                    if (i2.g != null) {
                        sourceMessage = i2.g.getSignature();
                    }
                    if (i2.behavingEntity == null) break;
                    sourceMessage = String.valueOf(sourceMessage) + " from " + i2.behavingEntity;
                    break;
                }
                case 2: {
                    sourceMessage = ((Step)source).toString();
                    break;
                }
                default: {
                    sourceMessage = "unrecognized source " + e.getSourceType();
                }
            }
            if (time != -1L) {
                actionMessage = String.valueOf(actionMessage) + " elapsed time = " + time;
            }
            if (sourceMessage.equals("")) {
                return blankBuffer + actionMessage + lineSep;
            }
            return blankBuffer + sourceMessage + ": " + actionMessage + lineSep;
        }

        @Override
        public void eventHappened(final AblEvent e) {
            if (Debugger.this.traceToScreenChkBox.isSelected()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((TraceListener)TraceListener.this).Debugger.this.traceArea.append(TraceListener.this.formatBehaviorTrace(TraceListener.this.computeElapsedTime(e)));
                    }
                });
            }
            if (Debugger.this.traceToBufferChkBox.isSelected()) {
                Debugger.this.traceBuffer.add(this.computeElapsedTime(e));
            }
        }
    }
}

