/*
 * Decompiled with CFR 0.152.
 */
package abl.runtime;

import abl.runtime.Behavior;
import abl.runtime.GoalStepWME;
import java.util.List;
import wm.WME;

public class BehaviorWME
extends WME {
    protected Behavior behavior;
    protected GoalStepWME parent = null;
    protected boolean valid = true;

    public BehaviorWME(Behavior behavior, GoalStepWME parent) {
        this.behavior = behavior;
        this.parent = parent;
        behavior.setReflectionWME(this);
    }

    public synchronized boolean getHasContextCondition() {
        return this.behavior.getHasContextCondition();
    }

    public synchronized int getSpecificity() {
        return this.behavior.getSpecificity();
    }

    public synchronized String getSignature() {
        return this.behavior.getSignature();
    }

    public synchronized String getUniqSignature() {
        return String.valueOf(this.behavior.getSignature()) + "_" + this.getBehaviorID();
    }

    public synchronized GoalStepWME getParent() {
        assert (!this.behavior.isRootBehavior() && this.parent != null || this.behavior.isRootBehavior() && this.parent == null);
        return this.parent;
    }

    public final synchronized int getBehaviorID() {
        return this.behavior.getBehaviorID();
    }

    public synchronized int getBehaviorType() {
        return this.behavior.getBehaviorType();
    }

    public synchronized Object getProperty(String name) {
        return this.behavior.propertyTable.getProperty(name);
    }

    public synchronized void setProperty(String name, Object value) {
        this.behavior.propertyTable.setProperty(name, value);
    }

    public synchronized void deleteProperty(String name) {
        this.behavior.propertyTable.deleteProperty(name);
    }

    public synchronized List getAllDefinedProperties() {
        return this.behavior.propertyTable.getAllDefinedProperties();
    }

    synchronized Behavior getBehavior() {
        if (this.isValid()) {
            return this.behavior;
        }
        return null;
    }

    public synchronized boolean isValid() {
        return this.valid;
    }

    public synchronized boolean isParent(GoalStepWME parentGoal) {
        if (this.parent == null) {
            return false;
        }
        if (this.parent == parentGoal) {
            return true;
        }
        return this.parent.isParent(parentGoal);
    }

    public synchronized boolean isParent(BehaviorWME parentBehavior) {
        if (this.parent == null) {
            return false;
        }
        return this.parent.isParent(parentBehavior);
    }

    void delete() {
        this.valid = false;
    }

    @Override
    public String toString() {
        return String.valueOf(this.objectToString()) + super.toString();
    }
}

