/*
 * Decompiled with CFR 0.152.
 */
package abl.runtime;

import abl.runtime.AblRuntimeError;
import abl.runtime.BehavingEntity;
import abl.runtime.Behavior;
import abl.runtime.DebuggableStep;
import abl.runtime.MultiStepBehavior;
import abl.runtime.SequentialBehavior;
import abl.runtime.Step;
import abl.runtime.__BehaviorDesc;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

class BehaviorDebugSupport {
    private final int nestLevel;
    private final Behavior debuggedBehavior;
    private final BehavingEntity entity = BehavingEntity.getBehavingEntity();

    BehaviorDebugSupport(Behavior arg_debuggedBehavior, int arg_nestLevel) {
        this.debuggedBehavior = arg_debuggedBehavior;
        this.nestLevel = arg_nestLevel;
    }

    int getNestLevel() {
        return this.nestLevel;
    }

    MutableTreeNode getTree() {
        short behaviorType = this.debuggedBehavior.getBehaviorType();
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(this.debuggedBehavior);
        switch (behaviorType) {
            case 1: 
            case 2: {
                Step[] children = ((MultiStepBehavior)this.debuggedBehavior).getChildren();
                int i = 0;
                while (i < children.length) {
                    node.add(((DebuggableStep)((Object)children[i])).getTree());
                    ++i;
                }
                return node;
            }
            case 3: {
                throw new AblRuntimeError("Debugging adaptive behaviors not implemented yet.");
            }
            case 0: {
                Step child = ((SequentialBehavior)this.debuggedBehavior).getChild();
                node.add(((DebuggableStep)((Object)child)).getTree());
                return node;
            }
        }
        throw new AblRuntimeError("Unexpected behavior type " + behaviorType);
    }

    void traceAblExecutionEvent(int type, Step source, Object obj, int nestLevel) {
        this.entity.traceAblExecutionEvent(type, source, obj, nestLevel, this.debuggedBehavior.getID());
    }

    void traceAblExecutionEvent(int type, Step source, Object obj) {
        this.entity.traceAblExecutionEvent(type, source, obj, this.nestLevel + 1, this.debuggedBehavior.getID());
    }

    void traceAblExecutionEvent(int type, __BehaviorDesc source, Object obj, int nestLevel) {
        this.entity.traceAblExecutionEvent(type, source, obj, nestLevel, source.behaviorID);
    }

    void traceAblExecutionEvent(int type, __BehaviorDesc source, Object obj) {
        this.entity.traceAblExecutionEvent(type, source, obj, this.nestLevel, source.behaviorID);
    }
}

