/*
 * Decompiled with CFR 0.152.
 */
package abl.runtime;

import abl.runtime.ABTNode;
import abl.runtime.AblNamedPropertySupport;
import abl.runtime.AblRuntimeError;
import abl.runtime.BehavingEntity;
import abl.runtime.BehaviorWME;
import abl.runtime.ExecutableStep;
import abl.runtime.GoalStep;
import abl.runtime.JointGoalNegotiationThread;
import abl.runtime.JointGoalStep;
import abl.runtime.MentalStep;
import abl.runtime.PrimitiveStep;
import abl.runtime.SensorActivation;
import abl.runtime.Step;
import abl.runtime.__StepDesc;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public abstract class Behavior
implements ABTNode {
    public static final short SEQUENTIAL = 0;
    public static final short PARALLEL = 1;
    public static final short COLLECTION = 2;
    public static final short ADAPTIVE = 3;
    final AblNamedPropertySupport propertyTable = new AblNamedPropertySupport();
    protected GoalStep parent;
    private short priority = 0;
    protected boolean isAtomic = false;
    protected PropertyChangeSupport changes = new PropertyChangeSupport(this);
    protected boolean behaviorRemoved = false;
    protected final String signature;
    protected final Object[] behaviorVariableFrame;
    protected __StepDesc[] stepDescs;
    protected short specificity;
    protected Set<BehavingEntity> teamMembers = null;
    protected final int behaviorID;
    private final Method contextCondition;
    private final Method contextConditionSensorFactory;
    private final Method successCondition;
    private final Method successConditionSensorFactory;
    private BehaviorWME behaviorWME = null;

    boolean getBehaviorRemoved() {
        return this.behaviorRemoved;
    }

    void setBehaviorRemoved() {
        this.behaviorRemoved = true;
    }

    Object[] getBehaviorVariableFrame() {
        return this.behaviorVariableFrame;
    }

    public Behavior(GoalStep arg_parent, Method arg_contextCondition, Method arg_contextConditionSensorFactory, Method arg_successCondition, Method arg_successConditionSensorFactory, boolean arg_isAtomic, String arg_signature, short arg_specificity, int arg_behaviorID, Object[] arg_behaviorVariableFrame, __StepDesc[] arg_stepDescs) {
        this.parent = arg_parent;
        this.isAtomic = arg_parent != null && !this.isAtomic ? this.parent.getIsAtomic() : arg_isAtomic;
        this.contextCondition = arg_contextCondition;
        this.contextConditionSensorFactory = arg_contextConditionSensorFactory;
        this.successCondition = arg_successCondition;
        this.successConditionSensorFactory = arg_successConditionSensorFactory;
        this.signature = arg_signature;
        this.specificity = arg_specificity;
        this.behaviorID = arg_behaviorID;
        this.behaviorVariableFrame = arg_behaviorVariableFrame;
        this.stepDescs = arg_stepDescs;
        this.priority = this.parent != null ? this.parent.getPriority() : (short)0;
    }

    public Behavior(GoalStep arg_parent, Method arg_contextCondition, Method arg_contextConditionSensorFactory, Method arg_successCondition, Method arg_successConditionSensorFactory, boolean arg_isAtomic, String arg_signature, short arg_specificity, int arg_behaviorID, Object[] arg_behaviorVariableFrame, __StepDesc[] arg_stepDescs, BehavingEntity[] arg_teamMembers) {
        this(arg_parent, arg_contextCondition, arg_contextConditionSensorFactory, arg_successCondition, arg_successConditionSensorFactory, arg_isAtomic, arg_signature, arg_specificity, arg_behaviorID, arg_behaviorVariableFrame, arg_stepDescs);
        assert (arg_teamMembers != null && arg_teamMembers.length > 0);
        this.teamMembers = new HashSet<BehavingEntity>();
        int i = 0;
        while (i < arg_teamMembers.length) {
            this.teamMembers.add(arg_teamMembers[i]);
            ++i;
        }
    }

    int getID() {
        return this.behaviorID;
    }

    short getPriority() {
        return this.priority;
    }

    public final GoalStep getParent() {
        return this.parent;
    }

    public String toString() {
        try {
            String behaviorTypeString;
            switch (this.getBehaviorType()) {
                case 0: {
                    behaviorTypeString = "sequential";
                    break;
                }
                case 1: {
                    behaviorTypeString = "parallel";
                    break;
                }
                case 2: {
                    behaviorTypeString = "collection";
                    break;
                }
                default: {
                    behaviorTypeString = "UNEXPECTED BEHAVIOR TYPE";
                }
            }
            return String.valueOf(behaviorTypeString) + " " + this.getSignature() + " priority: " + this.priority;
        }
        catch (Exception e) {
            throw new AblRuntimeError("Reflection error in SequentialBehavior.toString()");
        }
    }

    abstract short getBehaviorType();

    boolean getHasContextCondition() {
        return this.contextCondition != null;
    }

    boolean getHasSuccessCondition() {
        return this.successCondition != null;
    }

    short getSpecificity() {
        return this.specificity;
    }

    void setSpecificity(short arg_specificity) {
        this.specificity = arg_specificity;
    }

    String getSignature() {
        return this.signature;
    }

    boolean isJointBehavior() {
        return this.teamMembers != null;
    }

    final Set getTeamMembers() {
        assert (this.isJointBehavior());
        return this.teamMembers;
    }

    final int getBehaviorID() {
        return this.behaviorID;
    }

    abstract void addChildren();

    abstract void removeChildren();

    protected abstract boolean hasTeamEffectOnlySteps();

    protected void removeChild(Step child, boolean isCallerChild) {
        short stepType = child.getStepType();
        switch (stepType) {
            case 0: {
                if (((PrimitiveStep)child).isExecuting()) {
                    ((PrimitiveStep)child).abort();
                }
                ((PrimitiveStep)child).processStepRemoval();
                BehavingEntity.getBehavingEntity().removeStep(child);
                this.changes.firePropertyChange("child", child, null);
                break;
            }
            case 1: {
                if (((GoalStep)child).isExpanded()) {
                    ((GoalStep)child).removeGoal();
                }
                ((GoalStep)child).processStepRemoval();
                BehavingEntity.getBehavingEntity().removeStep(child);
                this.changes.firePropertyChange("child", child, null);
                break;
            }
            case 2: {
                ((MentalStep)child).delete();
                BehavingEntity.getBehavingEntity().removeStep(child);
                this.changes.firePropertyChange("child", child, null);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                BehavingEntity.getBehavingEntity().removeStep(child);
                this.changes.firePropertyChange("child", child, null);
                break;
            }
            default: {
                throw new AblRuntimeError("Unexpected step type " + stepType);
            }
        }
    }

    private void failBehaviorBody() {
        BehavingEntity.getBehavingEntity().removeBehavior(this);
        this.removeChildren();
        if (this.parent != null) {
            this.parent.addFailedBehavior(this);
            this.parent.removeChild(false);
            BehavingEntity.getBehavingEntity().resetStep(this.parent);
        }
    }

    void failBehavior() {
        final List<Step> jointGoals = this.freezeSubtreeAndNegotiateRemoval();
        if (!jointGoals.isEmpty()) {
            JointGoalNegotiationThread negotiateFailThread = new JointGoalNegotiationThread(null, this + " negotiateFailThread"){

                @Override
                public void run() {
                    JointGoalStep.blockOnSubtreeNegotiation(jointGoals);
                    Behavior.this.failBehaviorBody();
                }
            };
            BehavingEntity.getBehavingEntity().registerNegotiationThread(negotiateFailThread);
        } else {
            this.failBehaviorBody();
        }
    }

    void removeBehavior() {
        BehavingEntity.getBehavingEntity().removeBehavior(this);
        this.removeChildren();
    }

    private void succeedBehaviorBody() {
        BehavingEntity.getBehavingEntity().removeBehavior(this);
        this.removeChildren();
        if (this.parent != null) {
            this.parent.removeChild(false);
            this.parent.succeedStep();
        }
    }

    void succeedBehavior() {
        final List<Step> jointGoals = this.freezeSubtreeAndNegotiateRemoval();
        if (!jointGoals.isEmpty()) {
            JointGoalNegotiationThread negotiateSucceedThread = new JointGoalNegotiationThread(null, this + " negotiateSucceedThread"){

                @Override
                public void run() {
                    JointGoalStep.blockOnSubtreeNegotiation(jointGoals);
                    Behavior.this.succeedBehaviorBody();
                }
            };
            BehavingEntity.getBehavingEntity().registerNegotiationThread(negotiateSucceedThread);
        } else if (this.isJointBehavior() && this.hasTeamEffectOnlySteps()) {
            this.parent.succeedStep();
        } else {
            this.succeedBehaviorBody();
        }
    }

    boolean contextCondition() {
        if (this.contextCondition == null) {
            return true;
        }
        Object[] args = new Object[]{new Integer(this.behaviorID), this.behaviorVariableFrame, BehavingEntity.getBehavingEntity()};
        try {
            Boolean b = (Boolean)this.contextCondition.invoke(null, args);
            return b;
        }
        catch (Exception e) {
            throw new AblRuntimeError("Error invoking context condition", e);
        }
    }

    final SensorActivation[] getContextConditionSensorActivations() {
        if (this.contextConditionSensorFactory == null) {
            return null;
        }
        Object[] args = new Object[]{new Integer(this.behaviorID)};
        try {
            return (SensorActivation[])this.contextConditionSensorFactory.invoke(null, args);
        }
        catch (Exception e) {
            throw new AblRuntimeError("Error invoking context condition sensor factory", e);
        }
    }

    boolean successCondition() {
        if (this.successCondition == null) {
            return false;
        }
        Object[] args = new Object[]{new Integer(this.behaviorID), this.behaviorVariableFrame, BehavingEntity.getBehavingEntity()};
        try {
            Boolean b = (Boolean)this.successCondition.invoke(null, args);
            return b;
        }
        catch (Exception e) {
            throw new AblRuntimeError("Error invoking success condition", e);
        }
    }

    final SensorActivation[] getSuccessConditionSensorActivations() {
        if (this.successConditionSensorFactory == null) {
            return null;
        }
        Object[] args = new Object[]{new Integer(this.behaviorID)};
        try {
            return (SensorActivation[])this.successConditionSensorFactory.invoke(null, args);
        }
        catch (Exception e) {
            throw new AblRuntimeError("Error invoking success condition sensor factory", e);
        }
    }

    abstract boolean currentLineOfExpansion(GoalStep var1);

    abstract void suspend(ExecutableStep var1);

    abstract void suspendSkipJointGoals(ExecutableStep var1);

    abstract void jointUnsuspend();

    abstract void unsuspend(ExecutableStep var1);

    abstract void metaSuspend();

    abstract void metaSuspendSkipJointGoals();

    abstract void metaUnsuspend();

    public void addChildChangeListener(PropertyChangeListener l) {
        this.changes.addPropertyChangeListener("child", l);
    }

    public void removeChildChangeListener(PropertyChangeListener l) {
        this.changes.removePropertyChangeListener("child", l);
    }

    void setReflectionWME(BehaviorWME behaviorWME) {
        this.behaviorWME = behaviorWME;
    }

    protected BehaviorWME getReflectionWME() {
        return this.behaviorWME;
    }

    abstract List<Step> freezeSubtreeAndNegotiateRemoval();

    protected abstract List freezeNonTeamEffectOnlySubtreeAndNegotiateRemoval();

    abstract List negotiateSuspensionOfSubtree();

    abstract List negotiateSuspensionOfSubtree(ExecutableStep var1);

    protected List<Step> freezeChild(Step s) {
        short stepType = s.getStepType();
        switch (stepType) {
            case 0: {
                if (((PrimitiveStep)s).isExecuting()) {
                    ((PrimitiveStep)s).abort();
                }
                BehavingEntity.getBehavingEntity().removeStep(s);
                s.updateStepsSuspendingMe();
                return new Vector<Step>(0);
            }
            case 1: {
                BehavingEntity.getBehavingEntity().removeStep(s);
                s.updateStepsSuspendingMe();
                return ((GoalStep)s).freezeSubtreeAndNegotiateRemoval();
            }
            case 2: {
                ((MentalStep)s).delete();
                BehavingEntity.getBehavingEntity().removeStep(s);
                s.updateStepsSuspendingMe();
                return new Vector<Step>(0);
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                BehavingEntity.getBehavingEntity().removeStep(s);
                s.updateStepsSuspendingMe();
                return new Vector<Step>(0);
            }
        }
        throw new AblRuntimeError("Unexpected step type " + stepType);
    }

    protected List negotiateSuspensionOfChild(Step stepToSuspend, ExecutableStep stepToSuspendOn) {
        short stepType = stepToSuspend.getStepType();
        switch (stepType) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (stepToSuspendOn != null) {
                    stepToSuspend.suspend(stepToSuspendOn);
                } else {
                    stepToSuspend.metaSuspend();
                }
                return new Vector(0);
            }
            case 1: {
                return ((GoalStep)stepToSuspend).negotiateSuspensionOfSubtree(stepToSuspendOn);
            }
        }
        throw new AblRuntimeError("Unexpected step type " + stepType);
    }

    protected List negotiateSuspensionOfChild(Step stepToSuspend) {
        short stepType = stepToSuspend.getStepType();
        switch (stepType) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                stepToSuspend.jointSuspend();
                return new Vector(0);
            }
            case 1: {
                return ((GoalStep)stepToSuspend).negotiateSuspensionOfSubtree();
            }
        }
        throw new AblRuntimeError("Unexpected step type " + stepType);
    }

    boolean isRootBehavior() {
        return this.parent == null;
    }
}

