/*
 * Decompiled with CFR 0.152.
 */
package abl.runtime;

import abl.compiler.AblDebuggerConstants;
import abl.runtime.AblRuntimeError;
import abl.runtime.BehavingListener;
import abl.runtime.Behavior;
import abl.runtime.BehaviorSpecificityComparator;
import abl.runtime.CollectionBehavior;
import abl.runtime.CollectionBehaviorWME;
import abl.runtime.DebuggableBehavior;
import abl.runtime.DebuggableStep;
import abl.runtime.Debugger;
import abl.runtime.ExecutableStep;
import abl.runtime.GoalStep;
import abl.runtime.InitiatedJointGoalStep;
import abl.runtime.InitiatedJointGoalStepDebug;
import abl.runtime.JointGoalNegotiationThread;
import abl.runtime.JointGoalNegotiator;
import abl.runtime.JointGoalStep;
import abl.runtime.PrimitiveStep;
import abl.runtime.RuntimeError;
import abl.runtime.SatisfiedBehavior;
import abl.runtime.Sensor;
import abl.runtime.SensorActivation;
import abl.runtime.Step;
import abl.runtime.StepExpansionComparator;
import abl.runtime.StepPriorityComparator;
import abl.runtime.WaitStep;
import abl.runtime.__BehaviorDesc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import javax.swing.tree.DefaultTreeModel;
import wm.WME;
import wm.WorkingMemory;
import wm.WorkingMemoryDebugger;

public abstract class BehavingEntity
implements AblDebuggerConstants {
    public static final int suspendOnInstantiate = 0;
    public static final int suspendOnExecute = 1;
    protected final WorkingMemory workingMemory;
    protected CollectionBehavior ABT;
    protected Set leafSteps = Collections.synchronizedSet(new HashSet());
    protected HashSet atomicSteps = new HashSet();
    protected HashSet executingPrimitiveSteps = new HashSet();
    protected HashSet successTestStepsNoSensing = new HashSet();
    protected HashSet contextConditionBehaviorsNoSensing = new HashSet();
    protected final HashSet successConditionBehaviorsNoSensing = new HashSet();
    protected HashSet successTestStepsSensing = new HashSet();
    protected HashSet contextConditionBehaviorsSensing = new HashSet();
    protected final HashSet successConditionBehaviorsSensing = new HashSet();
    protected Hashtable executingSteps = new Hashtable();
    protected BehaviorLibrary individualBehaviorLibrary;
    protected BehaviorLibrary jointBehaviorLibrary;
    protected static final InheritableThreadLocal entity = new InheritableThreadLocal();
    private static BehaviorSpecificityComparator behComparator = new BehaviorSpecificityComparator();
    private static StepPriorityComparator stepPriorityComparator = new StepPriorityComparator();
    private static StepExpansionComparator stepExpansionComparator = new StepExpansionComparator();
    Random randomGen = new Random();
    static Object[] tempObjArray = new Object[1];
    protected boolean bCurrentLineOfExpansion = true;
    protected boolean bStepConflicts = true;
    protected byte debugLevel = 0;
    protected Debugger debuggerGUI = null;
    protected boolean bDecisionCycleSMCall = false;
    protected boolean asynchronousSenseCycle = true;
    private static Hashtable entityTable = new Hashtable();
    private Hashtable currentEntryNegotiators = new Hashtable();
    private List activeNegotiationThreads = Collections.synchronizedList(new LinkedList());
    private Thread decisionCycleThread = null;
    private boolean negotiatorCommittedDuringNegotiation = false;
    private long continuousConditionTime = 0L;
    private ShutdownHook shutdownHook;
    private CollectionBehaviorWME rootCollectionBehaviorWME = null;
    private boolean behaving = true;
    private boolean paused = false;
    private ArrayList<BehavingListener> behavingListeners = new ArrayList();
    SensedConditionMonitor senseMonitor = new SensedConditionMonitor();
    ActiveContinuousSensors activeSensors = new ActiveContinuousSensors();
    private final ThreadGroup timeCheckThreads = new ThreadGroup("TimeCheckThreads");

    public BehavingEntity() {
        entity.set(this);
        String longName = this.getClass().getName();
        this.workingMemory = new WorkingMemory(String.valueOf(longName.substring(longName.lastIndexOf(46) + 1)) + "Memory");
    }

    public String getBehavingEntityShortName() {
        String longName = this.getClass().getName();
        return longName.substring(longName.lastIndexOf(46) + 1);
    }

    public String toString() {
        return this.getBehavingEntityShortName();
    }

    CollectionBehavior getRootCollectionBehavior() {
        return this.ABT;
    }

    public static BehavingEntity getBehavingEntity() {
        return (BehavingEntity)entity.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void registerEntity(String name, BehavingEntity entity) {
        Hashtable hashtable = entityTable;
        synchronized (hashtable) {
            entityTable.put(name, entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BehavingEntity getBehavingEntity(String name) {
        Hashtable hashtable = entityTable;
        synchronized (hashtable) {
            BehavingEntity specifiedEntity = (BehavingEntity)entityTable.get(name);
            if (specifiedEntity == null) {
                throw new AblRuntimeError("No behaving entity found for entity name " + name);
            }
            return specifiedEntity;
        }
    }

    Thread getDecisionCycleThread() {
        return this.decisionCycleThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBehaving() {
        this.decisionCycleThread = Thread.currentThread();
        if (this.asynchronousSenseCycle) {
            class SenseCycleThread
            extends Thread {
                SenseCycleThread() {
                }

                @Override
                public void run() {
                    while (BehavingEntity.this.behaving) {
                        BehavingEntity.this.activeSensors.sense();
                    }
                }
            }
            new SenseCycleThread().start();
        }
        this.shutdownHook = new ShutdownHook();
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        while (this.behaving) {
            Thread.currentThread().setName("DecisionCycleThread");
            this.behave();
        }
        ActiveContinuousSensors activeContinuousSensors = this.activeSensors;
        synchronized (activeContinuousSensors) {
            this.activeSensors.notifyAll();
        }
    }

    public void stopBehaving() {
        this.behaving = false;
    }

    public void setUseSynchrousSensors() {
        this.asynchronousSenseCycle = false;
    }

    public void addBehavingListener(BehavingListener listener) {
        this.behavingListeners.add(listener);
    }

    public void pause() {
        this.paused = true;
    }

    public void unpause() {
        this.paused = false;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void behave() {
        if (this.paused) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        for (BehavingListener listener : this.behavingListeners) {
            listener.onBehave(this.executingSteps, this.leafSteps);
        }
        this.shutdownHook.shutdownMessage = String.valueOf(this.getBehavingEntityShortName()) + " was running negotiation threads";
        this.runNegotiationThreads();
        if (this.bDecisionCycleSMCall) {
            this.shutdownHook.shutdownMessage = String.valueOf(this.getBehavingEntityShortName()) + " was in the decision cycle SM call";
            this.decisionCycleSMCall();
        }
        this.workingMemory.deleteMarkedTransientWMEs();
        this.shutdownHook.shutdownMessage = String.valueOf(this.getBehavingEntityShortName()) + " was checking for completed primitive actions";
        for (PrimitiveStep primStep : this.executingPrimitiveSteps) {
            if (primStep.getCompletionStatus() == 1) {
                primStep.succeedStep();
                return;
            }
            if (primStep.getCompletionStatus() != 2) continue;
            primStep.failStep();
            return;
        }
        this.shutdownHook.shutdownMessage = String.valueOf(this.getBehavingEntityShortName()) + " was checking continuously monitored conditions";
        if (this.atomicSteps.isEmpty()) {
            if (!this.asynchronousSenseCycle) {
                this.activeSensors.sense();
                this.runSuccessTests(true);
                this.runContextConditions(true);
                this.runSuccessConditions(true);
                this.workingMemory.markTransientWMEs();
            }
            long continuousConditionStartTime = System.currentTimeMillis();
            this.runSuccessTests(false);
            this.runContextConditions(false);
            this.runSuccessConditions(false);
            this.continuousConditionTime = System.currentTimeMillis() - continuousConditionStartTime;
            if (this.asynchronousSenseCycle && this.senseMonitor.sensedConditionsReadyToRun()) {
                this.runSuccessTests(true);
                this.runContextConditions(true);
                this.runSuccessConditions(true);
                this.workingMemory.markTransientWMEs();
            }
        }
        this.shutdownHook.shutdownMessage = String.valueOf(this.getBehavingEntityShortName()) + " was selecting a step";
        Step stepToExecute = this.chooseStep();
        if (this.debugLevel == 2) {
            this.debuggerGUI.debug(this.continuousConditionTime);
        }
        if (stepToExecute != null) {
            this.shutdownHook.shutdownMessage = String.valueOf(this.getBehavingEntityShortName()) + " was executing step " + stepToExecute + " of behavior " + stepToExecute.getParent();
            stepToExecute.execute();
        } else {
            try {
                this.shutdownHook.shutdownMessage = String.valueOf(this.getBehavingEntityShortName()) + " was waiting because there was no step to execute";
                Thread.sleep(17L);
            }
            catch (InterruptedException exception) {
                throw new RuntimeError("Unexpected interruption");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printNegotiationThreads() {
        List list = this.activeNegotiationThreads;
        synchronized (list) {
            Iterator iter = this.activeNegotiationThreads.iterator();
            if (!iter.hasNext()) {
                System.err.println("No active negotiation threads in " + this.getBehavingEntityShortName());
            }
            while (iter.hasNext()) {
                System.err.println(iter.next());
            }
        }
    }

    private void runNegotiationThreads() {
        this.negotiatorCommittedDuringNegotiation = false;
        JointGoalNegotiationThread[] threads = this.activeNegotiationThreads.toArray(new JointGoalNegotiationThread[this.activeNegotiationThreads.size()]);
        int i = 0;
        while (i < threads.length) {
            class TimeCheckThread
            extends Thread {
                JointGoalNegotiationThread monitoredThread;

                TimeCheckThread(JointGoalNegotiationThread t2) {
                    super(BehavingEntity.this.timeCheckThreads, null, "tct");
                    this.monitoredThread = t2;
                }

                @Override
                public void run() {
                    try {
                        TimeCheckThread.sleep(1000L);
                        System.err.println("WARNING: a negotiation thread took longer than a second to execute. The thread was interrupted.");
                        this.monitoredThread.interrupt();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            TimeCheckThread tct;
            if (!threads[i].getIsStarted()) {
                tct = new TimeCheckThread(threads[i]);
                tct.start();
                threads[i].start();
                tct.interrupt();
            } else if (!threads[i].isAlive()) {
                this.activeNegotiationThreads.remove(threads[i]);
            } else {
                tct = new TimeCheckThread(threads[i]);
                tct.start();
                threads[i].continueNegotiation();
                tct.interrupt();
            }
            ++i;
        }
        if (this.negotiatorCommittedDuringNegotiation) {
            this.runNegotiationThreads();
        }
    }

    void jointGoalNegotiatorCommitted() {
        try {
            JointGoalNegotiationThread t2 = (JointGoalNegotiationThread)Thread.currentThread();
        }
        catch (ClassCastException e) {
            throw new AblRuntimeError("Non-negotiation thread " + Thread.currentThread() + " attempted jointGoalNegotiatorCommitted.");
        }
        this.negotiatorCommittedDuringNegotiation = true;
    }

    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    public void addWME(WME w) {
        this.workingMemory.addWME(w);
    }

    public void addWMEs(WME ... ws) {
        int i = 0;
        while (i < ws.length) {
            this.workingMemory.addWME(ws[i]);
            ++i;
        }
    }

    public void deleteWME(WME wmeToDelete) {
        this.workingMemory.deleteWME(wmeToDelete);
    }

    public void deleteAllWMEClass(String wmeClassName) {
        this.workingMemory.deleteAllWMEClass(wmeClassName);
    }

    public LinkedList lookupWME(String wmeClassName) {
        return this.workingMemory.lookupWME(wmeClassName);
    }

    public List lookupReflectionWMEBySignature(String wmeClassName, String signature) {
        return this.workingMemory.lookupReflectionWMEBySignature(wmeClassName, signature);
    }

    public List lookupReflectionWMEByUserProperty(String wmeClassName, String userPropertyName) {
        return this.workingMemory.lookupReflectionWMEByUserProperty(wmeClassName, userPropertyName);
    }

    public WorkingMemoryDebugger getWMDebugger() {
        return new WorkingMemoryDebugger(this.workingMemory);
    }

    void resetStep(Step s) {
        this.executingPrimitiveSteps.remove(s);
        this.removeExecutingStep(s);
        if (s.getStepType() != 3) {
            if (s.getIsAtomic()) {
                this.atomicSteps.add(s);
            } else {
                this.leafSteps.add(s);
            }
        }
    }

    void abortStep(PrimitiveStep s) {
        this.removeSuccessTest(s);
        this.executingPrimitiveSteps.remove(s);
        this.removeExecutingStep(s);
    }

    void suspendStep(ExecutableStep s) {
        boolean inFringe;
        this.removeSuccessTest(s);
        if (s.getStepType() == 1) {
            inFringe = !((GoalStep)s).isExpanded();
        } else {
            boolean bl = inFringe = !s.isExecuting();
        }
        if (!inFringe) {
            this.removeExecutingStep(s);
            if (s.getStepType() == 0) {
                this.executingPrimitiveSteps.remove(s);
            }
        } else if (s.getIsAtomic()) {
            this.atomicSteps.remove(s);
        } else {
            this.leafSteps.remove(s);
        }
    }

    void suspendStep(WaitStep s) {
        this.removeSuccessTest(s);
    }

    void unsuspendStep(ExecutableStep s) {
        if (s.getStepType() == 1 && ((GoalStep)s).isExpanded()) {
            HashSet<ExecutableStep> stepSet = (HashSet<ExecutableStep>)this.executingSteps.get(s.getName());
            if (stepSet != null) {
                stepSet.add(s);
            } else {
                stepSet = new HashSet<ExecutableStep>();
                stepSet.add(s);
                this.executingSteps.put(s.getName(), stepSet);
            }
        } else if (s.getIsAtomic()) {
            this.atomicSteps.add(s);
        } else {
            this.leafSteps.add(s);
        }
        this.addSuccessTest(s);
    }

    void unsuspendStep(WaitStep s) {
        this.addSuccessTest(s);
    }

    DefaultTreeModel getABTTreeModel() {
        return new DefaultTreeModel(((DebuggableBehavior)((Object)this.ABT)).getTree());
    }

    void removeSuccessTest(Step s) {
        if (s.getHasSuccessTest() && (this.successTestStepsSensing.contains(s) || this.successTestStepsNoSensing.contains(s))) {
            SensorActivation[] activations = s.getSuccessTestSensorActivations();
            if (activations != null) {
                this.successTestStepsSensing.remove(s);
            } else {
                this.successTestStepsNoSensing.remove(s);
            }
            if (activations != null) {
                this.activeSensors.deactivateSensors(activations);
            }
        }
    }

    private void addSuccessTest(Step s) {
        if (s.getHasSuccessTest()) {
            SensorActivation[] activations = s.getSuccessTestSensorActivations();
            if (activations != null) {
                this.successTestStepsSensing.add(s);
            } else {
                this.successTestStepsNoSensing.add(s);
            }
            if (activations != null) {
                this.activeSensors.activateSensors(activations);
            }
        }
    }

    void removeStep(Step s) {
        this.removeSuccessTest(s);
        this.executingPrimitiveSteps.remove(s);
        if (s.getIsAtomic()) {
            this.atomicSteps.remove(s);
        } else {
            this.leafSteps.remove(s);
        }
        this.removeExecutingStep(s);
    }

    void addStep(Step s) {
        if (s.getStepType() != 3) {
            if (s.getIsAtomic()) {
                this.atomicSteps.add(s);
            } else {
                this.leafSteps.add(s);
            }
        }
        this.addSuccessTest(s);
    }

    void removeExecutingStep(Step s) {
        HashSet stepSet;
        if ((s.getStepType() == 0 || s.getStepType() == 1) && (stepSet = (HashSet)this.executingSteps.get(((ExecutableStep)s).getName())) != null) {
            stepSet.remove(s);
        }
    }

    void executeStep(Step s) {
        if (s.getIsAtomic()) {
            this.atomicSteps.remove(s);
        } else {
            this.leafSteps.remove(s);
        }
        short stepType = s.getStepType();
        if (stepType == 0) {
            this.executingPrimitiveSteps.add(s);
        }
        if (stepType == 0 || stepType == 1) {
            HashSet<Step> stepSet = (HashSet<Step>)this.executingSteps.get(((ExecutableStep)s).getName());
            if (stepSet != null) {
                stepSet.add(s);
            } else {
                stepSet = new HashSet<Step>();
                stepSet.add(s);
                this.executingSteps.put(((ExecutableStep)s).getName(), stepSet);
            }
        }
    }

    void addBehavior(Behavior b) {
        SensorActivation[] activations;
        if (b.getHasContextCondition()) {
            activations = b.getContextConditionSensorActivations();
            if (activations != null) {
                this.contextConditionBehaviorsSensing.add(b);
            } else {
                this.contextConditionBehaviorsNoSensing.add(b);
            }
            if (activations != null) {
                this.activeSensors.activateSensors(activations);
            }
        }
        if (b.getHasSuccessCondition()) {
            activations = b.getSuccessConditionSensorActivations();
            if (activations != null) {
                this.successConditionBehaviorsSensing.add(b);
            } else {
                this.successConditionBehaviorsNoSensing.add(b);
            }
            if (activations != null) {
                this.activeSensors.activateSensors(activations);
            }
        }
    }

    void removeBehavior(Behavior b) {
        if ((b.getHasContextCondition() || b.getHasSuccessCondition()) && !b.getBehaviorRemoved()) {
            SensorActivation[] contextConditionActivations = b.getContextConditionSensorActivations();
            if (contextConditionActivations != null) {
                this.contextConditionBehaviorsSensing.remove(b);
            } else {
                this.contextConditionBehaviorsNoSensing.remove(b);
            }
            SensorActivation[] successConditionActivations = b.getSuccessConditionSensorActivations();
            if (successConditionActivations != null) {
                this.successConditionBehaviorsSensing.remove(b);
            } else {
                this.successConditionBehaviorsNoSensing.remove(b);
            }
            b.setBehaviorRemoved();
            if (contextConditionActivations != null) {
                this.activeSensors.deactivateSensors(contextConditionActivations);
            }
            if (successConditionActivations != null) {
                this.activeSensors.deactivateSensors(successConditionActivations);
            }
        }
    }

    private boolean runContextConditions(boolean runSensedConditions) {
        Iterator contextConditionIterator = runSensedConditions ? this.contextConditionBehaviorsSensing.iterator() : this.contextConditionBehaviorsNoSensing.iterator();
        while (contextConditionIterator.hasNext()) {
            Behavior contextConditionBehavior = (Behavior)contextConditionIterator.next();
            if (contextConditionBehavior.contextCondition()) continue;
            contextConditionBehavior.failBehavior();
            this.runContextConditions(runSensedConditions);
            return true;
        }
        return false;
    }

    private boolean runSuccessConditions(boolean runSensedConditions) {
        Iterator successConditionIterator = runSensedConditions ? this.successConditionBehaviorsSensing.iterator() : this.successConditionBehaviorsNoSensing.iterator();
        while (successConditionIterator.hasNext()) {
            Behavior successConditionBehavior = (Behavior)successConditionIterator.next();
            if (!successConditionBehavior.successCondition()) continue;
            successConditionBehavior.succeedBehavior();
            this.runSuccessConditions(runSensedConditions);
            return true;
        }
        return false;
    }

    private boolean runSuccessTests(boolean runSensedConditions) {
        Iterator successStepIterator = runSensedConditions ? this.successTestStepsSensing.iterator() : this.successTestStepsNoSensing.iterator();
        while (successStepIterator.hasNext()) {
            Step successStep = (Step)successStepIterator.next();
            if (!successStep.successTest()) continue;
            successStep.succeedStep();
            this.runSuccessTests(runSensedConditions);
            return true;
        }
        return false;
    }

    Behavior chooseIndividualBehavior(Object[] args, HashSet failedBehaviors, GoalStep g) {
        return this.chooseBehavior(args, failedBehaviors, g, false, null);
    }

    Behavior chooseJointBehavior(Object[] args, Set failedBehaviors, GoalStep g) {
        return this.chooseBehavior(args, failedBehaviors, g, true, null);
    }

    Behavior chooseJointBehavior(Object[] args, Set failedBehaviors, GoalStep g, Set teamMembers) {
        return this.chooseBehavior(args, failedBehaviors, g, true, teamMembers);
    }

    private Behavior chooseBehavior(Object[] args, Set failedBehaviors, GoalStep g, boolean findJointBehaviors, Set teamMembers) {
        __BehaviorDesc behDesc;
        Iterator iter;
        List behList;
        assert (!findJointBehaviors && teamMembers == null || findJointBehaviors);
        String signature = g.getSignature();
        if (findJointBehaviors) {
            behList = this.jointBehaviorLibrary.lookupBehavior(signature);
            if (behList.isEmpty()) {
                return null;
            }
            if (teamMembers != null) {
                iter = behList.iterator();
                while (iter.hasNext()) {
                    behDesc = (__BehaviorDesc)iter.next();
                    HashSet<BehavingEntity> behTeamMembers = new HashSet<BehavingEntity>(behDesc.teamMembers.length * 2);
                    int i = 0;
                    while (i < behDesc.teamMembers.length) {
                        behTeamMembers.add(BehavingEntity.getBehavingEntity(behDesc.teamMembers[i]));
                        ++i;
                    }
                    if (behTeamMembers.equals(teamMembers)) continue;
                    iter.remove();
                }
            }
        } else {
            behList = this.individualBehaviorLibrary.lookupBehavior(signature);
            if (behList == null) {
                return null;
            }
        }
        iter = behList.iterator();
        while (iter.hasNext()) {
            behDesc = (__BehaviorDesc)iter.next();
            if (!failedBehaviors.contains(new Integer(behDesc.behaviorID))) continue;
            iter.remove();
        }
        if (behList.isEmpty()) {
            return null;
        }
        Vector<SatisfiedBehavior> satisfiedBeh = new Vector<SatisfiedBehavior>(100);
        iter = behList.iterator();
        HashSet<SensorActivation> sensors = new HashSet<SensorActivation>();
        try {
            while (iter.hasNext()) {
                __BehaviorDesc behDesc2 = (__BehaviorDesc)iter.next();
                if (behDesc2.preconditionSensorFactory == null) continue;
                Object[] sensorFactoryArgs = new Object[]{new Integer(behDesc2.behaviorID)};
                SensorActivation[] activations = (SensorActivation[])behDesc2.preconditionSensorFactory.invoke(null, sensorFactoryArgs);
                int activationCounter = 0;
                while (activationCounter < activations.length) {
                    sensors.add(activations[activationCounter]);
                    ++activationCounter;
                }
            }
        }
        catch (Exception e) {
            throw new AblRuntimeError("Reflection error", e);
        }
        if (!sensors.isEmpty()) {
            this.runSensors(new Vector(sensors), false);
        }
        iter = behList.iterator();
        try {
            while (iter.hasNext()) {
                __BehaviorDesc behDesc3 = (__BehaviorDesc)iter.next();
                if (behDesc3.precondition != null) {
                    Object[] argArray = new Object[]{new Integer(behDesc3.behaviorID), args, new Hashtable(), this};
                    Boolean b = (Boolean)behDesc3.precondition.invoke(null, argArray);
                    if (this.debugLevel == 2) {
                        this.debuggerGUI.traceAblExecutionEvent(1, behDesc3, (Object)b, ((DebuggableStep)((Object)g)).getNestLevel() + 1, behDesc3.behaviorID);
                    }
                    if (!b.booleanValue()) continue;
                    satisfiedBeh.add(new SatisfiedBehavior(behDesc3, (Hashtable)argArray[2]));
                    continue;
                }
                if (this.debugLevel == 2) {
                    this.debuggerGUI.traceAblExecutionEvent(1, behDesc3, (Object)new Boolean(true), ((DebuggableStep)((Object)g)).getNestLevel() + 1, behDesc3.behaviorID);
                }
                satisfiedBeh.add(new SatisfiedBehavior(behDesc3, null));
            }
            if (!satisfiedBeh.isEmpty()) {
                Hashtable preconditionBoundVariables;
                __BehaviorDesc winningBeh;
                SatisfiedBehavior[] behArray = satisfiedBeh.toArray(new SatisfiedBehavior[satisfiedBeh.size()]);
                Arrays.sort(behArray, behComparator);
                ArrayList<SatisfiedBehavior> mostSpecificBeh = new ArrayList<SatisfiedBehavior>(satisfiedBeh.size());
                mostSpecificBeh.add(behArray[0]);
                int j = 1;
                while (j < behArray.length) {
                    if (behComparator.compare(behArray[0], behArray[j]) == 0) {
                        mostSpecificBeh.add(behArray[j]);
                    }
                    ++j;
                }
                if (mostSpecificBeh.size() == 1) {
                    winningBeh = ((SatisfiedBehavior)mostSpecificBeh.get((int)0)).behDesc;
                    preconditionBoundVariables = ((SatisfiedBehavior)mostSpecificBeh.get((int)0)).preconditionBoundVariables;
                } else if (mostSpecificBeh.size() > 1) {
                    int randomIndex = this.randomGen.nextInt(mostSpecificBeh.size());
                    winningBeh = ((SatisfiedBehavior)mostSpecificBeh.get((int)randomIndex)).behDesc;
                    preconditionBoundVariables = ((SatisfiedBehavior)mostSpecificBeh.get((int)randomIndex)).preconditionBoundVariables;
                } else {
                    throw new RuntimeError("Expected mostSpecificBeh >= 1, instead < 1");
                }
                Object[] behFactoryArgs = this.debugLevel == 2 ? new Object[]{new Integer(winningBeh.behaviorID), args, preconditionBoundVariables, g, winningBeh.signature, winningBeh} : new Object[]{new Integer(winningBeh.behaviorID), args, preconditionBoundVariables, g, winningBeh.signature};
                return (Behavior)winningBeh.factory.invoke(null, behFactoryArgs);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeError("Reflection error in chooseBehavior()");
        }
    }

    private Step chooseStep() {
        if (!this.leafSteps.isEmpty() || !this.atomicSteps.isEmpty()) {
            ListIterator iter;
            ArrayList<Step> conflictSet = !this.atomicSteps.isEmpty() ? new ArrayList<Step>(this.atomicSteps) : new ArrayList(this.leafSteps);
            if (this.bStepConflicts) {
                iter = conflictSet.listIterator();
                while (iter.hasNext()) {
                    if (!((Step)iter.next()).isSuspended()) continue;
                    iter.remove();
                }
            }
            iter = conflictSet.listIterator();
            while (iter.hasNext()) {
                Step s = (Step)iter.next();
                if (s.getStepType() != 1 || !((GoalStep)s).isJointGoal() || !((JointGoalStep)s).getIsNegotiating()) continue;
                iter.remove();
            }
            if (conflictSet.size() > 0) {
                Step[] conflictArray = conflictSet.toArray(new Step[conflictSet.size()]);
                Arrays.sort(conflictArray, stepPriorityComparator);
                conflictSet.clear();
                conflictSet.add(conflictArray[0]);
                int i = 1;
                while (i < conflictArray.length) {
                    if (stepPriorityComparator.compare(conflictArray[0], conflictArray[i]) != 0) break;
                    conflictSet.add(conflictArray[i]);
                    ++i;
                }
                if (this.bCurrentLineOfExpansion && conflictSet.size() > 1) {
                    conflictArray = conflictSet.toArray(new Step[conflictSet.size()]);
                    Arrays.sort(conflictArray, stepExpansionComparator);
                    conflictSet.clear();
                    conflictSet.add(conflictArray[0]);
                    i = 1;
                    while (i < conflictArray.length) {
                        if (stepExpansionComparator.compare(conflictArray[0], conflictArray[i]) != 0) break;
                        conflictSet.add(conflictArray[i]);
                        ++i;
                    }
                }
                assert (conflictSet.size() >= 1);
                if (conflictSet.size() > 1) {
                    return (Step)conflictSet.get(this.randomGen.nextInt(conflictSet.size()));
                }
                return (Step)conflictSet.get(0);
            }
            return null;
        }
        return null;
    }

    void findConflictsWithCurrentlyExecutingSteps(ExecutableStep step, int comparisonIndex) {
        assert (comparisonIndex == 0 || comparisonIndex == 1);
        String[] conflictArray = step.getConflicts();
        int i = 0;
        while (i < conflictArray.length) {
            HashSet stepSet = (HashSet)this.executingSteps.get(conflictArray[i]);
            if (stepSet != null) {
                for (ExecutableStep executingStep : stepSet) {
                    switch (comparisonIndex) {
                        case 0: {
                            if (executingStep.getPriority() < step.getPriority()) break;
                            step.suspend(executingStep);
                            break;
                        }
                        case 1: {
                            if (executingStep.getPriority() < step.getPriority()) {
                                executingStep.suspend(step);
                                break;
                            }
                            step.suspend(executingStep);
                        }
                    }
                }
            }
            ++i;
        }
    }

    void runSensors(List sensors, boolean isContinuous) {
        Iterator sensorIterator = sensors.iterator();
        class SensorThread
        extends Thread {
            Sensor s;
            Object[] args;
            boolean isContinuous;

            SensorThread(Sensor sToSet, Object[] argsToSet, boolean isContinuousToSet) {
                this.s = sToSet;
                this.args = argsToSet;
                this.isContinuous = isContinuousToSet;
            }

            @Override
            public void run() {
                if (this.isContinuous) {
                    this.s.senseContinuous(this.args);
                } else {
                    this.s.senseOneShot(this.args);
                }
            }
        }
        LinkedList<SensorThread> sensorThreadList = new LinkedList<SensorThread>();
        while (sensorIterator.hasNext()) {
            SensorActivation activationRecord = (SensorActivation)sensorIterator.next();
            Sensor s = activationRecord.activeSensor;
            Object[] args = activationRecord.arguments;
            if (s.canBeParallel()) {
                SensorThread st = new SensorThread(s, args, isContinuous);
                st.setPriority(5);
                sensorThreadList.add(st);
                st.start();
                continue;
            }
            if (this.asynchronousSenseCycle) {
                throw new AblRuntimeError("Asynchronous serial sensors not currently supported");
            }
            if (isContinuous) {
                s.senseContinuous(args);
                continue;
            }
            s.senseOneShot(args);
        }
        if (sensorThreadList.size() != 0) {
            ListIterator threadIter = sensorThreadList.listIterator();
            while (threadIter.hasNext()) {
                try {
                    ((SensorThread)threadIter.next()).join();
                }
                catch (InterruptedException e) {
                    throw new AblRuntimeError("Sensor thread interrupted");
                }
            }
        }
    }

    protected void decisionCycleSMCall() {
    }

    public void breakNextDecisionCycle() {
        if (this.debugLevel == 2) {
            this.debuggerGUI.breakNextDecisionCycle();
        }
    }

    public void breakNow() {
        if (this.debugLevel == 2) {
            this.debuggerGUI.breakNextDecisionCycle();
            this.debuggerGUI.debug(0L);
        }
    }

    public void setTraceToScreen(boolean b) {
        if (this.debugLevel == 2) {
            this.debuggerGUI.setTraceToScreen(b);
        }
    }

    public void setTraceToBuffer(boolean b) {
        if (this.debugLevel == 2) {
            this.debuggerGUI.setTraceToBuffer(b);
        }
    }

    protected void startWMEReflection(CollectionBehavior b) {
        CollectionBehaviorWME root = new CollectionBehaviorWME(b, null);
        this.addWME(root);
        this.rootCollectionBehaviorWME = root;
    }

    boolean reflectionEnabled() {
        return this.rootCollectionBehaviorWME != null;
    }

    public static boolean constantTrue(int i) {
        return true;
    }

    public static boolean constantTrue(float f) {
        return true;
    }

    public static boolean constantTrue(double d) {
        return true;
    }

    public static boolean constantTrue(short s) {
        return true;
    }

    public static boolean constantTrue(long l) {
        return true;
    }

    public static boolean constantTrue(char c) {
        return true;
    }

    public static boolean constantTrue(byte b) {
        return true;
    }

    public static boolean constantTrue(boolean b) {
        return true;
    }

    public static boolean constantTrue(Object o) {
        return true;
    }

    public static boolean truePrintln(String s) {
        System.out.println(s);
        return true;
    }

    Set getRegisteredIndividualBehaviors() {
        return this.individualBehaviorLibrary.getRegisteredBehaviors();
    }

    Set getRegisteredJointBehaviors() {
        return this.jointBehaviorLibrary.getRegisteredBehaviors();
    }

    Set getRegisteredBehaviors() {
        HashSet fullBehaviorSet = new HashSet(this.individualBehaviorLibrary.getRegisteredBehaviors());
        fullBehaviorSet.addAll(this.jointBehaviorLibrary.getRegisteredBehaviors());
        return fullBehaviorSet;
    }

    void traceBehaviorSignature(String behaviorSig) {
        List behaviorList = this.individualBehaviorLibrary.lookupBehavior(behaviorSig);
        behaviorList.addAll(this.jointBehaviorLibrary.lookupBehavior(behaviorSig));
        for (__BehaviorDesc behDesc : behaviorList) {
            this.debuggerGUI.traceBehavior(behDesc.behaviorID);
        }
    }

    void untraceBehaviorSignature(String behaviorSig) {
        List behaviorList = this.individualBehaviorLibrary.lookupBehavior(behaviorSig);
        behaviorList.addAll(this.jointBehaviorLibrary.lookupBehavior(behaviorSig));
        for (__BehaviorDesc behDesc : behaviorList) {
            this.debuggerGUI.untraceBehavior(behDesc.behaviorID);
        }
    }

    void registerNegotiationThread(JointGoalNegotiationThread t2) {
        assert (t2 != null);
        this.activeNegotiationThreads.add(t2);
    }

    void unregisterNegotiationThread(JointGoalNegotiationThread t2) {
        assert (t2 != null);
        this.activeNegotiationThreads.remove(t2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Hashtable negotiateEntry(JointGoalStep g, Object[] args) {
        Long uniqueEntryNegotiationID;
        JointGoalNegotiationThread test = (JointGoalNegotiationThread)Thread.currentThread();
        Hashtable hashtable = this.currentEntryNegotiators;
        synchronized (hashtable) {
            uniqueEntryNegotiationID = g.negotiator.getUniqueEntryNegotiationID();
            this.currentEntryNegotiators.put(uniqueEntryNegotiationID, g);
        }
        Hashtable commitSet = g.negotiator.negotiateEntry(args, g);
        Hashtable hashtable2 = this.currentEntryNegotiators;
        synchronized (hashtable2) {
            this.currentEntryNegotiators.remove(uniqueEntryNegotiationID);
        }
        return commitSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueIntentionToEnter(final Long uniqueEntryNegotiationID, final BehavingEntity sender, final Object[] args, final boolean teamNeededForSuccess, final Set teamMembers, final JointGoalStep g) {
        JointGoalStep tempGoalStep;
        Hashtable hashtable = this.currentEntryNegotiators;
        synchronized (hashtable) {
            tempGoalStep = (JointGoalStep)this.currentEntryNegotiators.get(uniqueEntryNegotiationID);
            if (tempGoalStep == null) {
                tempGoalStep = this.debugLevel == 0 ? this.getInitiatedJointGoalStep(this.getRootCollectionBehavior(), g.getSignature(), teamMembers, args, teamNeededForSuccess) : this.getInitiatedJointGoalStepDebug(this.getRootCollectionBehavior(), g.getSignature(), teamMembers, args, teamNeededForSuccess);
                this.currentEntryNegotiators.put(uniqueEntryNegotiationID, tempGoalStep);
            }
        }
        final JointGoalStep escroedGoalStep = tempGoalStep;
        JointGoalNegotiationThread intentionToEnterThread = new JointGoalNegotiationThread(escroedGoalStep.negotiator, escroedGoalStep + " queueIntentionToEnter"){

            @Override
            public void run() {
                entity.set(BehavingEntity.this);
                escroedGoalStep.negotiator.processIntentionToEnter(uniqueEntryNegotiationID, sender, args, teamNeededForSuccess, teamMembers, g, escroedGoalStep);
            }
        };
        this.registerNegotiationThread(intentionToEnterThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueIntentionToRefuseEntry(final Long uniqueEntryNegotiationID, final BehavingEntity sender, Set teamMembers) {
        JointGoalStep tempGoalStep;
        Hashtable hashtable = this.currentEntryNegotiators;
        synchronized (hashtable) {
            tempGoalStep = (JointGoalStep)this.currentEntryNegotiators.get(uniqueEntryNegotiationID);
            if (tempGoalStep == null) {
                tempGoalStep = this.debugLevel == 0 ? this.getInitiatedJointGoalStep(this.getRootCollectionBehavior(), "_RefuseEntryDummy()", teamMembers, null, false) : this.getInitiatedJointGoalStepDebug(this.getRootCollectionBehavior(), "_RefuseEntryDummy()", teamMembers, null, false);
                this.currentEntryNegotiators.put(uniqueEntryNegotiationID, tempGoalStep);
            }
        }
        final JointGoalStep escroedGoalStep = tempGoalStep;
        JointGoalNegotiationThread intentionToRefuseEntryThread = new JointGoalNegotiationThread(escroedGoalStep.negotiator, escroedGoalStep + " queueIntentionToRefuseEntry"){

            @Override
            public void run() {
                entity.set(BehavingEntity.this);
                escroedGoalStep.negotiator.processIntentionToRefuseEntry(uniqueEntryNegotiationID, sender);
            }
        };
        this.registerNegotiationThread(intentionToRefuseEntryThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateEntryNegotiation(Long uniqueEntryNegotiationID) {
        Hashtable hashtable = this.currentEntryNegotiators;
        synchronized (hashtable) {
            assert (this.currentEntryNegotiators.get(uniqueEntryNegotiationID) != null);
            this.currentEntryNegotiators.remove(uniqueEntryNegotiationID);
        }
    }

    public void queueIntentionToExit(final BehavingEntity sender, final JointGoalStep g, final int intention) {
        this.registerNegotiationThread(new JointGoalNegotiationThread(g.negotiator, g + " queueIntentionToExit(" + JointGoalNegotiator.formatIntention(intention) + ")"){

            @Override
            public void run() {
                if (g.negotiator != null) {
                    entity.set(BehavingEntity.this);
                    switch (intention) {
                        case 19: {
                            g.negotiator.processIntentionToSucceed(sender);
                            break;
                        }
                        case 20: {
                            g.negotiator.processIntentionToFail(sender);
                            break;
                        }
                        case 21: {
                            g.negotiator.processIntentionToRemove(sender);
                            break;
                        }
                        case 22: {
                            g.negotiator.processIntentionToSuspend(sender);
                            break;
                        }
                        case 23: {
                            g.negotiator.processIntentionToUnsuspend(sender);
                            break;
                        }
                        default: {
                            throw new AblRuntimeError("Unexpected intention");
                        }
                    }
                }
            }
        });
    }

    private InitiatedJointGoalStep getInitiatedJointGoalStep(CollectionBehavior abtRoot, String signature, Set teamMembers, Object[] args, boolean teamNeededForSuccess) {
        return new InitiatedJointGoalStep(abtRoot, signature, teamMembers, args, teamNeededForSuccess);
    }

    private InitiatedJointGoalStep getInitiatedJointGoalStepDebug(CollectionBehavior abtRoot, String signature, Set teamMembers, Object[] args, boolean teamNeededForSuccess) {
        return new InitiatedJointGoalStepDebug(abtRoot, signature, teamMembers, args, teamNeededForSuccess, this.debugLevel);
    }

    void traceAblExecutionEvent(int type, Step source, Object obj, int nestLevel, int behaviorID) {
        this.debuggerGUI.traceAblExecutionEvent(type, source, obj, nestLevel, behaviorID);
    }

    void traceAblExecutionEvent(int type, __BehaviorDesc source, Object obj, int nestLevel, int behaviorID) {
        this.debuggerGUI.traceAblExecutionEvent(type, source, obj, nestLevel, behaviorID);
    }

    void printLeafSteps() {
        Iterator iter = this.leafSteps.iterator();
        System.err.println("Leaf steps for " + this.getBehavingEntityShortName());
        while (iter.hasNext()) {
            System.err.println("    " + iter.next());
        }
    }

    void printExecutingSteps() {
        Iterator iter = this.executingSteps.keySet().iterator();
        System.err.println("Executing steps for " + this.getBehavingEntityShortName());
        while (iter.hasNext()) {
            System.err.println("    " + iter.next());
        }
    }

    void printAtomicSteps() {
        Iterator iter = this.atomicSteps.iterator();
        System.err.println("Atomic steps for " + this.getBehavingEntityShortName());
        while (iter.hasNext()) {
            System.err.println("    " + iter.next());
        }
    }

    static final void printABTBranchUpwards(Step s) {
        while (s != null) {
            System.err.println(s);
            Behavior b = s.getParent();
            System.err.println(b);
            s = b.getParent();
        }
    }

    static final void printABTBranchUpwards(Behavior b) {
        if (b != null) {
            System.err.println(b);
            GoalStep s = b.getParent();
            while (s != null) {
                System.err.println(s);
                b = s.getParent();
                System.err.println(b);
                s = b.getParent();
            }
        }
    }

    public Debugger getDebuggerGUI() {
        return this.debuggerGUI;
    }

    private class ActiveContinuousSensors {
        private LinkedList activeSensors = new LinkedList();

        private ActiveContinuousSensors() {
        }

        synchronized void activateSensor(SensorActivation s) {
            ListIterator iter = this.activeSensors.listIterator();
            while (iter.hasNext()) {
                SensorActivation currentSensor = (SensorActivation)iter.next();
                if (!s.equals(currentSensor)) continue;
                ++currentSensor.referenceCount;
                return;
            }
            this.activeSensors.add(s);
            s.activeSensor.initializeContinuous(s.arguments);
            this.notify();
        }

        synchronized void activateSensors(SensorActivation[] activations) {
            if (activations != null) {
                int i = 0;
                while (i < activations.length) {
                    this.activateSensor(activations[i]);
                    ++i;
                }
            }
        }

        synchronized void deactivateSensor(SensorActivation s) {
            ListIterator iter = this.activeSensors.listIterator();
            while (iter.hasNext()) {
                SensorActivation currentSensor = (SensorActivation)iter.next();
                if (!s.equals(currentSensor)) continue;
                if (currentSensor.referenceCount == 1) {
                    iter.remove();
                } else {
                    --currentSensor.referenceCount;
                }
                return;
            }
        }

        synchronized void deactivateSensors(SensorActivation[] activations) {
            if (activations != null) {
                int i = 0;
                while (i < activations.length) {
                    this.deactivateSensor(activations[i]);
                    ++i;
                }
            }
        }

        synchronized void sense() {
            if (!this.activeSensors.isEmpty()) {
                BehavingEntity.this.runSensors(this.activeSensors, true);
                BehavingEntity.this.senseMonitor.setSensedConditionsReadyToRun(true);
            } else if (BehavingEntity.this.asynchronousSenseCycle) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeError("Sense cycle interrupted");
                }
            }
        }
    }

    protected class BehaviorLibrary {
        Hashtable behaviorNames;
        Hashtable behaviors;

        public BehaviorLibrary(int initialSize) {
            this.behaviors = new Hashtable(initialSize);
        }

        public synchronized void registerBehavior(__BehaviorDesc behDesc) {
            String[] stringArray = behDesc.signatures;
            int n = behDesc.signatures.length;
            int n2 = 0;
            while (n2 < n) {
                String sig = stringArray[n2];
                Vector<__BehaviorDesc> behaviorDescList = (Vector<__BehaviorDesc>)this.behaviors.get(sig);
                if (behaviorDescList == null) {
                    behaviorDescList = new Vector<__BehaviorDesc>();
                    behaviorDescList.add(behDesc);
                    if (BehavingEntity.this.debugLevel == 2 && sig.equals(behDesc.signature)) {
                        behDesc.uniqueName = String.valueOf(behDesc.signature.substring(0, behDesc.signature.indexOf(40))) + "_1";
                    }
                    this.behaviors.put(sig, behaviorDescList);
                } else {
                    behaviorDescList.add(behDesc);
                    if (BehavingEntity.this.debugLevel == 2 && sig.equals(behDesc.signature)) {
                        behDesc.uniqueName = String.valueOf(behDesc.signature.substring(0, behDesc.signature.indexOf(40))) + "_" + behaviorDescList.size();
                    }
                }
                ++n2;
            }
        }

        public synchronized List lookupBehavior(String signature) {
            List behaviorDescList = (List)this.behaviors.get(signature);
            if (behaviorDescList == null) {
                return new Vector(0);
            }
            return new ArrayList(behaviorDescList);
        }

        private synchronized Set getRegisteredBehaviors() {
            return new HashSet(this.behaviors.keySet());
        }
    }

    private class SensedConditionMonitor {
        private boolean ready = false;

        private SensedConditionMonitor() {
        }

        synchronized boolean sensedConditionsReadyToRun() {
            boolean readyTemp = this.ready;
            this.ready = false;
            return readyTemp;
        }

        synchronized void setSensedConditionsReadyToRun(boolean b) {
            this.ready = b;
        }
    }

    class ShutdownHook
    extends Thread {
        public String shutdownMessage;

        ShutdownHook() {
        }

        @Override
        public void run() {
            System.err.println(this.shutdownMessage);
            BehavingEntity.this.printNegotiationThreads();
            System.err.flush();
        }
    }
}

