/*
 * Decompiled with CFR 0.152.
 */
package abl.runtime;

import abl.runtime.AblRuntimeError;
import abl.runtime.BehavingEntity;
import abl.runtime.ExecutePolicyStep;
import abl.runtime.GoalStep;
import abl.runtime.MultiStepBehavior;
import abl.runtime.SensorActivation;
import abl.runtime.Step;
import abl.runtime.__StepDesc;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;

public class AdaptiveBehavior
extends MultiStepBehavior {
    protected static final short behaviorType = 3;
    private final short adaptiveBehaviorType;
    private final Method reinforcementSignal;
    private final Method reinforcementSignalSensorFactory;
    private final Method stateWME;
    private final Method stateWMESensorFactory;
    private final Method rlPolicy;
    static Object oldStateWMEList;
    static int prevAction;

    public AdaptiveBehavior(GoalStep arg_parent, Method arg_contextCondition, Method arg_contextConditionSensorFactory, Method arg_successCondition, Method arg_successConditionSensorFactory, Method arg_reinforcementSignal, Method arg_reinforcementSignalSensorFactory, Method arg_stateWME, Method arg_stateWMESensorFactory, Method arg_rlPolicy, boolean arg_isAtomic, String arg_signature, short arg_specificity, int arg_behaviorID, Object[] arg_behaviorVariableFrame, __StepDesc[] arg_stepDescs, short arg_adaptiveBehaviorType) {
        super(arg_parent, arg_contextCondition, arg_contextConditionSensorFactory, arg_successCondition, arg_successConditionSensorFactory, arg_isAtomic, arg_signature, arg_specificity, arg_behaviorID, arg_behaviorVariableFrame, arg_stepDescs, -1);
        this.reinforcementSignal = arg_reinforcementSignal;
        this.reinforcementSignalSensorFactory = arg_reinforcementSignalSensorFactory;
        this.stateWME = arg_stateWME;
        this.stateWMESensorFactory = arg_stateWMESensorFactory;
        this.rlPolicy = arg_rlPolicy;
        this.adaptiveBehaviorType = arg_adaptiveBehaviorType;
    }

    @Override
    final int getNumberNeededForSuccess() {
        throw new AblRuntimeError("numberNeededForSuccess is meaningless for AdaptiveBehaviors");
    }

    private boolean childrenConsistencyTest() {
        return true;
    }

    @Override
    protected final void removeChildren() {
        assert (this.childrenConsistencyTest());
        super.removeChildren();
    }

    @Override
    final void addChild(Step s) {
        this.children.add(s);
        BehavingEntity.getBehavingEntity().addStep(s);
        this.changes.firePropertyChange("child", null, s);
    }

    @Override
    final void addChildren() {
        assert (this.children.size() == 0);
        this.addChild(new ExecutePolicyStep(this));
    }

    @Override
    protected final void removeChild(Step child, boolean isCallerChild) {
        assert (this.children.contains(child)) : "child == " + child + " current children == " + this.children;
        assert (this.childrenConsistencyTest());
        super.removeChild(child, isCallerChild);
        this.children.remove(child);
        this.clearLastPursuedGoal();
    }

    @Override
    protected final Step[] getAllSteps() {
        throw new AblRuntimeError("Don't call getAllSteps() on AdaptiveBehaviors");
    }

    @Override
    final boolean isSuccessful() {
        return false;
    }

    @Override
    public String toString() {
        try {
            String behaviorTypeString;
            switch (this.getAdaptiveBehaviorType()) {
                case 0: {
                    behaviorTypeString = "adaptive sequential";
                    break;
                }
                case 1: {
                    behaviorTypeString = "adaptive parallel";
                    break;
                }
                case 2: {
                    throw new AblRuntimeError("Adaptive collection behaviors currently not supported");
                }
                default: {
                    behaviorTypeString = "UNEXPECTED BEHAVIOR TYPE";
                }
            }
            return String.valueOf(behaviorTypeString) + " " + this.getSignature() + " priority: " + this.getPriority();
        }
        catch (Exception e) {
            throw new AblRuntimeError("Reflection error in SequentialBehavior.toString()");
        }
    }

    @Override
    final boolean currentLineOfExpansion(GoalStep currentGoal) {
        assert (this.parent != null) : "AdaptiveBehavior found at the root of the ABT " + this;
        return super.currentLineOfExpansion(currentGoal);
    }

    void executePolicy() {
        try {
            int stepIndex;
            ArrayList<SensorActivation> sensors = new ArrayList<SensorActivation>();
            SensorActivation[] stateWMEActivations = this.getStateWMESensorActivations();
            if (stateWMEActivations != null) {
                int activationCounter = 0;
                while (activationCounter < stateWMEActivations.length) {
                    sensors.add(stateWMEActivations[activationCounter]);
                    ++activationCounter;
                }
                BehavingEntity.getBehavingEntity().runSensors(new ArrayList(sensors), false);
            }
            Object[] args = new Object[]{new Integer(this.behaviorID), this.behaviorVariableFrame, BehavingEntity.getBehavingEntity()};
            oldStateWMEList = this.stateWME.invoke(null, args);
            Object[] objectArray = new Object[6];
            objectArray[0] = new Integer(this.behaviorID);
            objectArray[1] = oldStateWMEList;
            objectArray[2] = new Integer(0);
            objectArray[4] = new Double(0.0);
            objectArray[5] = new Boolean(false);
            Object[] args2 = objectArray;
            prevAction = stepIndex = ((Integer)this.rlPolicy.invoke(null, args2)).intValue();
            Object[] factoryArgs = new Object[]{new Integer(this.stepDescs[stepIndex].stepID), this, this.getBehaviorVariableFrame()};
            Step selectedStep = (Step)this.stepDescs[stepIndex].factory.invoke(null, factoryArgs);
            this.addChild(selectedStep);
            selectedStep.execute();
        }
        catch (Exception e) {
            throw new AblRuntimeError("Error invoking executePolicy", e);
        }
    }

    void updatePolicy() {
        try {
            SensorActivation[] stateWMEActivations;
            HashSet<SensorActivation> sensors = new HashSet<SensorActivation>();
            SensorActivation[] reinforcementActivations = this.getReinforcementSignalSensorActivations();
            if (reinforcementActivations != null) {
                int activationCounter = 0;
                while (activationCounter < reinforcementActivations.length) {
                    sensors.add(reinforcementActivations[activationCounter]);
                    ++activationCounter;
                }
            }
            if ((stateWMEActivations = this.getStateWMESensorActivations()) != null) {
                int activationCounter = 0;
                while (activationCounter < stateWMEActivations.length) {
                    sensors.add(stateWMEActivations[activationCounter]);
                    ++activationCounter;
                }
            }
            BehavingEntity.getBehavingEntity().runSensors(new ArrayList(sensors), false);
            Object[] args = new Object[]{new Integer(this.behaviorID), this.behaviorVariableFrame, BehavingEntity.getBehavingEntity()};
            Object newStateWMEList = this.stateWME.invoke(null, args);
            Object[] args2 = new Object[]{new Integer(this.behaviorID), this.behaviorVariableFrame, BehavingEntity.getBehavingEntity()};
            double reward = (Double)this.reinforcementSignal.invoke(null, args2);
            Object[] args3 = new Object[]{new Integer(this.behaviorID), oldStateWMEList, new Integer(prevAction), newStateWMEList, new Double(reward), new Boolean(true)};
            int ingored = (Integer)this.rlPolicy.invoke(null, args3);
        }
        catch (Exception e) {
            throw new AblRuntimeError("Error invoking updatePolicy", e);
        }
    }

    final float reinforcementSignal() {
        assert (this.reinforcementSignal != null);
        Object[] args = new Object[]{new Integer(this.behaviorID), this.behaviorVariableFrame, BehavingEntity.getBehavingEntity()};
        try {
            Float f = (Float)this.reinforcementSignal.invoke(null, args);
            return f.floatValue();
        }
        catch (Exception e) {
            throw new AblRuntimeError("Error invoking reinforcement signal function", e);
        }
    }

    final SensorActivation[] getReinforcementSignalSensorActivations() {
        if (this.reinforcementSignalSensorFactory == null) {
            return null;
        }
        Object[] args = new Object[]{new Integer(this.behaviorID)};
        try {
            return (SensorActivation[])this.reinforcementSignalSensorFactory.invoke(null, args);
        }
        catch (Exception e) {
            throw new AblRuntimeError("Error invoking reinforcement signal sensor factory", e);
        }
    }

    final SensorActivation[] getStateWMESensorActivations() {
        if (this.stateWMESensorFactory == null) {
            return null;
        }
        Object[] args = new Object[]{new Integer(this.behaviorID)};
        try {
            return (SensorActivation[])this.stateWMESensorFactory.invoke(null, args);
        }
        catch (Exception e) {
            throw new AblRuntimeError("Error invoking stateWME sensor factory", e);
        }
    }

    @Override
    public short getBehaviorType() {
        return 3;
    }

    public short getAdaptiveBehaviorType() {
        return this.adaptiveBehaviorType;
    }
}

