/*
 * Decompiled with CFR 0.152.
 */
package abl.compiler.astchecks;

import abl.compiler.ASTAblExpression;
import abl.compiler.ASTBehaviorUnit;
import abl.compiler.ASTGoalStep;
import abl.compiler.CompileException;
import abl.compiler.Node;
import abl.compiler.astchecks.IdentityASTVisitor;
import abl.compiler.util.StringUtil;
import fun.Fun;
import java.io.File;

public class TypeCheckVisitor
extends IdentityASTVisitor {
    public static final String DEFAULT_FILE_EXT = ".abl";
    private ASTBehaviorUnit unit = null;
    private final String origFilename;

    public TypeCheckVisitor(ASTBehaviorUnit unit, String origFilename) {
        this.unit = unit;
        this.origFilename = origFilename;
    }

    @Override
    public Node visit(ASTBehaviorUnit a) throws CompileException {
        this.filenameEqualsBehaviorUnitName(a.getBehavingEntityClass());
        return super.visit(a);
    }

    @Override
    public Node visit(ASTGoalStep a) throws CompileException {
        return super.visit(a);
    }

    public void filenameEqualsBehaviorUnitName(String behUnitName) throws CompileException {
        File f = new File(this.origFilename);
        String targetName = StringUtil.chopSuffix(f.getName(), DEFAULT_FILE_EXT);
        if (!targetName.equals(behUnitName)) {
            throw new CompileException("Behavior unit (" + behUnitName + ") must have " + "same name as file (" + targetName + ")");
        }
    }

    class ExpType
    extends Fun<ASTAblExpression, String> {
        ExpType() {
        }

        @Override
        public String apply(ASTAblExpression input) {
            try {
                assert (TypeCheckVisitor.this.unit != null);
                return input.getType(TypeCheckVisitor.this.unit);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

