/*
 * Decompiled with CFR 0.152.
 */
package abl.compiler.astchecks;

import abl.compiler.ASTBehaviorDefinition;
import abl.compiler.ASTBehaviorUnit;
import abl.compiler.ASTJavaStatement;
import abl.compiler.ASTMentalStep;
import abl.compiler.AblParseNode;
import abl.compiler.AblParserConstants;
import abl.compiler.AblParserTreeConstants;
import abl.compiler.CompileException;
import abl.compiler.Node;
import abl.compiler.astchecks.IdentityASTVisitor;

public class SanityCheckVisitor
extends IdentityASTVisitor
implements AblParserTreeConstants,
AblParserConstants {
    private final ASTBehaviorUnit unit;

    public SanityCheckVisitor(ASTBehaviorUnit unit) {
        this.unit = unit;
    }

    @Override
    public Node visit(ASTBehaviorDefinition a) throws CompileException {
        this.behaviorDefinitionNonEmpty(a);
        return super.visit(a);
    }

    @Override
    public Node visit(ASTMentalStep a) throws CompileException {
        this.mentalActHasNoEscape(a);
        return super.visit(a);
    }

    void behaviorDefinitionNonEmpty(ASTBehaviorDefinition node) throws CompileException {
        String behaviorName;
        String string = behaviorName = node.isInitialTree() ? "initial_tree" : node.getBehaviorName();
        if (node.jjtGetNumChildren() == 0) {
            throw new CompileException(node.getFirstLineNumber(), (Object)((Object)Messages.EMPTY_STEPS) + " " + behaviorName + ".");
        }
    }

    void mentalActHasNoEscape(ASTMentalStep node) throws CompileException {
        int i = 0;
        while (i < node.jjtGetNumChildren()) {
            AblParseNode child = (AblParseNode)node.jjtGetChild(i);
            switch (child.getId()) {
                case 29: {
                    ASTJavaStatement stmt = (ASTJavaStatement)child;
                    if (stmt.firstToken.kind != 49 && stmt.firstToken.kind != 56 && stmt.firstToken.kind != 16) break;
                    throw new CompileException(stmt.getFirstLineNumber(), String.valueOf(tokenImage[stmt.firstToken.kind]) + " not allowed " + " at toplevel in mental acts.");
                }
            }
            ++i;
        }
    }

    public static enum Messages {
        EMPTY_STEPS("No steps defined within behavior");

        private final String msg;

        private Messages(String msg) {
            this.msg = msg;
        }

        public String toString() {
            return this.msg;
        }
    }
}

