/*
 * Decompiled with CFR 0.152.
 */
package abl.compiler;

import abl.compiler.ASTAblExpression;
import abl.compiler.ASTBehaviorDefinition;
import abl.compiler.ASTBehaviorUnit;
import abl.compiler.ASTTestExpression;
import abl.compiler.AblParseNode;
import abl.compiler.AblParser;
import abl.compiler.AblScopeMaintainer;
import abl.compiler.CompileError;
import abl.compiler.CompileException;
import java.util.Enumeration;
import java.util.Hashtable;
import jd.CodeBlockDescriptor;
import jd.CodeSequenceDescriptor;
import jd.CodeStringDescriptor;

abstract class GenericStep
extends AblParseNode {
    boolean hasSuccessTest = false;
    int priority = Short.MIN_VALUE;
    int priorityModifier = 0;
    boolean persistent = false;
    boolean persistentWhenSucceeds = false;
    boolean persistentWhenFails = false;
    boolean effectOnly = false;
    boolean teamEffectOnly = false;
    boolean ignoreFailure = false;
    private boolean post = false;
    private String postMemory = null;
    protected String stepClassName;
    private String stepName;
    private final Hashtable<String, ASTAblExpression> propertyTable;
    private String stepFactoryMethod_rField;
    private String executeMethod_rField;
    private String successTestMethod_rField;
    private String successTestSensorFactoryMethod_rField;
    protected int stepID = Integer.MIN_VALUE;

    GenericStep(int id) {
        super(id);
        this.propertyTable = new Hashtable();
    }

    GenericStep(AblParser p, int id) {
        super(p, id);
        this.propertyTable = new Hashtable();
    }

    GenericStep(int id, GenericStep g) {
        super(id);
        this.hasSuccessTest = g.hasSuccessTest;
        this.priority = g.priority;
        this.priorityModifier = g.priorityModifier;
        this.persistent = g.persistent;
        this.persistentWhenSucceeds = g.persistentWhenSucceeds;
        this.persistentWhenFails = g.persistentWhenFails;
        this.effectOnly = g.effectOnly;
        this.teamEffectOnly = g.teamEffectOnly;
        this.ignoreFailure = g.ignoreFailure;
        this.post = g.post;
        this.postMemory = g.postMemory;
        this.propertyTable = new Hashtable<String, ASTAblExpression>(g.propertyTable);
    }

    int getStepID() {
        return this.stepID;
    }

    @Override
    AblScopeMaintainer getEnclosingBehaviorScope() {
        return ((ASTBehaviorDefinition)this.jjtGetParent()).getEnclosingBehaviorScope();
    }

    String getUniqueName() {
        return this.stepName;
    }

    boolean getPost() {
        return this.post;
    }

    void setPost(boolean post) {
        this.post = post;
    }

    String getPostMemory() {
        return new String(this.postMemory);
    }

    void setPostMemory(String postMemory) {
        postMemory = new String(postMemory);
    }

    void setStepFactoryMethod_rField(String arg_stepFactoryMethod_rField) {
        if (this.stepFactoryMethod_rField != null) {
            throw new CompileError("Attempt to set stepFactoryMethod_rField multiple times: " + this.stepFactoryMethod_rField);
        }
        this.stepFactoryMethod_rField = arg_stepFactoryMethod_rField;
    }

    void setExecuteMethod_rField(String arg_executeMethod_rField) {
        if (this.executeMethod_rField != null) {
            throw new CompileError("Attempt to set executeMethod_rField multiple times: " + this.executeMethod_rField);
        }
        this.executeMethod_rField = arg_executeMethod_rField;
    }

    void setSuccessTestMethod_rField(String arg_successTestMethod_rField) {
        if (this.successTestMethod_rField != null) {
            throw new CompileError("Attempt to set successTestMethod_rField multiple times: " + this.successTestMethod_rField);
        }
        this.successTestMethod_rField = arg_successTestMethod_rField;
    }

    void setSuccessTestSensorFactoryMethod_rField(String arg_successTestSensorFactoryMethod_rField) {
        if (this.successTestSensorFactoryMethod_rField != null) {
            throw new CompileError("Attempt to set successTestSensorFactoryMethod_rField multiple times: " + this.successTestSensorFactoryMethod_rField);
        }
        this.successTestSensorFactoryMethod_rField = arg_successTestSensorFactoryMethod_rField;
    }

    String getStepFactoryMethod_rField() {
        return this.stepFactoryMethod_rField;
    }

    String getExecuteMethod_rField() {
        return this.executeMethod_rField;
    }

    String getSuccessTestMethod_rField() {
        return this.successTestMethod_rField;
    }

    String getSuccessTestSensorFactoryMethod_rField() {
        return this.successTestSensorFactoryMethod_rField;
    }

    protected String standardConstructorArguments() throws CompileException {
        assert (this.stepID != Integer.MIN_VALUE);
        if (!((ASTBehaviorDefinition)this.jjtGetParent()).isJoint() && this.teamEffectOnly) {
            throw new CompileException(this.getFirstLineNumber(), "a step of a non-joint behavior was annotated with team_effect_only");
        }
        if (this.effectOnly && this.teamEffectOnly) {
            throw new CompileException(this.getFirstLineNumber(), "a step can't be annotated as both effect_only and team_effect_only");
        }
        String execute = null;
        if (this.executeMethod_rField != null) {
            execute = this.getBehavingEntityField(this.executeMethod_rField);
        }
        String successTest = null;
        if (this.successTestMethod_rField != null) {
            successTest = this.getBehavingEntityField(this.successTestMethod_rField);
        }
        String successTestSensorFactory = null;
        if (this.successTestSensorFactoryMethod_rField != null) {
            successTestSensorFactory = this.getBehavingEntityField(this.successTestSensorFactoryMethod_rField);
        }
        StringBuffer argString = new StringBuffer(500);
        argString.append(String.valueOf(this.stepID) + ", __$behaviorParent, " + this.persistent + ", " + this.persistentWhenSucceeds + ", " + this.persistentWhenFails + ", " + this.ignoreFailure + ", " + this.effectOnly + ", " + this.teamEffectOnly + ", " + "(short)" + this.priority + ", " + "(short)" + this.priorityModifier + ", " + this.post + ", ");
        if (this.postMemory != null) {
            argString.append("\"" + this.postMemory + "\"" + ", ");
        } else {
            argString.append("null, ");
        }
        argString.append(String.valueOf(execute) + ", " + successTest + ", " + successTestSensorFactory + ", ");
        if (this.hasProperties()) {
            argString.append("__$propertyTable");
        } else {
            argString.append("null");
        }
        return argString.toString();
    }

    protected CodeSequenceDescriptor compilePropertyTable() throws CompileException {
        Enumeration<String> propertyNames = this.propertyTable.keys();
        ASTBehaviorDefinition behaviorScope = (ASTBehaviorDefinition)this.getEnclosingBehaviorScope();
        CodeSequenceDescriptor createPropTableBlock = new CodeSequenceDescriptor();
        if (!propertyNames.hasMoreElements()) {
            return null;
        }
        createPropTableBlock.addToSequence(new CodeStringDescriptor("final AblNamedPropertySupport __$propertyTable = new AblNamedPropertySupport();"));
        while (propertyNames.hasMoreElements()) {
            String propertyName = propertyNames.nextElement();
            String declaredTypeName = ASTBehaviorUnit.getBehaviorUnit().lookupDeclaredProperty(propertyName);
            if (declaredTypeName == null) {
                throw new CompileException(this.getFirstLineNumber(), "Property " + propertyName + " has not been declared");
            }
            ASTAblExpression property = this.propertyTable.get(propertyName);
            if (!declaredTypeName.equals(property.getType(behaviorScope))) {
                throw new CompileException(this.getFirstLineNumber(), "The type of " + property.dumpTokens() + " does not match the declared type of property " + propertyName);
            }
            String propertyValueAsObject = property.getVariableReferenceConstantOrLiteralAsObject(behaviorScope);
            createPropTableBlock.addToSequence(new CodeStringDescriptor("__$propertyTable.setProperty(\"" + propertyName + "\", " + propertyValueAsObject + ");"));
        }
        return createPropTableBlock;
    }

    protected void compileSuccessTest() throws CompileException {
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode n = (AblParseNode)this.jjtGetChild(i);
            if (n.id == 8) {
                ((ASTTestExpression)n).compileToJava();
                CodeBlockDescriptor successTestSensorFactory = ((ASTTestExpression)n).compileSensorActivationFactory();
                if (successTestSensorFactory == null) break;
                CodeBlockDescriptor factorySwitchCase = new CodeBlockDescriptor("case " + this.stepID + ": {", "}");
                factorySwitchCase.addToBlockBody(successTestSensorFactory);
                ASTBehaviorUnit.getBehaviorUnit().writeSuccessTestSensorActivation(factorySwitchCase, this);
                break;
            }
            ++i;
        }
    }

    void setProperty(String name, ASTAblExpression value) throws CompileException {
        ASTAblExpression oldProp = this.propertyTable.get(name);
        if (oldProp != null) {
            throw new CompileException("Duplicate named step property: " + name);
        }
        this.propertyTable.put(name, value);
    }

    protected boolean hasProperties() {
        return !this.propertyTable.isEmpty();
    }

    protected void initStep(int stepType) {
        ASTBehaviorDefinition behaviorParent = (ASTBehaviorDefinition)this.jjtGetParent();
        ASTBehaviorUnit behaviorUnitNode = ASTBehaviorUnit.getBehaviorUnit();
        this.stepName = String.valueOf(behaviorParent.getUniqueName()) + "Step" + behaviorParent.incrementStepCount();
        switch (stepType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                this.stepID = behaviorUnitNode.getUniqueStepID();
                break;
            }
            default: {
                this.stepID = behaviorUnitNode.getSpecialStepID(stepType);
            }
        }
        if (!this.effectOnly && !this.teamEffectOnly) {
            behaviorParent.incrementNonEffectOnlySteps();
        }
    }

    abstract void compileToJava() throws CompileException;

    protected boolean hasModifiers() {
        return this.hasSuccessTest || this.priority != Short.MIN_VALUE || this.priorityModifier != 0 || this.persistent || this.persistentWhenSucceeds || this.persistentWhenFails || this.effectOnly || this.teamEffectOnly || this.ignoreFailure || this.post || this.hasProperties();
    }
}

