/*
 * Decompiled with CFR 0.152.
 */
package abl.compiler;

import abl.compiler.ASTAblExpression;
import abl.compiler.ASTBehaviorDefinition;
import abl.compiler.ASTBehaviorUnit;
import abl.compiler.ASTJavaName;
import abl.compiler.AblArgument;
import abl.compiler.AblParser;
import abl.compiler.CompileException;
import abl.compiler.GenericStep;
import abl.compiler.ScopeException;
import java.util.ArrayList;
import java.util.List;

abstract class ArgumentStep
extends GenericStep {
    protected List<ASTAblExpression> argList = new ArrayList<ASTAblExpression>(50);

    ArgumentStep(int id) {
        super(id);
    }

    ArgumentStep(AblParser p, int id) {
        super(p, id);
    }

    ArgumentStep(int id, GenericStep g) {
        super(id, g);
    }

    void addArgument(ASTAblExpression arg) {
        this.argList.add(arg);
    }

    protected String compileConflictArray(String executableStepName) {
        String[] conflictSet = ASTBehaviorUnit.getBehaviorUnit().lookupConflict(executableStepName);
        if (conflictSet != null) {
            return ASTBehaviorUnit.getBehaviorUnit().addConflictSet(conflictSet);
        }
        return null;
    }

    protected List<AblArgument> processArgs() throws CompileException {
        ArrayList<AblArgument> processedArgs = new ArrayList<AblArgument>(this.argList.size());
        for (ASTAblExpression arg : this.argList) {
            if (arg.isIdentifier()) {
                ASTJavaName javaName = arg.getRef();
                ASTBehaviorDefinition behaviorParent = (ASTBehaviorDefinition)this.jjtGetParent();
                try {
                    String scopeReference = javaName.getVariableReference(behaviorParent);
                    String argType = javaName.lookupFieldType(behaviorParent);
                    if (argType.equals("java.lang.String")) {
                        argType = "String";
                    }
                    processedArgs.add(new AblArgument(scopeReference, argType, true));
                    continue;
                }
                catch (ScopeException e) {
                    Object value = javaName.getConstantValue();
                    String constantType = value.getClass().getName();
                    if (constantType.equals("java.lang.Integer")) {
                        processedArgs.add(new AblArgument((Integer)value, "int"));
                        continue;
                    }
                    if (constantType.equals("java.lang.Float")) {
                        processedArgs.add(new AblArgument((Float)value, "float"));
                        continue;
                    }
                    if (constantType.equals("java.lang.Double")) {
                        processedArgs.add(new AblArgument((Double)value, "double"));
                        continue;
                    }
                    if (constantType.equals("java.lang.Character")) {
                        processedArgs.add(new AblArgument((Character)value, "char"));
                        continue;
                    }
                    if (constantType.equals("java.lang.String")) {
                        processedArgs.add(new AblArgument((String)value, "String"));
                        continue;
                    }
                    if (constantType.equals("java.lang.Boolean")) {
                        processedArgs.add(new AblArgument((Boolean)value, "boolean"));
                        continue;
                    }
                    throw new CompileException("Constant " + javaName.dumpTokens() + " of type " + constantType + " referenced in primitive step " + this.dumpTokens(1, this.numberOfTokens()) + " has an unrecognized type.");
                }
            }
            Object value = arg.getLiteralValue();
            String literalType = null;
            if (value == null) {
                processedArgs.add(new AblArgument(null, "null"));
                continue;
            }
            if (value == null) continue;
            literalType = value.getClass().getName();
            if (literalType.equals("java.lang.Integer")) {
                processedArgs.add(new AblArgument((Integer)value, "int"));
                continue;
            }
            if (literalType.equals("java.lang.Float")) {
                processedArgs.add(new AblArgument((Float)value, "float"));
                continue;
            }
            if (literalType.equals("java.lang.Double")) {
                processedArgs.add(new AblArgument((Double)value, "double"));
                continue;
            }
            if (literalType.equals("java.lang.Character")) {
                processedArgs.add(new AblArgument((Character)value, "char"));
                continue;
            }
            if (literalType.equals("java.lang.String")) {
                processedArgs.add(new AblArgument((String)value, "String"));
                continue;
            }
            if (literalType.equals("java.lang.Boolean")) {
                processedArgs.add(new AblArgument((Boolean)value, "boolean"));
                continue;
            }
            throw new CompileException("Literal " + arg.dumpTokens() + " of type " + literalType + " referenced in primitive step " + this.dumpTokens(1, this.numberOfTokens()) + " has an unrecognized type.");
        }
        return processedArgs;
    }

    public List<ASTAblExpression> getArgList() {
        return this.argList;
    }
}

