/*
 * Decompiled with CFR 0.152.
 */
package abl.compiler;

import abl.compiler.ASTAblVariableDecl;
import abl.compiler.AblParseNode;
import abl.compiler.AblParser;
import abl.compiler.CompileError;
import abl.compiler.CompileException;
import abl.compiler.ScopeException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import jd.FieldDescriptor;

class AblScopeMaintainer
extends AblParseNode {
    protected Hashtable<String, Object[]> variableDecl = new Hashtable();
    protected List<FieldDescriptor> fieldDescriptors = new ArrayList<FieldDescriptor>();
    protected AblScopeMaintainer scopeParent = null;
    protected String scopeName;
    private int scopeType = -1;
    boolean isNestedScope = false;
    static final int NO_SCOPE = -1;
    static final int GLOBAL_SCOPE = 0;
    static final int BEHAVIOR_SCOPE = 1;
    static final int METHOD_SCOPE = 2;

    AblScopeMaintainer(int id) {
        super(id);
    }

    AblScopeMaintainer(AblParser p, int id) {
        super(p, id);
    }

    void setScopeName(String scopeNameToSet) {
        this.scopeName = scopeNameToSet;
    }

    void setScopeParent(AblScopeMaintainer scopeParentToSet) {
        this.scopeParent = scopeParentToSet;
    }

    void setScopeType(int scopeTypeToSet) {
        if (scopeTypeToSet != 0 && scopeTypeToSet != 1 && scopeTypeToSet != 2) {
            throw new CompileError("Attempt to set illegal scope type " + scopeTypeToSet);
        }
        this.scopeType = scopeTypeToSet;
        if (scopeTypeToSet == 1) {
            this.scopeParent = (AblScopeMaintainer)this.jjtGetParent();
        }
    }

    int getScopeType() {
        return this.scopeType;
    }

    AblScopeMaintainer getEnclosingScope() {
        return this;
    }

    void addVariableDeclaration(FieldDescriptor field) {
        int fieldIndex = this.fieldDescriptors.size();
        this.fieldDescriptors.add(field);
        String[] fieldNames = field.getFieldNames();
        int j = 0;
        while (j < fieldNames.length) {
            if (this.variableDecl.get(fieldNames[j]) != null) {
                throw new CompileException("Variable " + fieldNames[j] + " multiply defined in scope " + this.scopeName);
            }
            Object[] variableEntry = new Object[]{field, new Integer(fieldIndex)};
            this.variableDecl.put(fieldNames[j], variableEntry);
            ++j;
        }
    }

    String lookupVariableType(String variableName) {
        if (this.variableDecl.containsKey(variableName)) {
            FieldDescriptor field = (FieldDescriptor)this.variableDecl.get(variableName)[0];
            return field.fieldType;
        }
        if (this.scopeParent != null) {
            return this.scopeParent.lookupVariableType(variableName);
        }
        return null;
    }

    int lookupVariableScope(String variableName) {
        if (this.variableDecl.containsKey(variableName)) {
            return this.scopeType;
        }
        if (this.scopeParent != null) {
            return this.scopeParent.lookupVariableScope(variableName);
        }
        return -1;
    }

    FieldDescriptor lookupVariable(String variableName) {
        if (this.variableDecl.containsKey(variableName)) {
            return (FieldDescriptor)this.variableDecl.get(variableName)[0];
        }
        if (this.scopeParent != null) {
            return this.scopeParent.lookupVariable(variableName);
        }
        return null;
    }

    List<FieldDescriptor> getDeclaredVariables() {
        return this.fieldDescriptors;
    }

    protected void addChildVariableDeclarations() throws CompileException {
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode n = (AblParseNode)this.jjtGetChild(i);
            if (n.id == 22) {
                if (this.isNestedScope) {
                    throw new CompileException(n.getFirstLineNumber(), "Attempt to declare a variable within an anonymous behavior. Currently this is not allowed. Future versions of ABL will lift this restriction");
                }
                FieldDescriptor[] fields = ((ASTAblVariableDecl)n).getFieldDescriptors();
                int x = 0;
                while (x < fields.length) {
                    this.addVariableDeclaration(fields[x]);
                    ++x;
                }
            }
            ++i;
        }
    }

    protected void addChildVariableDeclarationsWithReferenceRewrite() throws ScopeException, CompileException {
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode n = (AblParseNode)this.jjtGetChild(i);
            if (n.id == 22) {
                if (this.isNestedScope) {
                    throw new CompileException(n.getFirstLineNumber(), "Attempt to declare a variable within an anonymous behavior. Currently this is not allowed. Future versions of ABL will lift this restriction");
                }
                FieldDescriptor[] fields = ((ASTAblVariableDecl)n).getFieldDescriptors(this);
                int x = 0;
                while (x < fields.length) {
                    this.addVariableDeclaration(fields[x]);
                    ++x;
                }
            }
            ++i;
        }
    }

    List getExplicitlyDeclaredVariableFieldDescriptors() throws ScopeException {
        ArrayList<FieldDescriptor> fieldDescriptors = new ArrayList<FieldDescriptor>();
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode n = (AblParseNode)this.jjtGetChild(i);
            if (n.id == 22) {
                FieldDescriptor[] fields = ((ASTAblVariableDecl)n).getFieldDescriptors(this);
                int x = 0;
                while (x < fields.length) {
                    fieldDescriptors.add(fields[x]);
                    ++x;
                }
            }
            ++i;
        }
        return fieldDescriptors;
    }

    void initializeScope() {
        this.fieldDescriptors.clear();
        this.variableDecl.clear();
    }

    int getBehaviorFrameIndex(String varName) {
        assert (this.scopeType != 0);
        if (this.scopeType != 1) {
            return this.scopeParent.getBehaviorFrameIndex(varName);
        }
        if (!this.variableDecl.containsKey(varName)) {
            return this.scopeParent.getBehaviorFrameIndex(varName);
        }
        return (Integer)this.variableDecl.get(varName)[1];
    }

    int getBehaviorFrameDepth(String varName, int depthSoFar) {
        assert (this.scopeType != 0);
        if (this.scopeType != 1) {
            return this.scopeParent.getBehaviorFrameDepth(varName, depthSoFar);
        }
        if (!this.variableDecl.containsKey(varName)) {
            assert (this.isNestedScope);
            return this.scopeParent.getBehaviorFrameDepth(varName, depthSoFar + 1);
        }
        return depthSoFar;
    }
}

