/*
 * Decompiled with CFR 0.152.
 */
package abl.compiler;

import abl.compiler.ASTBehaviorUnit;
import abl.compiler.AblParser;
import abl.compiler.AblParserConstants;
import abl.compiler.AblParserTreeConstants;
import abl.compiler.AblScopeMaintainer;
import abl.compiler.CompileError;
import abl.compiler.SimpleNode;
import abl.compiler.Token;
import wm.WorkingMemory;

public abstract class AblParseNode
extends SimpleNode
implements AblParserConstants,
AblParserTreeConstants {
    public Token firstToken;
    public Token lastToken;

    public AblParseNode(int id) {
        super(id);
    }

    public AblParseNode(AblParser p, int id) {
        super(p, id);
    }

    public int getFirstLineNumber() {
        return this.firstToken.beginLine;
    }

    public int getLastLineNumber() {
        return this.lastToken.endLine;
    }

    public int getFirstColumn() {
        return this.firstToken.beginColumn;
    }

    public int getLastColumn() {
        return this.lastToken.endColumn;
    }

    public String prettyPrintTokens() {
        StringBuffer image = new StringBuffer();
        Token currentToken = this.firstToken;
        while (currentToken != this.lastToken) {
            if (!(currentToken.next.image.equals(";") || currentToken.next.image.equals(".") || currentToken.next.image.equals("(") || currentToken.next.image.equals(")") || currentToken.image.equals(".") || currentToken.image.equals("("))) {
                image.append(String.valueOf(currentToken.image) + " ");
            } else {
                image.append(currentToken.image);
            }
            currentToken = currentToken.next;
        }
        image.append(currentToken.image);
        return image.toString();
    }

    public String dumpTokens() {
        StringBuffer image = new StringBuffer();
        Token currentToken = this.firstToken;
        while (currentToken != this.lastToken) {
            image.append(currentToken.image);
            currentToken = currentToken.next;
        }
        image.append(currentToken.image);
        return image.toString();
    }

    public int numberOfTokens() {
        int tokenCount = 0;
        Token currentToken = this.firstToken;
        while (currentToken != this.lastToken) {
            ++tokenCount;
            currentToken = currentToken.next;
        }
        return ++tokenCount;
    }

    public String dumpTokens(int first, int last) {
        StringBuffer image = new StringBuffer();
        int tokenCounter = 0;
        assert (last <= this.numberOfTokens());
        assert (last >= 1);
        assert (first >= 0);
        assert (first < last);
        Token currentToken = this.firstToken;
        while (tokenCounter != first) {
            ++tokenCounter;
            currentToken = currentToken.next;
        }
        while (tokenCounter < last) {
            image.append(currentToken.image);
            currentToken = currentToken.next;
            ++tokenCounter;
        }
        return image.toString();
    }

    public static String uppercaseFirstCharacter(String s) {
        StringBuffer tempStringBuffer = new StringBuffer(s);
        tempStringBuffer.setCharAt(0, Character.toUpperCase(tempStringBuffer.charAt(0)));
        return tempStringBuffer.toString();
    }

    protected static String stripQuotes(String s) {
        return s.substring(1, s.length() - 1);
    }

    public static boolean primitiveType(String type) {
        return type.equals("int") || type.equals("float") || type.equals("char") || type.equals("boolean") || type.equals("long") || type.equals("short") || type.equals("byte") || type.equals("null") || type.equals("double");
    }

    /*
     * Unable to fully structure code
     */
    protected Class getClass(String className) throws ClassNotFoundException {
        try {
            if (className.indexOf(".") != -1) {
                return Class.forName(className);
            }
            return Class.forName(String.valueOf(ASTBehaviorUnit.getBehaviorUnit().behavingEntityPackage) + "." + className);
        }
        catch (ClassNotFoundException e1) {
            packageIter = ASTBehaviorUnit.getBehaviorUnit().getUserImportPackages();
            ** while (packageIter.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            try {
                packageName = packageIter.next();
                return Class.forName(String.valueOf(packageName) + "." + className);
            }
            catch (ClassNotFoundException packageName) {
                // empty catch block
            }
            continue;
        }
lbl14:
        // 1 sources

        classIter = ASTBehaviorUnit.getBehaviorUnit().getUserImportClasses();
        while (classIter.hasNext()) {
            importedClassName = classIter.next();
            if (!className.equals(importedClassName.substring(importedClassName.lastIndexOf(46) + 1, importedClassName.length()))) continue;
            return Class.forName(importedClassName);
        }
        throw new ClassNotFoundException(className);
    }

    protected Class getFieldType(String className, String fieldName) throws ClassNotFoundException, NoSuchFieldException {
        return this.getClass(className).getField(fieldName).getType();
    }

    protected Class getWMEFieldType(String wmeClassName, String fieldName) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> wmeClass = WorkingMemory.isReflectionWME(wmeClassName) ? Class.forName("abl.runtime." + wmeClassName) : this.getClass(wmeClassName);
        return wmeClass.getMethod("get" + AblParseNode.uppercaseFirstCharacter(fieldName), null).getReturnType();
    }

    AblScopeMaintainer getEnclosingBehaviorScope() {
        throw new CompileError("getEnclosingBehaviorScope() called on a parse node which never appears in a subtree rooted at an ASTBehaviorDefinition");
    }

    protected String getBehavingEntityField(String fieldName) {
        return String.valueOf(ASTBehaviorUnit.getBehaviorUnit().getBehavingEntityClass()) + "." + fieldName;
    }
}

