/*
 * Decompiled with CFR 0.152.
 */
package abl.compiler;

import abl.compiler.AblParseNode;
import abl.compiler.CompileError;

public class AblArgument {
    private Object argument;
    private String type;
    private boolean variableReference;

    public AblArgument(Object argumentToSet, String typeToSet) {
        this.argument = argumentToSet;
        this.type = typeToSet;
        this.variableReference = false;
    }

    public AblArgument(Object argumentToSet, String typeToSet, boolean varRef) {
        if (varRef && !argumentToSet.getClass().getName().equals("java.lang.String")) {
            throw new CompileError("Attempt to set a non-String argument in a variable reference AblArgument");
        }
        this.variableReference = varRef;
        this.type = typeToSet.intern();
        this.argument = argumentToSet;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (AblParseNode.primitiveType(this.type)) {
            if (this.type.equals("int")) {
                buf.append("new Integer(");
            } else if (this.type.equals("float")) {
                buf.append("new Float(");
            } else if (this.type.equals("double")) {
                buf.append("new Double(");
            } else if (this.type.equals("char")) {
                buf.append("new Character(");
            } else if (this.type.equals("boolean")) {
                buf.append("new Boolean(");
            } else {
                if (this.type.equals("null")) {
                    return "null";
                }
                if (this.type.equals("long")) {
                    buf.append("new Long(");
                } else if (this.type.equals("short")) {
                    buf.append("new Short(");
                } else if (this.type.equals("byte")) {
                    buf.append("new Byte(");
                } else {
                    throw new CompileError("Unrecognized primitive type " + this.type + " in a AblArgument.");
                }
            }
            buf.append(this.argument + ")");
        } else if (this.type.equals("String")) {
            buf.append("new String(" + this.argument + ")");
        } else {
            if (!this.variableReference) {
                throw new CompileError("Literal non-primitive reference to type " + this.type + " in a AblArgument.");
            }
            buf.append(this.argument);
        }
        return buf.toString();
    }
}

