/*
 * Decompiled with CFR 0.152.
 */
package abl.compiler;

import abl.compiler.ASTBehaviorUnit;
import abl.compiler.ASTVisitor;
import abl.compiler.ASTWalker;
import abl.compiler.AblDebuggerConstants;
import abl.compiler.AblParser;
import abl.compiler.CompileException;
import abl.compiler.ParseException;
import abl.compiler.astchecks.SanityCheckVisitor;
import abl.compiler.astchecks.TypeCheckVisitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class Abl
implements AblDebuggerConstants {
    private static List<String> sourceFiles = new ArrayList<String>();
    private static String objectDirectoryName = null;
    public static File objectDirectory;
    static byte debugLevel;
    private static boolean dumpTree;
    static boolean currentLineOfExpansion;
    static boolean bMetaEnabled;
    static boolean noCodeGeneration;
    static boolean reflectionOptimization;

    static {
        debugLevel = 0;
        dumpTree = false;
        currentLineOfExpansion = true;
        bMetaEnabled = true;
        noCodeGeneration = false;
        reflectionOptimization = true;
    }

    private static void processCommandlineArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            block27: {
                if (args[i].startsWith("-d")) {
                    if (++i >= args.length) {
                        Abl.usage();
                        System.exit(1);
                    } else {
                        objectDirectoryName = args[i];
                    }
                } else if (args[i].startsWith("-X")) {
                    if (++i >= args.length) {
                        Abl.usage();
                        System.exit(1);
                    } else if (args[i].equals("dumpTree")) {
                        dumpTree = true;
                    } else if (args[i].equals("noCurrentLineOfExpansion")) {
                        currentLineOfExpansion = false;
                    } else if (args[i].equals("noReflectOpt")) {
                        reflectionOptimization = false;
                    } else {
                        Abl.usage();
                        System.exit(1);
                    }
                } else if (args[i].startsWith("-g")) {
                    try {
                        byte level = Byte.parseByte(args[i + 1]);
                        if (level != 1 && level != 2) {
                            System.out.println("The debug level following -g should be either 1 or 2");
                            break block27;
                        }
                        debugLevel = level;
                    }
                    catch (NumberFormatException e) {
                        debugLevel = (byte)2;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        debugLevel = (byte)2;
                    }
                } else if (args[i].equals("-metaEnabled")) {
                    bMetaEnabled = true;
                } else if (args[i].equals("-metaDisabled")) {
                    bMetaEnabled = false;
                } else if (args[i].equals("-nc")) {
                    noCodeGeneration = true;
                } else {
                    sourceFiles.add(args[i]);
                }
            }
            ++i;
        }
        objectDirectory = objectDirectoryName != null ? new File(objectDirectoryName) : new File(".");
    }

    private static void usage() {
        System.out.println("abl [-d <object directory>] [-X dumpTree|noCurrentLineOfExpansion|noReflectOpt] [-g] [1|2] [-metaEnabled|metaDisabled] [-nc] <ABL source file>+");
    }

    public static void main(String[] args) throws CompileException {
        int errorcount = 0;
        long startTime = System.currentTimeMillis();
        Abl.processCommandlineArgs(args);
        if (args.length == 0) {
            Abl.usage();
        } else {
            ListIterator<String> sourceFileIter = sourceFiles.listIterator();
            while (sourceFileIter.hasNext()) {
                String sourceFile = sourceFileIter.next();
                System.out.println("Reading from file " + sourceFile + " . . .");
                try {
                    Abl.compileFile(sourceFile);
                }
                catch (FileNotFoundException e) {
                    System.err.println("ABL Parser: File " + sourceFile + " not found.");
                    ++errorcount;
                }
                catch (ParseException e) {
                    System.err.println(e.getMessage());
                    System.err.println("ABL Parser: Encountered errors during parse.");
                    ++errorcount;
                }
                catch (CompileException e) {
                    System.err.println(e.getMessage());
                    System.err.println("ABL: Encountered errors during compilation, exiting.");
                    System.exit(++errorcount);
                }
            }
        }
        System.out.println("ABL compiler took: " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
        if (errorcount != 0) {
            System.err.println("Encountered " + errorcount + " errors total");
            System.exit(errorcount);
        }
    }

    public static void compileFile(String sourceFile) throws FileNotFoundException, ParseException, CompileException {
        AblParser parser = new AblParser(new FileInputStream(sourceFile));
        ASTBehaviorUnit n = parser.BehaviorUnit();
        System.out.println(String.valueOf(sourceFile) + " parsed successfully.");
        if (dumpTree) {
            n.dump("");
        }
        n = ASTWalker.walk((ASTVisitor)new SanityCheckVisitor(n), n);
        n = ASTWalker.walk((ASTVisitor)new TypeCheckVisitor(n, sourceFile), n);
        System.out.println("Generating code . . .");
        n.compileToJava();
    }
}

