/*
 * Decompiled with CFR 0.152.
 */
package abl.compiler;

import abl.compiler.ASTBehaviorUnit;
import abl.compiler.ASTVisitor;
import abl.compiler.CompileError;
import abl.compiler.CompileException;
import abl.compiler.Node;
import fun.FoldL;
import fun.Fun2;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class ASTWalker {
    private ASTWalker() {
    }

    public static ASTBehaviorUnit dwalk(ASTVisitor visitor, ASTBehaviorUnit unit) throws CompileError, CompileException {
        return (ASTBehaviorUnit)ASTWalker.dwalk(visitor, (Node)unit);
    }

    public static Node dwalk(ASTVisitor visitor, Node ast) throws CompileError, CompileException {
        int i = ast.jjtGetNumChildren() - 1;
        while (i >= 0) {
            ast.jjtAddChild(ASTWalker.dwalk(visitor, ast.jjtGetChild(i)), i);
            --i;
        }
        return ASTWalker.visitNode(visitor, ast);
    }

    public static ASTBehaviorUnit walk(ASTVisitor visitor, ASTBehaviorUnit ast) throws CompileError, CompileException {
        return (ASTBehaviorUnit)ASTWalker.walk(visitor, (Node)ast);
    }

    public static Node walk(ASTVisitor visitor, Node ast) throws CompileError, CompileException {
        Node newNode = ASTWalker.visitNode(visitor, ast);
        int i = newNode.jjtGetNumChildren() - 1;
        while (i >= 0) {
            newNode.jjtAddChild(ASTWalker.dwalk(visitor, newNode.jjtGetChild(i)), i);
            --i;
        }
        return newNode;
    }

    public static Node walk(List<ASTVisitor> visitors, Node ast) throws CompileError, CompileException {
        Node astPrime;
        try {
            astPrime = FoldL.foldl(new VisitNodeL(), ast, visitors.iterator());
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof CompileException) {
                throw (CompileException)e.getCause();
            }
            throw e;
        }
        int i = astPrime.jjtGetNumChildren() - 1;
        while (i >= 0) {
            astPrime.jjtAddChild(ASTWalker.walk(visitors, astPrime.jjtGetChild(i)), i);
            --i;
        }
        return astPrime;
    }

    private static Node visitNode(ASTVisitor visitor, Node n) throws CompileError, CompileException {
        Method visit = ASTWalker.getVisitMethod(visitor, n.getClass());
        try {
            Node ret = (Node)visit.invoke((Object)visitor, n);
            return ret;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CompileException) {
                throw (CompileException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        catch (Exception e) {
            throw new CompileError("Compiler error", e);
        }
    }

    private static Method getVisitMethod(ASTVisitor visitor, Class astClass) {
        Method visit;
        try {
            visit = visitor.getClass().getMethod("visit", astClass);
        }
        catch (Exception e) {
            throw new CompileError("Compiler error", e);
        }
        return visit;
    }

    static class VisitNodeL
    extends Fun2<Node, ASTVisitor, Node> {
        VisitNodeL() {
        }

        @Override
        public Node apply(Node curNode, ASTVisitor visitor) {
            try {
                return ASTWalker.visitNode(visitor, curNode);
            }
            catch (CompileException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class VisitNodeR
    extends Fun2<ASTVisitor, Node, Node> {
        VisitNodeR() {
        }

        @Override
        public Node apply(ASTVisitor visitor, Node curNode) {
            try {
                return ASTWalker.visitNode(visitor, curNode);
            }
            catch (CompileException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

