/*
 * Decompiled with CFR 0.152.
 */
package abl.compiler;

import abl.compiler.ASTJavaName;
import abl.compiler.ASTTestExpression;
import abl.compiler.ASTWMEFieldTest;
import abl.compiler.Abl;
import abl.compiler.AblParseNode;
import abl.compiler.AblParser;
import abl.compiler.AblParserTreeConstants;
import abl.compiler.AblScopeMaintainer;
import abl.compiler.CompileError;
import abl.compiler.CompileException;
import abl.compiler.MacroDefinitions;
import abl.compiler.TestNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jd.CodeBlockDescriptor;
import jd.CodeStringDescriptor;
import jd.FieldDescriptor;
import jd.JavaCodeDescriptor;
import macro.SimpleMacro;
import macro.SimpleMacroException;
import wm.WorkingMemory;

public class ASTWMETest
extends TestNode
implements AblParserTreeConstants {
    boolean negated;
    String wmeClassName;
    ASTJavaName wmeAssignmentVariable = null;
    private static final SimpleMacro wmeTestGetWMEListNoMemory = new SimpleMacro(MacroDefinitions.wmeTestGetWMEListNoMemoryMacroString);
    private static final SimpleMacro wmeTestGetWMEListMemory = new SimpleMacro(MacroDefinitions.wmeTestGetWMEListMemoryMacroString);
    private static final SimpleMacro wmeTestGetWMEListNoMemorySignatureOpt = new SimpleMacro(MacroDefinitions.wmeTestGetWMEListNoMemorySignatureOptMacroString);
    private static final SimpleMacro wmeTestGetWMEListMemorySignatureOpt = new SimpleMacro(MacroDefinitions.wmeTestGetWMEListMemorySignatureOptMacroString);
    private static final SimpleMacro wmeTestGetWMEListNoMemoryPropertyOpt = new SimpleMacro(MacroDefinitions.wmeTestGetWMEListNoMemoryPropertyOptMacroString);
    private static final SimpleMacro wmeTestGetWMEListMemoryPropertyOpt = new SimpleMacro(MacroDefinitions.wmeTestGetWMEListMemoryPropertyOptMacroString);
    private static final SimpleMacro wmeTestWhile = new SimpleMacro("definemacro wmeTestWhile(wmeCount)while(wmeIter@wmeCount.hasNext()) {");
    private static final SimpleMacro wmeTestWhileNextAssign = new SimpleMacro(MacroDefinitions.wmeTestWhileNextAssignMacroString);
    private static final SimpleMacro wmeTestWhileNextNoAssign = new SimpleMacro("definemacro wmeTestWhileNext(wmeCount, wmeClassName)wmeClassName wme__@wmeCount = (wmeClassName)wmeIter@wmeCount.next();");
    String memoryName = null;

    ASTWMETest(int id) {
        super(id);
    }

    ASTWMETest(AblParser p, int id) {
        super(p, id);
    }

    @Override
    AblScopeMaintainer getEnclosingBehaviorScope() {
        return ((ASTTestExpression)this.jjtGetParent()).getEnclosingBehaviorScope();
    }

    AblScopeMaintainer getEnclosingScope() {
        return ((ASTTestExpression)this.jjtGetParent()).getEnclosingScope();
    }

    void setMemoryName(String memoryName) {
        this.memoryName = memoryName;
    }

    @Override
    final Set getExplicitlyDeclaredVariableReferences() {
        HashSet<FieldDescriptor> declaredVariableReferences = new HashSet<FieldDescriptor>();
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            ASTWMEFieldTest fieldTest;
            FieldDescriptor variable;
            AblParseNode node = (AblParseNode)this.jjtGetChild(i);
            if (node.id == 10 && (variable = (fieldTest = (ASTWMEFieldTest)node).getExplicitlyDeclaredVariableReference()) != null) {
                declaredVariableReferences.add(variable);
            }
            ++i;
        }
        return declaredVariableReferences;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Set<FieldDescriptor> preprocessVariableRefs() throws CompileException {
        HashSet<FieldDescriptor> newFieldDefs = new HashSet<FieldDescriptor>();
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            FieldDescriptor f;
            AblParseNode node = (AblParseNode)this.jjtGetChild(i);
            if (node.id == 10 && (f = ((ASTWMEFieldTest)node).preprocessVariableRef()) != null) {
                newFieldDefs.add(f);
            }
            ++i;
        }
        if (this.wmeAssignmentVariable == null) return newFieldDefs;
        if (!this.wmeAssignmentVariable.isVariableReference(this.getEnclosingBehaviorScope())) {
            if (!this.wmeAssignmentVariable.isSimpleRef()) throw new CompileException("Line " + this.getFirstLineNumber() + "Can not implicitly declare WME assignment variable (non-simple reference): " + this.prettyPrintTokens());
            FieldDescriptor newVar = new FieldDescriptor();
            newVar.addFieldName(this.wmeAssignmentVariable.getName());
            newVar.fieldType = this.wmeClassName;
            newFieldDefs.add(newVar);
            return newFieldDefs;
        } else {
            if (this.wmeAssignmentVariable.lookupVariableType(this.getEnclosingBehaviorScope()).equals(this.wmeClassName)) return newFieldDefs;
            throw new CompileException("Line " + this.getFirstLineNumber() + "Type error in WME assignment: " + this.prettyPrintTokens());
        }
    }

    @Override
    Set<String> getBoundVariables() {
        HashSet<String> boundVariables = new HashSet<String>();
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            String v;
            AblParseNode node = (AblParseNode)this.jjtGetChild(i);
            if (node.id == 10 && (v = ((ASTWMEFieldTest)node).getBoundVariable()) != null) {
                boundVariables.add(v);
            }
            ++i;
        }
        if (this.wmeAssignmentVariable != null) {
            boundVariables.add(this.wmeAssignmentVariable.getName());
        }
        return boundVariables;
    }

    int getWMECounter() {
        return ((ASTTestExpression)this.jjtGetParent()).getTestCounter();
    }

    protected List<JavaCodeDescriptor> compileFieldTests() throws CompileException {
        ArrayList<JavaCodeDescriptor> compiledFieldTests = new ArrayList<JavaCodeDescriptor>();
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode node = (AblParseNode)this.jjtGetChild(i);
            if (node.id == 10) {
                compiledFieldTests.add(((ASTWMEFieldTest)node).compileToJava());
            }
            ++i;
        }
        if (compiledFieldTests.size() == 0) {
            compiledFieldTests.add(new CodeStringDescriptor("true"));
        }
        return compiledFieldTests;
    }

    int getTestType() {
        return ((ASTTestExpression)this.jjtGetParent()).getTestType();
    }

    @Override
    JavaCodeDescriptor compileToJava() throws CompileException {
        int wmeCount = ((ASTTestExpression)this.jjtGetParent()).getTestCounter();
        String[] macroArgs1 = new String[]{Integer.toString(wmeCount), this.wmeClassName};
        CodeBlockDescriptor wmeTest = new CodeBlockDescriptor();
        String signatureTest = null;
        ASTWMEFieldTest propertyTest = null;
        try {
            if (WorkingMemory.isReflectionWME(this.wmeClassName) && Abl.reflectionOptimization) {
                int i = 0;
                while (i < this.jjtGetNumChildren()) {
                    AblParseNode node = (AblParseNode)this.jjtGetChild(i);
                    if (node.id == 10) {
                        ASTWMEFieldTest fieldTest = (ASTWMEFieldTest)node;
                        if (fieldTest.isProperty()) {
                            String operand = this.resolveOperandInFieldTest(fieldTest);
                            if (operand.equals("null") && fieldTest.testOp == 151 || !operand.equals("null")) {
                                propertyTest = fieldTest;
                                break;
                            }
                        } else if (fieldTest.wmeFieldName.equals("signature") && fieldTest.testOp == 148) {
                            signatureTest = this.resolveOperandInFieldTest(fieldTest);
                            break;
                        }
                    }
                    ++i;
                }
                if (signatureTest != null) {
                    if (this.memoryName == null) {
                        String[] sigMacroArgs = new String[]{Integer.toString(wmeCount), this.wmeClassName, signatureTest};
                        wmeTest.addToBlockBody(new CodeStringDescriptor(wmeTestGetWMEListNoMemorySignatureOpt.expand(sigMacroArgs)));
                    } else {
                        String[] sigMacroArgs = new String[]{Integer.toString(wmeCount), this.wmeClassName, this.memoryName, signatureTest};
                        wmeTest.addToBlockBody(new CodeStringDescriptor(wmeTestGetWMEListMemorySignatureOpt.expand(sigMacroArgs)));
                    }
                } else if (propertyTest != null) {
                    if (this.memoryName == null) {
                        String[] propertyMacroArgs = new String[]{Integer.toString(wmeCount), this.wmeClassName, propertyTest.wmeFieldName};
                        wmeTest.addToBlockBody(new CodeStringDescriptor(wmeTestGetWMEListNoMemoryPropertyOpt.expand(propertyMacroArgs)));
                    } else {
                        String[] propertyMacroArgs = new String[]{Integer.toString(wmeCount), this.wmeClassName, this.memoryName, propertyTest.wmeFieldName};
                        wmeTest.addToBlockBody(new CodeStringDescriptor(wmeTestGetWMEListMemoryPropertyOpt.expand(propertyMacroArgs)));
                    }
                }
            }
            if (signatureTest == null && propertyTest == null) {
                if (this.memoryName == null) {
                    wmeTest.addToBlockBody(new CodeStringDescriptor(wmeTestGetWMEListNoMemory.expand(macroArgs1)));
                } else {
                    String[] specfiedMemoryMacroArgs = new String[]{Integer.toString(wmeCount), this.wmeClassName, this.memoryName};
                    wmeTest.addToBlockBody(new CodeStringDescriptor(wmeTestGetWMEListMemory.expand(specfiedMemoryMacroArgs)));
                }
            }
            CodeBlockDescriptor testLoop = new CodeBlockDescriptor();
            String[] macroArgs2 = new String[]{Integer.toString(wmeCount)};
            testLoop.setBlockHeader(wmeTestWhile.expand(macroArgs2));
            testLoop.setBlockFooter("}");
            if (this.wmeAssignmentVariable != null) {
                String[] macroArgs3 = new String[]{Integer.toString(wmeCount), this.wmeClassName, this.wmeAssignmentVariable.getVariableReference(this.getEnclosingScope())};
                testLoop.addToBlockBody(new CodeStringDescriptor(wmeTestWhileNextAssign.expand(macroArgs3)));
            } else {
                testLoop.addToBlockBody(new CodeStringDescriptor(wmeTestWhileNextNoAssign.expand(macroArgs1)));
            }
            CodeBlockDescriptor ifTest = new CodeBlockDescriptor("if (", ")");
            List<JavaCodeDescriptor> wmeFieldTests = this.compileFieldTests();
            Iterator<JavaCodeDescriptor> wmeFieldTestIter = wmeFieldTests.iterator();
            if (wmeFieldTestIter.hasNext()) {
                ifTest.addToBlockBody((CodeStringDescriptor)wmeFieldTestIter.next());
            }
            while (wmeFieldTestIter.hasNext()) {
                ifTest.addToBlockBody(new CodeStringDescriptor("&&"));
                ifTest.addToBlockBody((CodeStringDescriptor)wmeFieldTestIter.next());
            }
            CodeBlockDescriptor ifBody = new CodeBlockDescriptor("{", "}");
            if (!this.negated) {
                if (((ASTTestExpression)this.jjtGetParent()).hasNextTest()) {
                    ifBody.addToBlockBody(((ASTTestExpression)this.jjtGetParent()).compileNextTest());
                } else {
                    if (((ASTTestExpression)this.jjtGetParent()).getTestType() == 0) {
                        ((ASTTestExpression)this.jjtGetParent()).compileOutgoingVariables(ifBody);
                    }
                    ifBody.addToBlockBody(new CodeStringDescriptor("return true;"));
                }
            } else {
                ifBody.addToBlockBody(new CodeStringDescriptor("return false;"));
            }
            testLoop.addToBlockBody(ifTest);
            testLoop.addToBlockBody(ifBody);
            wmeTest.addToBlockBody(testLoop);
            if (this.negated) {
                if (((ASTTestExpression)this.jjtGetParent()).hasNextTest()) {
                    wmeTest.addToBlockBody(((ASTTestExpression)this.jjtGetParent()).compileNextTest());
                } else {
                    if (((ASTTestExpression)this.jjtGetParent()).getTestType() == 0) {
                        ((ASTTestExpression)this.jjtGetParent()).compileOutgoingVariables(wmeTest);
                    }
                    wmeTest.addToBlockBody(new CodeStringDescriptor("return true;"));
                }
            }
            return wmeTest;
        }
        catch (SimpleMacroException e) {
            throw new CompileError("Error in ASTWMETest.compileToJava()", e);
        }
        catch (ClassNotFoundException e) {
            throw new CompileError("Error in ASTWMETest.compileToJava()", e);
        }
        catch (NoSuchFieldException e) {
            throw new CompileError("Error in ASTWMETest.compileToJava()", e);
        }
    }

    String resolveOperandInFieldTest(ASTWMEFieldTest fieldTest) throws CompileException {
        AblScopeMaintainer behaviorScope = this.getEnclosingBehaviorScope();
        if (this.getTestType() == 0) {
            if (fieldTest.wmeTestOperand.isIdentifier()) {
                if (fieldTest.wmeTestOperand.getRef().lookupVariableScope(behaviorScope) == 0) {
                    return fieldTest.wmeTestOperand.getRef().getVariableReference(behaviorScope);
                }
                if (fieldTest.wmeTestOperand.getRef().isConstant(behaviorScope)) {
                    return fieldTest.wmeTestOperand.getRef().getConstantString();
                }
                return fieldTest.wmeTestOperand.getFullNameOrLiteral();
            }
            return fieldTest.wmeTestOperand.getFullNameOrLiteral();
        }
        AblScopeMaintainer localScope = this.getEnclosingScope();
        return fieldTest.wmeTestOperand.getVariableReferenceConstantOrLiteral(localScope);
    }
}

