/*
 * Decompiled with CFR 0.152.
 */
package abl.compiler;

import abl.compiler.ASTAblExpression;
import abl.compiler.ASTBehaviorUnit;
import abl.compiler.ASTJavaName;
import abl.compiler.ASTWMETest;
import abl.compiler.AblParseNode;
import abl.compiler.AblParser;
import abl.compiler.AblScopeMaintainer;
import abl.compiler.CompileException;
import jd.CodeStringDescriptor;
import jd.FieldDescriptor;
import jd.JavaCodeDescriptor;

public class ASTWMEFieldTest
extends AblParseNode {
    String wmeFieldName;
    int testOp;
    ASTAblExpression wmeTestOperand;

    ASTWMEFieldTest(int id) {
        super(id);
    }

    ASTWMEFieldTest(AblParser p, int id) {
        super(p, id);
    }

    boolean isProperty() throws ClassNotFoundException, NoSuchFieldException {
        String wmeClassName = ((ASTWMETest)this.jjtGetParent()).wmeClassName;
        ASTBehaviorUnit behUnit = ASTBehaviorUnit.getBehaviorUnit();
        if (behUnit.isWMEDeclared(wmeClassName)) {
            String wmeFieldTypeName = behUnit.lookupWMEFieldType(wmeClassName, this.wmeFieldName);
            if (wmeFieldTypeName != null) {
                return false;
            }
            String propertyType = ASTBehaviorUnit.getBehaviorUnit().lookupDeclaredProperty(this.wmeFieldName);
            if (propertyType != null) {
                return true;
            }
            throw new NoSuchFieldException();
        }
        try {
            this.getWMEFieldType(wmeClassName, this.wmeFieldName).getName();
            return false;
        }
        catch (NoSuchMethodException e) {
            String propertyType = ASTBehaviorUnit.getBehaviorUnit().lookupDeclaredProperty(this.wmeFieldName);
            if (propertyType != null) {
                return true;
            }
            throw new NoSuchFieldException();
        }
    }

    private String getWMEFieldType() throws ClassNotFoundException, NoSuchFieldException {
        String wmeClassName = ((ASTWMETest)this.jjtGetParent()).wmeClassName;
        ASTBehaviorUnit behUnit = ASTBehaviorUnit.getBehaviorUnit();
        if (behUnit.isWMEDeclared(wmeClassName)) {
            String wmeFieldTypeName = behUnit.lookupWMEFieldType(wmeClassName, this.wmeFieldName);
            if (wmeFieldTypeName != null) {
                return wmeFieldTypeName;
            }
            String propertyType = ASTBehaviorUnit.getBehaviorUnit().lookupDeclaredProperty(this.wmeFieldName);
            if (propertyType != null) {
                return "Object";
            }
            throw new NoSuchFieldException();
        }
        try {
            return this.getWMEFieldType(wmeClassName, this.wmeFieldName).getName();
        }
        catch (NoSuchMethodException e) {
            String propertyType = ASTBehaviorUnit.getBehaviorUnit().lookupDeclaredProperty(this.wmeFieldName);
            if (propertyType != null) {
                return "Object";
            }
            throw new NoSuchFieldException();
        }
    }

    public FieldDescriptor preprocessVariableRef() throws CompileException {
        try {
            String wmeFieldType = this.getWMEFieldType();
            if (this.wmeTestOperand.isIdentifier() && this.testOp == 112) {
                AblScopeMaintainer scope = ((ASTWMETest)this.jjtGetParent()).getEnclosingBehaviorScope();
                if (!this.wmeTestOperand.getRef().isVariableReference(scope)) {
                    FieldDescriptor newVar = new FieldDescriptor();
                    newVar.addFieldName(this.wmeTestOperand.getRef().getName());
                    newVar.fieldType = wmeFieldType;
                    return newVar;
                }
                String argType = this.wmeTestOperand.getRef().lookupFieldType(scope);
                if (ASTWMEFieldTest.primitiveType(argType) && !argType.equals(wmeFieldType) || !ASTWMEFieldTest.primitiveType(argType) && !this.getClass(argType).isAssignableFrom(this.getClass(wmeFieldType))) {
                    throw new CompileException(this.getFirstLineNumber(), "Type error in WME field test: " + this.dumpTokens() + ". Attempt to assign WME field of type " + wmeFieldType + " to variable of type " + argType);
                }
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new CompileException(this.getFirstLineNumber(), "Reference to undefined WME " + e.getMessage() + " in WME test: " + this.dumpTokens());
        }
        catch (NoSuchFieldException e) {
            throw new CompileException(this.getFirstLineNumber(), "Reference to undefined WME field in WME test: " + this.dumpTokens());
        }
    }

    final FieldDescriptor getExplicitlyDeclaredVariableReference() {
        AblScopeMaintainer scope = ((ASTWMETest)this.jjtGetParent()).getEnclosingBehaviorScope();
        ASTJavaName ref = this.wmeTestOperand.getRef();
        if (ref != null && scope.lookupVariableScope(ref.getName()) == 1) {
            return scope.lookupVariable(ref.getName());
        }
        return null;
    }

    public String getBoundVariable() {
        if (this.wmeTestOperand.isIdentifier() && this.testOp == 112) {
            return this.wmeTestOperand.getRef().getName();
        }
        return null;
    }

    public int getTestType() {
        return ((ASTWMETest)this.jjtGetParent()).getTestType();
    }

    public JavaCodeDescriptor compileToJava() throws CompileException {
        String getAccessorName;
        int wmeCount = ((ASTWMETest)this.jjtGetParent()).getWMECounter();
        String ref = ((ASTWMETest)this.jjtGetParent()).resolveOperandInFieldTest(this);
        StringBuffer codeString = new StringBuffer();
        try {
            getAccessorName = this.isProperty() ? "getProperty(\"" + this.wmeFieldName + "\")" : "get" + ASTWMEFieldTest.uppercaseFirstCharacter(this.wmeFieldName) + "()";
        }
        catch (ClassNotFoundException e) {
            throw new CompileException(String.valueOf(this.getFirstLineNumber()) + "BReference to undefined WME " + e.getMessage() + " in WME test: " + this.dumpTokens());
        }
        catch (NoSuchFieldException e) {
            throw new CompileException(String.valueOf(this.getFirstLineNumber()) + "Reference to undefined WME field in WME test: " + this.dumpTokens());
        }
        if (this.testOp == 112) {
            codeString.append("BehavingEntity.constantTrue(" + ref + " = " + "wme__" + wmeCount + "." + getAccessorName + ")");
        } else {
            String fieldType;
            try {
                fieldType = this.getWMEFieldType();
            }
            catch (ClassNotFoundException e) {
                throw new CompileException(String.valueOf(this.getFirstLineNumber()) + "CReference to undefined WME " + e.getMessage() + " in WME test: " + this.dumpTokens());
            }
            catch (NoSuchFieldException e) {
                throw new CompileException(String.valueOf(this.getFirstLineNumber()) + "Reference to undefined WME field in WME test: " + this.dumpTokens());
            }
            if ((fieldType.equals("java.lang.String") || fieldType.equals("String")) && ASTWMEFieldTest.stripQuotes(tokenImage[this.testOp]).equals("==")) {
                codeString.append("(wme__" + wmeCount + "." + getAccessorName + ".equals(" + ref + "))");
            } else if ((fieldType.equals("java.lang.String") || fieldType.equals("String")) && ASTWMEFieldTest.stripQuotes(tokenImage[this.testOp]).equals("!=")) {
                codeString.append("(!wme__" + wmeCount + "." + getAccessorName + ".equals(" + ref + "))");
            } else {
                codeString.append("( wme__" + wmeCount + "." + getAccessorName + " " + ASTWMEFieldTest.stripQuotes(tokenImage[this.testOp]) + " ");
                codeString.append(String.valueOf(ref) + " )");
            }
        }
        return new CodeStringDescriptor(codeString.toString());
    }
}

