/*
 * Decompiled with CFR 0.152.
 */
package abl.compiler;

import abl.compiler.ASTAblVariableDecl;
import abl.compiler.ASTBehaviorUnit;
import abl.compiler.AblParseNode;
import abl.compiler.AblParser;
import abl.compiler.CompileError;
import abl.compiler.CompileException;
import java.util.Hashtable;
import jd.ClassDescriptor;
import jd.CodeStringDescriptor;
import jd.FieldDescriptor;
import jd.JavaCodeDescriptor;
import jd.MethodDescriptor;
import macro.SimpleMacro;
import macro.SimpleMacroException;

public class ASTWMEDecl
extends AblParseNode {
    public String wmeClassName;
    public String wmeExtendsClass = null;
    private static final SimpleMacro wmeConstructorAssignment = new SimpleMacro("definemacro wmeConstructorAssignmentBlock(fieldName)this.fieldName = fieldName;");
    private static final SimpleMacro wmeGetAccessorBody = new SimpleMacro("definemacro wmeGetAccessorBody(fieldName)return fieldName;");
    private static final SimpleMacro wmeSetAccessorBody = new SimpleMacro("definemacro wmeSetAccessorBody(fieldName)this.fieldName = fieldName;");

    public ASTWMEDecl(int id) {
        super(id);
    }

    public ASTWMEDecl(AblParser p, int id) {
        super(p, id);
    }

    private MethodDescriptor defineDefaultConstructor() {
        MethodDescriptor constructor = new MethodDescriptor();
        constructor.methodName = ASTWMEDecl.uppercaseFirstCharacter(this.wmeClassName);
        constructor.addModifier("public");
        return constructor;
    }

    private MethodDescriptor defineInitConstructor(FieldDescriptor[] fields) {
        MethodDescriptor constructor = new MethodDescriptor();
        try {
            constructor.methodName = ASTWMEDecl.uppercaseFirstCharacter(this.wmeClassName);
            constructor.addModifier("public");
            int i = 0;
            while (i < fields.length) {
                constructor.addArgument(fields[i].fieldType, fields[i].getFieldNames()[0]);
                ++i;
            }
            StringBuffer methodBodyBuf = new StringBuffer();
            int i2 = 0;
            while (i2 < fields.length) {
                String fieldName = fields[i2].getFieldNames()[0];
                String[] macroArgs = new String[]{fieldName};
                methodBodyBuf.append(wmeConstructorAssignment.expand(macroArgs));
                ++i2;
            }
            constructor.addToBlockBody(new CodeStringDescriptor(methodBodyBuf.toString()));
            return constructor;
        }
        catch (SimpleMacroException e) {
            throw new CompileError("Error expanding macro in ASTWMEDecl.defineInitConstructor(): " + e.getMessage());
        }
    }

    public Hashtable<String, String> getFieldTypeTable() {
        Hashtable<String, String> typeTable = new Hashtable<String, String>();
        int numberOfChildren = this.jjtGetNumChildren();
        int i = 0;
        while (i < numberOfChildren) {
            FieldDescriptor[] tempFields = ((ASTAblVariableDecl)this.jjtGetChild(i)).getFieldDescriptors();
            int j = 0;
            while (j < tempFields.length) {
                String[] fieldNames = tempFields[j].getFieldNames();
                typeTable.put(fieldNames[0], tempFields[j].fieldType);
                ++j;
            }
            ++i;
        }
        return typeTable;
    }

    private MethodDescriptor defineGetAccessor(FieldDescriptor field) {
        MethodDescriptor getAccessor = new MethodDescriptor();
        getAccessor.methodName = "get" + ASTWMEDecl.uppercaseFirstCharacter(field.getFieldNames()[0]);
        getAccessor.addModifier("public");
        getAccessor.addModifier("synchronized");
        getAccessor.addModifier(field.fieldType);
        String[] macroArgs = new String[]{field.getFieldNames()[0]};
        try {
            getAccessor.addToBlockBody(new CodeStringDescriptor(wmeGetAccessorBody.expand(macroArgs)));
        }
        catch (SimpleMacroException e) {
            throw new CompileError("Error expanding macro: " + e.getMessage());
        }
        return getAccessor;
    }

    private MethodDescriptor defineSetAccessor(FieldDescriptor field) {
        MethodDescriptor setAccessor = new MethodDescriptor();
        setAccessor.methodName = "set" + ASTWMEDecl.uppercaseFirstCharacter(field.getFieldNames()[0]);
        setAccessor.addModifier("public");
        setAccessor.addModifier("synchronized");
        setAccessor.addModifier("void");
        setAccessor.addArgument(field.fieldType, field.getFieldNames()[0]);
        String[] macroArgs = new String[]{field.getFieldNames()[0]};
        try {
            setAccessor.addToBlockBody(new CodeStringDescriptor(wmeSetAccessorBody.expand(macroArgs)));
        }
        catch (SimpleMacroException e) {
            throw new CompileError("Error expanding macro: " + e.getMessage());
        }
        return setAccessor;
    }

    public JavaCodeDescriptor compileToJava() throws CompileException {
        ClassDescriptor newWME = new ClassDescriptor();
        newWME.packageName = ASTBehaviorUnit.getBehaviorUnit().behavingEntityPackage;
        newWME.addPackageImport("wm.WME");
        newWME.className = ASTWMEDecl.uppercaseFirstCharacter(this.wmeClassName);
        newWME.extendsClass = this.wmeExtendsClass == null ? "WME" : String.valueOf(newWME.packageName) + "." + this.wmeExtendsClass;
        newWME.addClassModifier("public");
        int numberOfChildren = this.jjtGetNumChildren();
        int i = 0;
        while (i < numberOfChildren) {
            FieldDescriptor[] tempFields = ((ASTAblVariableDecl)this.jjtGetChild(i)).getFieldDescriptors();
            int x = 0;
            while (x < tempFields.length) {
                tempFields[x].addFieldModifier("private");
                newWME.addField(tempFields[x]);
                ++x;
            }
            ++i;
        }
        FieldDescriptor[] fieldNames = newWME.getFields();
        newWME.addMethod(this.defineInitConstructor(fieldNames));
        newWME.addMethod(this.defineDefaultConstructor());
        int i2 = 0;
        while (i2 < fieldNames.length) {
            newWME.addMethod(this.defineGetAccessor(fieldNames[i2]));
            ++i2;
        }
        i2 = 0;
        while (i2 < fieldNames.length) {
            newWME.addMethod(this.defineSetAccessor(fieldNames[i2]));
            ++i2;
        }
        return newWME;
    }
}

