/*
 * Decompiled with CFR 0.152.
 */
package abl.compiler;

import abl.compiler.ASTAblExpression;
import abl.compiler.ASTBehaviorDefinition;
import abl.compiler.ASTBehaviorUnit;
import abl.compiler.ASTWMETest;
import abl.compiler.AblParseNode;
import abl.compiler.AblParser;
import abl.compiler.AblParserTreeConstants;
import abl.compiler.AblScopeMaintainer;
import abl.compiler.CompileError;
import abl.compiler.CompileException;
import abl.compiler.GenericStep;
import abl.compiler.TestNode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import java.util.Vector;
import jd.CodeBlockDescriptor;
import jd.CodeStringDescriptor;
import jd.FieldDescriptor;
import jd.MethodArgDescriptor;
import jd.NestableCodeDescriptor;
import macro.SimpleMacro;
import macro.SimpleMacroException;

public class ASTTestExpression
extends AblScopeMaintainer
implements AblParserTreeConstants {
    private static final int MIN_CONDITION_VAL = 0;
    static final int PRECONDITION = 0;
    static final int CONTEXT_CONDITION = 1;
    static final int SUCCESS_TEST = 2;
    static final int ENTRY_CONDITION = 3;
    static final int SUCCESS_CONDITION = 4;
    static final int STATE_CONDITION = 5;
    static final int REINFORCEMENT_TEST = 6;
    private static final int MAX_CONDITION_VAL = 6;
    private int testType = -1;
    private int testCounter;
    private LinkedList testList = new LinkedList();
    private ListIterator testIter;
    private ASTAblExpression signalValue = null;
    private static final SimpleMacro sensorActivation = new SimpleMacro("definemacro sensorActivation(sensorClassName)new SensorActivation(new sensorClassName(), null)");

    ASTTestExpression(int id) {
        super(id);
    }

    ASTTestExpression(AblParser p, int id) {
        super(p, id);
    }

    void setTestType(int testTypeToSet) {
        if (testTypeToSet < 0 || testTypeToSet > 6) {
            throw new CompileError("Illegal test type in call to ASTTestExpression.setTestType(int)");
        }
        this.testType = testTypeToSet;
    }

    int getTestType() {
        if (this.testType == -1) {
            throw new CompileError("Attempt to get the test type of an ASTTestExpression node before the test type was set.");
        }
        return this.testType;
    }

    void setSignalValue(ASTAblExpression value) {
        if (this.testType != 6) {
            throw new CompileError("Attempt to set a signal value of an ASTTestExpression node without test type of REINFORCEMENT_TEST.");
        }
        this.signalValue = value;
    }

    ASTAblExpression getSignalValue() {
        return this.signalValue;
    }

    @Override
    AblScopeMaintainer getEnclosingBehaviorScope() {
        return ((AblParseNode)this.jjtGetParent()).getEnclosingBehaviorScope();
    }

    private Set<FieldDescriptor> preprocessVariableRefs() throws CompileException {
        HashSet<FieldDescriptor> variables = new HashSet<FieldDescriptor>();
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode node = (AblParseNode)this.jjtGetChild(i);
            if (node.id == 9) {
                variables.addAll(((ASTWMETest)node).preprocessVariableRefs());
            }
            ++i;
        }
        return variables;
    }

    private void compilePreconditionArguments() {
        Object[] behaviorArgs = ((ASTBehaviorDefinition)this.jjtGetParent()).getFormalArguments();
        int i = 0;
        while (i < behaviorArgs.length) {
            FieldDescriptor variableDecl = new FieldDescriptor();
            MethodArgDescriptor arg = (MethodArgDescriptor)behaviorArgs[i];
            variableDecl.fieldType = arg.argType;
            variableDecl.addFieldName(arg.argName);
            if (ASTTestExpression.primitiveType(arg.argType)) {
                if (arg.argType.equals("int")) {
                    variableDecl.initializer = "((Integer)__$args[" + i + "]).intValue()";
                } else if (arg.argType.equals("float")) {
                    variableDecl.initializer = "((Float)__$args[" + i + "]).floatValue()";
                } else if (arg.argType.equals("char")) {
                    variableDecl.initializer = "((Char)__$args[" + i + "]).charValue()";
                } else if (arg.argType.equals("boolean")) {
                    variableDecl.initializer = "((Boolean)__$args[" + i + "]).booleanValue()";
                } else if (arg.argType.equals("long")) {
                    variableDecl.initializer = "((Long)__$args[" + i + "]).longValue()";
                } else if (arg.argType.equals("short")) {
                    variableDecl.initializer = "((Short)__$args[" + i + "]).shortValue()";
                } else if (arg.argType.equals("byte")) {
                    variableDecl.initializer = "((Byte)__$args[" + i + "]).byteValue()";
                } else if (arg.argType.equals("double")) {
                    variableDecl.initializer = "((Double)__$args[" + i + "]).doubleValue()";
                }
            } else {
                variableDecl.initializer = "(" + arg.argType + ")__$args[" + i + "]";
            }
            this.addVariableDeclaration(variableDecl);
            ++i;
        }
    }

    private void compileExplicitBehaviorScopeVariables() {
        Set variables = this.getBehaviorScopeVariableReferences();
        Iterator iter = variables.iterator();
        while (iter.hasNext()) {
            this.addVariableDeclaration((FieldDescriptor)iter.next());
        }
    }

    private void compileExplicitStateScopeVariables() {
        Set variables = this.getStateScopeVariableReferences();
        Iterator iter = variables.iterator();
        while (iter.hasNext()) {
            this.addVariableDeclaration((FieldDescriptor)iter.next());
        }
    }

    private NestableCodeDescriptor compileTests() throws CompileException {
        this.testCounter = 0;
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode n = (AblParseNode)this.jjtGetChild(i);
            if (n.id == 9 || n.id == 28) {
                this.testList.add((TestNode)n);
            }
            ++i;
        }
        this.testIter = this.testList.listIterator();
        if (this.testIter.hasNext()) {
            return (NestableCodeDescriptor)((TestNode)this.testIter.next()).compileToJava();
        }
        return null;
    }

    boolean hasNextTest() {
        return this.testIter.hasNext();
    }

    NestableCodeDescriptor compileNextTest() throws CompileException {
        ++this.testCounter;
        if (!this.testIter.hasNext()) {
            throw new CompileError("Call to ASTTestExpression.compileNextTest() with no more tests.");
        }
        return (NestableCodeDescriptor)((TestNode)this.testIter.next()).compileToJava();
    }

    int getTestCounter() {
        return this.testCounter;
    }

    private HashSet getReferencedWMEs() {
        HashSet<String> referencedWMEs = new HashSet<String>();
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode node = (AblParseNode)this.jjtGetChild(i);
            if (node.id == 9) {
                referencedWMEs.add(((ASTWMETest)node).wmeClassName);
            }
            ++i;
        }
        return referencedWMEs;
    }

    Set<String> getBoundVariables() {
        HashSet<String> boundVariables = new HashSet<String>();
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode node = (AblParseNode)this.jjtGetChild(i);
            if (node.id == 9 || node.id == 28) {
                Set<String> varSet = ((TestNode)node).getBoundVariables();
                boundVariables.addAll(varSet);
            }
            ++i;
        }
        return boundVariables;
    }

    private Set getBehaviorScopeVariableReferences() {
        HashSet explicitlyDeclaredVariables = new HashSet();
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode node = (AblParseNode)this.jjtGetChild(i);
            assert (node.id == 9 || node.id == 28);
            explicitlyDeclaredVariables.addAll(((TestNode)node).getExplicitlyDeclaredVariableReferences());
            ++i;
        }
        Object[] behaviorArgs = ((ASTBehaviorDefinition)this.jjtGetParent()).getFormalArguments();
        int i2 = 0;
        while (i2 < behaviorArgs.length) {
            MethodArgDescriptor arg = (MethodArgDescriptor)behaviorArgs[i2];
            FieldDescriptor field = new FieldDescriptor();
            field.fieldType = arg.argType;
            field.addFieldName(arg.argName);
            explicitlyDeclaredVariables.remove(field);
            ++i2;
        }
        return explicitlyDeclaredVariables;
    }

    private Set getStateScopeVariableReferences() {
        HashSet explicitlyDeclaredVariables = new HashSet();
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode node = (AblParseNode)this.jjtGetChild(i);
            assert (node.id == 9 || node.id == 28);
            explicitlyDeclaredVariables.addAll(((TestNode)node).getExplicitlyDeclaredVariableReferences());
            ++i;
        }
        Object[] behaviorArgs = ((ASTBehaviorDefinition)this.jjtGetParent().jjtGetParent()).getFormalArguments();
        int i2 = 0;
        while (i2 < behaviorArgs.length) {
            MethodArgDescriptor arg = (MethodArgDescriptor)behaviorArgs[i2];
            FieldDescriptor field = new FieldDescriptor();
            field.fieldType = arg.argType;
            field.addFieldName(arg.argName);
            explicitlyDeclaredVariables.remove(field);
            ++i2;
        }
        return explicitlyDeclaredVariables;
    }

    void compileOutgoingVariables(CodeBlockDescriptor desc) {
        Set<String> boundVariables = this.getBoundVariables();
        for (String variable : boundVariables) {
            String variableType = this.lookupVariableType(variable);
            if (ASTTestExpression.primitiveType(variableType)) {
                if (variableType.equals("int")) {
                    desc.addToBlockBody(new CodeStringDescriptor("__$variableTable.put(\"" + variable + "\"" + ", new Integer(" + variable + "));"));
                    continue;
                }
                if (variableType.equals("float")) {
                    desc.addToBlockBody(new CodeStringDescriptor("__$variableTable.put(\"" + variable + "\"" + ", new Float(" + variable + "));"));
                    continue;
                }
                if (variableType.equals("char")) {
                    desc.addToBlockBody(new CodeStringDescriptor("__$variableTable.put(\"" + variable + "\"" + ", new Char(" + variable + "));"));
                    continue;
                }
                if (variableType.equals("boolean")) {
                    desc.addToBlockBody(new CodeStringDescriptor("__$variableTable.put(\"" + variable + "\"" + ", new Boolean(" + variable + "));"));
                    continue;
                }
                if (variableType.equals("long")) {
                    desc.addToBlockBody(new CodeStringDescriptor("__$variableTable.put(\"" + variable + "\"" + ", new Long(" + variable + "));"));
                    continue;
                }
                if (variableType.equals("short")) {
                    desc.addToBlockBody(new CodeStringDescriptor("__$variableTable.put(\"" + variable + "\"" + ", new Short(" + variable + "));"));
                    continue;
                }
                if (variableType.equals("byte")) {
                    desc.addToBlockBody(new CodeStringDescriptor("__$variableTable.put(\"" + variable + "\"" + ", new Byte(" + variable + "));"));
                    continue;
                }
                if (!variableType.equals("double")) continue;
                desc.addToBlockBody(new CodeStringDescriptor("__$variableTable.put(\"" + variable + "\"" + ", new Double(" + variable + "));"));
                continue;
            }
            desc.addToBlockBody(new CodeStringDescriptor("__$variableTable.put(\"" + variable + "\"" + ", new ObjectWrapper(" + variable + "));"));
        }
    }

    CodeBlockDescriptor compileSensorActivationFactory() {
        HashSet referencedWMEs = this.getReferencedWMEs();
        if (referencedWMEs == null) {
            return null;
        }
        Iterator wmeIter = referencedWMEs.iterator();
        Vector<String> activations = new Vector<String>(referencedWMEs.size());
        try {
            while (wmeIter.hasNext()) {
                String sensorClassName = ASTBehaviorUnit.getBehaviorUnit().lookupRegisteredWME((String)wmeIter.next());
                if (sensorClassName == null) continue;
                String[] macroArgs = new String[]{sensorClassName};
                activations.add(sensorActivation.expand(macroArgs));
            }
        }
        catch (SimpleMacroException e) {
            throw new CompileError("Error compiling getSensorActivations", e);
        }
        if (activations.size() != 0) {
            Iterator activationIter = activations.iterator();
            CodeBlockDescriptor arrayInit = new CodeBlockDescriptor("SensorActivation[] __$activationArray = {", "};");
            while (activationIter.hasNext()) {
                String init = (String)activationIter.next();
                if (activationIter.hasNext()) {
                    arrayInit.addToBlockBody(new CodeStringDescriptor(String.valueOf(init) + ","));
                    continue;
                }
                arrayInit.addToBlockBody(new CodeStringDescriptor(init));
            }
            CodeBlockDescriptor sensorActivationBlock = new CodeBlockDescriptor();
            sensorActivationBlock.addToBlockBody(arrayInit);
            sensorActivationBlock.addToBlockBody(new CodeStringDescriptor("return __$activationArray;"));
            return sensorActivationBlock;
        }
        return null;
    }

    protected boolean allNegatedTests() {
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode node = (AblParseNode)this.jjtGetChild(i);
            if (node.id == 9 ? !((ASTWMETest)node).negated : node.id == 28) {
                return false;
            }
            ++i;
        }
        return true;
    }

    void compileToJava() throws CompileException {
        CodeBlockDescriptor test;
        int behaviorID;
        ASTBehaviorDefinition beh;
        if (this.testType == -1) {
            throw new CompileError("ASTTestExpression.compileToJava() called before setting the test type.");
        }
        this.setScopeType(2);
        this.setScopeParent(this.getEnclosingBehaviorScope());
        if (this.testType == 0 || this.testType == 1 || this.testType == 3 || this.testType == 4) {
            beh = (ASTBehaviorDefinition)this.jjtGetParent();
            behaviorID = beh.getID();
            test = new CodeBlockDescriptor("case " + behaviorID + ": {", "}");
            test.addToBlockBody(new CodeStringDescriptor("// " + beh.getUniqueName()));
        } else if (this.testType == 6) {
            test = new CodeBlockDescriptor("{//begin reinforcement signal test: " + this.signalValue.dumpTokens(), "}//end reinforcement signal test: " + this.signalValue.dumpTokens());
        } else if (this.testType == 5) {
            beh = (ASTBehaviorDefinition)this.jjtGetParent().jjtGetParent();
            behaviorID = beh.getID();
            test = new CodeBlockDescriptor("class stateTest" + behaviorID + "{//begin state condition", "}}//end state condition");
        } else {
            GenericStep step = (GenericStep)this.jjtGetParent();
            int stepID = step.getStepID();
            test = new CodeBlockDescriptor("case " + stepID + ": {", "}");
            test.addToBlockBody(new CodeStringDescriptor("// " + step.getUniqueName()));
        }
        if (this.testType == 0 || this.testType == 3) {
            this.compilePreconditionArguments();
            this.compileExplicitBehaviorScopeVariables();
        } else if (this.testType == 5) {
            this.compileExplicitStateScopeVariables();
        }
        Set<FieldDescriptor> variableRefs = this.preprocessVariableRefs();
        for (FieldDescriptor newVarDecl : variableRefs) {
            if (this.testType == 0 || this.testType == 2 || this.testType == 5) {
                this.addVariableDeclaration(newVarDecl);
            }
            if (this.testType != 0 && this.testType != 1 && this.testType != 3 && this.testType != 4 && this.testType != 5) continue;
            ((AblScopeMaintainer)this.jjtGetParent()).addVariableDeclaration(newVarDecl);
        }
        ListIterator varIter = this.fieldDescriptors.listIterator();
        while (varIter.hasNext()) {
            test.addToBlockBody((FieldDescriptor)varIter.next());
        }
        if (this.testType == 5) {
            test.addToBlockBody(new CodeStringDescriptor("boolean doTest(){"));
        }
        NestableCodeDescriptor testBody = this.compileTests();
        test.addToBlockBody(testBody);
        if (!this.allNegatedTests()) {
            test.addToBlockBody(new CodeStringDescriptor("return false;"));
        }
        ASTBehaviorUnit behUnit = ASTBehaviorUnit.getBehaviorUnit();
        switch (this.testType) {
            case 0: {
                behUnit.writePrecondition(test, (ASTBehaviorDefinition)this.jjtGetParent());
                break;
            }
            case 1: {
                behUnit.writeContextCondition(test, (ASTBehaviorDefinition)this.jjtGetParent());
                break;
            }
            case 4: {
                behUnit.writeSuccessCondition(test, (ASTBehaviorDefinition)this.jjtGetParent());
                break;
            }
            case 2: {
                behUnit.writeSuccessTest(test, (GenericStep)this.jjtGetParent());
                break;
            }
            case 3: {
                break;
            }
            case 6: {
                behUnit.writeReinforcementTest(test, (ASTBehaviorDefinition)this.jjtGetParent().jjtGetParent());
                break;
            }
            case 5: {
                behUnit.writeStateWME(test, (ASTBehaviorDefinition)this.jjtGetParent().jjtGetParent());
                break;
            }
            default: {
                throw new CompileError("Invalid testType " + this.testType);
            }
        }
    }
}

