/*
 * Decompiled with CFR 0.152.
 */
package abl.compiler;

import abl.compiler.ASTBehaviorDefinition;
import abl.compiler.ASTBehaviorUnit;
import abl.compiler.Abl;
import abl.compiler.AblDebuggerConstants;
import abl.compiler.AblParser;
import abl.compiler.CompileException;
import abl.compiler.GenericStep;
import jd.CodeBlockDescriptor;
import jd.CodeSequenceDescriptor;
import jd.CodeStringDescriptor;

public class ASTSucceedStep
extends GenericStep
implements AblDebuggerConstants {
    ASTSucceedStep(int id) {
        super(id);
    }

    ASTSucceedStep(AblParser p, int id) {
        super(p, id);
    }

    private CodeBlockDescriptor compileStepFactory() throws CompileException {
        CodeBlockDescriptor stepFactory = new CodeBlockDescriptor("case " + this.stepID + ": {", "}");
        stepFactory.addToBlockBody(new CodeStringDescriptor("// " + this.getUniqueName()));
        CodeSequenceDescriptor propertyTableInit = this.compilePropertyTable();
        if (propertyTableInit != null) {
            stepFactory.addToBlockBody(propertyTableInit);
        }
        if (!((ASTBehaviorDefinition)this.jjtGetParent()).isJoint() && this.teamEffectOnly) {
            throw new CompileException(this.getFirstLineNumber(), "a step of a non-joint behavior was annotated with team_effect_only");
        }
        if (this.effectOnly && this.teamEffectOnly) {
            throw new CompileException(this.getFirstLineNumber(), "a step can't be annotated as both effect_only and team_effect_only");
        }
        StringBuffer argString = new StringBuffer(500);
        argString.append(String.valueOf(this.stepID) + ", __$behaviorParent, " + this.ignoreFailure + ", " + this.effectOnly + ", " + this.teamEffectOnly + ", " + "(short)" + this.priority + ", " + "(short)" + this.priorityModifier + ", " + this.getPost() + ", ");
        if (this.getPostMemory() != null) {
            argString.append("\"" + this.getPostMemory() + "\"" + ", ");
        } else {
            argString.append("null, ");
        }
        if (this.hasProperties()) {
            argString.append("__$propertyTable");
        } else {
            argString.append("null");
        }
        if (Abl.debugLevel == 2) {
            stepFactory.addToBlockBody(new CodeStringDescriptor("return new SucceedStepDebug(" + argString.toString() + ");"));
        } else {
            stepFactory.addToBlockBody(new CodeStringDescriptor("return new SucceedStep(" + argString.toString() + ");"));
        }
        return stepFactory;
    }

    @Override
    void compileToJava() throws CompileException {
        ASTBehaviorUnit behaviorUnitNode = ASTBehaviorUnit.getBehaviorUnit();
        ASTBehaviorDefinition behaviorParent = (ASTBehaviorDefinition)this.jjtGetParent();
        if (this.hasModifiers()) {
            this.initStep(5);
            behaviorUnitNode.writeStepFactory(this.compileStepFactory(), this);
        } else {
            this.initStep(-1);
        }
        behaviorParent.addStep(this.stepID, this.getStepFactoryMethod_rField());
    }
}

