/*
 * Decompiled with CFR 0.152.
 */
package abl.compiler;

import abl.compiler.ASTAblExpression;
import abl.compiler.ASTAblVariableDecl;
import abl.compiler.ASTBehaviorDefinition;
import abl.compiler.ASTBehaviorUnit;
import abl.compiler.ASTJavaStatement;
import abl.compiler.ASTTestExpression;
import abl.compiler.AblParseNode;
import abl.compiler.AblParser;
import abl.compiler.AblScopeMaintainer;
import abl.compiler.CompileException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import jd.CodeBlockDescriptor;
import jd.CodeStringDescriptor;
import jd.FieldDescriptor;

public class ASTReinforcementState
extends AblScopeMaintainer {
    private List tupleList = new LinkedList();

    public ASTReinforcementState(int id) {
        super(id);
    }

    public ASTReinforcementState(AblParser p, int id) {
        super(p, id);
    }

    @Override
    AblScopeMaintainer getEnclosingBehaviorScope() {
        return this;
    }

    void addTupleEntry(ASTAblExpression tupleEntry) {
        this.tupleList.add(tupleEntry);
    }

    CodeStringDescriptor compileStateTupleAndClass() throws CompileException {
        ASTBehaviorUnit behUnit = ASTBehaviorUnit.getBehaviorUnit();
        ASTBehaviorDefinition beh = (ASTBehaviorDefinition)this.jjtGetParent();
        int behaviorID = beh.getID();
        String stateClassName = String.valueOf(behUnit.getBehavingEntityClass()) + "_State" + behaviorID;
        String tupleArgs = "";
        String ctorArgs = "";
        LinkedList<String> varTypes = new LinkedList<String>();
        CodeBlockDescriptor codeBlock = new CodeBlockDescriptor("public class " + stateClassName + " implements State {", "}");
        int i = 0;
        ListIterator tupleIter = this.tupleList.listIterator();
        while (tupleIter.hasNext()) {
            ASTAblExpression exp = (ASTAblExpression)tupleIter.next();
            String varType = exp.getType(this);
            String varName = exp.getFullNameOrLiteral();
            System.out.println(String.valueOf(varType) + " " + varName);
            if (!tupleArgs.equals("")) {
                tupleArgs = String.valueOf(tupleArgs) + ", ";
                ctorArgs = String.valueOf(ctorArgs) + ", ";
            }
            tupleArgs = String.valueOf(tupleArgs) + varName;
            ctorArgs = String.valueOf(ctorArgs) + varType + " arg" + i;
            String varTypeClass = varType;
            if (varTypeClass.equals("int")) {
                varTypeClass = "Integer";
            } else if (varTypeClass.equals("float")) {
                varTypeClass = "Float";
            } else if (varTypeClass.equals("double")) {
                varTypeClass = "Double";
            } else if (varTypeClass.equals("char")) {
                varTypeClass = "Char";
            } else if (varTypeClass.equals("boolean")) {
                varTypeClass = "Boolean";
            }
            varTypes.add(varTypeClass);
            codeBlock.addToBlockBody(new CodeStringDescriptor("private " + varTypeClass + " value" + i + ";"));
            ++i;
        }
        int varNum = i;
        i = 0;
        codeBlock.addToBlockBody(new CodeStringDescriptor("public " + stateClassName + "(" + ctorArgs + ") {"));
        tupleIter = varTypes.listIterator();
        while (tupleIter.hasNext()) {
            String varTypeClass = (String)tupleIter.next();
            codeBlock.addToBlockBody(new CodeStringDescriptor(" value" + i + " = new " + varTypeClass + "(arg" + i + ");"));
            ++i;
        }
        codeBlock.addToBlockBody(new CodeStringDescriptor("}"));
        String hashCodes = "";
        codeBlock.addToBlockBody(new CodeStringDescriptor("public int hashCode() {"));
        i = 0;
        while (i < varNum) {
            if (i > 0) {
                hashCodes = String.valueOf(hashCodes) + " + ";
            }
            hashCodes = String.valueOf(hashCodes) + "value" + i + ".hashCode()";
            ++i;
        }
        codeBlock.addToBlockBody(new CodeStringDescriptor(" return " + hashCodes + ";"));
        codeBlock.addToBlockBody(new CodeStringDescriptor("}"));
        codeBlock.addToBlockBody(new CodeStringDescriptor("public boolean equals(Object o) {"));
        codeBlock.addToBlockBody(new CodeStringDescriptor(" return (o instanceof " + stateClassName + ") ?"));
        i = 0;
        while (i < varNum) {
            String equals = "  ";
            if (i > 0) {
                equals = String.valueOf(equals) + "&& ";
            }
            equals = String.valueOf(equals) + "value" + i + ".equals(((" + stateClassName + ")o)." + "value" + i + ")";
            codeBlock.addToBlockBody(new CodeStringDescriptor(equals));
            ++i;
        }
        codeBlock.addToBlockBody(new CodeStringDescriptor(" :false;"));
        codeBlock.addToBlockBody(new CodeStringDescriptor("}"));
        behUnit.writeRawClass(codeBlock, stateClassName);
        return new CodeStringDescriptor("return new " + stateClassName + "(" + tupleArgs + ");");
    }

    private CodeBlockDescriptor compileSensorActivationFactory(int testType) {
        CodeBlockDescriptor sensorArray;
        ASTTestExpression test = null;
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode n = (AblParseNode)this.jjtGetChild(i);
            if (n.id == 8 && ((ASTTestExpression)n).getTestType() == testType) {
                test = (ASTTestExpression)n;
            }
            ++i;
        }
        if (test != null && (sensorArray = test.compileSensorActivationFactory()) != null) {
            int behaviorID = ((ASTBehaviorDefinition)this.jjtGetParent()).getID();
            CodeBlockDescriptor factorySwitchCase = new CodeBlockDescriptor("case " + behaviorID + ": {", "}");
            factorySwitchCase.addToBlockBody(sensorArray);
            return factorySwitchCase;
        }
        return null;
    }

    void compileToJava() throws CompileException {
        AblParseNode n;
        ASTBehaviorDefinition beh = (ASTBehaviorDefinition)this.jjtGetParent();
        this.setScopeName(String.valueOf(beh.getUniqueName()) + "_State");
        this.setScopeType(2);
        this.setScopeParent(beh);
        this.initializeScope();
        ASTBehaviorUnit behUnit = ASTBehaviorUnit.getBehaviorUnit();
        int behaviorID = beh.getID();
        CodeBlockDescriptor block = new CodeBlockDescriptor("case " + behaviorID + ": {", "");
        block.addToBlockBody(new CodeStringDescriptor("// " + beh.getUniqueName()));
        behUnit.writeStateWME(block, beh);
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            n = (AblParseNode)this.jjtGetChild(i);
            if (n.id == 8) {
                ((ASTTestExpression)n).compileToJava();
            }
            ++i;
        }
        String stateTestName = "stateTest" + behaviorID;
        block = new CodeBlockDescriptor("", "}");
        block.addToBlockBody(new CodeStringDescriptor(String.valueOf(stateTestName) + " theTest = new " + stateTestName + "();"));
        block.addToBlockBody(new CodeStringDescriptor("if (theTest.doTest()){"));
        List<FieldDescriptor> variableFields = this.getDeclaredVariables();
        ListIterator<FieldDescriptor> fieldIter = variableFields.listIterator();
        while (fieldIter.hasNext()) {
            FieldDescriptor field = fieldIter.next();
            String fieldName = field.getFieldNames()[0];
            block.addToBlockBody(new CodeStringDescriptor(String.valueOf(field.fieldType) + " " + fieldName + " = theTest." + fieldName + ";"));
        }
        int i2 = 0;
        while (i2 < this.jjtGetNumChildren()) {
            n = (AblParseNode)this.jjtGetChild(i2);
            if (n.id == 22) {
                FieldDescriptor[] fields = ((ASTAblVariableDecl)n).getFieldDescriptors(this);
                int x = 0;
                while (x < fields.length) {
                    this.addVariableDeclaration(fields[x]);
                    block.addToBlockBody(fields[x]);
                    ++x;
                }
            }
            if (n.id == 29) {
                block.addToBlockBody(new CodeStringDescriptor(((ASTJavaStatement)n).processVariableReferences(this)));
            }
            ++i2;
        }
        CodeStringDescriptor stateTuple = this.compileStateTupleAndClass();
        if (stateTuple != null) {
            block.addToBlockBody(stateTuple);
        }
        block.addToBlockBody(new CodeStringDescriptor("}"));
        block.addToBlockBody(new CodeStringDescriptor("throw new AblRuntimeError(\"State WME Test failed for behaviorID \" + __$behaviorID);"));
        behUnit.writeStateWME(block, beh);
        block = this.compileSensorActivationFactory(5);
        if (block != null) {
            behUnit.writeStateWMESensorActivation(block, beh);
        }
    }
}

