/*
 * Decompiled with CFR 0.152.
 */
package abl.compiler;

import abl.compiler.ASTBehaviorDefinition;
import abl.compiler.ASTBehaviorUnit;
import abl.compiler.ASTTestExpression;
import abl.compiler.AblParseNode;
import abl.compiler.AblParser;
import abl.compiler.AblScopeMaintainer;
import abl.compiler.CompileException;
import java.util.LinkedList;
import java.util.ListIterator;
import jd.CodeBlockDescriptor;
import jd.CodeStringDescriptor;

public class ASTReinforcementSignals
extends AblParseNode {
    public ASTReinforcementSignals(int id) {
        super(id);
    }

    public ASTReinforcementSignals(AblParser p, int id) {
        super(p, id);
    }

    @Override
    AblScopeMaintainer getEnclosingBehaviorScope() {
        return ((ASTBehaviorDefinition)this.jjtGetParent()).getEnclosingBehaviorScope();
    }

    private CodeBlockDescriptor compileSensorActivationFactory(int testType) {
        ASTTestExpression test = null;
        LinkedList<AblParseNode> testList = new LinkedList<AblParseNode>();
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode n = (AblParseNode)this.jjtGetChild(i);
            if (n.id == 8 && ((ASTTestExpression)n).getTestType() == testType) {
                testList.add(n);
            }
            ++i;
        }
        int x = 0;
        if (testList.size() > 0) {
            int behaviorID = ((ASTBehaviorDefinition)this.jjtGetParent()).getID();
            CodeBlockDescriptor factorySwitchCase = new CodeBlockDescriptor("case " + behaviorID + ": {", "}");
            ListIterator testIter = testList.listIterator();
            while (testIter.hasNext()) {
                test = (ASTTestExpression)testIter.next();
                CodeBlockDescriptor sensorArray = test.compileSensorActivationFactory();
                if (sensorArray == null) continue;
                factorySwitchCase.addToBlockBody(new CodeStringDescriptor("class Activation" + x + " {"));
                factorySwitchCase.addToBlockBody(new CodeStringDescriptor("SensorActivation[] doActivation() {"));
                factorySwitchCase.addToBlockBody(sensorArray);
                factorySwitchCase.addToBlockBody(new CodeStringDescriptor("}"));
                factorySwitchCase.addToBlockBody(new CodeStringDescriptor("}"));
                ++x;
            }
            int numActivations = x;
            x = 0;
            while (x < numActivations) {
                factorySwitchCase.addToBlockBody(new CodeStringDescriptor("SensorActivation[] __$activation" + x + " = (new Activation" + x + "()).doActivation();"));
                ++x;
            }
            factorySwitchCase.addToBlockBody(new CodeStringDescriptor("SensorActivation[] __$allActivations = new SensorActivation["));
            x = 0;
            while (x < numActivations) {
                String addBlock = x > 0 ? " + " : "   ";
                addBlock = String.valueOf(addBlock) + "__$activation" + x + ".length";
                factorySwitchCase.addToBlockBody(new CodeStringDescriptor(addBlock));
                ++x;
            }
            factorySwitchCase.addToBlockBody(new CodeStringDescriptor("];"));
            factorySwitchCase.addToBlockBody(new CodeStringDescriptor("int index = 0;"));
            x = 0;
            while (x < numActivations) {
                factorySwitchCase.addToBlockBody(new CodeStringDescriptor("for(int k = 0; k < __$activation" + x + ".length; ++k) {"));
                factorySwitchCase.addToBlockBody(new CodeStringDescriptor(" __$allActivations[index] = __$activation" + x + "[k];"));
                factorySwitchCase.addToBlockBody(new CodeStringDescriptor(" index += 1;"));
                factorySwitchCase.addToBlockBody(new CodeStringDescriptor("}"));
                ++x;
            }
            factorySwitchCase.addToBlockBody(new CodeStringDescriptor("return __$allActivations;"));
            return factorySwitchCase;
        }
        return null;
    }

    void compileToJava() throws CompileException {
        ASTBehaviorDefinition beh = (ASTBehaviorDefinition)this.jjtGetParent();
        int behaviorID = beh.getID();
        CodeBlockDescriptor block = new CodeBlockDescriptor("case " + behaviorID + ": {", "");
        block.addToBlockBody(new CodeStringDescriptor("// " + beh.getUniqueName()));
        ASTBehaviorUnit behUnit = ASTBehaviorUnit.getBehaviorUnit();
        behUnit.writeReinforcementTest(block, (ASTBehaviorDefinition)this.jjtGetParent());
        CodeBlockDescriptor mainBlock = new CodeBlockDescriptor("// run actual test", "}");
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode n = (AblParseNode)this.jjtGetChild(i);
            if (n.id == 8) {
                ASTTestExpression test = (ASTTestExpression)n;
                block = new CodeBlockDescriptor("class test" + i + "{", "boolean doTest()");
                behUnit.writeReinforcementTest(block, (ASTBehaviorDefinition)this.jjtGetParent());
                test.compileToJava();
                block = new CodeBlockDescriptor("}", "");
                behUnit.writeReinforcementTest(block, (ASTBehaviorDefinition)this.jjtGetParent());
                mainBlock.addToBlockBody(new CodeStringDescriptor("test" + i + " instance" + i + " = new test" + i + "();"));
                mainBlock.addToBlockBody(new CodeStringDescriptor("if (instance" + i + ".doTest())"));
                mainBlock.addToBlockBody(new CodeStringDescriptor("   return " + test.getSignalValue().dumpTokens() + ";"));
            }
            ++i;
        }
        mainBlock.addToBlockBody(new CodeStringDescriptor("return 0.0;"));
        behUnit.writeReinforcementTest(mainBlock, (ASTBehaviorDefinition)this.jjtGetParent());
        block = this.compileSensorActivationFactory(6);
        if (block != null) {
            behUnit.writeReinforcementTestSensorActivation(block, beh);
        }
    }
}

