/*
 * Decompiled with CFR 0.152.
 */
package abl.compiler;

import abl.compiler.ASTBehaviorDefinition;
import abl.compiler.ASTBehaviorUnit;
import abl.compiler.Abl;
import abl.compiler.AblArgument;
import abl.compiler.AblDebuggerConstants;
import abl.compiler.AblParser;
import abl.compiler.ArgumentStep;
import abl.compiler.CompileError;
import abl.compiler.CompileException;
import abl.compiler.RegisteredAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jd.CodeBlockDescriptor;
import jd.CodeSequenceDescriptor;
import jd.CodeStringDescriptor;

public class ASTPrimitiveStep
extends ArgumentStep
implements AblDebuggerConstants {
    String actName = null;

    ASTPrimitiveStep(int id) {
        super(id);
    }

    ASTPrimitiveStep(AblParser p, int id) {
        super(p, id);
    }

    private boolean assignable(String assignedFrom, String assignedTo) {
        block7: {
            block6: {
                try {
                    if (assignedFrom != null || ASTPrimitiveStep.primitiveType(assignedTo)) break block6;
                    return true;
                }
                catch (ClassNotFoundException e) {
                    throw new CompileError("Error compiling primitive step", e);
                }
            }
            if (!ASTPrimitiveStep.primitiveType(assignedFrom) || !ASTPrimitiveStep.primitiveType(assignedTo) || !assignedFrom.equals(assignedTo)) break block7;
            return true;
        }
        if (!ASTPrimitiveStep.primitiveType(assignedFrom) && !ASTPrimitiveStep.primitiveType(assignedTo)) {
            Class assignedFromClass = this.getClass(assignedFrom);
            Class assignedToClass = this.getClass(assignedTo);
            if (assignedToClass.isAssignableFrom(assignedFromClass)) {
                return true;
            }
        }
        return false;
    }

    private String determineActionClass(List<AblArgument> stepArguments) throws CompileException {
        List<RegisteredAction> registeredActions = ASTBehaviorUnit.getBehaviorUnit().lookupRegisteredAction(this.actName);
        ArrayList<String> actionToCall = new ArrayList<String>();
        if (registeredActions != null) {
            for (RegisteredAction action : registeredActions) {
                List<String> argTypes = action.argTypes;
                if (argTypes.size() != stepArguments.size()) continue;
                Iterator<String> registeredActionArgTypesIter = argTypes.iterator();
                Iterator<AblArgument> primitiveStepArgIter = stepArguments.iterator();
                boolean argumentsMatch = true;
                while (primitiveStepArgIter.hasNext()) {
                    String registeredActionArgType = registeredActionArgTypesIter.next().intern();
                    String primitiveStepArgType = primitiveStepArgIter.next().getType().intern();
                    if (this.assignable(primitiveStepArgType, registeredActionArgType)) continue;
                    argumentsMatch = false;
                    break;
                }
                if (!argumentsMatch) continue;
                actionToCall.add(action.actionClass);
            }
        } else {
            throw new CompileException("Line: " + this.getFirstLineNumber() + ". Attempt to call unregistered action " + this.actName);
        }
        if (actionToCall.size() == 0) {
            throw new CompileException("Line: " + this.getFirstLineNumber() + ". No registered action found for primitive step " + this.actName);
        }
        if (actionToCall.size() > 1) {
            throw new CompileException("Line: " + this.getFirstLineNumber() + ". Ambiguous registered actions found for primitive step " + this.actName);
        }
        return (String)actionToCall.get(0);
    }

    private CodeBlockDescriptor compilePrimitiveStepExecute(List<AblArgument> processedArgs) {
        assert (processedArgs != null);
        if (processedArgs.size() == 0) {
            return null;
        }
        CodeBlockDescriptor block = new CodeBlockDescriptor("case " + this.stepID + ": {", "}");
        block.addToBlockBody(new CodeStringDescriptor("// " + this.getUniqueName()));
        int argCount = processedArgs.size();
        block.addToBlockBody(new CodeStringDescriptor("final Object[] args = new Object[" + argCount + "];"));
        Iterator<AblArgument> iter = processedArgs.iterator();
        int i = 0;
        while (iter.hasNext()) {
            AblArgument arg = iter.next();
            block.addToBlockBody(new CodeStringDescriptor("args[" + i++ + "] = " + arg + ";"));
        }
        block.addToBlockBody(new CodeStringDescriptor("return args;"));
        return block;
    }

    private CodeBlockDescriptor compileStepFactory(List<AblArgument> processedArgs) throws CompileException {
        String conflictArrayName;
        CodeBlockDescriptor stepFactory = new CodeBlockDescriptor("case " + this.stepID + ": {", "}");
        stepFactory.addToBlockBody(new CodeStringDescriptor("// " + this.getUniqueName()));
        CodeSequenceDescriptor propertyTableInit = this.compilePropertyTable();
        if (propertyTableInit != null) {
            stepFactory.addToBlockBody(propertyTableInit);
        }
        String fullConflictArrayName = (conflictArrayName = this.compileConflictArray(this.actName)) != null ? this.getBehavingEntityField(conflictArrayName) : conflictArrayName;
        StringBuffer factoryBuf = new StringBuffer(1024);
        if (Abl.debugLevel == 2) {
            factoryBuf.append("return new PrimitiveStepDebug(");
        } else {
            factoryBuf.append("return new PrimitiveStep(");
        }
        factoryBuf.append(String.valueOf(this.standardConstructorArguments()) + ", new " + this.determineActionClass(processedArgs) + "(), " + fullConflictArrayName + ", \"" + this.actName + "\"");
        factoryBuf.append(");");
        stepFactory.addToBlockBody(new CodeStringDescriptor(factoryBuf.toString()));
        return stepFactory;
    }

    @Override
    final void compileToJava() throws CompileException {
        ASTBehaviorUnit behaviorUnitNode = ASTBehaviorUnit.getBehaviorUnit();
        this.initStep(0);
        List<AblArgument> processedArgs = this.processArgs();
        CodeBlockDescriptor actExecute = this.compilePrimitiveStepExecute(processedArgs);
        if (actExecute != null) {
            behaviorUnitNode.writeArgumentStepExecute(actExecute, this);
        }
        if (this.hasSuccessTest) {
            this.compileSuccessTest();
        }
        behaviorUnitNode.writeStepFactory(this.compileStepFactory(processedArgs), this);
        ((ASTBehaviorDefinition)this.jjtGetParent()).addStep(this.stepID, this.getStepFactoryMethod_rField());
    }
}

