/*
 * Decompiled with CFR 0.152.
 */
package abl.compiler;

import abl.compiler.ASTBehaviorDefinition;
import abl.compiler.ASTBehaviorUnit;
import abl.compiler.ASTJavaName;
import abl.compiler.Abl;
import abl.compiler.AblDebuggerConstants;
import abl.compiler.AblParser;
import abl.compiler.ArgumentStep;
import abl.compiler.CompileException;
import abl.compiler.GenericStep;
import jd.CodeBlockDescriptor;
import jd.CodeSequenceDescriptor;
import jd.CodeStringDescriptor;

public class ASTModifyStep
extends ArgumentStep
implements AblDebuggerConstants {
    public int fromIndex = -1;
    public int toIndex = -1;
    public boolean toAfter = false;
    public ASTJavaName inBehavior = null;
    private int childStepID = -4;
    private String childStepFactory = null;
    public static final short MOVESTEP = 0;
    public static final short DELETESTEP = 1;
    public static final short ADDSTEP = 2;
    public short modifyType = 0;
    private static final ASTBehaviorDefinition blankBeh = new ASTBehaviorDefinition(7);

    public ASTModifyStep(int id) {
        super(id);
    }

    public ASTModifyStep(AblParser p, int id) {
        super(p, id);
    }

    private CodeBlockDescriptor compileModifyStepExecute() throws CompileException {
        CodeBlockDescriptor block = new CodeBlockDescriptor("case " + this.stepID + ": {", "}");
        block.addToBlockBody(new CodeStringDescriptor("// " + this.getUniqueName()));
        int argCount = 1;
        block.addToBlockBody(new CodeStringDescriptor("final Object[] args = new Object[" + argCount + "];"));
        ASTBehaviorDefinition scope = (ASTBehaviorDefinition)this.jjtGetParent();
        String targetTypeName = this.inBehavior.lookupVariableType(scope);
        if (this.inBehavior.isVariableReference(scope)) {
            if (!targetTypeName.equals("SequentialBehaviorWME")) {
                throw new CompileException(this.getFirstLineNumber(), "Attempt to modify step in " + this.inBehavior.dumpTokens() + " with type " + targetTypeName + ". Modify target must be a SequentialBehaviorWME (or subtype).");
            }
        } else {
            throw new CompileException(this.getFirstLineNumber(), "Modify step target " + this.inBehavior.dumpTokens() + " is not a declared variable");
        }
        block.addToBlockBody(new CodeStringDescriptor("args[0] = " + this.inBehavior.getVariableReference(scope) + ";"));
        block.addToBlockBody(new CodeStringDescriptor("return args;"));
        return block;
    }

    private CodeBlockDescriptor compileStepFactory() throws CompileException {
        CodeBlockDescriptor stepFactory = new CodeBlockDescriptor("case " + this.stepID + ": {", "}");
        stepFactory.addToBlockBody(new CodeStringDescriptor("// " + this.getUniqueName()));
        CodeSequenceDescriptor propertyTableInit = this.compilePropertyTable();
        if (propertyTableInit != null) {
            stepFactory.addToBlockBody(propertyTableInit);
        }
        if (Abl.debugLevel == 2) {
            stepFactory.addToBlockBody(new CodeStringDescriptor("return new ModifyStepDebug(" + this.standardConstructorArguments() + ", (short)" + this.modifyType + ", " + this.childStepID + ", " + this.fromIndex + ", " + this.toIndex + ", " + this.childStepFactory + ");"));
        } else {
            stepFactory.addToBlockBody(new CodeStringDescriptor("return new ModifyStep(" + this.standardConstructorArguments() + ", (short)" + this.modifyType + ", " + this.childStepID + ", " + this.fromIndex + ", " + this.toIndex + ", " + this.childStepFactory + ");"));
        }
        return stepFactory;
    }

    @Override
    void compileToJava() throws CompileException {
        ASTBehaviorUnit behaviorUnitNode = ASTBehaviorUnit.getBehaviorUnit();
        ASTBehaviorDefinition behaviorParent = (ASTBehaviorDefinition)this.jjtGetParent();
        this.initStep(7);
        ASTModifyStep.blankBeh.behaviorName = String.valueOf(this.getUniqueName()) + "_Sub";
        switch (this.modifyType) {
            default: {
                throw new CompileException(this.getFirstLineNumber(), "Invalid modifyType for ASTModifyStep");
            }
            case 0: {
                System.out.print("ASTModifyStep.MOVESTEP ");
                System.out.print(((ASTJavaName)this.jjtGetChild(0)).getName());
                System.out.print(" " + this.fromIndex + " ");
                System.out.print(((ASTJavaName)this.jjtGetChild(1)).getName());
                System.out.print(" " + this.toIndex + " ");
                System.out.print(((ASTJavaName)this.jjtGetChild(2)).getName());
                System.out.print(" " + this.inBehavior.getName() + "\n");
                break;
            }
            case 1: {
                System.out.print("ASTModifyStep.DELETESTEP ");
                System.out.print(((ASTJavaName)this.jjtGetChild(0)).getName());
                System.out.print(" " + this.fromIndex + " ");
                System.out.print(((ASTJavaName)this.jjtGetChild(1)).getName());
                System.out.print(" " + this.inBehavior.getName() + "\n");
                break;
            }
            case 2: {
                System.out.print("ASTModifyStep.ADDSTEP ");
                System.out.print(((ASTJavaName)this.jjtGetChild(0)).getName());
                System.out.print(" " + this.fromIndex + " ");
                System.out.print(((ASTJavaName)this.jjtGetChild(1)).getName());
                System.out.print(" " + this.inBehavior.getName() + " ");
                GenericStep realStep = (GenericStep)this.jjtGetChild(3);
                System.out.print(realStep.dumpTokens());
                realStep.jjtSetParent(blankBeh);
                realStep.compileToJava();
                this.childStepID = realStep.stepID;
                this.childStepFactory = realStep.getStepFactoryMethod_rField();
                if (this.childStepFactory == null) {
                    this.childStepFactory = "__$stepFactory0_rfield";
                }
                this.childStepFactory = this.getBehavingEntityField(this.childStepFactory);
                System.out.print(" (" + this.childStepID + ", " + this.childStepFactory + ")");
                System.out.print("\n");
            }
        }
        CodeBlockDescriptor modifyExecute = this.compileModifyStepExecute();
        if (modifyExecute != null) {
            behaviorUnitNode.writeArgumentStepExecute(modifyExecute, this);
        }
        if (this.hasSuccessTest) {
            this.compileSuccessTest();
        }
        behaviorUnitNode.writeStepFactory(this.compileStepFactory(), this);
        behaviorParent.addStep(this.stepID, this.getStepFactoryMethod_rField());
    }
}

