/*
 * Decompiled with CFR 0.152.
 */
package abl.compiler;

import abl.compiler.ASTBehaviorUnit;
import abl.compiler.ASTWMEFieldTest;
import abl.compiler.AblParseNode;
import abl.compiler.AblParser;
import abl.compiler.AblScopeMaintainer;
import abl.compiler.CompileError;
import abl.compiler.CompileException;
import abl.compiler.ScopeException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ASTJavaName
extends AblParseNode {
    static final String getReflectionWME = "getReflectionWME";

    ASTJavaName(int id) {
        super(id);
    }

    ASTJavaName(AblParser p, int id) {
        super(p, id);
    }

    int lookupVariableScope(AblScopeMaintainer scope) {
        String variableName = this.dumpTokens(0, 1);
        return scope.lookupVariableScope(variableName);
    }

    String lookupVariableType(AblScopeMaintainer scope) {
        String variableName = this.dumpTokens(0, 1);
        return scope.lookupVariableType(variableName);
    }

    private int getBehaviorFrameIndex(AblScopeMaintainer scope) {
        assert (this.lookupVariableScope(scope) == 1);
        return scope.getBehaviorFrameIndex(this.dumpTokens(0, 1));
    }

    String getName() {
        return this.dumpTokens(0, 1);
    }

    String getFullName() {
        return this.dumpTokens();
    }

    private String getRestOfName() {
        return this.dumpTokens(1, this.numberOfTokens());
    }

    boolean isSimpleRef() {
        return this.getName().equals(this.getFullName());
    }

    String lookupFieldType(AblScopeMaintainer scope) throws CompileException {
        String type = this.lookupVariableType(scope);
        if (this.numberOfTokens() == 1) {
            return type;
        }
        int numTok = this.numberOfTokens();
        assert (numTok % 2 == 1);
        for (int tokenCounter = 2; tokenCounter < numTok; tokenCounter += 2) {
            String currentField = this.dumpTokens(tokenCounter, numTok);
            try {
                type = this.getFieldType(type, currentField).getName();
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new CompileException("Class not found in variable reference. " + e.getMessage());
            }
            catch (NoSuchFieldException e) {
                throw new CompileException("No such field found in variable reference. " + e.getMessage());
            }
        }
        return type;
    }

    boolean isVariableReference(AblScopeMaintainer scope) {
        int scopeType = this.lookupVariableScope(scope);
        return scopeType != -1;
    }

    Method getMethod() throws CompileException {
        if (this.numberOfTokens() == 1) {
            return null;
        }
        try {
            int numTok = this.numberOfTokens();
            assert (numTok % 2 == 1);
            Class type = this.getClass(this.dumpTokens(0, 1));
            String typeName = type.getName();
            int tokenCounter = 2;
            while (tokenCounter < numTok - 1) {
                type = this.getFieldType(typeName, this.dumpTokens(tokenCounter, tokenCounter + 1));
                typeName = type.getName();
                tokenCounter += 2;
            }
            return type.getMethod(this.dumpTokens(numTok - 1, numTok), null);
        }
        catch (ClassNotFoundException e) {
            throw new CompileException(this.getFirstLineNumber(), "Class not found in method reference. " + e.getMessage());
        }
        catch (NoSuchFieldException e) {
            throw new CompileException(this.getFirstLineNumber(), "Field not found in method reference. " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    String getVariableReference(AblScopeMaintainer scope) throws ScopeException {
        int scopeType = this.lookupVariableScope(scope);
        switch (scopeType) {
            case 0: {
                String behavingEntityClassName = ASTBehaviorUnit.getBehaviorUnit().getBehavingEntityClass();
                return "((" + behavingEntityClassName + ")__$thisEntity)." + this.getFullName();
            }
            case 1: {
                int behaviorFrameIndex = this.getBehaviorFrameIndex(scope);
                String frameRef = new String("__$behaviorFrame");
                String varType = this.lookupVariableType(scope);
                if (ASTJavaName.primitiveType(varType)) {
                    if (varType.equals("int")) {
                        return "((__ValueTypes.IntVar)" + frameRef + "[" + behaviorFrameIndex + "]).i";
                    }
                    if (varType.equals("float")) {
                        return "((__ValueTypes.FloatVar)" + frameRef + "[" + behaviorFrameIndex + "]).f";
                    }
                    if (varType.equals("char")) {
                        return "((__ValueTypes.CharVar)" + frameRef + "[" + behaviorFrameIndex + "]).c";
                    }
                    if (varType.equals("boolean")) {
                        return "((__ValueTypes.BooleanVar)" + frameRef + "[" + behaviorFrameIndex + "]).b";
                    }
                    if (varType.equals("long")) {
                        return "((__ValueTypes.LongVar)" + frameRef + "[" + behaviorFrameIndex + "]).l";
                    }
                    if (varType.equals("short")) {
                        return "((__ValueTypes.ShortVar)" + frameRef + "[" + behaviorFrameIndex + "]).s";
                    }
                    if (varType.equals("byte")) {
                        return "((__ValueTypes.ByteVar)" + frameRef + "[" + behaviorFrameIndex + "]).b";
                    }
                    if (varType.equals("double")) {
                        return "((__ValueTypes.DoubleVar)" + frameRef + "[" + behaviorFrameIndex + "]).d";
                    }
                    throw new CompileError("Unexpected primitive type " + varType);
                }
                if (this.isSimpleRef()) {
                    if (this.isLValue()) {
                        return String.valueOf(frameRef) + "[" + behaviorFrameIndex + "]";
                    }
                    return "((" + varType + ")" + frameRef + "[" + behaviorFrameIndex + "])";
                }
                return "((" + varType + ")" + frameRef + "[" + behaviorFrameIndex + "])" + this.getRestOfName();
            }
            case 2: {
                return this.getFullName();
            }
        }
        throw new ScopeException(this.getFullName());
    }

    String getVariableReferenceAsObject(AblScopeMaintainer scope) throws ScopeException {
        String variableRefString = this.getVariableReference(scope);
        String variableType = this.lookupVariableType(scope);
        if (variableType.equals("int")) {
            return "new Integer(" + variableRefString + ")";
        }
        if (variableType.equals("long")) {
            return "new Long(" + variableRefString + ")";
        }
        if (variableType.equals("short")) {
            return "new Short(" + variableRefString + ")";
        }
        if (variableType.equals("float")) {
            return "new Float(" + variableRefString + ")";
        }
        if (variableType.equals("double")) {
            return "new Double(" + variableRefString + ")";
        }
        if (variableType.equals("char")) {
            return "new Character(" + variableRefString + ")";
        }
        if (variableType.equals("boolean")) {
            return "new Boolean(" + variableRefString + ")";
        }
        return variableRefString;
    }

    String getVariableReferenceOrConstant(AblScopeMaintainer scope) throws CompileException {
        try {
            return this.getVariableReference(scope);
        }
        catch (ScopeException e1) {
            String variableName = this.dumpTokens();
            Field constant = ASTBehaviorUnit.getBehaviorUnit().getDeclaredConstant(variableName);
            if (constant != null) {
                Object value;
                String constantType = constant.getType().getName();
                try {
                    value = constant.get(null);
                }
                catch (IllegalAccessException e2) {
                    throw new CompileException(this.getFirstLineNumber(), "Illegal access exception while processing constant " + variableName);
                }
                if (!(constantType.equals("int") || constantType.equals("float") || constantType.equals("double") || constantType.equals("char") || constantType.equals("String") || constantType.equals("boolean"))) {
                    throw new CompileException(this.getFirstLineNumber(), "Constant " + variableName + " of type " + constantType + " has an unrecognized type.");
                }
                if (constantType.equals("String")) {
                    return "\"" + value.toString() + "\"";
                }
                return value.toString();
            }
            throw new CompileException(this.getFirstLineNumber(), "The variable " + variableName + " is not defined in any scope nor is it a constant.");
        }
    }

    String getVariableReferenceOrConstantAsObject(AblScopeMaintainer scope) throws CompileException {
        try {
            return this.getVariableReferenceAsObject(scope);
        }
        catch (ScopeException e1) {
            String variableName = this.dumpTokens();
            Field constant = ASTBehaviorUnit.getBehaviorUnit().getDeclaredConstant(variableName);
            if (constant != null) {
                Object value;
                String constantType = constant.getType().getName();
                try {
                    value = constant.get(null);
                }
                catch (IllegalAccessException e2) {
                    throw new CompileException(this.getFirstLineNumber(), "Illegal access exception while processing constant " + variableName);
                }
                if (constantType.equals("int")) {
                    return "new Integer(" + value + ")";
                }
                if (constantType.equals("float")) {
                    return "new Float(" + value + ")";
                }
                if (constantType.equals("double")) {
                    return "new Double(" + value + ")";
                }
                if (constantType.equals("char")) {
                    return "new Character(" + value + ")";
                }
                if (constantType.equals("boolean")) {
                    return "new Boolean(" + value + ")";
                }
                if (constantType.equals("String")) {
                    return "new String(\"" + value + "\")";
                }
                throw new CompileException(this.getFirstLineNumber(), "Constant " + variableName + " of type " + constantType + " has an unrecognized type.");
            }
            throw new CompileException(this.getFirstLineNumber(), "The variable " + variableName + " is not defined in any scope nor is it a constant.");
        }
    }

    boolean isConstant(AblScopeMaintainer scope) throws CompileException {
        if (this.isVariableReference(scope)) {
            return false;
        }
        String constantName = this.dumpTokens();
        return ASTBehaviorUnit.getBehaviorUnit().getDeclaredConstant(constantName) != null;
    }

    Object getConstantValue() throws CompileException {
        String variableName = this.dumpTokens();
        Field constant = ASTBehaviorUnit.getBehaviorUnit().getDeclaredConstant(variableName);
        if (constant != null) {
            Object value;
            String constantType = constant.getType().getName();
            try {
                value = constant.get(null);
            }
            catch (IllegalAccessException e) {
                throw new CompileException(this.getFirstLineNumber(), "Illegal access exception while processing constant " + variableName);
            }
            if (!(constantType.equals("int") || constantType.equals("float") || constantType.equals("double") || constantType.equals("char") || constantType.equals("String") || constantType.equals("boolean"))) {
                throw new CompileException(this.getFirstLineNumber(), "Constant " + variableName + " of type " + constantType + " has an unrecognized type.");
            }
            return value;
        }
        throw new CompileException(this.getFirstLineNumber(), "The variable " + variableName + " is not defined in any scope nor is it a constant.");
    }

    String getConstantType() throws CompileException {
        String constantName = this.dumpTokens();
        Field constant = ASTBehaviorUnit.getBehaviorUnit().getDeclaredConstant(constantName);
        if (constant != null) {
            return constant.getType().getName();
        }
        throw new CompileException(this.getFirstLineNumber(), "The constant " + constantName + " is not defined");
    }

    String getConstantString() throws CompileException {
        return this.getConstantValue().toString();
    }

    void setJavaNameImage(String image) {
        this.firstToken.image = image;
        this.firstToken.kind = 129;
        this.firstToken.next = this.lastToken.next;
        this.lastToken = this.firstToken;
    }

    String getType(AblScopeMaintainer scope) throws CompileException {
        if (this.isVariableReference(scope)) {
            return this.lookupFieldType(scope);
        }
        if (this.isConstant(scope)) {
            return this.getConstantType();
        }
        throw new CompileException(this.getFirstLineNumber(), "The expression " + this.dumpTokens(0, 1) + " is neither a declared variable nor constant");
    }

    boolean isLValue() {
        int nt = this.lastToken.next.kind;
        AblParseNode parent2 = (AblParseNode)this.jjtGetParent().jjtGetParent();
        return nt == 141 || nt == 167 || nt == 168 || nt == 169 || nt == 170 || nt == 171 || nt == 172 || nt == 173 || nt == 174 || nt == 175 || nt == 176 || nt == 177 || parent2.id == 10 && ((ASTWMEFieldTest)parent2).testOp == 112;
    }

    void rewriteSpecialMethods() {
        if (this.firstToken == this.lastToken && this.lastToken.next.kind == 132 && this.firstToken.image.equals(getReflectionWME)) {
            this.firstToken.image = "__$thisStep.getReflectionWME";
        }
    }
}

