/*
 * Decompiled with CFR 0.152.
 */
package abl.compiler;

import abl.compiler.ASTBehaviorDefinition;
import abl.compiler.ASTBehaviorUnit;
import abl.compiler.ASTJavaName;
import abl.compiler.Abl;
import abl.compiler.AblArgument;
import abl.compiler.AblDebuggerConstants;
import abl.compiler.AblParser;
import abl.compiler.ArgumentStep;
import abl.compiler.CompileException;
import abl.compiler.GenericStep;
import java.util.Iterator;
import java.util.List;
import jd.CodeBlockDescriptor;
import jd.CodeSequenceDescriptor;
import jd.CodeStringDescriptor;

public class ASTGoalStep
extends ArgumentStep
implements AblDebuggerConstants {
    String goalName = null;
    private boolean teamNeededForSuccess = false;
    private boolean teamSuccessModifierExplicitlySet = false;
    private List<AblArgument> processedArgs;
    private short goalExecutionType = 0;
    private boolean isJointGoal = false;
    private boolean isNestedScope = false;
    private ASTJavaName rerootParent = null;

    ASTGoalStep(int id) {
        super(id);
    }

    ASTGoalStep(AblParser p, int id) {
        super(p, id);
    }

    ASTGoalStep(int id, GenericStep g) {
        super(id, g);
    }

    void setGoalExecutionType(short goalExecutionType) {
        this.goalExecutionType = goalExecutionType;
    }

    int getGoalExecutionType() {
        return this.goalExecutionType;
    }

    void setJointGoal() {
        this.isJointGoal = true;
    }

    boolean isJointGoal() {
        return this.isJointGoal;
    }

    void setNestedScope(boolean isNested) {
        this.isNestedScope = isNested;
    }

    boolean isNestedScope() {
        return this.isNestedScope;
    }

    void setTeamNeededForSuccess(boolean b) {
        this.teamNeededForSuccess = b;
        this.teamSuccessModifierExplicitlySet = true;
    }

    boolean getTeamNeededForSuccess() {
        return this.teamNeededForSuccess;
    }

    String getSignature() {
        assert (this.processedArgs != null);
        StringBuffer signatureBuf = new StringBuffer();
        signatureBuf.append(String.valueOf(this.goalName) + "(");
        Iterator<AblArgument> iter = this.processedArgs.iterator();
        while (iter.hasNext()) {
            String type = iter.next().getType();
            signatureBuf.append(String.valueOf(type.substring(type.lastIndexOf(46) + 1)) + ", ");
        }
        if (this.processedArgs.size() != 0) {
            signatureBuf.delete(signatureBuf.length() - 2, signatureBuf.length());
        }
        signatureBuf.append(")");
        return signatureBuf.toString().intern();
    }

    void setRerootParent(ASTJavaName p) {
        this.rerootParent = p;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CodeBlockDescriptor compileGoalStepExecute() throws CompileException {
        CodeBlockDescriptor block = new CodeBlockDescriptor("case " + this.stepID + ": {", "}");
        block.addToBlockBody(new CodeStringDescriptor("// " + this.getUniqueName()));
        assert (this.processedArgs != null);
        if (this.processedArgs.size() == 0 && this.rerootParent == null) {
            if (!this.isNestedScope) {
                return null;
            }
            block.addToBlockBody(new CodeStringDescriptor("final Object[] args = __$behaviorFrame;"));
        } else {
            int argCount = this.rerootParent == null ? this.processedArgs.size() : this.processedArgs.size() + 1;
            block.addToBlockBody(new CodeStringDescriptor("final Object[] args = new Object[" + argCount + "];"));
            if (this.rerootParent != null) {
                ASTBehaviorDefinition scope = (ASTBehaviorDefinition)this.jjtGetParent();
                String rerootParentTypeName = this.rerootParent.lookupVariableType(scope);
                if (!this.rerootParent.isVariableReference(scope)) throw new CompileException(this.getFirstLineNumber(), "Spawngoal reroot parent " + this.rerootParent.dumpTokens() + " is not a declared variable");
                if (!rerootParentTypeName.equals("MultiStepBehaviorWME") && !rerootParentTypeName.equals("CollectionBehaviorWME") && !rerootParentTypeName.equals("ParallelBehaviorWME") && !rerootParentTypeName.equals("abl.runtime.MultiStepBehaviorWME") && !rerootParentTypeName.equals("abl.runtime.CollectionBehaviorWME") && !rerootParentTypeName.equals("abl.runtime.ParallelBehaviorWME")) throw new CompileException(this.getFirstLineNumber(), "Attempt to spawn goal at parent " + this.rerootParent.dumpTokens() + " with type " + rerootParentTypeName + ". Reroot parent must be a MultiStepBehaviorWME (or subtype).");
                block.addToBlockBody(new CodeStringDescriptor("args[0] = " + this.rerootParent.getVariableReference(scope) + ";"));
            }
            Iterator<AblArgument> iter = this.processedArgs.iterator();
            int i = this.rerootParent == null ? 0 : 1;
            while (iter.hasNext()) {
                AblArgument arg = iter.next();
                block.addToBlockBody(new CodeStringDescriptor("args[" + i++ + "] = " + arg + ";"));
            }
        }
        block.addToBlockBody(new CodeStringDescriptor("return args;"));
        return block;
    }

    private CodeBlockDescriptor compileStepFactory() throws CompileException {
        String conflictArrayName;
        CodeBlockDescriptor stepFactory = new CodeBlockDescriptor("case " + this.stepID + ": {", "}");
        stepFactory.addToBlockBody(new CodeStringDescriptor("// " + this.getUniqueName()));
        CodeSequenceDescriptor propertyTableInit = this.compilePropertyTable();
        if (propertyTableInit != null) {
            stepFactory.addToBlockBody(propertyTableInit);
        }
        String fullConflictArrayName = (conflictArrayName = this.compileConflictArray(this.goalName)) != null ? this.getBehavingEntityField(conflictArrayName) : conflictArrayName;
        StringBuffer factoryBuf = new StringBuffer(1024);
        factoryBuf.append("return ");
        if (this.isJointGoal && Abl.debugLevel != 0) {
            factoryBuf.append("new JointGoalStepDebug(");
        } else if (this.isJointGoal && Abl.debugLevel == 0) {
            factoryBuf.append("new JointGoalStep(");
        } else if (!this.isJointGoal && Abl.debugLevel == 2) {
            factoryBuf.append("new GoalStepDebug(");
        } else {
            factoryBuf.append("new GoalStep(");
        }
        factoryBuf.append(String.valueOf(this.standardConstructorArguments()) + ", " + "\"" + this.getSignature() + "\"" + ", " + fullConflictArrayName + ", (short)" + this.goalExecutionType);
        if (this.isJointGoal) {
            if (this.teamSuccessModifierExplicitlySet) {
                factoryBuf.append(", " + this.teamNeededForSuccess);
            } else {
                factoryBuf.append(", " + ASTBehaviorUnit.getBehaviorUnit().getTeamNeededForSuccess());
            }
        }
        if (this.isJointGoal && Abl.debugLevel != 0) {
            factoryBuf.append(", (byte)" + Abl.debugLevel);
        }
        factoryBuf.append(");");
        stepFactory.addToBlockBody(new CodeStringDescriptor(factoryBuf.toString()));
        return stepFactory;
    }

    @Override
    final void compileToJava() throws CompileException {
        ASTBehaviorUnit behaviorUnitNode = ASTBehaviorUnit.getBehaviorUnit();
        ASTBehaviorDefinition behaviorParent = (ASTBehaviorDefinition)this.jjtGetParent();
        this.initStep(1);
        if (this.teamSuccessModifierExplicitlySet && !this.isJointGoal) {
            if (this.teamNeededForSuccess) {
                throw new CompileException(this.getFirstLineNumber(), "team_needed_for_success modifier declared on a non-joint goal");
            }
            throw new CompileException(this.getFirstLineNumber(), "one_needed_for_success modifier declared on a non-joint goal");
        }
        this.processedArgs = this.processArgs();
        CodeBlockDescriptor goalExecute = this.compileGoalStepExecute();
        if (goalExecute != null) {
            behaviorUnitNode.writeArgumentStepExecute(goalExecute, this);
        }
        if (this.hasSuccessTest) {
            this.compileSuccessTest();
        }
        behaviorUnitNode.writeStepFactory(this.compileStepFactory(), this);
        behaviorParent.addStep(this.stepID, this.getStepFactoryMethod_rField());
    }

    public String getGoalName() {
        return this.goalName;
    }

    public List getProcessedArgs() {
        return this.processedArgs;
    }
}

