/*
 * Decompiled with CFR 0.152.
 */
package abl.compiler;

import abl.compiler.ASTJavaName;
import abl.compiler.ASTTestExpression;
import abl.compiler.AblParseNode;
import abl.compiler.AblParser;
import abl.compiler.AblParserTreeConstants;
import abl.compiler.AblScopeMaintainer;
import abl.compiler.CompileException;
import abl.compiler.ScopeException;
import abl.compiler.SimpleNode;
import abl.compiler.TestNode;
import java.util.HashSet;
import java.util.Set;
import jd.CodeBlockDescriptor;
import jd.CodeStringDescriptor;
import jd.FieldDescriptor;
import jd.JavaCodeDescriptor;

public class ASTConditionalExpression
extends TestNode
implements AblParserTreeConstants {
    ASTConditionalExpression(int id) {
        super(id);
    }

    ASTConditionalExpression(AblParser p, int id) {
        super(p, id);
    }

    void processVariableReferences(AblScopeMaintainer scope) {
        boolean rewriteBehaviorScopeRefs = ((SimpleNode)this.jjtGetParent()).id != 8 || ((ASTTestExpression)this.jjtGetParent()).getTestType() != 0;
        this.processVariableReferences(scope, rewriteBehaviorScopeRefs);
    }

    private void processVariableReferences(AblScopeMaintainer scope, boolean rewriteBehaviorScopeRefs) {
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode n = (AblParseNode)this.jjtGetChild(i);
            if (n.id == 27) {
                ASTJavaName jName = (ASTJavaName)n;
                int scopeType = scope.lookupVariableScope(jName.getName());
                try {
                    if (rewriteBehaviorScopeRefs || scopeType != 1) {
                        jName.setJavaNameImage(jName.getVariableReference(scope));
                    }
                }
                catch (ScopeException e) {
                    jName.rewriteSpecialMethods();
                }
            } else if (n.id == 28) {
                ((ASTConditionalExpression)n).processVariableReferences(scope, rewriteBehaviorScopeRefs);
            }
            ++i;
        }
    }

    @Override
    Set<String> getBoundVariables() {
        HashSet<String> boundVariables = new HashSet<String>();
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode node = (AblParseNode)this.jjtGetChild(i);
            if (node.id == 27) {
                ASTJavaName jName = (ASTJavaName)node;
                AblScopeMaintainer scope = ((AblParseNode)this.jjtGetParent()).getEnclosingBehaviorScope();
                int scopeType = scope.lookupVariableScope(jName.getName());
                if (scopeType == 1 && jName.isLValue()) {
                    boundVariables.add(jName.getName());
                }
            } else if (node.id == 28) {
                boundVariables.addAll(((ASTConditionalExpression)node).getBoundVariables());
            }
            ++i;
        }
        return boundVariables;
    }

    @Override
    AblScopeMaintainer getEnclosingBehaviorScope() {
        AblParseNode n = (AblParseNode)this.jjtGetParent();
        assert (n.id == 28 || n.id == 8);
        return n.getEnclosingBehaviorScope();
    }

    @Override
    final Set<FieldDescriptor> getExplicitlyDeclaredVariableReferences() {
        HashSet<FieldDescriptor> declaredVariableReferences = new HashSet<FieldDescriptor>();
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode node = (AblParseNode)this.jjtGetChild(i);
            if (node.id == 27) {
                ASTJavaName jName = (ASTJavaName)node;
                AblScopeMaintainer scope = ((AblParseNode)this.jjtGetParent()).getEnclosingBehaviorScope();
                int scopeType = scope.lookupVariableScope(jName.getName());
                if (scopeType == 1) {
                    FieldDescriptor variable = scope.lookupVariable(jName.getName());
                    declaredVariableReferences.add(variable);
                }
            } else if (node.id == 28) {
                declaredVariableReferences.addAll(((ASTConditionalExpression)node).getExplicitlyDeclaredVariableReferences());
            }
            ++i;
        }
        return declaredVariableReferences;
    }

    @Override
    JavaCodeDescriptor compileToJava() throws CompileException {
        CodeBlockDescriptor ifTest = new CodeBlockDescriptor("if (", ")");
        AblScopeMaintainer scope = ((ASTTestExpression)this.jjtGetParent()).getEnclosingBehaviorScope();
        this.processVariableReferences(scope);
        ifTest.addToBlockBody(new CodeStringDescriptor(this.prettyPrintTokens()));
        CodeBlockDescriptor ifBody = new CodeBlockDescriptor("{", "}");
        if (((ASTTestExpression)this.jjtGetParent()).hasNextTest()) {
            ifBody.addToBlockBody(((ASTTestExpression)this.jjtGetParent()).compileNextTest());
        } else {
            if (((ASTTestExpression)this.jjtGetParent()).getTestType() == 0) {
                ((ASTTestExpression)this.jjtGetParent()).compileOutgoingVariables(ifBody);
            }
            ifBody.addToBlockBody(new CodeStringDescriptor("return true;"));
        }
        CodeBlockDescriptor test = new CodeBlockDescriptor();
        test.addToBlockBody(ifTest);
        test.addToBlockBody(ifBody);
        return test;
    }
}

