/*
 * Decompiled with CFR 0.152.
 */
package abl.compiler;

import abl.compiler.ASTActionRegistration;
import abl.compiler.ASTBehaviorDefinition;
import abl.compiler.ASTJavaName;
import abl.compiler.ASTMentalStep;
import abl.compiler.ASTPropertyDeclaration;
import abl.compiler.ASTWMEDecl;
import abl.compiler.ASTWMERegistration;
import abl.compiler.Abl;
import abl.compiler.AblDebuggerConstants;
import abl.compiler.AblParseNode;
import abl.compiler.AblParser;
import abl.compiler.AblParserTreeConstants;
import abl.compiler.AblScopeMaintainer;
import abl.compiler.ArgumentStep;
import abl.compiler.CompileError;
import abl.compiler.CompileException;
import abl.compiler.GenericStep;
import abl.compiler.MacroDefinitions;
import abl.compiler.RegisteredAction;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.constant.Constable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import jd.ClassDescriptor;
import jd.CodeBlockDescriptor;
import jd.CodeSequenceDescriptor;
import jd.CodeStringDescriptor;
import jd.FieldDescriptor;
import jd.MethodArgDescriptor;
import jd.MethodDescriptor;
import macro.SimpleMacro;
import macro.SimpleMacroException;

public class ASTBehaviorUnit
extends AblScopeMaintainer
implements MacroDefinitions,
AblParserTreeConstants,
AblDebuggerConstants {
    private final int BEHAVIOR_FACTORY_LIMIT = 225;
    private final int PRECONDITION_SENSOR_FACTORY_LIMIT = 1000;
    private final int CONTEXT_CONDITION_SENSOR_FACTORY_LIMIT = 1000;
    private final int SUCCESS_CONDITION_SENSOR_FACTORY_LIMIT = 1000;
    private final int SUCCESS_TEST_SENSOR_FACTORY_LIMIT = 1000;
    private final int REINFORCEMENT_TEST_SENSOR_FACTORY_LIMIT = 1000;
    private final int STATE_WME_SENSOR_FACTORY_LIMIT = 300;
    private final int CONTEXT_CONDITION_LIMIT = 300;
    private final int SUCCESS_CONDITION_LIMIT = 300;
    private final int SUCCESS_TEST_LIMIT = 300;
    private final int REINFORCEMENT_TEST_LIMIT = 300;
    private final int STATE_WME_LIMIT = 300;
    private final int PRECONDITION_LIMIT = 300;
    private final int STEP_FACTORY_LIMIT = 1000;
    private final int STEP_EXECUTE_LIMIT = 250;
    private final int INIT_CONFLICT_SET_METHOD_SIZE = 40000;
    static final int DEFAULT_SUCCEED_STEP_ID = -1;
    static final int DEFAULT_FAIL_STEP_ID = -2;
    static final int DEFAULT_WAIT_STEP_ID = -3;
    static final short DEFAULT_SUCCEED_STEP = -1;
    static final short DEFAULT_FAIL_STEP = -2;
    static final short DEFAULT_WAIT_STEP = -3;
    private static final CodeBlockDescriptor DEFAULT_WAIT_STEP_FACTORY = new CodeBlockDescriptor("case -3: {", "}");
    private static final CodeBlockDescriptor DEFAULT_FAIL_STEP_FACTORY;
    private static final CodeBlockDescriptor DEFAULT_SUCCEED_STEP_FACTORY;
    private static final CodeBlockDescriptor DEFAULT_WAIT_STEP_FACTORY_DEBUG;
    private static final CodeBlockDescriptor DEFAULT_FAIL_STEP_FACTORY_DEBUG;
    private static final CodeBlockDescriptor DEFAULT_SUCCEED_STEP_FACTORY_DEBUG;
    protected static final String[] packageMods;
    protected static final String[] privateMods;
    protected String behavingEntityClass;
    String behavingEntityPackage = null;
    protected static final String[] importPackages;
    private List<String> userImportPackages = new ArrayList<String>();
    private List<String> userImportClasses = new ArrayList<String>();
    private final Hashtable<String, Class> userConstantDeclarations = new Hashtable();
    private final List<String> userConstantDeclarationsList = new ArrayList<String>();
    private static final SimpleMacro behaviorRegistration;
    private static final SimpleMacro behaviorRegistrationCall;
    private static final SimpleMacro codeMethodReflectionFieldName;
    protected static final SimpleMacro initCodeClassReflectionField;
    protected static final SimpleMacro initCodeMethodReflectionField;
    protected static final SimpleMacro setAssignableCodeMethodReflectionField;
    private Hashtable<String, Integer> behaviorCount = new Hashtable();
    private List<ASTBehaviorDefinition> individualBehaviorDefinitionNodes = new ArrayList<ASTBehaviorDefinition>();
    private List<ASTBehaviorDefinition> jointBehaviorDefinitionNodes = new ArrayList<ASTBehaviorDefinition>();
    private Hashtable<String, String> wmeRegistrations = new Hashtable();
    private static ASTBehaviorUnit behaviorUnit;
    private Hashtable<String, List<RegisteredAction>> actionRegistrations = new Hashtable();
    private Hashtable<String, Hashtable<String, String>> declaredWMEs = new Hashtable();
    private Hashtable<String, Set<String>> registeredConflicts = new Hashtable();
    ASTJavaName decisionCycleSMCallNode = null;
    private boolean teamNeededForSuccess = false;
    private boolean teamSuccessModifierExplicitlySet = false;
    private Hashtable<String, String> declaredProperties = new Hashtable();
    private static final int REGISTRATION_SIZE = 1000;
    private CodeStream behaviorFactoryStream;
    private CodeStream contextConditionSensorFactoryStream;
    private CodeStream successConditionSensorFactoryStream;
    private CodeStream preconditionSensorFactoryStream;
    private CodeStream contextConditionStream;
    private CodeStream successConditionStream;
    private CodeStream preconditionStream;
    private CodeStream stepFactoryStream;
    private CodeStream argumentStepExecuteStream;
    private CodeStream mentalStepExecuteStream;
    private CodeStream successTestStream;
    private CodeStream successTestSensorFactoryStream;
    private CodeStream reinforcementTestStream;
    private CodeStream reinforcementTestSensorFactoryStream;
    private CodeStream rlPolicyStream;
    private CodeBlockDescriptor rlPolicySuffix;
    private CodeStream stateWMEStream;
    private CodeStream stateWMESensorFactoryStream;
    private int behaviorIDCounter = 0;
    private int stepIDCounter = 0;
    int rootBehaviorID;
    private final Set<List<String>> conflictSets = new HashSet<List<String>>(100);
    private final Hashtable<List<String>, String> conflictSetsToFieldNames = new Hashtable(100);
    private int initConflictSetMethodCounter = 0;

    static {
        DEFAULT_WAIT_STEP_FACTORY.addToBlockBody(new CodeStringDescriptor("// default wait step"));
        DEFAULT_WAIT_STEP_FACTORY.addToBlockBody(new CodeStringDescriptor("return new WaitStep(-3, __$behaviorParent, false, false, false, false, false, false, (short)-32768, (short)0, false, null, null, null, null, null);"));
        DEFAULT_WAIT_STEP_FACTORY_DEBUG = new CodeBlockDescriptor("case -3: {", "}");
        DEFAULT_WAIT_STEP_FACTORY_DEBUG.addToBlockBody(new CodeStringDescriptor("// default wait step"));
        DEFAULT_WAIT_STEP_FACTORY_DEBUG.addToBlockBody(new CodeStringDescriptor("return new WaitStepDebug(-3, __$behaviorParent, false, false, false, false, false, false, (short)-32768, (short)0, false, null, null, null, null, null);"));
        DEFAULT_FAIL_STEP_FACTORY = new CodeBlockDescriptor("case -2: {", "}");
        DEFAULT_FAIL_STEP_FACTORY.addToBlockBody(new CodeStringDescriptor("// default fail step"));
        DEFAULT_FAIL_STEP_FACTORY.addToBlockBody(new CodeStringDescriptor("return new FailStep(-2, __$behaviorParent, false, false, false, (short)-32768, (short)0, false, null, null);"));
        DEFAULT_FAIL_STEP_FACTORY_DEBUG = new CodeBlockDescriptor("case -2: {", "}");
        DEFAULT_FAIL_STEP_FACTORY_DEBUG.addToBlockBody(new CodeStringDescriptor("// default fail step"));
        DEFAULT_FAIL_STEP_FACTORY_DEBUG.addToBlockBody(new CodeStringDescriptor("return new FailStepDebug(-2, __$behaviorParent, false, false, false, (short)-32768, (short)0, false, null, null);"));
        DEFAULT_SUCCEED_STEP_FACTORY = new CodeBlockDescriptor("case -1: {", "}");
        DEFAULT_SUCCEED_STEP_FACTORY.addToBlockBody(new CodeStringDescriptor("// default succeed step"));
        DEFAULT_SUCCEED_STEP_FACTORY.addToBlockBody(new CodeStringDescriptor("return new SucceedStep(-1, __$behaviorParent, false, false, (short)-32768, (short)0, false, null, null);"));
        DEFAULT_SUCCEED_STEP_FACTORY_DEBUG = new CodeBlockDescriptor("case -1: {", "}");
        DEFAULT_SUCCEED_STEP_FACTORY_DEBUG.addToBlockBody(new CodeStringDescriptor("// default succeed step"));
        DEFAULT_SUCCEED_STEP_FACTORY_DEBUG.addToBlockBody(new CodeStringDescriptor("return new SucceedStepDebug(-1, __$behaviorParent, false, false, (short)-32768, (short)0, false, null, null);"));
        packageMods = new String[]{"final", "static"};
        privateMods = new String[]{"private", "final", "static"};
        importPackages = new String[]{"abl.runtime.*", "wm.WME", "java.util.*", "java.lang.reflect.Method", "abl.learning.*"};
        behaviorRegistration = new SimpleMacro("definemacro behaviorUnitBehaviorRegistration(signature, signatures, behaviorID, factory, precondition, preconditionSensorFactory, teamMembers, specificity)behaviorLibrary.registerBehavior(new __BehaviorDesc(behaviorID, factory, precondition, preconditionSensorFactory, \"signature\", signatures, teamMembers, (short)specificity));");
        behaviorRegistrationCall = new SimpleMacro("definemacro behaviorUnitBehaviorRegistrationCall(callCounter, behaviorLibrary)registerBehaviors_callCounter@(behaviorLibrary);");
        codeMethodReflectionFieldName = new SimpleMacro("definemacro behaviorUnitCodeMethodReflectionFieldName(codeMethodName)__$codeMethodName@_rfield");
        initCodeClassReflectionField = new SimpleMacro("definemacro behaviorUnitInitCodeClassReflectionField(classFieldName, className, packageName)classFieldName = Class.forName(\"packageName.className\");");
        initCodeMethodReflectionField = new SimpleMacro("definemacro behaviorUnitInitCodeMethodReflectionField(methodFieldName, classFieldName, methodName, argArray)methodFieldName = classFieldName.getDeclaredMethod(\"methodName\", argArray);");
        setAssignableCodeMethodReflectionField = new SimpleMacro("definemacro behaviorUnitSetAssignableCodeMethodReflectionField(methodFieldName)methodFieldName.setAccessible(true);");
    }

    ASTBehaviorUnit(int id) {
        super(id);
        behaviorUnit = this;
    }

    ASTBehaviorUnit(AblParser p, int id) {
        super(p, id);
        behaviorUnit = this;
    }

    void setBehavingEntityClass(String behaviorUnitName) {
        this.behavingEntityClass = ASTBehaviorUnit.uppercaseFirstCharacter(behaviorUnitName);
    }

    public String getBehavingEntityClass() {
        return this.behavingEntityClass;
    }

    void addUserImport(String importName) {
        if (importName.endsWith("*")) {
            this.userImportPackages.add(importName.substring(0, importName.length() - 2));
        } else {
            this.userImportClasses.add(importName);
        }
    }

    void addUserImports(ClassDescriptor c) {
        ListIterator<String> packageIter = this.userImportPackages.listIterator();
        while (packageIter.hasNext()) {
            c.addPackageImport(String.valueOf((String)packageIter.next()) + ".*");
        }
        ListIterator<String> classIter = this.userImportClasses.listIterator();
        while (classIter.hasNext()) {
            c.addPackageImport((String)classIter.next());
        }
    }

    void printUserImports(PrintStream p) {
        Iterator<String> packageIter = this.userImportPackages.iterator();
        while (packageIter.hasNext()) {
            p.println("import " + packageIter.next() + ".*;");
        }
        Iterator<String> classIter = this.userImportClasses.iterator();
        while (classIter.hasNext()) {
            p.println("import " + classIter.next() + ";");
        }
    }

    Iterator<String> getUserImportPackages() {
        return this.userImportPackages.iterator();
    }

    Iterator<String> getUserImportClasses() {
        return this.userImportClasses.iterator();
    }

    void addUserConstants(String constantsName) throws CompileException {
        Class<?> constantInterface;
        try {
            constantInterface = Class.forName(constantsName);
            if (!Modifier.isInterface(constantInterface.getModifiers())) {
                throw new CompileException("Expected " + constantsName + " to be an interface declaring constants.");
            }
        }
        catch (ClassNotFoundException e) {
            throw new CompileException("Unable to find interface " + constantsName);
        }
        Field[] fields = constantInterface.getFields();
        int i = 0;
        while (i < fields.length) {
            String fieldName = fields[i].getName();
            if (this.userConstantDeclarations.get(fieldName) != null) {
                throw new CompileException("Duplicate declaration of constant " + fieldName + " in file " + constantsName);
            }
            this.userConstantDeclarations.put(fieldName, constantInterface);
            ++i;
        }
        this.userConstantDeclarationsList.add(constantsName);
    }

    void addUserConstantDeclarations(ClassDescriptor c) {
        Iterator<String> constantsIter = this.userConstantDeclarationsList.iterator();
        while (constantsIter.hasNext()) {
            c.addInterface(constantsIter.next());
        }
    }

    void printUserConstantDeclarations(PrintStream p) {
        Iterator<String> constantsIter = this.userConstantDeclarationsList.iterator();
        if (constantsIter.hasNext()) {
            p.print("implements ");
            while (constantsIter.hasNext()) {
                p.print(constantsIter.next());
                if (!constantsIter.hasNext()) continue;
                p.print(", ");
            }
            p.println("");
        }
    }

    Field getDeclaredConstant(String name) throws CompileException {
        Class constantInterface = this.userConstantDeclarations.get(name);
        if (constantInterface == null) {
            return null;
        }
        try {
            return constantInterface.getDeclaredField(name);
        }
        catch (SecurityException e) {
            throw new CompileError("Security exception accessing " + name + " in interface " + constantInterface.getName());
        }
        catch (NoSuchFieldException e) {
            throw new CompileError("Constant " + name + " not found in interface " + constantInterface.getName());
        }
    }

    boolean setTeamNeededForSuccess(boolean teamNeededForSuccess) {
        this.teamNeededForSuccess = teamNeededForSuccess;
        if (this.teamSuccessModifierExplicitlySet) {
            return false;
        }
        this.teamSuccessModifierExplicitlySet = true;
        return true;
    }

    boolean getTeamNeededForSuccess() {
        return this.teamNeededForSuccess;
    }

    static ASTBehaviorUnit getBehaviorUnit() {
        return behaviorUnit;
    }

    void addBehaviorNode(ASTBehaviorDefinition behaviorNode) {
        if (behaviorNode.isJoint()) {
            this.jointBehaviorDefinitionNodes.add(behaviorNode);
        } else {
            this.individualBehaviorDefinitionNodes.add(behaviorNode);
        }
    }

    Integer getBehaviorCount(String behaviorName) {
        Integer count = this.behaviorCount.get(behaviorName);
        if (count == null) {
            return new Integer(1);
        }
        return count;
    }

    void incrementBehaviorCount(String behaviorName) {
        Integer count = this.behaviorCount.get(behaviorName);
        if (count == null) {
            this.behaviorCount.put(behaviorName, new Integer(2));
        } else {
            int newCount = count + 1;
            this.behaviorCount.put(behaviorName, new Integer(newCount));
        }
    }

    private void compileChildren() throws CompileException {
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode n = (AblParseNode)this.jjtGetChild(i);
            if (n.id == 23) {
                ASTWMEDecl wmeDecl = (ASTWMEDecl)n;
                this.declaredWMEs.put(wmeDecl.wmeClassName, wmeDecl.getFieldTypeTable());
                ClassDescriptor wmeClass = (ClassDescriptor)wmeDecl.compileToJava();
                if (!Abl.noCodeGeneration) {
                    wmeClass.writeToFile(this.getFullPackagePath(Abl.objectDirectory, this.behavingEntityPackage));
                }
            } else if (n.id == 7) {
                ((ASTBehaviorDefinition)n).compileToJava();
            }
            ++i;
        }
    }

    boolean isWMEDeclared(String wmeClassName) {
        return this.declaredWMEs.get(wmeClassName) != null;
    }

    String lookupWMEFieldType(String wmeClassName, String wmeFieldName) {
        Hashtable<String, String> typeTable = this.declaredWMEs.get(wmeClassName);
        if (typeTable != null) {
            return typeTable.get(wmeFieldName);
        }
        return null;
    }

    private MethodDescriptor compileDecisionCycleSMCall() throws CompileException {
        if (this.decisionCycleSMCallNode != null) {
            Method decisionCycleSMCallMethod = this.decisionCycleSMCallNode.getMethod();
            if (decisionCycleSMCallMethod == null) {
                throw new CompileException("The decision cycle callback " + this.decisionCycleSMCallNode.dumpTokens() + " is not a method");
            }
            int methodMods = decisionCycleSMCallMethod.getModifiers();
            if (!Modifier.isStatic(methodMods)) {
                throw new CompileException("The decision cycle callback method must be static");
            }
            if (!Modifier.isPublic(methodMods)) {
                throw new CompileException("The decision cycle callback method must be public");
            }
            if (decisionCycleSMCallMethod.getParameterTypes().length != 0) {
                throw new CompileException("The decision cycle callback method must take 0 parameters");
            }
            MethodDescriptor decisionCycleSMCallDescriptor = new MethodDescriptor();
            decisionCycleSMCallDescriptor.addModifier("protected");
            decisionCycleSMCallDescriptor.addModifier("void");
            decisionCycleSMCallDescriptor.methodName = "decisionCycleSMCall";
            decisionCycleSMCallDescriptor.addToBlockBody(new CodeStringDescriptor(String.valueOf(this.decisionCycleSMCallNode.dumpTokens()) + "();"));
            return decisionCycleSMCallDescriptor;
        }
        return null;
    }

    private MethodDescriptor compileRegistrationMethod(int methodCounter, Hashtable<Integer, HashSet<String>> signatures, Iterator<ASTBehaviorDefinition> behaviorIter) {
        MethodDescriptor regMethod = new MethodDescriptor();
        regMethod.addModifier("private");
        regMethod.addModifier("static");
        regMethod.addModifier("void");
        regMethod.methodName = "registerBehaviors_" + methodCounter;
        regMethod.addArgument(new MethodArgDescriptor("BehaviorLibrary", "behaviorLibrary"));
        try {
            int i = 0;
            while (i < 1000 && behaviorIter.hasNext()) {
                ASTBehaviorDefinition beh = behaviorIter.next();
                int behaviorID = beh.getID();
                String behaviorFactoryMethod_rField = beh.getBehaviorFactoryMethod_rField();
                String preconditionMethod_rField = beh.getPreconditionMethod_rField();
                String preconditionSensorFactoryMethod_rField = beh.getPreconditionSensorFactoryMethod_rField();
                StringBuffer teamBuf = new StringBuffer(100);
                if (beh.isJoint()) {
                    List teamMembers = beh.getTeamMembers();
                    Iterator iter = teamMembers.iterator();
                    teamBuf.append("new String[] {");
                    while (iter.hasNext()) {
                        String roleName = (String)iter.next();
                        teamBuf.append("\"" + roleName + "\"");
                        if (!iter.hasNext()) continue;
                        teamBuf.append(", ");
                    }
                    teamBuf.append("}");
                } else {
                    teamBuf.append("null");
                }
                StringBuffer signaturesBuf = new StringBuffer(100);
                signaturesBuf.append("new String[] {\"" + beh.getSignature() + "\"" + ", ");
                if (signatures.get(behaviorID) == null || signatures.get(behaviorID).size() == 0) {
                    signaturesBuf.append("null");
                } else {
                    for (String sig : signatures.get(behaviorID)) {
                        if (sig.equals(beh.getSignature())) continue;
                        signaturesBuf.append("\"" + sig + "\"" + ", ");
                    }
                }
                signaturesBuf.delete(signaturesBuf.lastIndexOf(","), signaturesBuf.length());
                signaturesBuf.append("}");
                String[] behaviorRegistrationArgs = new String[]{beh.getSignature(), signaturesBuf.toString(), Integer.toString(behaviorID), behaviorFactoryMethod_rField, preconditionMethod_rField, preconditionSensorFactoryMethod_rField, teamBuf.toString(), Integer.toString(beh.specificity)};
                regMethod.addToBlockBody(new CodeStringDescriptor(behaviorRegistration.expand(behaviorRegistrationArgs)));
                ++i;
            }
        }
        catch (SimpleMacroException e) {
            throw new CompileError("Error compiling behavior registration method", e);
        }
        return regMethod;
    }

    private MethodDescriptor compileEntryPoint() {
        MethodDescriptor entryPoint = new MethodDescriptor();
        entryPoint.addModifier("public");
        entryPoint.addModifier("static");
        entryPoint.addModifier("void");
        entryPoint.methodName = "main";
        entryPoint.addArgument(new MethodArgDescriptor("String[]", "args"));
        entryPoint.addToBlockBody(new CodeStringDescriptor("new " + this.behavingEntityClass + "().startBehaving();"));
        return entryPoint;
    }

    private MethodDescriptor compileConstructor() {
        MethodDescriptor constructor = new MethodDescriptor();
        constructor.addModifier("public");
        constructor.methodName = this.behavingEntityClass;
        constructor.addToBlockBody(new CodeStringDescriptor("individualBehaviorLibrary = new BehaviorLibrary(" + this.individualBehaviorDefinitionNodes.size() * 2 + ");"));
        constructor.addToBlockBody(new CodeStringDescriptor("jointBehaviorLibrary = new BehaviorLibrary(" + this.jointBehaviorDefinitionNodes.size() * 2 + ");"));
        if (Abl.debugLevel != 0) {
            constructor.addToBlockBody(new CodeStringDescriptor("debugLevel = " + Abl.debugLevel + ";"));
        }
        if (Abl.debugLevel == 2) {
            constructor.addToBlockBody(new CodeStringDescriptor("debuggerGUI = new Debugger(this);"));
        }
        try {
            String[] args;
            int registrationMethodCounter = 0;
            int i = 0;
            while (i < this.individualBehaviorDefinitionNodes.size() / 1000 + 1) {
                args = new String[]{Integer.toString(registrationMethodCounter), "individualBehaviorLibrary"};
                constructor.addToBlockBody(new CodeStringDescriptor(behaviorRegistrationCall.expand(args)));
                ++i;
                ++registrationMethodCounter;
            }
            i = 0;
            while (i < this.jointBehaviorDefinitionNodes.size() / 1000 + 1) {
                args = new String[]{Integer.toString(registrationMethodCounter), "jointBehaviorLibrary"};
                constructor.addToBlockBody(new CodeStringDescriptor(behaviorRegistrationCall.expand(args)));
                ++i;
                ++registrationMethodCounter;
            }
            i = 0;
            while (i < this.initConflictSetMethodCounter) {
                constructor.addToBlockBody(new CodeStringDescriptor("__$initConflictSet" + i + "();"));
                ++i;
            }
            if (Abl.debugLevel == 2) {
                constructor.addToBlockBody(new CodeStringDescriptor("ABT = (CollectionBehavior)" + this.behavingEntityClass + "_BehaviorFactories.behaviorFactory" + this.behaviorFactoryStream.getMethodCounter() + "(" + this.rootBehaviorID + ", null, null, null, \"" + this.behavingEntityClass + "_RootCollectionBehavior()\", (__BehaviorDesc)((List)individualBehaviorLibrary.lookupBehavior(\"" + this.behavingEntityClass + "_RootCollectionBehavior()\")).get(0));"));
            } else {
                constructor.addToBlockBody(new CodeStringDescriptor("ABT = (CollectionBehavior)" + this.behavingEntityClass + "_BehaviorFactories.behaviorFactory" + this.behaviorFactoryStream.getMethodCounter() + "(" + this.rootBehaviorID + ", null, null, null, \"" + this.behavingEntityClass + "_RootCollectionBehavior()\");"));
            }
            if (Abl.bMetaEnabled) {
                constructor.addToBlockBody(new CodeStringDescriptor("startWMEReflection(ABT);"));
            }
            constructor.addToBlockBody(new CodeStringDescriptor("ABT.initRootBehavior();"));
            if (!Abl.currentLineOfExpansion) {
                constructor.addToBlockBody(new CodeStringDescriptor("bCurrentLineOfExpansion = false;"));
            }
            if (this.decisionCycleSMCallNode != null) {
                constructor.addToBlockBody(new CodeStringDescriptor("bDecisionCycleSMCall = true;"));
            }
            constructor.addToBlockBody(new CodeStringDescriptor("registerEntity(\"" + this.behavingEntityClass + "\", this);"));
        }
        catch (SimpleMacroException e) {
            throw new CompileError("Error compiling behaving entity constructor", e);
        }
        return constructor;
    }

    private void processActionRegistration() {
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode node = (AblParseNode)this.jjtGetChild(i);
            if (node.id == 6) {
                RegisteredAction regAction = new RegisteredAction(((ASTActionRegistration)node).getPrimitiveAction(), ((ASTActionRegistration)node).getArgumentTypes());
                String actionName = ((ASTActionRegistration)node).actionName;
                List<RegisteredAction> regActions = this.actionRegistrations.get(actionName);
                if (regActions != null) {
                    regActions.add(regAction);
                } else {
                    ArrayList<RegisteredAction> newActionList = new ArrayList<RegisteredAction>();
                    newActionList.add(regAction);
                    this.actionRegistrations.put(actionName, newActionList);
                }
            }
            ++i;
        }
    }

    List<RegisteredAction> lookupRegisteredAction(String actionName) {
        return this.actionRegistrations.get(actionName);
    }

    private void processWMERegistration() {
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode node = (AblParseNode)this.jjtGetChild(i);
            if (node.id == 5) {
                String registeredWME = ((ASTWMERegistration)node).getRegisteredWME();
                String sensorWMERegisteredOn = ((ASTWMERegistration)node).getSensorWMERegisteredOn();
                this.wmeRegistrations.put(registeredWME, sensorWMERegisteredOn);
            }
            ++i;
        }
    }

    String lookupRegisteredWME(String wmeClassName) {
        return this.wmeRegistrations.get(wmeClassName);
    }

    private void processPropertyDeclarations() throws CompileException {
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode node = (AblParseNode)this.jjtGetChild(i);
            if (node.id == 3) {
                String propertyName = ((ASTPropertyDeclaration)node).getPropertyName();
                String propertyType = ((ASTPropertyDeclaration)node).getPropertyType();
                this.declareProperty(propertyName, propertyType);
            }
            ++i;
        }
    }

    private void registerConflictHelper(String stepName1, String stepName2) {
        Set<String> conflictingSteps = this.registeredConflicts.get(stepName1);
        if (conflictingSteps != null) {
            if (!conflictingSteps.contains(stepName2)) {
                conflictingSteps.add(stepName2);
            }
        } else {
            conflictingSteps = new HashSet<String>();
            conflictingSteps.add(stepName2);
            this.registeredConflicts.put(stepName1, conflictingSteps);
        }
    }

    void registerConflictPair(String stepName1, String stepName2) {
        this.registerConflictHelper(stepName1, stepName2);
        if (!stepName1.equals(stepName2)) {
            this.registerConflictHelper(stepName2, stepName1);
        }
    }

    void registerConflictList(List conflictList) {
        int i = 0;
        while (i < conflictList.size() - 1) {
            String stepName1 = (String)conflictList.get(i);
            int j = i + 1;
            while (j < conflictList.size()) {
                String stepName2 = (String)conflictList.get(j);
                this.registerConflictPair(stepName1, stepName2);
                ++j;
            }
            ++i;
        }
    }

    String[] lookupConflict(String stepName) {
        Set<String> conflictingSteps = this.registeredConflicts.get(stepName);
        if (conflictingSteps == null) {
            return null;
        }
        return conflictingSteps.toArray(new String[conflictingSteps.size()]);
    }

    private void declareProperty(String name, String type) throws CompileException {
        if (this.declaredProperties.get(name) != null) {
            throw new CompileException("Duplicate property declaration: " + name);
        }
        this.declaredProperties.put(name, type);
    }

    String lookupDeclaredProperty(String name) {
        return this.declaredProperties.get(name);
    }

    /*
     * Unable to fully structure code
     */
    public Class findClassFromShortName(String shortName) {
        if (shortName.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (shortName.equals("byte")) {
            return Byte.TYPE;
        }
        if (shortName.equals("char")) {
            return Character.TYPE;
        }
        if (shortName.equals("short")) {
            return Short.TYPE;
        }
        if (shortName.equals("int")) {
            return Integer.TYPE;
        }
        if (shortName.equals("long")) {
            return Long.TYPE;
        }
        if (shortName.equals("float")) {
            return Float.TYPE;
        }
        if (shortName.equals("double")) {
            return Double.TYPE;
        }
        if (shortName.equals("void")) {
            return Void.TYPE;
        }
        classnameItr = this.getUserImportClasses();
        while (classnameItr.hasNext()) {
            classname = classnameItr.next();
            if (!classname.substring(classname.lastIndexOf(46) + 1, classname.length()).equals(shortName)) continue;
            try {
                return Class.forName(classname);
            }
            catch (ClassNotFoundException var4_6) {
                // empty catch block
            }
        }
        try {
            return Class.forName(String.valueOf(this.behavingEntityPackage) + "." + shortName);
        }
        catch (ClassNotFoundException classname) {
            packagenameItr = this.getUserImportPackages();
            ** while (packagenameItr.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            packagename = packagenameItr.next();
            try {
                c = Class.forName(String.valueOf(packagename) + "." + shortName);
                return c;
            }
            catch (ClassNotFoundException var5_8) {
                // empty catch block
            }
            continue;
        }
lbl40:
        // 1 sources

        return null;
    }

    private ArrayList<Hashtable<Integer, HashSet<String>>> buildBehaviorSignatureIndices() throws CompileException {
        AblParseNode n;
        Hashtable<String, ArrayList<ArrayList<Object>>> individualBehaviorSigTable = new Hashtable<String, ArrayList<ArrayList<Object>>>();
        Hashtable<String, ArrayList<ArrayList<Object>>> jointBehaviorSigTable = new Hashtable<String, ArrayList<ArrayList<Object>>>();
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            n = (AblParseNode)this.jjtGetChild(i);
            if (n.id == 7) {
                ArrayList<ArrayList<Constable>> tempList;
                ASTBehaviorDefinition behDef = (ASTBehaviorDefinition)n;
                String behaviorSig = behDef.getSignature();
                Object[] args = behDef.getFormalArguments();
                String key = String.valueOf(behaviorSig.substring(0, behaviorSig.indexOf(40))) + "(" + args.length + ")";
                ArrayList<Constable> value = new ArrayList<Constable>();
                value.add(Integer.valueOf(behDef.getID()));
                Object[] objectArray = args;
                int n2 = args.length;
                int n3 = 0;
                while (n3 < n2) {
                    Object o = objectArray[n3];
                    Class c = this.findClassFromShortName(((MethodArgDescriptor)o).argType);
                    if (c == null) {
                        throw new CompileException("Unable to find class " + ((MethodArgDescriptor)o).argType + " in the imported packages.");
                    }
                    value.add(c);
                    ++n3;
                }
                if (behDef.isJoint()) {
                    if (jointBehaviorSigTable.containsKey(key)) {
                        jointBehaviorSigTable.get(key).add(value);
                    } else {
                        tempList = new ArrayList<ArrayList<Constable>>();
                        tempList.add(value);
                        jointBehaviorSigTable.put(key, tempList);
                    }
                } else if (individualBehaviorSigTable.containsKey(key)) {
                    individualBehaviorSigTable.get(key).add(value);
                } else {
                    tempList = new ArrayList();
                    tempList.add(value);
                    individualBehaviorSigTable.put(key, tempList);
                }
            }
            ++i;
        }
        ArrayList<Hashtable<Integer, HashSet<String>>> signatureIndices = new ArrayList<Hashtable<Integer, HashSet<String>>>();
        Hashtable<Integer, HashSet<String>> individualSignatureIndex = new Hashtable<Integer, HashSet<String>>();
        Hashtable<Integer, HashSet<String>> jointSignatureIndex = new Hashtable<Integer, HashSet<String>>();
        int i2 = 0;
        while (i2 < this.jjtGetNumChildren()) {
            n = (AblParseNode)this.jjtGetChild(i2);
            if (n.id == 7) {
                ArrayList<Hashtable<Integer, HashSet<String>>> signatures = ((ASTBehaviorDefinition)n).typeCheckSubgoalsWithInheritance(individualBehaviorSigTable, jointBehaviorSigTable, this);
                Enumeration<Integer> indKeys = signatures.get(0).keys();
                while (indKeys.hasMoreElements()) {
                    Integer key = indKeys.nextElement();
                    if (individualSignatureIndex.containsKey(key)) {
                        HashSet<String> sigs = signatures.get(0).get(key);
                        for (String s : sigs) {
                            ((HashSet)individualSignatureIndex.get(key)).add(s);
                        }
                        continue;
                    }
                    individualSignatureIndex.put(key, signatures.get(0).get(key));
                }
                Enumeration<Integer> jointKeys = signatures.get(1).keys();
                while (jointKeys.hasMoreElements()) {
                    Integer key = jointKeys.nextElement();
                    if (jointSignatureIndex.containsKey(key)) {
                        HashSet<String> sigs = signatures.get(0).get(key);
                        for (String s : sigs) {
                            ((HashSet)jointSignatureIndex.get(key)).add(s);
                        }
                        continue;
                    }
                    jointSignatureIndex.put(key, signatures.get(0).get(key));
                }
            }
            ++i2;
        }
        signatureIndices.add(individualSignatureIndex);
        signatureIndices.add(jointSignatureIndex);
        return signatureIndices;
    }

    private void checkForSubgoalsWithNoMatchingBehaviors() throws CompileException {
        AblParseNode n;
        HashSet<String> individualSigSet = new HashSet<String>();
        HashSet<String> jointSigSet = new HashSet<String>();
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            n = (AblParseNode)this.jjtGetChild(i);
            if (n.id == 7) {
                ASTBehaviorDefinition behDef = (ASTBehaviorDefinition)n;
                if (behDef.isJoint()) {
                    jointSigSet.add(behDef.getSignature());
                } else {
                    individualSigSet.add(behDef.getSignature());
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.jjtGetNumChildren()) {
            n = (AblParseNode)this.jjtGetChild(i);
            if (n.id == 7) {
                ((ASTBehaviorDefinition)n).checkForSubgoalsWithNoMatchingBehaviors(individualSigSet, jointSigSet);
            }
            ++i;
        }
    }

    void writeBehaviorFactory(CodeBlockDescriptor behaviorFactory, ASTBehaviorDefinition node) {
        this.behaviorFactoryStream.writeCode(behaviorFactory, node);
    }

    void writeContextConditionSensorActivation(CodeBlockDescriptor contextConditionSensorActivation, ASTBehaviorDefinition node) {
        this.contextConditionSensorFactoryStream.writeCode(contextConditionSensorActivation, node);
    }

    void writeContextCondition(CodeBlockDescriptor contextCondition, ASTBehaviorDefinition node) {
        this.contextConditionStream.writeCode(contextCondition, node);
    }

    void writeSuccessConditionSensorActivation(CodeBlockDescriptor successConditionSensorActivation, ASTBehaviorDefinition node) {
        this.successConditionSensorFactoryStream.writeCode(successConditionSensorActivation, node);
    }

    void writeSuccessCondition(CodeBlockDescriptor successCondition, ASTBehaviorDefinition node) {
        this.successConditionStream.writeCode(successCondition, node);
    }

    void writeSuccessTestSensorActivation(CodeBlockDescriptor successTestSensorActivation, GenericStep node) {
        this.successTestSensorFactoryStream.writeCode(successTestSensorActivation, node);
    }

    void writeSuccessTest(CodeBlockDescriptor successTest, GenericStep node) {
        this.successTestStream.writeCode(successTest, node);
    }

    void writeReinforcementTestSensorActivation(CodeBlockDescriptor reinforcementTestSensorActivation, ASTBehaviorDefinition node) {
        this.reinforcementTestSensorFactoryStream.writeCode(reinforcementTestSensorActivation, node);
    }

    void writeReinforcementTest(CodeBlockDescriptor reinforcementTest, ASTBehaviorDefinition node) {
        this.reinforcementTestStream.writeCode(reinforcementTest, node);
    }

    void writeRLPolicy(CodeBlockDescriptor rlPolicy, ASTBehaviorDefinition node) {
        this.rlPolicyStream.writeCode(rlPolicy, node);
    }

    void writeRLPolicySuffix(CodeStringDescriptor suffix) {
        this.rlPolicySuffix.addToBlockBody(suffix);
    }

    void writeStateWMESensorActivation(CodeBlockDescriptor stateWMESensorActivation, ASTBehaviorDefinition node) {
        this.stateWMESensorFactoryStream.writeCode(stateWMESensorActivation, node);
    }

    void writeStateWME(CodeBlockDescriptor stateWME, ASTBehaviorDefinition node) {
        this.stateWMEStream.writeCode(stateWME, node);
    }

    void writePreconditionSensorActivation(CodeBlockDescriptor preconditionSensorActivation, ASTBehaviorDefinition node) {
        this.preconditionSensorFactoryStream.writeCode(preconditionSensorActivation, node);
    }

    void writePrecondition(CodeBlockDescriptor precondition, ASTBehaviorDefinition node) {
        this.preconditionStream.writeCode(precondition, node);
    }

    void writeStepFactory(CodeBlockDescriptor stepFactory, GenericStep node) {
        this.stepFactoryStream.writeCode(stepFactory, node);
    }

    void writeArgumentStepExecute(CodeBlockDescriptor execute, ArgumentStep node) {
        this.argumentStepExecuteStream.writeCode(execute, node);
    }

    void writeMentalStepExecute(CodeBlockDescriptor execute, ASTMentalStep node) {
        this.mentalStepExecuteStream.writeCode(execute, node);
    }

    void writeRawClass(CodeBlockDescriptor classCode, String className) {
        try {
            File packageDir = this.getFullPackagePath(Abl.objectDirectory, this.behavingEntityPackage);
            PrintStream codeStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(new File(packageDir, String.valueOf(className) + ".java")), 100000));
            codeStream.println("package " + this.behavingEntityPackage + ";");
            codeStream.println("");
            int i = 0;
            while (i < importPackages.length) {
                codeStream.println("import " + importPackages[i] + ";");
                ++i;
            }
            codeStream.print(classCode.toString(3));
            codeStream.close();
        }
        catch (IOException e) {
            throw new CompileError("Error initing stream " + className, e);
        }
    }

    int getUniqueBehaviorID() {
        return this.behaviorIDCounter++;
    }

    int getUniqueStepID() {
        return this.stepIDCounter++;
    }

    int getSpecialStepID(int stepType) {
        switch (stepType) {
            case -3: {
                return -3;
            }
            case -2: {
                return -2;
            }
            case -1: {
                return -1;
            }
        }
        throw new CompileError("Unexpected step type " + stepType);
    }

    protected String getCodeMethodReflectionField(String codeMethodName) {
        try {
            String[] macroArgs = new String[]{codeMethodName};
            return codeMethodReflectionFieldName.expand(macroArgs);
        }
        catch (SimpleMacroException e) {
            throw new CompileError("Error generating code method reflection field name", e);
        }
    }

    private void initializeArgumentFields(ClassDescriptor behavingEntity) {
        CodeBlockDescriptor staticInit = new CodeBlockDescriptor("try {", "} catch (Exception e) { throw new AblRuntimeError(\"Error in static initializer\", e); }");
        FieldDescriptor tempObjArray = new FieldDescriptor();
        tempObjArray.fieldType = "Object[]";
        tempObjArray.addFieldModifiers(privateMods);
        tempObjArray.addFieldName("__$tempObjArray");
        tempObjArray.initializer = "new Object[1]";
        behavingEntity.addField(tempObjArray);
        FieldDescriptor sensorFactoryArgArray = new FieldDescriptor();
        sensorFactoryArgArray.fieldType = "Class[]";
        sensorFactoryArgArray.addFieldModifiers(privateMods);
        sensorFactoryArgArray.addFieldName("__$sensorFactoryArgArray");
        sensorFactoryArgArray.initializer = "new Class[1]";
        behavingEntity.addField(sensorFactoryArgArray);
        staticInit.addToBlockBody(new CodeStringDescriptor("__$sensorFactoryArgArray[0] = Integer.TYPE;"));
        FieldDescriptor behFactoryArgArray = new FieldDescriptor();
        behFactoryArgArray.fieldType = "Class[]";
        behFactoryArgArray.addFieldModifiers(privateMods);
        behFactoryArgArray.addFieldName("__$behFactoryArgArray");
        behFactoryArgArray.initializer = Abl.debugLevel == 2 ? "new Class[6]" : "new Class[5]";
        behavingEntity.addField(behFactoryArgArray);
        staticInit.addToBlockBody(new CodeStringDescriptor("__$behFactoryArgArray[0] = Integer.TYPE;"));
        staticInit.addToBlockBody(new CodeStringDescriptor("__$behFactoryArgArray[1] = __$tempObjArray.getClass();"));
        staticInit.addToBlockBody(new CodeStringDescriptor("__$behFactoryArgArray[2] = Class.forName(\"java.util.Hashtable\");"));
        staticInit.addToBlockBody(new CodeStringDescriptor("__$behFactoryArgArray[3] = Class.forName(\"abl.runtime.GoalStep\");"));
        staticInit.addToBlockBody(new CodeStringDescriptor("__$behFactoryArgArray[4] = Class.forName(\"java.lang.String\");"));
        if (Abl.debugLevel == 2) {
            staticInit.addToBlockBody(new CodeStringDescriptor("__$behFactoryArgArray[5] = Class.forName(\"abl.runtime.__BehaviorDesc\");"));
        }
        FieldDescriptor preconditionArgArray = new FieldDescriptor();
        preconditionArgArray.fieldType = "Class[]";
        preconditionArgArray.addFieldModifiers(privateMods);
        preconditionArgArray.addFieldName("__$preconditionArgArray");
        preconditionArgArray.initializer = "new Class[4]";
        behavingEntity.addField(preconditionArgArray);
        staticInit.addToBlockBody(new CodeStringDescriptor("__$preconditionArgArray[0] = Integer.TYPE;"));
        staticInit.addToBlockBody(new CodeStringDescriptor("__$preconditionArgArray[1] = __$tempObjArray.getClass();"));
        staticInit.addToBlockBody(new CodeStringDescriptor("__$preconditionArgArray[2] = Class.forName(\"java.util.Hashtable\");"));
        staticInit.addToBlockBody(new CodeStringDescriptor("__$preconditionArgArray[3] = Class.forName(\"abl.runtime.BehavingEntity\");"));
        FieldDescriptor continuousConditionArgArray = new FieldDescriptor();
        continuousConditionArgArray.fieldType = "Class[]";
        continuousConditionArgArray.addFieldModifiers(privateMods);
        continuousConditionArgArray.addFieldName("__$continuousConditionArgArray");
        continuousConditionArgArray.initializer = "new Class[3]";
        behavingEntity.addField(continuousConditionArgArray);
        staticInit.addToBlockBody(new CodeStringDescriptor("__$continuousConditionArgArray[0] = Integer.TYPE;"));
        staticInit.addToBlockBody(new CodeStringDescriptor("__$continuousConditionArgArray[1] = __$tempObjArray.getClass();"));
        staticInit.addToBlockBody(new CodeStringDescriptor("__$continuousConditionArgArray[2] = Class.forName(\"abl.runtime.BehavingEntity\");"));
        FieldDescriptor stepFactoryArgArray = new FieldDescriptor();
        stepFactoryArgArray.fieldType = "Class[]";
        stepFactoryArgArray.addFieldModifiers(privateMods);
        stepFactoryArgArray.addFieldName("__$stepFactoryArgArray");
        stepFactoryArgArray.initializer = "new Class[3]";
        behavingEntity.addField(stepFactoryArgArray);
        staticInit.addToBlockBody(new CodeStringDescriptor("__$stepFactoryArgArray[0] = Integer.TYPE;"));
        staticInit.addToBlockBody(new CodeStringDescriptor("__$stepFactoryArgArray[1] = Class.forName(\"abl.runtime.Behavior\");"));
        staticInit.addToBlockBody(new CodeStringDescriptor("__$stepFactoryArgArray[2] = __$tempObjArray.getClass();"));
        FieldDescriptor argumentStepExecuteArgArray = new FieldDescriptor();
        argumentStepExecuteArgArray.fieldType = "Class[]";
        argumentStepExecuteArgArray.addFieldModifiers(privateMods);
        argumentStepExecuteArgArray.addFieldName("__$argumentStepExecuteArgArray");
        argumentStepExecuteArgArray.initializer = "new Class[3]";
        behavingEntity.addField(argumentStepExecuteArgArray);
        staticInit.addToBlockBody(new CodeStringDescriptor("__$argumentStepExecuteArgArray[0] = Integer.TYPE;"));
        staticInit.addToBlockBody(new CodeStringDescriptor("__$argumentStepExecuteArgArray[1] = __$tempObjArray.getClass();"));
        staticInit.addToBlockBody(new CodeStringDescriptor("__$argumentStepExecuteArgArray[2] = Class.forName(\"abl.runtime.BehavingEntity\");"));
        FieldDescriptor mentalStepExecuteArgArray = new FieldDescriptor();
        mentalStepExecuteArgArray.fieldType = "Class[]";
        mentalStepExecuteArgArray.addFieldModifiers(privateMods);
        mentalStepExecuteArgArray.addFieldName("__$mentalStepExecuteArgArray");
        mentalStepExecuteArgArray.initializer = "new Class[4]";
        behavingEntity.addField(mentalStepExecuteArgArray);
        staticInit.addToBlockBody(new CodeStringDescriptor("__$mentalStepExecuteArgArray[0] = Integer.TYPE;"));
        staticInit.addToBlockBody(new CodeStringDescriptor("__$mentalStepExecuteArgArray[1] = __$tempObjArray.getClass();"));
        staticInit.addToBlockBody(new CodeStringDescriptor("__$mentalStepExecuteArgArray[2] = Class.forName(\"abl.runtime.BehavingEntity\");"));
        staticInit.addToBlockBody(new CodeStringDescriptor("__$mentalStepExecuteArgArray[3] = Class.forName(\"abl.runtime.MentalStep\");"));
        FieldDescriptor reinforcementSignalArgArray = new FieldDescriptor();
        reinforcementSignalArgArray.fieldType = "Class[]";
        reinforcementSignalArgArray.addFieldModifiers(privateMods);
        reinforcementSignalArgArray.addFieldName("__$reinforcementSignalArgArray");
        reinforcementSignalArgArray.initializer = "new Class[3]";
        behavingEntity.addField(reinforcementSignalArgArray);
        staticInit.addToBlockBody(new CodeStringDescriptor("__$reinforcementSignalArgArray[0] = Integer.TYPE;"));
        staticInit.addToBlockBody(new CodeStringDescriptor("__$reinforcementSignalArgArray[1] = __$tempObjArray.getClass();"));
        staticInit.addToBlockBody(new CodeStringDescriptor("__$reinforcementSignalArgArray[2] = Class.forName(\"abl.runtime.BehavingEntity\");"));
        FieldDescriptor rlPolicyArgArray = new FieldDescriptor();
        rlPolicyArgArray.fieldType = "Class[]";
        rlPolicyArgArray.addFieldModifiers(privateMods);
        rlPolicyArgArray.addFieldName("__$rlPolicyArgArray");
        rlPolicyArgArray.initializer = "new Class[6]";
        behavingEntity.addField(rlPolicyArgArray);
        staticInit.addToBlockBody(new CodeStringDescriptor("__$rlPolicyArgArray[0] = Integer.TYPE;"));
        staticInit.addToBlockBody(new CodeStringDescriptor("__$rlPolicyArgArray[1] = Class.forName(\"java.lang.Object\");"));
        staticInit.addToBlockBody(new CodeStringDescriptor("__$rlPolicyArgArray[2] = Integer.TYPE;"));
        staticInit.addToBlockBody(new CodeStringDescriptor("__$rlPolicyArgArray[3] = Class.forName(\"java.lang.Object\");"));
        staticInit.addToBlockBody(new CodeStringDescriptor("__$rlPolicyArgArray[4] = Double.TYPE;"));
        staticInit.addToBlockBody(new CodeStringDescriptor("__$rlPolicyArgArray[5] = Boolean.TYPE;"));
        FieldDescriptor stateWMEArgArray = new FieldDescriptor();
        stateWMEArgArray.fieldType = "Class[]";
        stateWMEArgArray.addFieldModifiers(privateMods);
        stateWMEArgArray.addFieldName("__$stateWMEArgArray");
        stateWMEArgArray.initializer = "new Class[3]";
        behavingEntity.addField(stateWMEArgArray);
        staticInit.addToBlockBody(new CodeStringDescriptor("__$stateWMEArgArray[0] = Integer.TYPE;"));
        staticInit.addToBlockBody(new CodeStringDescriptor("__$stateWMEArgArray[1] = __$tempObjArray.getClass();"));
        staticInit.addToBlockBody(new CodeStringDescriptor("__$stateWMEArgArray[2] = Class.forName(\"abl.runtime.BehavingEntity\");"));
        FieldDescriptor successConditionArgArray = new FieldDescriptor();
        successConditionArgArray.fieldType = "Class[]";
        successConditionArgArray.addFieldModifiers(privateMods);
        successConditionArgArray.addFieldName("__$successConditionArgArray");
        successConditionArgArray.initializer = "new Class[3]";
        behavingEntity.addField(successConditionArgArray);
        staticInit.addToBlockBody(new CodeStringDescriptor("__$successConditionArgArray[0] = Integer.TYPE;"));
        staticInit.addToBlockBody(new CodeStringDescriptor("__$successConditionArgArray[1] = __$tempObjArray.getClass();"));
        staticInit.addToBlockBody(new CodeStringDescriptor("__$successConditionArgArray[2] = Class.forName(\"abl.runtime.BehavingEntity\");"));
        behavingEntity.addStaticBlock(new CodeStringDescriptor(staticInit.toString()));
    }

    private void compileEntityStaticInitializer(ClassDescriptor behavingEntity) {
        this.initializeArgumentFields(behavingEntity);
        CodeBlockDescriptor tryBlock = new CodeBlockDescriptor("try {", "} catch (Exception e) { throw new AblRuntimeError(\"Error in static initializer\", e); }");
        tryBlock.addToBlockBody(this.behaviorFactoryStream.compileReflectionFields(behavingEntity));
        behavingEntity.addStaticBlock(new CodeStringDescriptor(tryBlock.toString()));
        tryBlock = new CodeBlockDescriptor("try {", "} catch (Exception e) { throw new AblRuntimeError(\"Error in static initializer\", e); }");
        tryBlock.addToBlockBody(this.preconditionStream.compileReflectionFields(behavingEntity));
        behavingEntity.addStaticBlock(new CodeStringDescriptor(tryBlock.toString()));
        tryBlock = new CodeBlockDescriptor("try {", "} catch (Exception e) { throw new AblRuntimeError(\"Error in static initializer\", e); }");
        tryBlock.addToBlockBody(this.preconditionSensorFactoryStream.compileReflectionFields(behavingEntity));
        behavingEntity.addStaticBlock(new CodeStringDescriptor(tryBlock.toString()));
        tryBlock = new CodeBlockDescriptor("try {", "} catch (Exception e) { throw new AblRuntimeError(\"Error in static initializer\", e); }");
        tryBlock.addToBlockBody(this.contextConditionStream.compileReflectionFields(behavingEntity));
        behavingEntity.addStaticBlock(new CodeStringDescriptor(tryBlock.toString()));
        tryBlock = new CodeBlockDescriptor("try {", "} catch (Exception e) { throw new AblRuntimeError(\"Error in static initializer\", e); }");
        tryBlock.addToBlockBody(this.contextConditionSensorFactoryStream.compileReflectionFields(behavingEntity));
        behavingEntity.addStaticBlock(new CodeStringDescriptor(tryBlock.toString()));
        tryBlock = new CodeBlockDescriptor("try {", "} catch (Exception e) { throw new AblRuntimeError(\"Error in static initializer\", e); }");
        tryBlock.addToBlockBody(this.stepFactoryStream.compileReflectionFields(behavingEntity));
        behavingEntity.addStaticBlock(new CodeStringDescriptor(tryBlock.toString()));
        tryBlock = new CodeBlockDescriptor("try {", "} catch (Exception e) { throw new AblRuntimeError(\"Error in static initializer\", e); }");
        tryBlock.addToBlockBody(this.argumentStepExecuteStream.compileReflectionFields(behavingEntity));
        behavingEntity.addStaticBlock(new CodeStringDescriptor(tryBlock.toString()));
        tryBlock = new CodeBlockDescriptor("try {", "} catch (Exception e) { throw new AblRuntimeError(\"Error in static initializer\", e); }");
        tryBlock.addToBlockBody(this.mentalStepExecuteStream.compileReflectionFields(behavingEntity));
        behavingEntity.addStaticBlock(new CodeStringDescriptor(tryBlock.toString()));
        tryBlock = new CodeBlockDescriptor("try {", "} catch (Exception e) { throw new AblRuntimeError(\"Error in static initializer\", e); }");
        tryBlock.addToBlockBody(this.successTestStream.compileReflectionFields(behavingEntity));
        behavingEntity.addStaticBlock(new CodeStringDescriptor(tryBlock.toString()));
        tryBlock = new CodeBlockDescriptor("try {", "} catch (Exception e) { throw new AblRuntimeError(\"Error in static initializer\", e); }");
        tryBlock.addToBlockBody(this.successTestSensorFactoryStream.compileReflectionFields(behavingEntity));
        behavingEntity.addStaticBlock(new CodeStringDescriptor(tryBlock.toString()));
        tryBlock = new CodeBlockDescriptor("try {", "} catch (Exception e) { throw new AblRuntimeError(\"Error in static initializer\", e); }");
        tryBlock.addToBlockBody(this.reinforcementTestStream.compileReflectionFields(behavingEntity));
        behavingEntity.addStaticBlock(new CodeStringDescriptor(tryBlock.toString()));
        tryBlock = new CodeBlockDescriptor("try {", "} catch (Exception e) { throw new AblRuntimeError(\"Error in static initializer\", e); }");
        tryBlock.addToBlockBody(this.reinforcementTestSensorFactoryStream.compileReflectionFields(behavingEntity));
        behavingEntity.addStaticBlock(new CodeStringDescriptor(tryBlock.toString()));
        tryBlock = new CodeBlockDescriptor("try {", "} catch (Exception e) { throw new AblRuntimeError(\"Error in static initializer\", e); }");
        tryBlock.addToBlockBody(this.rlPolicyStream.compileReflectionFields(behavingEntity));
        behavingEntity.addStaticBlock(new CodeStringDescriptor(tryBlock.toString()));
        tryBlock = new CodeBlockDescriptor("try {", "} catch (Exception e) { throw new AblRuntimeError(\"Error in static initializer\", e); }");
        tryBlock.addToBlockBody(this.stateWMEStream.compileReflectionFields(behavingEntity));
        behavingEntity.addStaticBlock(new CodeStringDescriptor(tryBlock.toString()));
        tryBlock = new CodeBlockDescriptor("try {", "} catch (Exception e) { throw new AblRuntimeError(\"Error in static initializer\", e); }");
        tryBlock.addToBlockBody(this.stateWMESensorFactoryStream.compileReflectionFields(behavingEntity));
        behavingEntity.addStaticBlock(new CodeStringDescriptor(tryBlock.toString()));
        tryBlock = new CodeBlockDescriptor("try {", "} catch (Exception e) { throw new AblRuntimeError(\"Error in static initializer\", e); }");
        tryBlock.addToBlockBody(this.successConditionStream.compileReflectionFields(behavingEntity));
        behavingEntity.addStaticBlock(new CodeStringDescriptor(tryBlock.toString()));
        tryBlock = new CodeBlockDescriptor("try {", "} catch (Exception e) { throw new AblRuntimeError(\"Error in static initializer\", e); }");
        tryBlock.addToBlockBody(this.successConditionSensorFactoryStream.compileReflectionFields(behavingEntity));
        behavingEntity.addStaticBlock(new CodeStringDescriptor(tryBlock.toString()));
    }

    private MethodDescriptor defineInitConflictSet() {
        MethodDescriptor initConflictSet = new MethodDescriptor();
        initConflictSet.addModifier("private");
        initConflictSet.addModifier("static");
        initConflictSet.addModifier("void");
        initConflictSet.methodName = "__$initConflictSet" + this.initConflictSetMethodCounter++;
        return initConflictSet;
    }

    private void compileConflictSets(ClassDescriptor behavingEntity) {
        if (this.conflictSets.size() > 0) {
            MethodDescriptor initConflictSet = this.defineInitConflictSet();
            for (List<String> conflictSet : this.conflictSets) {
                String fieldName = this.conflictSetsToFieldNames.get(conflictSet);
                FieldDescriptor f = new FieldDescriptor();
                f.fieldType = "String[]";
                f.addFieldModifier("static");
                f.addFieldName(fieldName);
                behavingEntity.addField(f);
                StringBuffer buf = new StringBuffer(4096);
                buf.append("{");
                int i = 0;
                while (i < conflictSet.size() - 1) {
                    buf.append("\"" + conflictSet.get(i) + "\"" + ", ");
                    ++i;
                }
                buf.append("\"" + conflictSet.get(conflictSet.size() - 1) + "\"" + "};");
                initConflictSet.addToBlockBody(new CodeStringDescriptor(String.valueOf(fieldName) + " = new String[]" + buf.toString()));
                if (initConflictSet.toString().length() <= 40000) continue;
                behavingEntity.addMethod(initConflictSet);
                initConflictSet = this.defineInitConflictSet();
            }
            behavingEntity.addMethod(initConflictSet);
        }
    }

    public void compileToJava() throws CompileException {
        this.scopeName = this.behavingEntityClass;
        this.setScopeType(0);
        this.initializeScope();
        this.addChildVariableDeclarations();
        this.processWMERegistration();
        this.processActionRegistration();
        this.processPropertyDeclarations();
        this.getFullPackagePath(Abl.objectDirectory, this.behavingEntityPackage).mkdirs();
        this.behaviorFactoryStream = new CodeStream(String.valueOf(this.behavingEntityClass) + "_BehaviorFactories", 0, 225);
        this.preconditionSensorFactoryStream = new CodeStream(String.valueOf(this.behavingEntityClass) + "_PreconditionSensorFactories", 1, 1000);
        this.contextConditionSensorFactoryStream = new CodeStream(String.valueOf(this.behavingEntityClass) + "_ContextConditionSensorFactories", 2, 1000);
        this.contextConditionStream = new CodeStream(String.valueOf(this.behavingEntityClass) + "_ContextConditions", 7, 300);
        this.preconditionStream = new CodeStream(String.valueOf(this.behavingEntityClass) + "_Preconditions", 13, 300);
        this.stepFactoryStream = new CodeStream(String.valueOf(this.behavingEntityClass) + "_StepFactories", 14, 1000);
        if (Abl.debugLevel == 2) {
            this.stepFactoryStream.writeCode(DEFAULT_WAIT_STEP_FACTORY_DEBUG, null);
            this.stepFactoryStream.writeCode(DEFAULT_FAIL_STEP_FACTORY_DEBUG, null);
            this.stepFactoryStream.writeCode(DEFAULT_SUCCEED_STEP_FACTORY_DEBUG, null);
        } else {
            this.stepFactoryStream.writeCode(DEFAULT_WAIT_STEP_FACTORY, null);
            this.stepFactoryStream.writeCode(DEFAULT_FAIL_STEP_FACTORY, null);
            this.stepFactoryStream.writeCode(DEFAULT_SUCCEED_STEP_FACTORY, null);
        }
        this.argumentStepExecuteStream = new CodeStream(String.valueOf(this.behavingEntityClass) + "_ArgumentStepExecute", 15, 250);
        this.mentalStepExecuteStream = new CodeStream(String.valueOf(this.behavingEntityClass) + "_MentalStepExecute", 16, 250);
        this.successTestStream = new CodeStream(String.valueOf(this.behavingEntityClass) + "_SuccessTests", 9, 300);
        this.successTestSensorFactoryStream = new CodeStream(String.valueOf(this.behavingEntityClass) + "_SuccessTestSensorFactories", 4, 1000);
        this.reinforcementTestStream = new CodeStream(String.valueOf(this.behavingEntityClass) + "_ReinforcementSignals", 10, 300);
        this.reinforcementTestSensorFactoryStream = new CodeStream(String.valueOf(this.behavingEntityClass) + "_ReinforcementSignalSensorFactories", 5, 1000);
        this.rlPolicyStream = new CodeStream(String.valueOf(this.behavingEntityClass) + "_RLPolicy", 11, 1);
        this.rlPolicySuffix = new CodeBlockDescriptor("", "");
        this.stateWMEStream = new CodeStream(String.valueOf(this.behavingEntityClass) + "_StateWMEs", 12, 300);
        this.stateWMESensorFactoryStream = new CodeStream(String.valueOf(this.behavingEntityClass) + "_StateWMESensorFactories", 6, 300);
        this.successConditionSensorFactoryStream = new CodeStream(String.valueOf(this.behavingEntityClass) + "_SuccessConditionSensorFactories", 3, 1000);
        this.successConditionStream = new CodeStream(String.valueOf(this.behavingEntityClass) + "_SuccessConditions", 8, 300);
        this.compileChildren();
        ArrayList<Hashtable<Integer, HashSet<String>>> signatures = this.buildBehaviorSignatureIndices();
        ClassDescriptor behavingEntity = new ClassDescriptor();
        behavingEntity.className = this.behavingEntityClass;
        int i = 0;
        while (i < importPackages.length) {
            behavingEntity.addPackageImport(importPackages[i]);
            ++i;
        }
        this.addUserImports(behavingEntity);
        this.addUserConstantDeclarations(behavingEntity);
        behavingEntity.packageName = this.behavingEntityPackage;
        behavingEntity.addClassModifier("public");
        behavingEntity.extendsClass = "BehavingEntity";
        ListIterator iter = this.fieldDescriptors.listIterator();
        while (iter.hasNext()) {
            behavingEntity.addField((FieldDescriptor)iter.next());
        }
        this.compileEntityStaticInitializer(behavingEntity);
        this.compileConflictSets(behavingEntity);
        Iterator<ASTBehaviorDefinition> individualBehaviorIter = this.individualBehaviorDefinitionNodes.iterator();
        int registrationMethodCounter = 0;
        int i2 = 0;
        while (i2 < this.individualBehaviorDefinitionNodes.size() / 1000 + 1) {
            behavingEntity.addMethod(this.compileRegistrationMethod(registrationMethodCounter, signatures.get(0), individualBehaviorIter));
            ++i2;
            ++registrationMethodCounter;
        }
        Iterator<ASTBehaviorDefinition> jointBehaviorIter = this.jointBehaviorDefinitionNodes.iterator();
        int i3 = 0;
        while (i3 < this.jointBehaviorDefinitionNodes.size() / 1000 + 1) {
            behavingEntity.addMethod(this.compileRegistrationMethod(registrationMethodCounter, signatures.get(1), jointBehaviorIter));
            ++i3;
            ++registrationMethodCounter;
        }
        MethodDescriptor decisionCycleSMCall = this.compileDecisionCycleSMCall();
        if (decisionCycleSMCall != null) {
            behavingEntity.addMethod(decisionCycleSMCall);
        }
        behavingEntity.addMethod(this.compileEntryPoint());
        behavingEntity.addMethod(this.compileConstructor());
        behavingEntity.writeToFile(this.getFullPackagePath(Abl.objectDirectory, this.behavingEntityPackage));
        this.behaviorFactoryStream.closeCode();
        this.preconditionSensorFactoryStream.closeCode();
        this.contextConditionSensorFactoryStream.closeCode();
        this.contextConditionStream.closeCode();
        this.successConditionSensorFactoryStream.closeCode();
        this.successConditionStream.closeCode();
        this.preconditionStream.closeCode();
        this.stepFactoryStream.closeCode();
        this.argumentStepExecuteStream.closeCode();
        this.mentalStepExecuteStream.closeCode();
        this.successTestStream.closeCode();
        this.successTestSensorFactoryStream.closeCode();
        this.reinforcementTestStream.closeCode();
        this.reinforcementTestSensorFactoryStream.closeCode();
        this.rlPolicyStream.closeCode(this.rlPolicySuffix);
        this.stateWMEStream.closeCode();
        this.stateWMESensorFactoryStream.closeCode();
    }

    String addConflictSet(String[] conflictArray) {
        List<String> conflictList = Arrays.asList(conflictArray);
        if (this.conflictSets.contains(conflictList)) {
            assert (this.conflictSetsToFieldNames.get(conflictList) != null);
            return this.conflictSetsToFieldNames.get(conflictList);
        }
        assert (this.conflictSetsToFieldNames.get(conflictList) == null);
        this.conflictSets.add(conflictList);
        String fieldName = "__$conflictSet" + this.conflictSets.size();
        this.conflictSetsToFieldNames.put(conflictList, fieldName);
        return fieldName;
    }

    File getFullPackagePath(File baseDir, String packageName) {
        return new File(baseDir, packageName.replace('.', File.separatorChar));
    }

    private class CodeStream {
        static final int CODE_TYPE_BEHAVIOR_FACTORY = 0;
        static final int CODE_TYPE_PRECONDITION_SENSOR_FACTORY = 1;
        static final int CODE_TYPE_CONTEXT_CONDITION_SENSOR_FACTORY = 2;
        static final int CODE_TYPE_SUCCESS_CONDITION_SENSOR_FACTORY = 3;
        static final int CODE_TYPE_SUCCESS_TEST_SENSOR_FACTORY = 4;
        static final int CODE_TYPE_REINFORCEMENT_TEST_SENSOR_FACTORY = 5;
        static final int CODE_TYPE_STATE_WME_SENSOR_FACTORY = 6;
        static final int CODE_TYPE_CONTEXT_CONDITION = 7;
        static final int CODE_TYPE_SUCCESS_CONDITION = 8;
        static final int CODE_TYPE_SUCCESS_TEST = 9;
        static final int CODE_TYPE_REINFORCEMENT_TEST = 10;
        static final int CODE_TYPE_RL_POLICY = 11;
        static final int CODE_TYPE_STATE_WME = 12;
        static final int CODE_TYPE_PRECONDITION = 13;
        static final int CODE_TYPE_STEP_FACTORY = 14;
        static final int CODE_TYPE_ARGUMENT_STEP_EXECUTE = 15;
        static final int CODE_TYPE_MENTAL_STEP_EXECUTE = 16;
        private final PrintStream codeStream;
        private final int codeStreamType;
        private int methodCounter;
        private int caseCounter;
        private final int caseLimit;
        private final List<String> methods;

        CodeStream(String arg_codeStreamName, int arg_codeStreamType, int arg_caseLimit) {
            this.codeStreamType = arg_codeStreamType;
            this.methodCounter = -1;
            this.caseCounter = 0;
            this.caseLimit = arg_caseLimit;
            this.methods = new ArrayList<String>(1000);
            try {
                File packageDir = ASTBehaviorUnit.this.getFullPackagePath(Abl.objectDirectory, ASTBehaviorUnit.this.behavingEntityPackage);
                this.codeStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(new File(packageDir, String.valueOf(arg_codeStreamName) + ".java")), 100000));
                this.codeStream.println("package " + ASTBehaviorUnit.this.behavingEntityPackage + ";");
                this.codeStream.println("");
                int i = 0;
                while (i < importPackages.length) {
                    this.codeStream.println("import " + importPackages[i] + ";");
                    ++i;
                }
                ASTBehaviorUnit.this.printUserImports(this.codeStream);
                this.codeStream.print("public class " + arg_codeStreamName + " ");
                ASTBehaviorUnit.this.printUserConstantDeclarations(this.codeStream);
                this.codeStream.println("{");
                this.startCodeMethod();
            }
            catch (IOException e) {
                throw new CompileError("Error initing stream " + arg_codeStreamName, e);
            }
        }

        int getMethodCounter() {
            return this.methodCounter;
        }

        List getMethods() {
            return this.methods;
        }

        private void startCodeMethod() {
            ++this.methodCounter;
            this.methods.add(this.getCodeClassName(this.codeStreamType));
            this.methods.add(this.getCodeMethodName(this.codeStreamType));
            switch (this.codeStreamType) {
                case 0: {
                    if (Abl.debugLevel == 2) {
                        this.codeStream.println("   static public Behavior " + this.getCodeMethodName(this.codeStreamType) + "(int __$behaviorID, Object[] __$args, Hashtable __$boundVars, " + "GoalStep __$parentGoal, String __$signature, __BehaviorDesc __$behaviorDesc) {");
                        break;
                    }
                    this.codeStream.println("   static public Behavior " + this.getCodeMethodName(this.codeStreamType) + "(int __$behaviorID, Object[] __$args, Hashtable __$boundVars, " + "GoalStep __$parentGoal, String __$signature) {");
                    break;
                }
                case 1: {
                    this.codeStream.println("   static public SensorActivation[] " + this.getCodeMethodName(this.codeStreamType) + "(int __$behaviorID) {");
                    break;
                }
                case 2: {
                    this.codeStream.println("   static public SensorActivation[] " + this.getCodeMethodName(this.codeStreamType) + "(int __$behaviorID) {");
                    break;
                }
                case 3: {
                    this.codeStream.println("   static public SensorActivation[] " + this.getCodeMethodName(this.codeStreamType) + "(int __$behaviorID) {");
                    break;
                }
                case 4: {
                    this.codeStream.println("   static public SensorActivation[] " + this.getCodeMethodName(this.codeStreamType) + "(int __$stepID) {");
                    break;
                }
                case 5: {
                    this.codeStream.println("   static public SensorActivation[] " + this.getCodeMethodName(this.codeStreamType) + "(int __$behaviorID) {");
                    break;
                }
                case 6: {
                    this.codeStream.println("   static public SensorActivation[] " + this.getCodeMethodName(this.codeStreamType) + "(int __$behaviorID) {");
                    break;
                }
                case 7: {
                    this.codeStream.println("   static public boolean " + this.getCodeMethodName(this.codeStreamType) + "(int __$behaviorID, final Object[] __$behaviorFrame, final BehavingEntity __$thisEntity) {");
                    break;
                }
                case 8: {
                    this.codeStream.println("   static public boolean " + this.getCodeMethodName(this.codeStreamType) + "(int __$behaviorID, final Object[] __$behaviorFrame, final BehavingEntity __$thisEntity) {");
                    break;
                }
                case 9: {
                    this.codeStream.println("   static public boolean " + this.getCodeMethodName(this.codeStreamType) + "(int __$stepID, final Object[] __$behaviorFrame, final BehavingEntity __$thisEntity) {");
                    break;
                }
                case 10: {
                    this.codeStream.println("   static public double " + this.getCodeMethodName(this.codeStreamType) + "(int __$behaviorID, final Object[] __$behaviorFrame, final BehavingEntity __$thisEntity) {");
                    break;
                }
                case 11: {
                    this.codeStream.println("   static public int " + this.getCodeMethodName(this.codeStreamType) + "(int __$behaviorID, Object prevLocation, int stepIndex, Object currLocation, double rewardValue, boolean isRewarding) {");
                    break;
                }
                case 12: {
                    this.codeStream.println("   static public Object " + this.getCodeMethodName(this.codeStreamType) + "(int __$behaviorID, final Object[] __$behaviorFrame, final BehavingEntity __$thisEntity) {");
                    break;
                }
                case 13: {
                    this.codeStream.println("   static public boolean " + this.getCodeMethodName(this.codeStreamType) + "(int __$behaviorID, Object[] __$args, Hashtable __$variableTable, final BehavingEntity __$thisEntity) {");
                    break;
                }
                case 14: {
                    this.codeStream.println("   static public Step " + this.getCodeMethodName(this.codeStreamType) + "(int __$stepID, Behavior __$behaviorParent, final Object[] __$behaviorFrame) {");
                    break;
                }
                case 15: {
                    this.codeStream.println("   static public Object[] " + this.getCodeMethodName(this.codeStreamType) + "(int __$stepID, final Object[] __$behaviorFrame, final BehavingEntity __$thisEntity) {");
                    break;
                }
                case 16: {
                    this.codeStream.println("   static public void " + this.getCodeMethodName(this.codeStreamType) + "(int __$stepID, final Object[] __$behaviorFrame, final BehavingEntity __$thisEntity, MentalStep __$thisStep) {");
                    break;
                }
                default: {
                    throw new CompileError("Unexpected code type " + this.codeStreamType);
                }
            }
            switch (this.codeStreamType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 12: 
                case 13: {
                    this.codeStream.println("      switch (__$behaviorID) {");
                    break;
                }
                case 4: 
                case 9: 
                case 14: 
                case 15: 
                case 16: {
                    this.codeStream.println("      switch (__$stepID) {");
                    break;
                }
                case 11: {
                    this.codeStream.println("      switch (__$behaviorID) {");
                    break;
                }
                default: {
                    throw new CompileError("Unexpected code type " + this.codeStreamType);
                }
            }
        }

        void writeCode(CodeBlockDescriptor code, AblParseNode node) {
            assert (code != null);
            if (node != null) {
                switch (this.codeStreamType) {
                    case 0: {
                        ((ASTBehaviorDefinition)node).setBehaviorFactoryClass(this.getCodeClassName(0));
                        ((ASTBehaviorDefinition)node).setBehaviorFactoryMethod_rField(ASTBehaviorUnit.this.getCodeMethodReflectionField(this.getCodeMethodName(0)));
                        break;
                    }
                    case 1: {
                        ((ASTBehaviorDefinition)node).setPreconditionSensorFactoryClass(this.getCodeClassName(1));
                        ((ASTBehaviorDefinition)node).setPreconditionSensorFactoryMethod_rField(ASTBehaviorUnit.this.getCodeMethodReflectionField(this.getCodeMethodName(1)));
                        break;
                    }
                    case 2: {
                        ((ASTBehaviorDefinition)node).setContextConditionSensorFactoryClass(this.getCodeClassName(2));
                        ((ASTBehaviorDefinition)node).setContextConditionSensorFactoryMethod_rField(ASTBehaviorUnit.this.getCodeMethodReflectionField(this.getCodeMethodName(2)));
                        break;
                    }
                    case 3: {
                        ((ASTBehaviorDefinition)node).setSuccessConditionSensorFactoryClass(this.getCodeClassName(3));
                        ((ASTBehaviorDefinition)node).setSuccessConditionSensorFactoryMethod_rField(ASTBehaviorUnit.this.getCodeMethodReflectionField(this.getCodeMethodName(3)));
                        break;
                    }
                    case 4: {
                        ((GenericStep)node).setSuccessTestSensorFactoryMethod_rField(ASTBehaviorUnit.this.getCodeMethodReflectionField(this.getCodeMethodName(4)));
                        break;
                    }
                    case 5: {
                        ((ASTBehaviorDefinition)node).setReinforcementSignalsSensorFactoryClass(this.getCodeClassName(5));
                        ((ASTBehaviorDefinition)node).setReinforcementSignalsSensorFactoryMethod_rField(ASTBehaviorUnit.this.getCodeMethodReflectionField(this.getCodeMethodName(5)));
                        break;
                    }
                    case 6: {
                        ((ASTBehaviorDefinition)node).setStateWMESensorFactoryClass(this.getCodeClassName(6));
                        ((ASTBehaviorDefinition)node).setStateWMESensorFactoryMethod_rField(ASTBehaviorUnit.this.getCodeMethodReflectionField(this.getCodeMethodName(6)));
                        break;
                    }
                    case 7: {
                        ((ASTBehaviorDefinition)node).setContextConditionClass(this.getCodeClassName(7));
                        ((ASTBehaviorDefinition)node).setContextConditionMethod_rField(ASTBehaviorUnit.this.getCodeMethodReflectionField(this.getCodeMethodName(7)));
                        break;
                    }
                    case 8: {
                        ((ASTBehaviorDefinition)node).setSuccessConditionClass(this.getCodeClassName(8));
                        ((ASTBehaviorDefinition)node).setSuccessConditionMethod_rField(ASTBehaviorUnit.this.getCodeMethodReflectionField(this.getCodeMethodName(8)));
                        break;
                    }
                    case 9: {
                        ((GenericStep)node).setSuccessTestMethod_rField(ASTBehaviorUnit.this.getCodeMethodReflectionField(this.getCodeMethodName(9)));
                        break;
                    }
                    case 10: {
                        ((ASTBehaviorDefinition)node).setReinforcementSignalsClass(this.getCodeClassName(10));
                        ((ASTBehaviorDefinition)node).setReinforcementSignalsMethod_rField(ASTBehaviorUnit.this.getCodeMethodReflectionField(this.getCodeMethodName(10)));
                        break;
                    }
                    case 11: {
                        ((ASTBehaviorDefinition)node).setRLPolicyClass(this.getCodeClassName(11));
                        ((ASTBehaviorDefinition)node).setRLPolicyMethod_rField(ASTBehaviorUnit.this.getCodeMethodReflectionField(this.getCodeMethodName(11)));
                        break;
                    }
                    case 12: {
                        ((ASTBehaviorDefinition)node).setStateWMEClass(this.getCodeClassName(12));
                        ((ASTBehaviorDefinition)node).setStateWMEMethod_rField(ASTBehaviorUnit.this.getCodeMethodReflectionField(this.getCodeMethodName(12)));
                        break;
                    }
                    case 13: {
                        ((ASTBehaviorDefinition)node).setPreconditionClass(this.getCodeClassName(13));
                        ((ASTBehaviorDefinition)node).setPreconditionMethod_rField(ASTBehaviorUnit.this.getCodeMethodReflectionField(this.getCodeMethodName(13)));
                        break;
                    }
                    case 14: {
                        ((GenericStep)node).setStepFactoryMethod_rField(ASTBehaviorUnit.this.getCodeMethodReflectionField(this.getCodeMethodName(this.codeStreamType)));
                        break;
                    }
                    case 15: 
                    case 16: {
                        ((GenericStep)node).setExecuteMethod_rField(ASTBehaviorUnit.this.getCodeMethodReflectionField(this.getCodeMethodName(this.codeStreamType)));
                        break;
                    }
                    default: {
                        throw new CompileError("Unexpected code type " + this.codeStreamType);
                    }
                }
            }
            this.codeStream.print(code.toString(3));
            ++this.caseCounter;
            if (this.caseCounter > this.caseLimit) {
                this.closeSwitch();
                this.caseCounter = 0;
                this.startCodeMethod();
            }
        }

        private void closeSwitch() {
            this.codeStream.println("      default:");
            switch (this.codeStreamType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 12: 
                case 13: {
                    this.codeStream.println("         throw new AblRuntimeError(\"Unexpected behaviorID \" + __$behaviorID);");
                    break;
                }
                case 4: 
                case 9: 
                case 14: 
                case 15: 
                case 16: {
                    this.codeStream.println("         throw new AblRuntimeError(\"Unexpected stepID \" + __$stepID);");
                    break;
                }
                case 11: {
                    this.codeStream.println("         throw new AblRuntimeError(\"Unexpected behaviorID \" + __$behaviorID);");
                    break;
                }
                default: {
                    throw new CompileError("Unexpected code type " + this.codeStreamType);
                }
            }
            this.codeStream.println("      }");
            this.codeStream.println("   }");
        }

        void closeCode() {
            this.closeSwitch();
            this.codeStream.println("}");
            this.codeStream.close();
        }

        void closeCode(CodeBlockDescriptor suffix) {
            this.closeSwitch();
            this.codeStream.print(suffix.toString(0));
            this.codeStream.println("}");
            this.codeStream.close();
        }

        private String getCodeClassName(int codeType) {
            switch (codeType) {
                case 0: {
                    return String.valueOf(ASTBehaviorUnit.this.behavingEntityClass) + "_BehaviorFactories";
                }
                case 1: {
                    return String.valueOf(ASTBehaviorUnit.this.behavingEntityClass) + "_PreconditionSensorFactories";
                }
                case 2: {
                    return String.valueOf(ASTBehaviorUnit.this.behavingEntityClass) + "_ContextConditionSensorFactories";
                }
                case 3: {
                    return String.valueOf(ASTBehaviorUnit.this.behavingEntityClass) + "_SuccessConditionSensorFactories";
                }
                case 4: {
                    return String.valueOf(ASTBehaviorUnit.this.behavingEntityClass) + "_SuccessTestSensorFactories";
                }
                case 5: {
                    return String.valueOf(ASTBehaviorUnit.this.behavingEntityClass) + "_ReinforcementSignalSensorFactories";
                }
                case 6: {
                    return String.valueOf(ASTBehaviorUnit.this.behavingEntityClass) + "_StateWMESensorFactories";
                }
                case 7: {
                    return String.valueOf(ASTBehaviorUnit.this.behavingEntityClass) + "_ContextConditions";
                }
                case 8: {
                    return String.valueOf(ASTBehaviorUnit.this.behavingEntityClass) + "_SuccessConditions";
                }
                case 9: {
                    return String.valueOf(ASTBehaviorUnit.this.behavingEntityClass) + "_SuccessTests";
                }
                case 10: {
                    return String.valueOf(ASTBehaviorUnit.this.behavingEntityClass) + "_ReinforcementSignals";
                }
                case 11: {
                    return String.valueOf(ASTBehaviorUnit.this.behavingEntityClass) + "_RLPolicy";
                }
                case 12: {
                    return String.valueOf(ASTBehaviorUnit.this.behavingEntityClass) + "_StateWMEs";
                }
                case 13: {
                    return String.valueOf(ASTBehaviorUnit.this.behavingEntityClass) + "_Preconditions";
                }
                case 14: {
                    return String.valueOf(ASTBehaviorUnit.this.behavingEntityClass) + "_StepFactories";
                }
                case 15: {
                    return String.valueOf(ASTBehaviorUnit.this.behavingEntityClass) + "_ArgumentStepExecute";
                }
                case 16: {
                    return String.valueOf(ASTBehaviorUnit.this.behavingEntityClass) + "_MentalStepExecute";
                }
            }
            throw new CompileError("Unexpected code type " + codeType);
        }

        private String getCodeMethodName(int codeType) {
            switch (codeType) {
                case 0: {
                    return "behaviorFactory" + this.methodCounter;
                }
                case 1: {
                    return "preconditionSensorFactory" + this.methodCounter;
                }
                case 2: {
                    return "contextConditionSensorFactory" + this.methodCounter;
                }
                case 3: {
                    return "successConditionSensorFactory" + this.methodCounter;
                }
                case 4: {
                    return "successTestSensorFactory" + this.methodCounter;
                }
                case 5: {
                    return "reinforcementSignalSensorFactory" + this.methodCounter;
                }
                case 6: {
                    return "stateWMESensorFactory" + this.methodCounter;
                }
                case 7: {
                    return "contextCondition" + this.methodCounter;
                }
                case 8: {
                    return "successCondition" + this.methodCounter;
                }
                case 9: {
                    return "successTest" + this.methodCounter;
                }
                case 10: {
                    return "reinforcementSignal" + this.methodCounter;
                }
                case 11: {
                    return "rlPolicy" + this.methodCounter;
                }
                case 12: {
                    return "stateWME" + this.methodCounter;
                }
                case 13: {
                    return "precondition" + this.methodCounter;
                }
                case 14: {
                    return "stepFactory" + this.methodCounter;
                }
                case 15: {
                    return "argumentExecute" + this.methodCounter;
                }
                case 16: {
                    return "mentalExecute" + this.methodCounter;
                }
            }
            throw new CompileError("Unexpected code type " + codeType);
        }

        CodeSequenceDescriptor compileReflectionFields(ClassDescriptor behavingEntity) {
            assert (this.methods.size() % 2 == 0);
            CodeSequenceDescriptor reflectionFieldInit = new CodeSequenceDescriptor();
            HashSet<String> initedClasses = new HashSet<String>();
            Iterator<String> methodsIter = this.methods.iterator();
            while (methodsIter.hasNext()) {
                String className = methodsIter.next();
                if (!initedClasses.contains(className)) {
                    initedClasses.add(className);
                    FieldDescriptor classField = new FieldDescriptor();
                    classField.fieldType = "Class";
                    classField.addFieldModifiers(privateMods);
                    String classFieldName = ASTBehaviorUnit.this.getCodeMethodReflectionField(className);
                    classField.addFieldName(classFieldName);
                    behavingEntity.addField(classField);
                    String[] classFieldInitMacroArgs = new String[]{classFieldName, className, ASTBehaviorUnit.this.behavingEntityPackage};
                    try {
                        reflectionFieldInit.addToSequence(new CodeStringDescriptor(initCodeClassReflectionField.expand(classFieldInitMacroArgs)));
                    }
                    catch (SimpleMacroException e) {
                        throw new CompileError("Error compiling static initializer block", e);
                    }
                }
                String methodName = methodsIter.next();
                String methodFieldName = ASTBehaviorUnit.this.getCodeMethodReflectionField(methodName);
                FieldDescriptor methodField = new FieldDescriptor();
                methodField.fieldType = "Method";
                methodField.addFieldModifiers(packageMods);
                methodField.addFieldName(methodFieldName);
                behavingEntity.addField(methodField);
                String[] macroArgs1 = new String[4];
                macroArgs1[0] = methodFieldName;
                macroArgs1[1] = ASTBehaviorUnit.this.getCodeMethodReflectionField(className);
                macroArgs1[2] = methodName;
                switch (this.codeStreamType) {
                    case 0: {
                        macroArgs1[3] = "__$behFactoryArgArray";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        macroArgs1[3] = "__$sensorFactoryArgArray";
                        break;
                    }
                    case 7: 
                    case 9: {
                        macroArgs1[3] = "__$continuousConditionArgArray";
                        break;
                    }
                    case 8: {
                        macroArgs1[3] = "__$successConditionArgArray";
                        break;
                    }
                    case 10: {
                        macroArgs1[3] = "__$reinforcementSignalArgArray";
                        break;
                    }
                    case 11: {
                        macroArgs1[3] = "__$rlPolicyArgArray";
                        break;
                    }
                    case 12: {
                        macroArgs1[3] = "__$stateWMEArgArray";
                        break;
                    }
                    case 13: {
                        macroArgs1[3] = "__$preconditionArgArray";
                        break;
                    }
                    case 14: {
                        macroArgs1[3] = "__$stepFactoryArgArray";
                        break;
                    }
                    case 15: {
                        macroArgs1[3] = "__$argumentStepExecuteArgArray";
                        break;
                    }
                    case 16: {
                        macroArgs1[3] = "__$mentalStepExecuteArgArray";
                        break;
                    }
                    default: {
                        throw new CompileError("Unexpected code type " + this.codeStreamType);
                    }
                }
                String[] macroArgs2 = new String[]{methodFieldName};
                try {
                    reflectionFieldInit.addToSequence(new CodeStringDescriptor(initCodeMethodReflectionField.expand(macroArgs1)));
                    reflectionFieldInit.addToSequence(new CodeStringDescriptor(setAssignableCodeMethodReflectionField.expand(macroArgs2)));
                }
                catch (SimpleMacroException e) {
                    throw new CompileError("Error compiling static initializer block", e);
                }
            }
            return reflectionFieldInit;
        }
    }
}

