/*
 * Decompiled with CFR 0.152.
 */
package abl.compiler;

import abl.compiler.ASTAnonymousStep;
import abl.compiler.ASTBehaviorUnit;
import abl.compiler.ASTGoalStep;
import abl.compiler.ASTReinforcementSignals;
import abl.compiler.ASTReinforcementState;
import abl.compiler.ASTTestExpression;
import abl.compiler.ASTWaitStep;
import abl.compiler.Abl;
import abl.compiler.AblArgument;
import abl.compiler.AblDebuggerConstants;
import abl.compiler.AblParseNode;
import abl.compiler.AblParser;
import abl.compiler.AblScopeMaintainer;
import abl.compiler.CompileError;
import abl.compiler.CompileException;
import abl.compiler.CompileWarning;
import abl.compiler.GenericStep;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jd.CodeBlockDescriptor;
import jd.CodeStringDescriptor;
import jd.FieldDescriptor;
import jd.MethodArgDescriptor;
import jd.MethodArglistDescriptor;

public class ASTBehaviorDefinition
extends AblScopeMaintainer
implements AblDebuggerConstants {
    private String behaviorType = null;
    String behaviorName;
    private boolean initialTree = false;
    private String uniqueBehaviorName;
    private int behaviorID;
    private boolean hasContextCondition = false;
    private boolean hasPrecondition = false;
    private boolean hasEntryCondition = false;
    private boolean hasSuccessCondition = false;
    private boolean hasReinforcementSignals = false;
    private boolean hasStateCondition = false;
    int specificity = 0;
    int numberNeededForSuccess = -1;
    boolean isAtomic = false;
    private boolean isJoint = false;
    private boolean isAdaptive = false;
    private MethodArglistDescriptor formalArgs = new MethodArglistDescriptor();
    private List<String> teamMembers = new ArrayList<String>();
    private List<Integer> stepIDs = new ArrayList<Integer>(100);
    private List<String> stepFactories = new ArrayList<String>(100);
    private int nonEffectOnlySteps = 0;
    private String behaviorFactoryClass;
    private String behaviorFactoryMethod_rField;
    private String preconditionSensorFactoryClass;
    private String preconditionSensorFactoryMethod_rField;
    private String preconditionClass;
    private String preconditionMethod_rField;
    private String contextConditionSensorFactoryClass;
    private String contextConditionSensorFactoryMethod_rField;
    private String contextConditionClass;
    private String contextConditionMethod_rField;
    private String successConditionSensorFactoryClass;
    private String successConditionSensorFactoryMethod_rField;
    private String successConditionClass;
    private String successConditionMethod_rField;
    private String successTestSensorFactoryClass;
    private String successTestSensorFactoryMethod_rField;
    private String successTestClass;
    private String successTestMethod_rField;
    private String reinforcementSignalsSensorFactoryClass;
    private String reinforcementSignalsSensorFactoryMethod_rField;
    private String reinforcementSignalsClass;
    private String reinforcementSignalsMethod_rField;
    private String rlPolicyClass;
    private String rlPolicyMethod_rField;
    private String stateWMESensorFactoryClass;
    private String stateWMESensorFactoryMethod_rField;
    private String stateWMEClass;
    private String stateWMEMethod_rField;
    private int stepCounter = 0;

    ASTBehaviorDefinition(int id) {
        super(id);
    }

    ASTBehaviorDefinition(AblParser p, int id) {
        super(p, id);
    }

    public boolean isInitialTree() {
        return this.initialTree;
    }

    public String getBehaviorName() {
        return this.behaviorName;
    }

    boolean isJoint() {
        return this.isJoint;
    }

    void setIsJoint() {
        this.isJoint = true;
    }

    void setInitialTree() {
        this.initialTree = true;
        this.setBehaviorType("collection");
        this.behaviorName = "__RootCollectionBehavior";
    }

    boolean isAdaptive() {
        return this.isAdaptive;
    }

    void setIsAdaptive() {
        this.isAdaptive = true;
    }

    void addRole(String role) {
        if (!this.isJoint) {
            throw new CompileError("Attempt to add a role specifier to a non-joint behavior " + this.getSignature());
        }
        this.teamMembers.add(role);
    }

    List getTeamMembers() {
        return this.teamMembers;
    }

    boolean teamMembersSpecified() {
        return !this.teamMembers.isEmpty();
    }

    void setBehaviorType(String behaviorTypeToSet) {
        if (!(behaviorTypeToSet.equals("sequential") || behaviorTypeToSet.equals("parallel") || behaviorTypeToSet.equals("collection"))) {
            throw new CompileError("Attempt to set illegal behavior type: " + behaviorTypeToSet);
        }
        this.behaviorType = behaviorTypeToSet;
    }

    String getBehaviorType() {
        return this.behaviorType;
    }

    void addFormalArgument(MethodArgDescriptor arg) {
        this.formalArgs.addArgument(arg);
    }

    Object[] getFormalArguments() {
        return this.formalArgs.getArguments();
    }

    String getUniqueName() {
        if (this.uniqueBehaviorName != null) {
            return this.uniqueBehaviorName;
        }
        return this.behaviorName;
    }

    @Override
    AblScopeMaintainer getEnclosingBehaviorScope() {
        return this;
    }

    void incrementNonEffectOnlySteps() {
        ++this.nonEffectOnlySteps;
    }

    void addStep(int stepID, String factory) {
        if (stepID != -1 && stepID != -2 && stepID != -3) {
            assert (factory != null);
            this.stepFactories.add(factory);
        } else {
            this.stepFactories.add("__$stepFactory0_rfield");
        }
        this.stepIDs.add(new Integer(stepID));
    }

    int getID() {
        return this.behaviorID;
    }

    boolean getHasPrecondition() {
        return this.hasPrecondition;
    }

    void setHasPrecondition(boolean arg_hasPrecondition) {
        this.hasPrecondition = arg_hasPrecondition;
    }

    boolean getHasContextCondition() {
        return this.hasContextCondition;
    }

    void setHasContextCondition(boolean arg_hasContextCondition) {
        this.hasContextCondition = arg_hasContextCondition;
    }

    boolean getHasEntryCondition() {
        return this.hasEntryCondition;
    }

    void setHasEntryCondition(boolean arg_hasEntryCondition) {
        this.hasEntryCondition = arg_hasEntryCondition;
    }

    boolean getHasSuccessCondition() {
        return this.hasSuccessCondition;
    }

    void setHasSuccessCondition(boolean arg_hasSuccessCondition) {
        this.hasSuccessCondition = arg_hasSuccessCondition;
    }

    boolean getHasReinforcementSignals() {
        return this.hasReinforcementSignals;
    }

    void setHasReinforcementSignals(boolean arg_hasReinforcementSignals) {
        this.hasReinforcementSignals = arg_hasReinforcementSignals;
    }

    boolean getHasStateCondition() {
        return this.hasStateCondition;
    }

    void setHasStateCondition(boolean arg_hasStateCondition) {
        this.hasStateCondition = arg_hasStateCondition;
    }

    public int incrementStepCount() {
        return ++this.stepCounter;
    }

    String getSignature() {
        Object[] args = this.formalArgs.getArguments();
        StringBuffer signatureBuf = new StringBuffer();
        signatureBuf.append(String.valueOf(this.behaviorName) + "(");
        int i = 0;
        while (i < args.length) {
            signatureBuf.append(String.valueOf(((MethodArgDescriptor)args[i]).argType) + ", ");
            ++i;
        }
        if (args.length != 0) {
            signatureBuf.delete(signatureBuf.length() - 2, signatureBuf.length());
        }
        signatureBuf.append(")");
        return signatureBuf.toString().intern();
    }

    String getBehaviorFactoryClass() {
        return this.behaviorFactoryClass;
    }

    String getBehaviorFactoryMethod_rField() {
        return this.behaviorFactoryMethod_rField;
    }

    String getPreconditionSensorFactoryClass() {
        return this.preconditionSensorFactoryClass;
    }

    String getPreconditionSensorFactoryMethod_rField() {
        return this.preconditionSensorFactoryMethod_rField;
    }

    String getPreconditionClass() {
        return this.preconditionClass;
    }

    String getPreconditionMethod_rField() {
        return this.preconditionMethod_rField;
    }

    String getContextConditionSensorFactoryClass() {
        return this.contextConditionSensorFactoryClass;
    }

    String getContextConditionSensorFactoryMethod_rField() {
        return this.contextConditionSensorFactoryMethod_rField;
    }

    String getContextConditionClass() {
        return this.contextConditionClass;
    }

    String getContextConditionMethod_rField() {
        return this.contextConditionMethod_rField;
    }

    String getSuccessConditionSensorFactoryClass() {
        return this.successConditionSensorFactoryClass;
    }

    String getSuccessConditionSensorFactoryMethod_rField() {
        return this.successConditionSensorFactoryMethod_rField;
    }

    String getSuccessConditionClass() {
        return this.successConditionClass;
    }

    String getSuccessConditionMethod_rField() {
        return this.successConditionMethod_rField;
    }

    String getSuccessTestSensorFactoryClass() {
        return this.successTestSensorFactoryClass;
    }

    String getSuccessTestSensorFactoryMethod_rField() {
        return this.successTestSensorFactoryMethod_rField;
    }

    String getSuccessTestClass() {
        return this.successTestClass;
    }

    String getSuccessTestMethod_rField() {
        return this.successTestMethod_rField;
    }

    String getReinforcementSignalsSensorFactoryClass() {
        return this.reinforcementSignalsSensorFactoryClass;
    }

    String getReinforcementSignalsSensorFactoryMethod_rField() {
        return this.reinforcementSignalsSensorFactoryMethod_rField;
    }

    String getReinforcementSignalsClass() {
        return this.reinforcementSignalsClass;
    }

    String getReinforcementSignalsMethod_rField() {
        return this.reinforcementSignalsMethod_rField;
    }

    void setBehaviorFactoryClass(String arg_behaviorFactoryClass) {
        if (this.behaviorFactoryClass != null) {
            throw new CompileError("Attempt to set behaviorFactoryClass multiple times: " + this.behaviorFactoryClass);
        }
        this.behaviorFactoryClass = arg_behaviorFactoryClass;
    }

    void setBehaviorFactoryMethod_rField(String arg_behaviorFactoryMethod_rField) {
        if (this.behaviorFactoryMethod_rField != null) {
            throw new CompileError("Attempt to set behaviorFactoryMethod_rField multiple times: " + this.behaviorFactoryMethod_rField);
        }
        this.behaviorFactoryMethod_rField = arg_behaviorFactoryMethod_rField;
    }

    void setPreconditionSensorFactoryClass(String arg_preconditionSensorFactoryClass) {
        if (this.preconditionSensorFactoryClass != null) {
            throw new CompileError("Attempt to set preconditionSensorFactoryClass multiple times: " + this.preconditionSensorFactoryClass);
        }
        this.preconditionSensorFactoryClass = arg_preconditionSensorFactoryClass;
    }

    void setPreconditionSensorFactoryMethod_rField(String arg_preconditionSensorFactoryMethod_rField) {
        if (this.preconditionSensorFactoryMethod_rField != null) {
            throw new CompileError("Attempt to set preconditionSensorFactoryMethod_rField multiple times: " + this.preconditionSensorFactoryMethod_rField);
        }
        this.preconditionSensorFactoryMethod_rField = arg_preconditionSensorFactoryMethod_rField;
    }

    void setPreconditionClass(String arg_preconditionClass) {
        if (this.preconditionClass != null) {
            throw new CompileError("Attempt to set preconditionClass multiple times: " + this.preconditionClass);
        }
        this.preconditionClass = arg_preconditionClass;
    }

    void setPreconditionMethod_rField(String arg_preconditionMethod_rField) {
        if (this.preconditionMethod_rField != null) {
            throw new CompileError("Attempt to set preconditionMethod_rField multiple times: " + this.preconditionMethod_rField);
        }
        this.preconditionMethod_rField = arg_preconditionMethod_rField;
    }

    void setContextConditionSensorFactoryClass(String arg_contextConditionSensorFactoryClass) {
        if (this.contextConditionSensorFactoryClass != null) {
            throw new CompileError("Attempt to set contextConditionSensorFactoryClass multiple times: " + this.contextConditionSensorFactoryClass);
        }
        this.contextConditionSensorFactoryClass = arg_contextConditionSensorFactoryClass;
    }

    void setContextConditionSensorFactoryMethod_rField(String arg_contextConditionSensorFactoryMethod_rField) {
        if (this.contextConditionSensorFactoryMethod_rField != null) {
            throw new CompileError("Attempt to set contextConditionSensorFactoryMethod_rField multiple times: " + this.contextConditionSensorFactoryMethod_rField);
        }
        this.contextConditionSensorFactoryMethod_rField = arg_contextConditionSensorFactoryMethod_rField;
    }

    void setContextConditionClass(String arg_contextConditionClass) {
        if (this.contextConditionClass != null) {
            throw new CompileError("Attempt to set contextConditionClass multiple times: " + this.contextConditionClass);
        }
        this.contextConditionClass = arg_contextConditionClass;
    }

    void setContextConditionMethod_rField(String arg_contextConditionMethod_rField) {
        if (this.contextConditionMethod_rField != null) {
            throw new CompileError("Attempt to set contextConditionMethod_rField multiple times: " + this.contextConditionMethod_rField);
        }
        this.contextConditionMethod_rField = arg_contextConditionMethod_rField;
    }

    void setSuccessConditionSensorFactoryClass(String arg_successConditionSensorFactoryClass) {
        if (this.successConditionSensorFactoryClass != null) {
            throw new CompileError("Attempt to set successConditionSensorFactoryClass multiple times: " + this.successConditionSensorFactoryClass);
        }
        this.successConditionSensorFactoryClass = arg_successConditionSensorFactoryClass;
    }

    void setSuccessConditionSensorFactoryMethod_rField(String arg_successConditionSensorFactoryMethod_rField) {
        if (this.successConditionSensorFactoryMethod_rField != null) {
            throw new CompileError("Attempt to set successConditionSensorFactoryMethod_rField multiple times: " + this.successConditionSensorFactoryMethod_rField);
        }
        this.successConditionSensorFactoryMethod_rField = arg_successConditionSensorFactoryMethod_rField;
    }

    void setSuccessConditionClass(String arg_successConditionClass) {
        if (this.successConditionClass != null) {
            throw new CompileError("Attempt to set successConditionClass multiple times: " + this.successConditionClass);
        }
        this.successConditionClass = arg_successConditionClass;
    }

    void setSuccessConditionMethod_rField(String arg_successConditionMethod_rField) {
        if (this.successConditionMethod_rField != null) {
            throw new CompileError("Attempt to set successConditionMethod_rField multiple times: " + this.successConditionMethod_rField);
        }
        this.successConditionMethod_rField = arg_successConditionMethod_rField;
    }

    void setSuccessTestSensorFactoryClass(String arg_successTestSensorFactoryClass) {
        if (this.successTestSensorFactoryClass != null) {
            throw new CompileError("Attempt to set successTestSensorFactoryClass multiple times: " + this.successTestSensorFactoryClass);
        }
        this.successTestSensorFactoryClass = arg_successTestSensorFactoryClass;
    }

    void setSuccessTestSensorFactoryMethod_rField(String arg_successTestSensorFactoryMethod_rField) {
        if (this.successTestSensorFactoryMethod_rField != null) {
            throw new CompileError("Attempt to set successTestSensorFactoryMethod_rField multiple times: " + this.successTestSensorFactoryMethod_rField);
        }
        this.successTestSensorFactoryMethod_rField = arg_successTestSensorFactoryMethod_rField;
    }

    void setSuccessTestClass(String arg_successTestClass) {
        if (this.successTestClass != null) {
            throw new CompileError("Attempt to set successTestClass multiple times: " + this.successTestClass);
        }
        this.successTestClass = arg_successTestClass;
    }

    void setSuccessTestMethod_rField(String arg_successTestMethod_rField) {
        if (this.successTestMethod_rField != null) {
            throw new CompileError("Attempt to set successTestMethod_rField multiple times: " + this.successTestMethod_rField);
        }
        this.successTestMethod_rField = arg_successTestMethod_rField;
    }

    void setReinforcementSignalsSensorFactoryClass(String arg_reinforcementSignalsSensorFactoryClass) {
        if (this.reinforcementSignalsSensorFactoryClass != null) {
            throw new CompileError("Attempt to set reinforcementSignalsSensorFactoryClass multiple times: " + this.reinforcementSignalsSensorFactoryClass);
        }
        this.reinforcementSignalsSensorFactoryClass = arg_reinforcementSignalsSensorFactoryClass;
    }

    void setReinforcementSignalsSensorFactoryMethod_rField(String arg_reinforcementSignalsSensorFactoryMethod_rField) {
        if (this.reinforcementSignalsSensorFactoryMethod_rField != null) {
            throw new CompileError("Attempt to set reinforcementSignalsSensorFactoryMethod_rField multiple times: " + this.reinforcementSignalsSensorFactoryMethod_rField);
        }
        this.reinforcementSignalsSensorFactoryMethod_rField = arg_reinforcementSignalsSensorFactoryMethod_rField;
    }

    void setReinforcementSignalsClass(String arg_reinforcementSignalsClass) {
        this.reinforcementSignalsClass = arg_reinforcementSignalsClass;
    }

    void setReinforcementSignalsMethod_rField(String arg_reinforcementSignalsMethod_rField) {
        this.reinforcementSignalsMethod_rField = arg_reinforcementSignalsMethod_rField;
    }

    void setRLPolicyClass(String arg_rlPolicyClass) {
        if (this.rlPolicyClass != null) {
            throw new CompileError("Attempt to set rlPolicyClass multiple times: " + this.rlPolicyClass);
        }
        this.rlPolicyClass = arg_rlPolicyClass;
    }

    void setRLPolicyMethod_rField(String arg_rlPolicyMethod_rField) {
        if (this.rlPolicyMethod_rField != null) {
            throw new CompileError("Attempt to set rlPolicyMethod_rField multiple times: " + this.rlPolicyMethod_rField);
        }
        this.rlPolicyMethod_rField = arg_rlPolicyMethod_rField;
    }

    void setStateWMESensorFactoryClass(String arg_stateWMESensorFactoryClass) {
        if (this.stateWMESensorFactoryClass != null) {
            throw new CompileError("Attempt to set stateWMESensorFactoryClass multiple times: " + this.stateWMESensorFactoryClass);
        }
        this.stateWMESensorFactoryClass = arg_stateWMESensorFactoryClass;
    }

    void setStateWMESensorFactoryMethod_rField(String arg_stateWMESensorFactoryMethod_rField) {
        if (this.stateWMESensorFactoryMethod_rField != null) {
            throw new CompileError("Attempt to set stateWMESensorFactoryMethod_rField multiple times: " + this.stateWMESensorFactoryMethod_rField);
        }
        this.stateWMESensorFactoryMethod_rField = arg_stateWMESensorFactoryMethod_rField;
    }

    void setStateWMEClass(String arg_stateWMEClass) {
        this.stateWMEClass = arg_stateWMEClass;
    }

    void setStateWMEMethod_rField(String arg_stateWMEMethod_rField) {
        this.stateWMEMethod_rField = arg_stateWMEMethod_rField;
    }

    private String compileBehaviorArgument(String name, String type) {
        int i = this.formalArgs.getArgIndex(name);
        if (ASTBehaviorDefinition.primitiveType(type)) {
            if (type.equals("int")) {
                return "(Integer)__$args[" + i + "]";
            }
            if (type.equals("float")) {
                return "(Float)__$args[" + i + "]";
            }
            if (type.equals("char")) {
                return "(Char)__$args[" + i + "]";
            }
            if (type.equals("boolean")) {
                return "(Boolean)__$args[" + i + "]";
            }
            if (type.equals("long")) {
                return "(Long)__$args[" + i + "]";
            }
            if (type.equals("short")) {
                return "(Short)__$args[" + i + "]";
            }
            if (type.equals("byte")) {
                return "(Byte)__$args[" + i + "]";
            }
            if (type.equals("double")) {
                return "(Double)__$args[" + i + "]";
            }
            throw new CompileError("Unexpected primitive type " + type);
        }
        return "(" + type + ")__$args[" + i + "]";
    }

    private HashSet getBoundVariables() {
        ASTTestExpression precondition = null;
        ASTTestExpression entrycondition = null;
        HashSet<String> returnSet = new HashSet<String>();
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode n = (AblParseNode)this.jjtGetChild(i);
            if (n.id == 8) {
                ASTTestExpression testexp = (ASTTestExpression)n;
                if (testexp.getTestType() == 0) {
                    precondition = testexp;
                } else if (testexp.getTestType() == 3) {
                    entrycondition = testexp;
                }
            }
            ++i;
        }
        if (precondition != null) {
            returnSet.addAll(precondition.getBoundVariables());
        }
        if (entrycondition != null) {
            returnSet.addAll(entrycondition.getBoundVariables());
        }
        return returnSet;
    }

    private CodeBlockDescriptor compileSensorActivationFactory(int testType) {
        CodeBlockDescriptor sensorArray;
        ASTTestExpression test = null;
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode n = (AblParseNode)this.jjtGetChild(i);
            if (n.id == 8 && ((ASTTestExpression)n).getTestType() == testType) {
                test = (ASTTestExpression)n;
            }
            ++i;
        }
        if (test != null && (sensorArray = test.compileSensorActivationFactory()) != null) {
            CodeBlockDescriptor factorySwitchCase = new CodeBlockDescriptor("case " + this.behaviorID + ": {", "}");
            factorySwitchCase.addToBlockBody(sensorArray);
            return factorySwitchCase;
        }
        return null;
    }

    private void compileSteps() throws CompileException {
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode n = (AblParseNode)this.jjtGetChild(i);
            if (n.id == 16 || n.id == 14 || n.id == 15 || n.id == 17 || n.id == 20 || n.id == 21 || n.id == 19 || n.id == 18) {
                String behType;
                if (n.id == 18 && (behType = ((ASTAnonymousStep)n).getBehaviorType()).equals(this.behaviorType)) {
                    throw new CompileException(n.getFirstLineNumber(), "Anonymous Block has same behavior type as parent");
                }
                ((GenericStep)n).compileToJava();
            }
            ++i;
        }
    }

    private void compileTests() throws CompileException {
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode n = (AblParseNode)this.jjtGetChild(i);
            if (n.id == 8) {
                ASTTestExpression testexp = (ASTTestExpression)n;
                testexp.compileToJava();
                if (testexp.getTestType() == 3) {
                    ASTWaitStep waitstep = new ASTWaitStep(17);
                    waitstep.jjtAddChild(n, 0);
                    waitstep.hasSuccessTest = true;
                    waitstep.jjtSetParent(this);
                    testexp.jjtSetParent(waitstep);
                    testexp.setTestType(2);
                    waitstep.compileToJava();
                    testexp.jjtSetParent(this);
                    testexp.setTestType(3);
                }
            }
            ++i;
        }
    }

    private void compileReinforcementStateAndSignals() throws CompileException {
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode n = (AblParseNode)this.jjtGetChild(i);
            if (n.id == 13) {
                ASTReinforcementState state = (ASTReinforcementState)n;
                state.compileToJava();
            } else if (n.id == 12) {
                ASTReinforcementSignals signals = (ASTReinforcementSignals)n;
                signals.compileToJava();
            }
            ++i;
        }
    }

    private void compileReinforcementPolicyAndAction() throws CompileException {
        ASTBehaviorUnit behUnit = ASTBehaviorUnit.getBehaviorUnit();
        String actionClassName = String.valueOf(behUnit.getBehavingEntityClass()) + "_Action" + this.behaviorID;
        int numSteps = 0;
        String actionSteps = "";
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode n = (AblParseNode)this.jjtGetChild(i);
            if (n.id == 16) {
                if (numSteps > 0) {
                    actionSteps = String.valueOf(actionSteps) + ",";
                }
                ++numSteps;
                ASTGoalStep goalStep = (ASTGoalStep)n;
                actionSteps = String.valueOf(actionSteps) + "\"" + goalStep.getSignature() + "\"";
            }
            ++i;
        }
        String actionNames = "";
        int i2 = 0;
        while (i2 < numSteps) {
            if (i2 > 0) {
                actionNames = String.valueOf(actionNames) + ", ";
            }
            actionNames = String.valueOf(actionNames) + "new " + actionClassName + "(" + i2 + ")";
            ++i2;
        }
        String actionsVarName = "actions" + this.behaviorID;
        String learnerVarName = "learner" + this.behaviorID;
        CodeBlockDescriptor codeBlock = new CodeBlockDescriptor("public class " + actionClassName + " implements Action {", "}");
        codeBlock.addToBlockBody(new CodeStringDescriptor("Integer stepIndex;"));
        codeBlock.addToBlockBody(new CodeStringDescriptor("static String[] names = new String[] {" + actionSteps + "};"));
        codeBlock.addToBlockBody(new CodeStringDescriptor("public " + actionClassName + "(int stepIndex) {"));
        codeBlock.addToBlockBody(new CodeStringDescriptor("\tthis.stepIndex = new Integer(stepIndex);}"));
        codeBlock.addToBlockBody(new CodeStringDescriptor("public int hashCode() {"));
        codeBlock.addToBlockBody(new CodeStringDescriptor("\treturn stepIndex.hashCode();}"));
        codeBlock.addToBlockBody(new CodeStringDescriptor("public boolean equals(Object o) {"));
        codeBlock.addToBlockBody(new CodeStringDescriptor("\treturn (o instanceof " + actionClassName + ") ? stepIndex.equals( ((" + actionClassName + ")o).stepIndex ) : false;}"));
        codeBlock.addToBlockBody(new CodeStringDescriptor("public String toString() {"));
        codeBlock.addToBlockBody(new CodeStringDescriptor("\treturn names[stepIndex.intValue()];}"));
        behUnit.writeRawClass(codeBlock, actionClassName);
        codeBlock = new CodeBlockDescriptor("case " + this.behaviorID + ": {", "}");
        codeBlock.addToBlockBody(new CodeStringDescriptor("State prevState = (State)prevLocation;"));
        codeBlock.addToBlockBody(new CodeStringDescriptor("if (isRewarding) { "));
        codeBlock.addToBlockBody(new CodeStringDescriptor("    State currState = (State)currLocation;"));
        codeBlock.addToBlockBody(new CodeStringDescriptor("    Action prevAction = new " + actionClassName + "(stepIndex);"));
        codeBlock.addToBlockBody(new CodeStringDescriptor("    " + learnerVarName + ".update(prevState,prevAction,rewardValue,currState); "));
        codeBlock.addToBlockBody(new CodeStringDescriptor("    return 0; "));
        codeBlock.addToBlockBody(new CodeStringDescriptor("}"));
        codeBlock.addToBlockBody(new CodeStringDescriptor("else {"));
        codeBlock.addToBlockBody(new CodeStringDescriptor("    " + actionClassName + " a = (" + actionClassName + ")" + learnerVarName + ".selectAction(prevState);"));
        codeBlock.addToBlockBody(new CodeStringDescriptor("    return a.stepIndex.intValue();"));
        codeBlock.addToBlockBody(new CodeStringDescriptor("}"));
        behUnit.writeRLPolicy(codeBlock, this);
        behUnit.writeRLPolicySuffix(new CodeStringDescriptor("static Action[] " + actionsVarName + ";"));
        behUnit.writeRLPolicySuffix(new CodeStringDescriptor("static QLearner " + learnerVarName + ";"));
        behUnit.writeRLPolicySuffix(new CodeStringDescriptor("static {"));
        behUnit.writeRLPolicySuffix(new CodeStringDescriptor("    " + actionsVarName + " = new Action[] {" + actionNames + "};"));
        behUnit.writeRLPolicySuffix(new CodeStringDescriptor("    " + learnerVarName + " = new QLearner(" + actionsVarName + ");"));
        behUnit.writeRLPolicySuffix(new CodeStringDescriptor("}"));
    }

    private void addArgumentDeclarations() {
        Object[] args = this.formalArgs.getArguments();
        int i = 0;
        while (i < args.length) {
            MethodArgDescriptor arg = (MethodArgDescriptor)args[i];
            FieldDescriptor variableDecl = new FieldDescriptor();
            variableDecl.fieldType = arg.argType;
            variableDecl.addFieldName(arg.argName);
            variableDecl.initializer = this.compileBehaviorArgument(arg.argName, arg.argType);
            this.addVariableDeclaration(variableDecl);
            ++i;
        }
    }

    void checkForSubgoalsWithNoMatchingBehaviors(Set individualSigSet, Set jointSigSet) throws CompileException {
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode n = (AblParseNode)this.jjtGetChild(i);
            if (n.id == 16) {
                ASTGoalStep goalStepDef = (ASTGoalStep)n;
                if (goalStepDef.isJointGoal()) {
                    if (!jointSigSet.contains(goalStepDef.getSignature())) {
                        CompileWarning.warn(this.getFirstLineNumber(), "no matching joint behavior signature for joint goal signature " + goalStepDef.getSignature());
                    }
                } else if (!individualSigSet.contains(goalStepDef.getSignature())) {
                    CompileWarning.warn(this.getFirstLineNumber(), "no matching behavior signature for goal signature " + goalStepDef.getSignature());
                }
            }
            ++i;
        }
    }

    ArrayList<Hashtable<Integer, HashSet<String>>> typeCheckSubgoalsWithInheritance(Hashtable<String, ArrayList<ArrayList<Object>>> individualBehaviors, Hashtable<String, ArrayList<ArrayList<Object>>> jointBehaviors, ASTBehaviorUnit caller) throws CompileException {
        Hashtable individualSignatures = new Hashtable();
        Hashtable jointSignatures = new Hashtable();
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode n = (AblParseNode)this.jjtGetChild(i);
            if (n.id == 16) {
                HashSet<String> temp;
                ASTGoalStep goalStepDef = (ASTGoalStep)n;
                String signature = goalStepDef.getSignature();
                String[] args = new String[goalStepDef.getProcessedArgs().size()];
                int c = 0;
                while (c < args.length) {
                    args[c] = ((AblArgument)goalStepDef.getProcessedArgs().get(c)).getType();
                    ++c;
                }
                String lookup = String.valueOf(signature.substring(0, signature.indexOf(40) + 1)) + args.length + ")";
                Class[] goalStepClasses = new Class[args.length];
                int c2 = 0;
                while (c2 < args.length) {
                    Class cl = caller.findClassFromShortName(args[c2]);
                    if (cl == null) {
                        throw new CompileException("Unable to find class " + args[c2] + " in the imported packages.");
                    }
                    goalStepClasses[c2] = cl;
                    ++c2;
                }
                if (args.length > 0) {
                    HashSet<String> temp2;
                    int c3;
                    boolean isMatch;
                    Integer id;
                    ArrayList<Integer> matchingIDs;
                    if (goalStepDef.isJointGoal()) {
                        ArrayList<ArrayList<Object>> matches = jointBehaviors.get(lookup);
                        if (matches == null) {
                            CompileWarning.warn(this.getFirstLineNumber(), "no joint behavior signature for joint goal signature " + goalStepDef.getSignature());
                        } else {
                            matchingIDs = new ArrayList<Integer>();
                            boolean matchFound = false;
                            for (ArrayList<Object> match : matches) {
                                id = (Integer)match.get(0);
                                isMatch = true;
                                c3 = 1;
                                while (c3 < match.size()) {
                                    if (!((Class)match.get(c3)).isAssignableFrom(goalStepClasses[c3 - 1])) {
                                        isMatch = false;
                                        break;
                                    }
                                    ++c3;
                                }
                                if (!isMatch) continue;
                                matchFound = true;
                                matchingIDs.add(id);
                            }
                            if (!matchFound) {
                                CompileWarning.warn(this.getFirstLineNumber(), "no matching joint behavior signature for joint goal signature " + goalStepDef.getSignature());
                            } else {
                                for (Integer id2 : matchingIDs) {
                                    if (jointSignatures.containsKey(id2)) {
                                        ((HashSet)jointSignatures.get(id2)).add(signature);
                                        continue;
                                    }
                                    temp2 = new HashSet<String>();
                                    temp2.add(signature);
                                    jointSignatures.put(id2, temp2);
                                }
                            }
                        }
                    } else {
                        ArrayList<ArrayList<Object>> matches = individualBehaviors.get(lookup);
                        if (matches == null) {
                            CompileWarning.warn(this.getFirstLineNumber(), "no behavior signature for goal signature " + goalStepDef.getSignature());
                        } else {
                            matchingIDs = new ArrayList();
                            boolean matchFound = false;
                            for (ArrayList<Object> match : matches) {
                                id = (Integer)match.get(0);
                                isMatch = true;
                                c3 = 1;
                                while (c3 < match.size()) {
                                    if (!((Class)match.get(c3)).isAssignableFrom(goalStepClasses[c3 - 1])) {
                                        isMatch = false;
                                        break;
                                    }
                                    ++c3;
                                }
                                if (!isMatch) continue;
                                matchFound = true;
                                matchingIDs.add(id);
                            }
                            if (!matchFound) {
                                CompileWarning.warn(this.getFirstLineNumber(), "no matching behavior signature for goal signature " + goalStepDef.getSignature());
                            } else {
                                for (Integer id2 : matchingIDs) {
                                    if (individualSignatures.containsKey(id2)) {
                                        ((HashSet)individualSignatures.get(id2)).add(signature);
                                        continue;
                                    }
                                    temp2 = new HashSet();
                                    temp2.add(signature);
                                    individualSignatures.put(id2, temp2);
                                }
                            }
                        }
                    }
                } else if (goalStepDef.isJointGoal()) {
                    if (jointBehaviors.containsKey(lookup)) {
                        for (ArrayList<Object> idArgs : jointBehaviors.get(lookup)) {
                            Integer id = (Integer)idArgs.get(0);
                            if (jointSignatures.containsKey(id)) {
                                ((HashSet)jointSignatures.get(id)).add(signature);
                                continue;
                            }
                            temp = new HashSet<String>();
                            temp.add(signature);
                            jointSignatures.put(id, temp);
                        }
                    } else {
                        CompileWarning.warn(this.getFirstLineNumber(), "no matching joint behavior signature for joint goal signature " + goalStepDef.getSignature());
                    }
                } else if (individualBehaviors.containsKey(lookup)) {
                    for (ArrayList<Object> idArgs : individualBehaviors.get(lookup)) {
                        Integer id = (Integer)idArgs.get(0);
                        if (individualSignatures.containsKey(id)) {
                            ((HashSet)individualSignatures.get(id)).add(signature);
                            continue;
                        }
                        temp = new HashSet();
                        temp.add(signature);
                        individualSignatures.put(id, temp);
                    }
                } else {
                    CompileWarning.warn(this.getFirstLineNumber(), "no matching behavior signature for goal signature " + goalStepDef.getSignature());
                }
            }
            ++i;
        }
        ArrayList<Hashtable<Integer, HashSet<String>>> signatures = new ArrayList<Hashtable<Integer, HashSet<String>>>();
        signatures.add(individualSignatures);
        signatures.add(jointSignatures);
        return signatures;
    }

    private CodeBlockDescriptor compileBehaviorFrame() throws CompileException {
        CodeBlockDescriptor frameInit = new CodeBlockDescriptor();
        if (this.fieldDescriptors.size() > 0) {
            assert (!this.isNestedScope) : "Attempt to declare a variable within an anonymous behavior. Currently this is not allowed. Future versions of ABL will lift this restriction";
            frameInit.addToBlockBody(new CodeStringDescriptor("final Object[] __$behaviorFrame = new Object[" + this.fieldDescriptors.size() + "];"));
        } else if (this.isNestedScope) {
            frameInit.addToBlockBody(new CodeStringDescriptor("final Object[] __$behaviorFrame = __$args;"));
        }
        Iterator varIter = this.fieldDescriptors.iterator();
        HashSet boundVariables = this.getBoundVariables();
        while (varIter.hasNext()) {
            FieldDescriptor field = (FieldDescriptor)varIter.next();
            assert (field.getFieldNames().length == 1);
            String variableName = field.getFieldNames()[0];
            String initString = "";
            if (boundVariables.contains(variableName)) {
                if (ASTBehaviorDefinition.primitiveType(field.fieldType)) {
                    if (field.fieldType.equals("int")) {
                        initString = "(Integer)__$boundVars.get(\"" + variableName + "\")";
                    } else if (field.fieldType.equals("float")) {
                        initString = "(Float)__$boundVars.get(\"" + variableName + "\")";
                    } else if (field.fieldType.equals("char")) {
                        initString = "(Character)__$boundVars.get(\"" + variableName + "\")";
                    } else if (field.fieldType.equals("boolean")) {
                        initString = "(Boolean)__$boundVars.get(\"" + variableName + "\")";
                    } else if (field.fieldType.equals("long")) {
                        initString = "(Long)__$boundVars.get(\"" + variableName + "\")";
                    } else if (field.fieldType.equals("short")) {
                        initString = "(Short)__$boundVars.get(\"" + variableName + "\")";
                    } else if (field.fieldType.equals("byte")) {
                        initString = "(Byte)__$boundVars.get(\"" + variableName + "\")";
                    } else if (field.fieldType.equals("double")) {
                        initString = "(Double)__$boundVars.get(\"" + variableName + "\")";
                    }
                } else {
                    initString = "((ObjectWrapper)__$boundVars.get(\"" + variableName + "\")).objectValue()";
                }
            } else if (field.initializer != null) {
                initString = field.initializer;
            }
            String valueString = null;
            if (ASTBehaviorDefinition.primitiveType(field.fieldType)) {
                if (field.fieldType.equals("int")) {
                    valueString = "new __ValueTypes.IntVar(" + initString + ")";
                } else if (field.fieldType.equals("float")) {
                    valueString = "new __ValueTypes.FloatVar(" + initString + ")";
                } else if (field.fieldType.equals("char")) {
                    valueString = "new __ValueTypes.CharVar(" + initString + ")";
                } else if (field.fieldType.equals("boolean")) {
                    valueString = "new __ValueTypes.BooleanVar(" + initString + ")";
                } else if (field.fieldType.equals("long")) {
                    valueString = "new __ValueTypes.LongVar(" + initString + ")";
                } else if (field.fieldType.equals("short")) {
                    valueString = "new __ValueTypes.ShortVar(" + initString + ")";
                } else if (field.fieldType.equals("byte")) {
                    valueString = "new __ValueTypes.ByteVar(" + initString + ")";
                } else if (field.fieldType.equals("double")) {
                    valueString = "new __ValueTypes.DoubleVar(" + initString + ")";
                }
            } else {
                valueString = initString;
            }
            if (valueString.length() == 0) continue;
            frameInit.addToBlockBody(new CodeStringDescriptor("__$behaviorFrame[" + this.getBehaviorFrameIndex(variableName) + "] = " + valueString + ";"));
        }
        return frameInit;
    }

    private CodeBlockDescriptor compileBehaviorFactory() throws CompileException {
        assert (this.stepIDs.size() == this.stepFactories.size());
        CodeBlockDescriptor behaviorFactory = new CodeBlockDescriptor("case " + this.behaviorID + ": {", "}");
        behaviorFactory.addToBlockBody(new CodeStringDescriptor("// " + this.uniqueBehaviorName));
        behaviorFactory.addToBlockBody(this.compileBehaviorFrame());
        StringBuffer stepArrayInit = new StringBuffer(2000);
        stepArrayInit.append("final __StepDesc[] __$steps = ");
        if (this.stepIDs.size() > 0) {
            stepArrayInit.append("{");
            Iterator<Integer> stepIDIter = this.stepIDs.iterator();
            Iterator<String> stepFactoryIter = this.stepFactories.iterator();
            while (stepIDIter.hasNext()) {
                stepArrayInit.append("new __StepDesc(" + stepIDIter.next() + ", " + this.getBehavingEntityField(stepFactoryIter.next()) + ")");
                if (!stepIDIter.hasNext()) continue;
                stepArrayInit.append(", ");
            }
            stepArrayInit.append("}");
        } else {
            stepArrayInit.append("null");
        }
        stepArrayInit.append(";");
        behaviorFactory.addToBlockBody(new CodeStringDescriptor(stepArrayInit.toString()));
        StringBuffer constructorCall = new StringBuffer(500);
        constructorCall.append("return new ");
        if (this.isAdaptive) {
            constructorCall.append("AdaptiveBehavior");
        } else if (this.behaviorType.equals("sequential")) {
            constructorCall.append("SequentialBehavior");
        } else if (this.behaviorType.equals("parallel")) {
            constructorCall.append("ParallelBehavior");
        } else if (this.behaviorType.equals("collection")) {
            constructorCall.append("CollectionBehavior");
        }
        if (Abl.debugLevel == 2) {
            constructorCall.append("Debug(");
        } else {
            constructorCall.append("(");
        }
        String contextCondition = null;
        if (this.contextConditionMethod_rField != null) {
            contextCondition = this.getBehavingEntityField(this.contextConditionMethod_rField);
        }
        String contextConditionSensorFactory = null;
        if (this.contextConditionSensorFactoryMethod_rField != null) {
            contextConditionSensorFactory = this.getBehavingEntityField(this.contextConditionSensorFactoryMethod_rField);
        }
        String successCondition = null;
        if (this.successConditionMethod_rField != null) {
            successCondition = this.getBehavingEntityField(this.successConditionMethod_rField);
        }
        String successConditionSensorFactory = null;
        if (this.successConditionSensorFactoryMethod_rField != null) {
            successConditionSensorFactory = this.getBehavingEntityField(this.successConditionSensorFactoryMethod_rField);
        }
        constructorCall.append("__$parentGoal, " + contextCondition + ", " + contextConditionSensorFactory + ", " + successCondition + ", " + successConditionSensorFactory + ", ");
        if (this.isAdaptive) {
            String reinforcementSignals = null;
            if (this.reinforcementSignalsMethod_rField != null) {
                reinforcementSignals = this.getBehavingEntityField(this.reinforcementSignalsMethod_rField);
            }
            String reinforcementSignalsSensorFactory = null;
            if (this.reinforcementSignalsSensorFactoryMethod_rField != null) {
                reinforcementSignalsSensorFactory = this.getBehavingEntityField(this.reinforcementSignalsSensorFactoryMethod_rField);
            }
            String reinforcementState = null;
            if (this.stateWMEMethod_rField != null) {
                reinforcementState = this.getBehavingEntityField(this.stateWMEMethod_rField);
            }
            String reinforcementStateSensorFactory = null;
            if (this.stateWMESensorFactoryMethod_rField != null) {
                reinforcementStateSensorFactory = this.getBehavingEntityField(this.stateWMESensorFactoryMethod_rField);
            }
            String rlPolicy = null;
            if (this.rlPolicyMethod_rField != null) {
                rlPolicy = this.getBehavingEntityField(this.rlPolicyMethod_rField);
            }
            constructorCall.append(String.valueOf(reinforcementSignals) + ", " + reinforcementSignalsSensorFactory + ", " + reinforcementState + ", " + reinforcementStateSensorFactory + ", " + rlPolicy + ", ");
        }
        constructorCall.append(String.valueOf(this.isAtomic) + ", " + "__$signature" + ", (short)" + this.specificity + ", " + this.behaviorID + ", ");
        if (this.fieldDescriptors.size() > 0 || this.isNestedScope) {
            constructorCall.append("__$behaviorFrame, ");
        } else {
            constructorCall.append("null, ");
        }
        constructorCall.append("__$steps");
        if (this.isAdaptive) {
            if (this.behaviorType.equals("sequential")) {
                constructorCall.append(", Behavior.SEQUENTIAL");
            } else if (this.behaviorType.equals("parallel")) {
                constructorCall.append(", Behavior.PARALLEL");
            } else {
                throw new CompileException(this.getFirstLineNumber(), "Invalid behavior type for adaptive behavior");
            }
        }
        if (this.behaviorType.equals("parallel") || this.behaviorType.equals("collection")) {
            if (this.numberNeededForSuccess == -1) {
                constructorCall.append(", " + this.nonEffectOnlySteps);
            } else {
                constructorCall.append(", " + this.numberNeededForSuccess);
            }
        }
        if (this.isJoint) {
            assert (this.teamMembers.size() > 0);
            StringBuffer teamArrayInit = new StringBuffer(500);
            teamArrayInit.append("BehavingEntity[] __$teamMembers = {");
            Iterator<String> iter = this.teamMembers.iterator();
            while (iter.hasNext()) {
                teamArrayInit.append("BehavingEntity.getBehavingEntity(\"" + iter.next() + "\")");
                if (!iter.hasNext()) continue;
                teamArrayInit.append(", ");
            }
            teamArrayInit.append("};");
            behaviorFactory.addToBlockBody(new CodeStringDescriptor(teamArrayInit.toString()));
            constructorCall.append(", __$teamMembers");
        }
        if (Abl.debugLevel == 2) {
            constructorCall.append(", __$behaviorDesc");
        }
        constructorCall.append(");");
        behaviorFactory.addToBlockBody(new CodeStringDescriptor(constructorCall.toString()));
        return behaviorFactory;
    }

    void compileToJava() throws CompileException {
        CodeBlockDescriptor preconditionSensorFactory;
        CodeBlockDescriptor successConditionSensorFactory;
        CodeBlockDescriptor contextConditionSensorFactory;
        assert (this.behaviorType != null && this.behaviorName != null);
        ASTBehaviorUnit behaviorUnitNode = ASTBehaviorUnit.getBehaviorUnit();
        this.behaviorID = behaviorUnitNode.getUniqueBehaviorID();
        if (this.behaviorName.equals("__RootCollectionBehavior")) {
            this.uniqueBehaviorName = this.behaviorName = String.valueOf(behaviorUnitNode.getBehavingEntityClass()) + "_RootCollectionBehavior";
            behaviorUnitNode.rootBehaviorID = this.behaviorID;
        } else {
            this.uniqueBehaviorName = String.valueOf(this.behaviorName) + "_" + behaviorUnitNode.getBehaviorCount(this.behaviorName);
            behaviorUnitNode.incrementBehaviorCount(this.behaviorName);
        }
        behaviorUnitNode.addBehaviorNode(this);
        this.scopeName = this.uniqueBehaviorName;
        this.setScopeType(1);
        this.initializeScope();
        this.addArgumentDeclarations();
        this.addChildVariableDeclarationsWithReferenceRewrite();
        this.compileTests();
        this.compileSteps();
        if (this.isAdaptive) {
            this.compileReinforcementStateAndSignals();
        }
        if (this.hasContextCondition && (contextConditionSensorFactory = this.compileSensorActivationFactory(1)) != null) {
            behaviorUnitNode.writeContextConditionSensorActivation(contextConditionSensorFactory, this);
        }
        if (this.hasSuccessCondition && (successConditionSensorFactory = this.compileSensorActivationFactory(4)) != null) {
            behaviorUnitNode.writeSuccessConditionSensorActivation(successConditionSensorFactory, this);
        }
        if (this.hasPrecondition && (preconditionSensorFactory = this.compileSensorActivationFactory(0)) != null) {
            behaviorUnitNode.writePreconditionSensorActivation(preconditionSensorFactory, this);
        }
        if (this.isAdaptive) {
            this.compileReinforcementPolicyAndAction();
        }
        behaviorUnitNode.writeBehaviorFactory(this.compileBehaviorFactory(), this);
    }
}

