/*
 * Decompiled with CFR 0.152.
 */
package abl.compiler;

import abl.compiler.ASTBehaviorDefinition;
import abl.compiler.ASTBehaviorUnit;
import abl.compiler.ASTGoalStep;
import abl.compiler.AblDebuggerConstants;
import abl.compiler.AblParseNode;
import abl.compiler.AblParser;
import abl.compiler.CompileError;
import abl.compiler.CompileException;
import abl.compiler.GenericStep;

public class ASTAnonymousStep
extends GenericStep
implements AblDebuggerConstants {
    private String behaviorType = null;

    public ASTAnonymousStep(int id) {
        super(id);
    }

    public ASTAnonymousStep(AblParser p, int id) {
        super(p, id);
    }

    void setBehaviorType(String behaviorTypeToSet) {
        if (!behaviorTypeToSet.equals("sequential") && !behaviorTypeToSet.equals("parallel")) {
            throw new CompileError("Attempt to set illegal behavior type: " + behaviorTypeToSet);
        }
        this.behaviorType = behaviorTypeToSet;
    }

    String getBehaviorType() {
        return this.behaviorType;
    }

    @Override
    void compileToJava() throws CompileException {
        ASTBehaviorUnit behaviorUnitNode = ASTBehaviorUnit.getBehaviorUnit();
        ASTBehaviorDefinition parentBehavior = (ASTBehaviorDefinition)this.jjtGetParent();
        int newBehId = behaviorUnitNode.getUniqueBehaviorID();
        ASTBehaviorDefinition newBehavior = new ASTBehaviorDefinition(7);
        newBehavior.behaviorName = "AnonymousStep" + Integer.toString(newBehId);
        newBehavior.setBehaviorType(this.behaviorType);
        newBehavior.isNestedScope = true;
        newBehavior.jjtSetParent(parentBehavior);
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            AblParseNode n = (AblParseNode)this.jjtGetChild(i);
            newBehavior.jjtAddChild(n, i);
            n.jjtSetParent(newBehavior);
            ++i;
        }
        newBehavior.compileToJava();
        ASTGoalStep goalStep = new ASTGoalStep(16, this);
        goalStep.jjtSetParent(parentBehavior);
        goalStep.goalName = newBehavior.behaviorName;
        goalStep.setNestedScope(true);
        goalStep.compileToJava();
    }
}

