/*
 * Decompiled with CFR 0.152.
 */
package abl.compiler;

import abl.compiler.ASTJavaName;
import abl.compiler.AblParseNode;
import abl.compiler.AblParser;
import abl.compiler.AblScopeMaintainer;
import abl.compiler.CompileError;
import abl.compiler.CompileException;

public class ASTAblExpression
extends AblParseNode {
    ASTAblExpression(int id) {
        super(id);
    }

    ASTAblExpression(AblParser p, int id) {
        super(p, id);
    }

    boolean isIdentifier() {
        return this.jjtGetNumChildren() == 1;
    }

    boolean isLiteral() {
        return !this.isIdentifier();
    }

    ASTJavaName getRef() {
        if (this.isIdentifier()) {
            return (ASTJavaName)this.jjtGetChild(0);
        }
        return null;
    }

    String getVariableReferenceConstantOrLiteral(AblScopeMaintainer scope) throws CompileException {
        if (this.isIdentifier()) {
            return this.getRef().getVariableReferenceOrConstant(scope);
        }
        return this.firstToken.image;
    }

    String getVariableReferenceConstantOrLiteralAsObject(AblScopeMaintainer scope) throws CompileException {
        if (this.isIdentifier()) {
            return this.getRef().getVariableReferenceOrConstantAsObject(scope);
        }
        switch (this.firstToken.kind) {
            case 120: {
                return "new Integer(" + this.firstToken.image + ")";
            }
            case 124: {
                return "new Float(" + this.firstToken.image + ")";
            }
            case 125: {
                return "new Double(" + this.firstToken.image + ")";
            }
            case 127: {
                return "new Character(" + this.firstToken.image.charAt(0) + ")";
            }
            case 128: {
                return "new String(" + this.firstToken.image + ")";
            }
            case 29: 
            case 59: {
                return "new Boolean(" + this.firstToken.image + ")";
            }
            case 44: {
                return "null";
            }
        }
        throw new CompileError("Unexpected literal token");
    }

    Object getLiteralValue() {
        if (this.isLiteral()) {
            switch (this.firstToken.kind) {
                case 120: {
                    return new Integer(this.firstToken.image);
                }
                case 124: {
                    return new Float(this.firstToken.image);
                }
                case 125: {
                    return new Double(this.firstToken.image);
                }
                case 127: {
                    return new Character(this.firstToken.image.charAt(0));
                }
                case 128: {
                    return new String(this.firstToken.image);
                }
                case 29: 
                case 59: {
                    return new Boolean(this.firstToken.image);
                }
                case 44: {
                    return null;
                }
            }
            throw new CompileError("Unexpected literal token");
        }
        throw new CompileError(String.valueOf(this.dumpTokens()) + " is not a literal.");
    }

    String getFullNameOrLiteral() {
        if (this.isIdentifier()) {
            return this.getRef().getFullName();
        }
        return this.firstToken.image;
    }

    public String getType(AblScopeMaintainer scope) throws CompileException {
        if (this.isIdentifier()) {
            return this.getRef().getType(scope);
        }
        switch (this.firstToken.kind) {
            case 120: {
                return "int";
            }
            case 124: {
                return "float";
            }
            case 125: {
                return "double";
            }
            case 127: {
                return "char";
            }
            case 128: {
                return "String";
            }
            case 29: 
            case 59: {
                return "boolean";
            }
            case 44: {
                return "Object";
            }
        }
        throw new CompileError("Unexpected literal token");
    }
}

