#pragma once

#include <BWAPI.h>
#include <set>
#include <map>
#include <string>
#include <list>
#include <math.h>

#define PI 3.141592

using namespace BWAPI;
using namespace std;

class Environment;
class Agent;
class BaseAgent;
class WorkerAgent;
class Task;
class BuildSupplyTask;
class BuildRefineryTask;
class RecollectMinTask;
class RecollectGasTask;
class TrainWorkerTask;
class ExploreSectorTask;
class AssaultSectorTask;
class AttackUnitTask;
class ProtectUnitTask;
class MapSector;
class AiLogger;

struct BuildingSpaceInfo;
struct Quadrant;
struct UnitMemory;
struct TileBox;

#define ANALYSIS_FREQ					1
#define DEFAULT_TASK_VALIDATION_FREQ	100
#define DIST_APTITUDE_FACTOR			100.0
#define NO_APTITUDE						-1.0

#define MIN_TASK_HOLD_FRAMES			50

#define MAX_SUPPLY						400

#define MAX_THREAT_RANGE				400			//in Pixels

#define MAX_RESOURCE_RANGE				400			//in Pixels
#define MAX_BUILD_RANGE					800			//in Pixels
#define MAX_POS_DISTANCE				10000000	//in Pixels

#define SECTOR_LENGTH					10			//in Tiles
#define SECTOR_LENGTH_IN_PIXELS			320			//in Pixels

#define SECTOR_FRAMES_PER_REFRESH		10
#define SECTOR_FRAMES_PER_EXPLORE		500

#define SECTOR_STUCK_TIMEOUT			10000

enum AgentDisposition
{
	BRAVE = 0,
	COWARD
};

enum TaskStatus
{
	NOT_STARTED = 0,
	IN_PROGRESS,
	FINISHED,
	HALTED,
	CANCELLED
};

enum TaskType
{
	NULL_TASK = -1,
	TASK = 0,
	BUILD_TASK,
	BUILD_BARRACKS_TASK,
	BUILD_ENGINEERING_TASK,
	BUILD_FACTORY_TASK,
	BUILD_STARPORT_TASK,
	BUILD_SCIENCE_FACILITY_TASK,
	BUILD_ACADEMY_TASK,
	BUILD_SUPPLY_TASK,
	BUILD_REFINERY_TASK,
	BUILD_COMMAND_TASK,
	MOVE_COMMAND_TASK,
	ADDON_BUILD_TASK,
	ADDON_BUILD_COMSAT_TASK,
	ADDON_MACHINE_SHOP_TASK,
	ADDON_CONTROL_TOWER_TASK,
	TRAIN_TASK,
	TRAIN_WORKER_TASK,
	TRAIN_MARINE_TASK,
	TRAIN_MEDIC_TASK,
	TRAIN_SIEGE_TANK_TASK,
	TRAIN_WRAITH_TASK,
	REPAIR_TASK,
	RECOLLECT_TASK,
	RECOLLECT_MIN_TASK,
	RECOLLECT_GAS_TASK,
	EXPLORE_SECTOR_TASK,
	ASSAULT_SECTOR_TASK,
	ATTACK_UNIT_TASK,
	PROTECT_UNIT_TASK,
	SCAN_TARGET_TASK,
	RESEARCH_TASK
};

enum AgentType
{
	AGENT = 0,
	EXPLORER_AGENT,
	ATTACKER_AGENT,
	WORKER_AGENT,
	BUILDING_AGENT,
	BASE_AGENT
};

typedef set<Task*> TaskSet;
typedef set<Unit*> UnitSet;
typedef set<Agent*> AgentSet;
typedef set<BuildingSpaceInfo*> PlannedBuildingSet;
typedef set<TaskType> TaskTypeSet;
typedef set<AgentType> AgentTypeSet;
typedef set<TilePosition> TilePositionSet;
typedef set<MapSector*> MapSectorSet;
typedef set<UnitMemory*> UnitMemorySet;

typedef map<unsigned long, TilePosition> TilePositionMap;
typedef map<Unit*, Agent*> AgentMap;
typedef map<Unit*, BuildRefineryTask*> BuildRefineryTaskMap;
typedef map<Unit*, RecollectGasTask*> RecollectGasTaskMap;
typedef map<Unit*, RecollectMinTask*> RecollectMinTaskMap;
typedef map<Unit*, TaskTypeSet> TaskTargetMap;
typedef map<unsigned long, MapSector*> MapSectorMap;
typedef map<unsigned long, int> DistanceMap;
typedef map<unsigned long, Quadrant*> QuadrantMap;
typedef map<Unit*, UnitMemory*> UnitMemoryMap;
typedef map<UnitType, int> UnitTypeCountMap;

typedef list<Unit*> UnitList;
typedef list<Agent*> AgentList;
typedef list<Task*> TaskList;
typedef list<MapSector*> SectorList;
typedef list<UnitType> UnitTypeList;

////////// TASK PRIORITIES

#define	MAX_ACTIVE_ASSAULT_PRIORITY		120
#define	MIN_ACTIVE_ASSAULT_PRIORITY		110

#define	MAX_ACTIVE_PROTECT_PRIORITY		110
#define	MIN_ACTIVE_PROTECT_PRIORITY		100

#define	MAX_INACTIVE_ASSAULT_PRIORITY	100
#define	MIN_INACTIVE_ASSAULT_PRIORITY	90

#define	MAX_MOVE_PRIORITY				100
#define	MIN_MOVE_PRIORITY				90

#define	MAX_ATTACK_PRIORITY				90
#define	MIN_ATTACK_PRIORITY				80

#define	MAX_SCAN_PRIORITY				90
#define	MIN_SCAN_PRIORITY				80

#define	MAX_EXPLORE_PRIORITY			80
#define	MIN_EXPLORE_PRIORITY			70

#define	MAX_RESEARCH_PRIORITY			70
#define	MIN_RESEARCH_PRIORITY			60

#define	MAX_BUILD_PRIORITY				70
#define	MIN_BUILD_PRIORITY				60

#define	MAX_TRAIN_PRIORITY				70
#define	MIN_TRAIN_PRIORITY				60

#define	MAX_MINERAL_PRIORITY			40
#define	MIN_MINERAL_PRIORITY			30

#define	MAX_GAS_PRIORITY				40
#define	MIN_GAS_PRIORITY				30

#define	MAX_PASSIVE_PROTECT_PRIORITY	20
#define	MIN_PASSIVE_PROTECT_PRIORITY	10

