#include "TrainWraithTask.h"
#include "Environment.h"
#include "Agent.h"

#define TASK_PRIORITY_FACTOR		100.0
#define WORKER_PRIORITY_FACTOR		19.0
#define BUILDING_PRIORITY_FACTOR	0.0
#define ATTACKER_PRIORITY_FACTOR	10.0

#define DEATH_PRIORITY_FACTOR		20

void TrainWraithTask::generateNecessaryTasks(Environment* env)
{
	AgentMap starports = env->getFilteredAgents(UnitTypes::Terran_Starport);

	int starportsCount = starports.size();
	int trainTasksNeeded = starportsCount;

	trainTasksNeeded -= env->getFilteredTasks(TRAIN_WRAITH_TASK).size();

	for (int i = 0; i < trainTasksNeeded; i++)
	{
		//Broodwar->printf("Generating TrainWraithTask task.");
		env->addTask(new TrainWraithTask(env));
	}
}

TrainWraithTask::TrainWraithTask(Environment* env) :
TrainTask(UnitTypes::Terran_Wraith, env)
{
	_types.insert(TRAIN_WRAITH_TASK);
}

TrainWraithTask::~TrainWraithTask(void)
{
}

void TrainWraithTask::calculatePriority()
{
	int supplyRequired = max(1, _unitType.supplyRequired());
	int currentSupply = max(0, _env->getCurrentSupply());

	double buildingCountFactor = 0;//_env->getFilteredAgents(BUILDING_AGENT).size()*BUILDING_PRIORITY_FACTOR;
	double workerCountFactor = _env->getFilteredAgents(WORKER_AGENT).size()*WORKER_PRIORITY_FACTOR;
	double attackerCountFactor = _env->getFilteredAgents(ATTACKER_AGENT).size()*ATTACKER_PRIORITY_FACTOR;

	double unitFactor = max(0.0, buildingCountFactor + workerCountFactor - attackerCountFactor);

	double supplyFactor = currentSupply/(double)(currentSupply + supplyRequired);

	int deathCount = _env->getUnitTypeDeaths(_unitType);
	int restDeathCount = _env->getTotalDeaths() - deathCount;
	double deathFactor = (DEATH_PRIORITY_FACTOR + restDeathCount)/(double)(DEATH_PRIORITY_FACTOR + restDeathCount + deathCount);

	double prePriority = TASK_PRIORITY_FACTOR*unitFactor*supplyFactor*deathFactor;

	_priority = scalePriority(prePriority, MAX_TRAIN_PRIORITY, MIN_TRAIN_PRIORITY);
}
