#include "TrainWorkerTask.h"
#include "Environment.h"
#include "Agent.h"

#define TASK_PRIORITY_FACTOR	100.0
#define MAX_WORKERS				60

void TrainWorkerTask::generateNecessaryTasks(Environment* env)
{
	AgentMap bases = env->getFilteredAgents(BASE_AGENT);
	int workerCount = env->getFilteredAgents(WORKER_AGENT).size();

	int baseCount = bases.size();
	int neededWorkers = env->calculateNeededExtraWorkers();
	int trainWorkerTasksNeeded = min(baseCount, neededWorkers);

	TaskSet trainWorkerTasks = env->getFilteredTasks(TRAIN_WORKER_TASK);
	trainWorkerTasksNeeded -= trainWorkerTasks.size();

	trainWorkerTasksNeeded = min(trainWorkerTasksNeeded, MAX_WORKERS - workerCount);

	for (int i = 0; i < trainWorkerTasksNeeded; i++)
	{
		//Broodwar->printf("Generating TrainWorkerTask task.");
		env->addTask(new TrainWorkerTask(env));
	}
}

TrainWorkerTask::TrainWorkerTask(Environment* env) :
	TrainTask(env->getPlayer()->getRace().getWorker(), env)
{
	_types.insert(TRAIN_WORKER_TASK);
}

TrainWorkerTask::~TrainWorkerTask(void)
{
}

void TrainWorkerTask::calculatePriority()
{
	int neededWorkers = _env->calculateNeededExtraWorkers();

	int supplyRequired = max(1, _unitType.supplyRequired());
	int currentSupply = max(0, _env->getCurrentSupply());

	double supplyFactor = currentSupply/(double)(currentSupply + supplyRequired);

	double prePriority = TASK_PRIORITY_FACTOR*neededWorkers*supplyFactor;

	_priority = scalePriority(prePriority, MAX_TRAIN_PRIORITY, MIN_TRAIN_PRIORITY);
}
