#pragma once

#include "task.h"

class TrainTask :
	public Task
{
protected:
	UnitType _unitType;
	UnitType _trainerType;
	UnitType _requiredAddon;

	UnitType _unitTypeTrained;

	Position _rallyPosition;

	bool _requiresUnits;

public:
	TrainTask(UnitType unitType, Environment* env);
	TrainTask(UnitType unitType, Position rallyPosition, Environment* env);
	virtual ~TrainTask(void);

	virtual double evaluateAptitude(Agent* agent);
	virtual void evaluateStatus();

	UnitType getUnitTypeTrained();
	
	virtual void evaluateNeededUnits();

	virtual bool execute(Agent* agent);
};
