#include "TrainSiegeTankTask.h"
#include "Environment.h"
#include "Agent.h"

#define TASK_PRIORITY_FACTOR		100.0
#define WORKER_PRIORITY_FACTOR		19.0
#define BUILDING_PRIORITY_FACTOR	0.0
#define ATTACKER_PRIORITY_FACTOR	10.0

#define DEATH_PRIORITY_FACTOR		20

void TrainSiegeTankTask::generateNecessaryTasks(Environment* env)
{
	int machineShopCount = env->getFilteredAgents(UnitTypes::Terran_Machine_Shop).size();

	int trainTankTasksNeeded = machineShopCount;

	trainTankTasksNeeded -= env->getFilteredTasks(TRAIN_SIEGE_TANK_TASK).size();

	for (int i = 0; i < trainTankTasksNeeded; i++)
	{
		//Broodwar->printf("Generating TrainSiegeTankTask task.");
		env->addTask(new TrainSiegeTankTask(env));
	}
}

TrainSiegeTankTask::TrainSiegeTankTask(Environment* env) :
TrainTask(UnitTypes::Terran_Siege_Tank_Tank_Mode, env)
{
	_types.insert(TRAIN_SIEGE_TANK_TASK);
}

TrainSiegeTankTask::~TrainSiegeTankTask(void)
{
}

void TrainSiegeTankTask::calculatePriority()
{
	int supplyRequired = max(1, _unitType.supplyRequired());
	int currentSupply = max(0, _env->getCurrentSupply());

	double buildingCountFactor = 0;//_env->getFilteredAgents(BUILDING_AGENT).size()*BUILDING_PRIORITY_FACTOR;
	double workerCountFactor = _env->getFilteredAgents(WORKER_AGENT).size()*WORKER_PRIORITY_FACTOR;
	double attackerCountFactor = _env->getFilteredAgents(ATTACKER_AGENT).size()*ATTACKER_PRIORITY_FACTOR;

	double unitFactor = max(0.0, buildingCountFactor + workerCountFactor - attackerCountFactor);

	double supplyFactor = currentSupply/(double)(currentSupply + supplyRequired);

	int deathCount = _env->getUnitTypeDeaths(_unitType);
	int restDeathCount = _env->getTotalDeaths() - deathCount;
	double deathFactor = (DEATH_PRIORITY_FACTOR + restDeathCount)/(double)(DEATH_PRIORITY_FACTOR + restDeathCount + deathCount);

	double prePriority = TASK_PRIORITY_FACTOR*unitFactor*supplyFactor*deathFactor;

	_priority = scalePriority(prePriority, MAX_TRAIN_PRIORITY, MIN_TRAIN_PRIORITY);
}
