#include "TrainMedicTask.h"
#include "Environment.h"
#include "Agent.h"

#define TASK_PRIORITY_FACTOR		1000.0
#define MARINE_PRIORITY_FACTOR		8.0
#define MEDIC_PRIORITY_FACTOR		1.0

void TrainMedicTask::generateNecessaryTasks(Environment* env)
{
	UnitTypeCountMap requiredUnits = UnitTypes::Terran_Medic.requiredUnits();

	for (UnitTypeCountMap::iterator i = requiredUnits.begin(); i != requiredUnits.end(); i++)
	{
		if (env->getFilteredAgents((*i).first).size() == 0) return;
	}
	
	int medicsCount = env->getFilteredAgents(UnitTypes::Terran_Medic).size();
	int marineCount = env->getFilteredAgents(UnitTypes::Terran_Marine).size();

	if (medicsCount*MARINE_PRIORITY_FACTOR >= marineCount*MEDIC_PRIORITY_FACTOR) return;

	int barracksCount = env->getFilteredAgents(UnitTypes::Terran_Barracks).size();

	int balanceDiff = (int)ceil((marineCount*MEDIC_PRIORITY_FACTOR - medicsCount*MARINE_PRIORITY_FACTOR)/MEDIC_PRIORITY_FACTOR);
	int trainMedicTasksNeeded = min(barracksCount, balanceDiff);

	trainMedicTasksNeeded -= env->getFilteredTasks(TRAIN_MEDIC_TASK).size();

	for (int i = 0; i < trainMedicTasksNeeded; i++)
	{
		//Broodwar->printf("Generating TrainMarineTask task.");
		env->addTask(new TrainMedicTask(env));
	}
}

TrainMedicTask::TrainMedicTask(Environment* env) :
TrainTask(UnitTypes::Terran_Medic, env)
{
	_types.insert(TRAIN_MEDIC_TASK);
}

TrainMedicTask::~TrainMedicTask(void)
{
}

void TrainMedicTask::calculatePriority()
{
	int supplyRequired = max(1, _unitType.supplyRequired());
	int currentSupply = max(0, _env->getCurrentSupply());

	double medicCountFactor = _env->getFilteredAgents(UnitTypes::Terran_Medic).size()*MARINE_PRIORITY_FACTOR;
	double marineCountFactor = _env->getFilteredAgents(UnitTypes::Terran_Marine).size()*MEDIC_PRIORITY_FACTOR;

	double unitFactor = max(0.0, marineCountFactor - medicCountFactor);

	double supplyFactor = currentSupply/(double)(currentSupply + supplyRequired);

	double prePriority = TASK_PRIORITY_FACTOR*unitFactor*supplyFactor;

	_priority = scalePriority(prePriority, MAX_TRAIN_PRIORITY, MIN_TRAIN_PRIORITY);
}
