#include "TrainMarineTask.h"
#include "Environment.h"
#include "Agent.h"

#define TASK_PRIORITY_FACTOR		100.0
#define WORKER_PRIORITY_FACTOR		19.0
#define BUILDING_PRIORITY_FACTOR	0.0
#define ATTACKER_PRIORITY_FACTOR	10.0
//#define MAX_ATTACKERS				50

#define DEATH_PRIORITY_FACTOR		20

void TrainMarineTask::generateNecessaryTasks(Environment* env)
{
	//// This is to test under constraint
	//if (env->getFilteredAgents(ATTACKER_AGENT).size() >= MAX_ATTACKERS) return;

	AgentMap barracks = env->getFilteredAgents(UnitTypes::Terran_Barracks);

	int barracksCount = barracks.size();
	int trainMarineTasksNeeded = barracksCount;

	trainMarineTasksNeeded -= env->getFilteredTasks(TRAIN_MARINE_TASK).size();

	for (int i = 0; i < trainMarineTasksNeeded; i++)
	{
		//Broodwar->printf("Generating TrainMarineTask task.");
		env->addTask(new TrainMarineTask(env));
	}
}

TrainMarineTask::TrainMarineTask(Environment* env) :
	TrainTask(UnitTypes::Terran_Marine, env)
{
	_types.insert(TRAIN_MARINE_TASK);
}

TrainMarineTask::~TrainMarineTask(void)
{
}

void TrainMarineTask::calculatePriority()
{
	int supplyRequired = max(1, _unitType.supplyRequired());
	int currentSupply = max(0, _env->getCurrentSupply());

	double workerCountFactor = _env->getFilteredAgents(WORKER_AGENT).size()*WORKER_PRIORITY_FACTOR;
	double attackerCountFactor = _env->getFilteredAgents(ATTACKER_AGENT).size()*ATTACKER_PRIORITY_FACTOR;

	double unitFactor = max(0.0, workerCountFactor - attackerCountFactor);

	double supplyFactor = currentSupply/(double)(currentSupply + supplyRequired);

	int deathCount = _env->getUnitTypeDeaths(_unitType);
	int restDeathCount = _env->getTotalDeaths() - deathCount;
	double deathFactor = (DEATH_PRIORITY_FACTOR + restDeathCount)/(double)(DEATH_PRIORITY_FACTOR + restDeathCount + deathCount);

	double prePriority = TASK_PRIORITY_FACTOR*unitFactor*supplyFactor*deathFactor;

	_priority = scalePriority(prePriority, MAX_TRAIN_PRIORITY, MIN_TRAIN_PRIORITY);
}
