#pragma once

#include "defines.h"

class Task
{
protected:
	double _priority;

	TaskTypeSet _types;

	Environment* _env;
	AgentSet _agents;

	TaskStatus _status;
	string _statusMessage;
	bool _canExecute;
	bool _needsMoreUnits;

	string _name;
	int _id;
	int _creationFrame;
	int _execValidationFreq;

	bool _canBePreempted;
	bool _filterTaskInfo;

	bool _syncUp;

public:
	static TaskSet filterSet(TaskSet* tasks, TaskType type);
	static TaskSet filterSet(TaskSet* tasks, TaskType type, int maxCreationFrame);
	static TaskSet filterSetByPriority(TaskSet* tasks, TaskType type, double priority);

	static double scalePriority(double value, double maxPriority, double minPriority);

	Task(Environment* env, string name, bool canBePreempted = true, int execValidationFreq = DEFAULT_TASK_VALIDATION_FREQ);
	virtual ~Task(void);

	virtual void cleanup();

	bool isType(TaskType);

	double getPriority();
	TaskStatus getStatus();
	void setStatus(TaskStatus status);
	void setStatus(TaskStatus status, string statusMessage);

	int getId();
	string getName();
	int getCreationFrame();

	int getExecValidationFreq();

	bool mustSyncUp();
	
	bool canBePreempted();

	virtual void calculatePriority() = 0;
	virtual void evaluateStatus() = 0;
	virtual void evaluateNeededUnits() = 0;
	
	virtual double evaluateAptitude(Agent* agent) = 0;

	bool needsMoreUnits();
	bool canExecute();
	string statusMessage();

	virtual bool execute(Agent* agent) = 0;

	virtual void addAgent(Agent* agent);
	virtual void removeAgent(Agent* agent);

	void assignNeededAgents(AgentMap* agents);

	virtual void displayInfo(int &row, Agent* agent);
};
