#pragma once

#include "Task.h"

class ProtectUnitTask :
	public Task
{
protected:
	Agent* _protectedAgent;

	int _neededUnits;

	Unit* _targetEnemy;

	int _readyRange;
	Position _groupPosition;

	Agent* _centerAgent;

	bool marineExecute(Agent* agent);
	bool medicExecute(Agent* agent);
	bool wraithExecute(Agent* agent);
	bool tankExecute(Agent* agent);
	bool siegeExecute(Agent* agent);

public:
	static void generateNecessaryTasks(Environment* env);

	ProtectUnitTask(Agent* agent, Environment* env);
	virtual ~ProtectUnitTask(void);

	virtual void addAgent(Agent* agent);
	virtual void removeAgent(Agent* agent);

	Agent* getProtectedAgent();

	Unit* getTargetEnemy();
	int getReadyRange();
	Position getGroupPosition();

	virtual void calculatePriority();
	virtual double evaluateAptitude(Agent* agent);
	virtual void evaluateStatus();
	
	virtual void evaluateNeededUnits();

	virtual bool execute(Agent* agent);
};
