#pragma once

#include "Task.h"

class MoveCommandTask :
	public Task
{
protected:
	UnitType _buildingType;

	TilePosition _buildingPos;
	Position _targetPosition;

	BuildingSpaceInfo* _plannedBuilding;

public:
	static void generateNecessaryTasks(Environment* env);

	MoveCommandTask(TilePosition pos, Environment* env);
	virtual ~MoveCommandTask(void);

	virtual void calculatePriority();
	double evaluateAptitude(Agent* agent);
	void evaluateStatus();
	
	void evaluateNeededUnits();

	TilePosition getBuildingPosition();
	UnitType getBuildingType();

	bool execute(Agent* agent);
};
